# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class TopicRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        TopicRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'description': 'str',
            'strictness': 'str',
            'program_ids': 'list[str]',
            'tags': 'list[str]',
            'dialect': 'str',
            'participants': 'str',
            'phrases': 'list[Phrase]'
        }

        self.attribute_map = {
            'name': 'name',
            'description': 'description',
            'strictness': 'strictness',
            'program_ids': 'programIds',
            'tags': 'tags',
            'dialect': 'dialect',
            'participants': 'participants',
            'phrases': 'phrases'
        }

        self._name = None
        self._description = None
        self._strictness = None
        self._program_ids = None
        self._tags = None
        self._dialect = None
        self._participants = None
        self._phrases = None

    @property
    def name(self):
        """
        Gets the name of this TopicRequest.
        The topic name

        :return: The name of this TopicRequest.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this TopicRequest.
        The topic name

        :param name: The name of this TopicRequest.
        :type: str
        """
        
        self._name = name

    @property
    def description(self):
        """
        Gets the description of this TopicRequest.
        The topic description

        :return: The description of this TopicRequest.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this TopicRequest.
        The topic description

        :param description: The description of this TopicRequest.
        :type: str
        """
        
        self._description = description

    @property
    def strictness(self):
        """
        Gets the strictness of this TopicRequest.
        The topic strictness, default value is 72

        :return: The strictness of this TopicRequest.
        :rtype: str
        """
        return self._strictness

    @strictness.setter
    def strictness(self, strictness):
        """
        Sets the strictness of this TopicRequest.
        The topic strictness, default value is 72

        :param strictness: The strictness of this TopicRequest.
        :type: str
        """
        allowed_values = ["1", "55", "65", "72", "85", "90"]
        if strictness.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for strictness -> " + strictness)
            self._strictness = "outdated_sdk_version"
        else:
            self._strictness = strictness

    @property
    def program_ids(self):
        """
        Gets the program_ids of this TopicRequest.
        The ids of programs associated to the topic

        :return: The program_ids of this TopicRequest.
        :rtype: list[str]
        """
        return self._program_ids

    @program_ids.setter
    def program_ids(self, program_ids):
        """
        Sets the program_ids of this TopicRequest.
        The ids of programs associated to the topic

        :param program_ids: The program_ids of this TopicRequest.
        :type: list[str]
        """
        
        self._program_ids = program_ids

    @property
    def tags(self):
        """
        Gets the tags of this TopicRequest.
        The topic tags

        :return: The tags of this TopicRequest.
        :rtype: list[str]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """
        Sets the tags of this TopicRequest.
        The topic tags

        :param tags: The tags of this TopicRequest.
        :type: list[str]
        """
        
        self._tags = tags

    @property
    def dialect(self):
        """
        Gets the dialect of this TopicRequest.
        The topic dialect

        :return: The dialect of this TopicRequest.
        :rtype: str
        """
        return self._dialect

    @dialect.setter
    def dialect(self, dialect):
        """
        Sets the dialect of this TopicRequest.
        The topic dialect

        :param dialect: The dialect of this TopicRequest.
        :type: str
        """
        
        self._dialect = dialect

    @property
    def participants(self):
        """
        Gets the participants of this TopicRequest.
        The topic participants, default value is All

        :return: The participants of this TopicRequest.
        :rtype: str
        """
        return self._participants

    @participants.setter
    def participants(self, participants):
        """
        Sets the participants of this TopicRequest.
        The topic participants, default value is All

        :param participants: The participants of this TopicRequest.
        :type: str
        """
        allowed_values = ["External", "Internal", "All"]
        if participants.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for participants -> " + participants)
            self._participants = "outdated_sdk_version"
        else:
            self._participants = participants

    @property
    def phrases(self):
        """
        Gets the phrases of this TopicRequest.
        The topic phrases

        :return: The phrases of this TopicRequest.
        :rtype: list[Phrase]
        """
        return self._phrases

    @phrases.setter
    def phrases(self, phrases):
        """
        Sets the phrases of this TopicRequest.
        The topic phrases

        :param phrases: The phrases of this TopicRequest.
        :type: list[Phrase]
        """
        
        self._phrases = phrases

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

