# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class SchedulingProcessingError(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        SchedulingProcessingError - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'internal_error_code': 'str',
            'description': 'str'
        }

        self.attribute_map = {
            'internal_error_code': 'internalErrorCode',
            'description': 'description'
        }

        self._internal_error_code = None
        self._description = None

    @property
    def internal_error_code(self):
        """
        Gets the internal_error_code of this SchedulingProcessingError.
        An internal code representing the type of error. BadJson for 'Unable to parse json.' NotFound for 'Resource not found.' Fail for 'An unexpected server error occured.'

        :return: The internal_error_code of this SchedulingProcessingError.
        :rtype: str
        """
        return self._internal_error_code

    @internal_error_code.setter
    def internal_error_code(self, internal_error_code):
        """
        Sets the internal_error_code of this SchedulingProcessingError.
        An internal code representing the type of error. BadJson for 'Unable to parse json.' NotFound for 'Resource not found.' Fail for 'An unexpected server error occured.'

        :param internal_error_code: The internal_error_code of this SchedulingProcessingError.
        :type: str
        """
        allowed_values = ["BadJson", "NotFound", "Fail"]
        if internal_error_code.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for internal_error_code -> " + internal_error_code)
            self._internal_error_code = "outdated_sdk_version"
        else:
            self._internal_error_code = internal_error_code

    @property
    def description(self):
        """
        Gets the description of this SchedulingProcessingError.
        A text description of the error

        :return: The description of this SchedulingProcessingError.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this SchedulingProcessingError.
        A text description of the error

        :param description: The description of this SchedulingProcessingError.
        :type: str
        """
        
        self._description = description

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

