# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class PhoneChangeTopicLineStatus(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        PhoneChangeTopicLineStatus - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'reachable': 'bool',
            'address_of_record': 'str',
            'contact_addresses': 'list[str]',
            'reachable_state_time': 'datetime'
        }

        self.attribute_map = {
            'id': 'id',
            'reachable': 'reachable',
            'address_of_record': 'addressOfRecord',
            'contact_addresses': 'contactAddresses',
            'reachable_state_time': 'reachableStateTime'
        }

        self._id = None
        self._reachable = None
        self._address_of_record = None
        self._contact_addresses = None
        self._reachable_state_time = None

    @property
    def id(self):
        """
        Gets the id of this PhoneChangeTopicLineStatus.


        :return: The id of this PhoneChangeTopicLineStatus.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this PhoneChangeTopicLineStatus.


        :param id: The id of this PhoneChangeTopicLineStatus.
        :type: str
        """
        
        self._id = id

    @property
    def reachable(self):
        """
        Gets the reachable of this PhoneChangeTopicLineStatus.


        :return: The reachable of this PhoneChangeTopicLineStatus.
        :rtype: bool
        """
        return self._reachable

    @reachable.setter
    def reachable(self, reachable):
        """
        Sets the reachable of this PhoneChangeTopicLineStatus.


        :param reachable: The reachable of this PhoneChangeTopicLineStatus.
        :type: bool
        """
        
        self._reachable = reachable

    @property
    def address_of_record(self):
        """
        Gets the address_of_record of this PhoneChangeTopicLineStatus.


        :return: The address_of_record of this PhoneChangeTopicLineStatus.
        :rtype: str
        """
        return self._address_of_record

    @address_of_record.setter
    def address_of_record(self, address_of_record):
        """
        Sets the address_of_record of this PhoneChangeTopicLineStatus.


        :param address_of_record: The address_of_record of this PhoneChangeTopicLineStatus.
        :type: str
        """
        
        self._address_of_record = address_of_record

    @property
    def contact_addresses(self):
        """
        Gets the contact_addresses of this PhoneChangeTopicLineStatus.


        :return: The contact_addresses of this PhoneChangeTopicLineStatus.
        :rtype: list[str]
        """
        return self._contact_addresses

    @contact_addresses.setter
    def contact_addresses(self, contact_addresses):
        """
        Sets the contact_addresses of this PhoneChangeTopicLineStatus.


        :param contact_addresses: The contact_addresses of this PhoneChangeTopicLineStatus.
        :type: list[str]
        """
        
        self._contact_addresses = contact_addresses

    @property
    def reachable_state_time(self):
        """
        Gets the reachable_state_time of this PhoneChangeTopicLineStatus.


        :return: The reachable_state_time of this PhoneChangeTopicLineStatus.
        :rtype: datetime
        """
        return self._reachable_state_time

    @reachable_state_time.setter
    def reachable_state_time(self, reachable_state_time):
        """
        Sets the reachable_state_time of this PhoneChangeTopicLineStatus.


        :param reachable_state_time: The reachable_state_time of this PhoneChangeTopicLineStatus.
        :type: datetime
        """
        
        self._reachable_state_time = reachable_state_time

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

