# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class KeyPerformanceIndicatorAssessment(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        KeyPerformanceIndicatorAssessment - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'kpi': 'str',
            'assessment_result': 'str',
            'checks': 'list[Check]'
        }

        self.attribute_map = {
            'kpi': 'kpi',
            'assessment_result': 'assessmentResult',
            'checks': 'checks'
        }

        self._kpi = None
        self._assessment_result = None
        self._checks = None

    @property
    def kpi(self):
        """
        Gets the kpi of this KeyPerformanceIndicatorAssessment.
        Name of the key performance indicator assessed.

        :return: The kpi of this KeyPerformanceIndicatorAssessment.
        :rtype: str
        """
        return self._kpi

    @kpi.setter
    def kpi(self, kpi):
        """
        Sets the kpi of this KeyPerformanceIndicatorAssessment.
        Name of the key performance indicator assessed.

        :param kpi: The kpi of this KeyPerformanceIndicatorAssessment.
        :type: str
        """
        
        self._kpi = kpi

    @property
    def assessment_result(self):
        """
        Gets the assessment_result of this KeyPerformanceIndicatorAssessment.
        The overall result of the assessment for a key performance indicator.

        :return: The assessment_result of this KeyPerformanceIndicatorAssessment.
        :rtype: str
        """
        return self._assessment_result

    @assessment_result.setter
    def assessment_result(self, assessment_result):
        """
        Sets the assessment_result of this KeyPerformanceIndicatorAssessment.
        The overall result of the assessment for a key performance indicator.

        :param assessment_result: The assessment_result of this KeyPerformanceIndicatorAssessment.
        :type: str
        """
        allowed_values = ["Unknown", "NotSupported", "High", "Low", "Error"]
        if assessment_result.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for assessment_result -> " + assessment_result)
            self._assessment_result = "outdated_sdk_version"
        else:
            self._assessment_result = assessment_result

    @property
    def checks(self):
        """
        Gets the checks of this KeyPerformanceIndicatorAssessment.
        Set of checks executed as part of an assessment.

        :return: The checks of this KeyPerformanceIndicatorAssessment.
        :rtype: list[Check]
        """
        return self._checks

    @checks.setter
    def checks(self, checks):
        """
        Sets the checks of this KeyPerformanceIndicatorAssessment.
        Set of checks executed as part of an assessment.

        :param checks: The checks of this KeyPerformanceIndicatorAssessment.
        :type: list[Check]
        """
        
        self._checks = checks

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

