from __future__ import absolute_import
from __future__ import print_function
import veriloggen
import thread_ram_initvals_nocheck

expected_verilog = """
module test;

  reg CLK;
  reg RST;

  blinkled
  uut
  (
    .CLK(CLK),
    .RST(RST)
  );


  initial begin
    $dumpfile("uut.vcd");
    $dumpvars(0, uut);
  end


  initial begin
    CLK = 0;
    forever begin
      #5 CLK = !CLK;
    end
  end


  initial begin
    RST = 0;
    #100;
    RST = 1;
    #100;
    RST = 0;
    #10000;
    $finish;
  end


endmodule



module blinkled
(
  input CLK,
  input RST
);

  reg [10-1:0] myram_0_addr;
  wire [32-1:0] myram_0_rdata;
  reg [32-1:0] myram_0_wdata;
  reg myram_0_wenable;

  myram
  inst_myram
  (
    .CLK(CLK),
    .myram_0_addr(myram_0_addr),
    .myram_0_rdata(myram_0_rdata),
    .myram_0_wdata(myram_0_wdata),
    .myram_0_wenable(myram_0_wenable)
  );

  reg [32-1:0] th_blink;
  localparam th_blink_init = 0;
  reg signed [32-1:0] _th_blink_times_0;
  reg signed [32-1:0] _th_blink_i_1;
  reg _tmp_0;
  reg _myram_cond_0_1;
  reg _myram_cond_1_1;
  reg _myram_cond_1_2;
  reg signed [32-1:0] _tmp_1;
  reg signed [32-1:0] _th_blink_rdata_2;
  reg signed [32-1:0] _th_blink_wdata_3;
  reg _myram_cond_2_1;
  reg signed [32-1:0] _th_blink_sum_4;
  reg _tmp_2;
  reg _myram_cond_3_1;
  reg _myram_cond_4_1;
  reg _myram_cond_4_2;
  reg signed [32-1:0] _tmp_3;

  always @(posedge CLK) begin
    if(RST) begin
      myram_0_addr <= 0;
      _myram_cond_0_1 <= 0;
      _tmp_0 <= 0;
      _myram_cond_1_1 <= 0;
      _myram_cond_1_2 <= 0;
      myram_0_wdata <= 0;
      myram_0_wenable <= 0;
      _myram_cond_2_1 <= 0;
      _myram_cond_3_1 <= 0;
      _tmp_2 <= 0;
      _myram_cond_4_1 <= 0;
      _myram_cond_4_2 <= 0;
    end else begin
      if(_myram_cond_1_2) begin
        _tmp_0 <= 0;
      end 
      if(_myram_cond_4_2) begin
        _tmp_2 <= 0;
      end 
      if(_myram_cond_0_1) begin
        _tmp_0 <= 1;
      end 
      _myram_cond_1_2 <= _myram_cond_1_1;
      if(_myram_cond_2_1) begin
        myram_0_wenable <= 0;
      end 
      if(_myram_cond_3_1) begin
        _tmp_2 <= 1;
      end 
      _myram_cond_4_2 <= _myram_cond_4_1;
      if(th_blink == 3) begin
        myram_0_addr <= _th_blink_i_1;
      end 
      _myram_cond_0_1 <= th_blink == 3;
      _myram_cond_1_1 <= th_blink == 3;
      if(th_blink == 7) begin
        myram_0_addr <= _th_blink_i_1;
        myram_0_wdata <= _th_blink_wdata_3;
        myram_0_wenable <= 1;
      end 
      _myram_cond_2_1 <= th_blink == 7;
      if(th_blink == 13) begin
        myram_0_addr <= _th_blink_i_1;
      end 
      _myram_cond_3_1 <= th_blink == 13;
      _myram_cond_4_1 <= th_blink == 13;
    end
  end

  localparam th_blink_1 = 1;
  localparam th_blink_2 = 2;
  localparam th_blink_3 = 3;
  localparam th_blink_4 = 4;
  localparam th_blink_5 = 5;
  localparam th_blink_6 = 6;
  localparam th_blink_7 = 7;
  localparam th_blink_8 = 8;
  localparam th_blink_9 = 9;
  localparam th_blink_10 = 10;
  localparam th_blink_11 = 11;
  localparam th_blink_12 = 12;
  localparam th_blink_13 = 13;
  localparam th_blink_14 = 14;
  localparam th_blink_15 = 15;
  localparam th_blink_16 = 16;
  localparam th_blink_17 = 17;
  localparam th_blink_18 = 18;
  localparam th_blink_19 = 19;

  always @(posedge CLK) begin
    if(RST) begin
      th_blink <= th_blink_init;
      _th_blink_times_0 <= 0;
      _th_blink_i_1 <= 0;
      _tmp_1 <= 0;
      _th_blink_rdata_2 <= 0;
      _th_blink_wdata_3 <= 0;
      _th_blink_sum_4 <= 0;
      _tmp_3 <= 0;
    end else begin
      case(th_blink)
        th_blink_init: begin
          _th_blink_times_0 <= 10;
          th_blink <= th_blink_1;
        end
        th_blink_1: begin
          _th_blink_i_1 <= 0;
          th_blink <= th_blink_2;
        end
        th_blink_2: begin
          if(_th_blink_i_1 < _th_blink_times_0) begin
            th_blink <= th_blink_3;
          end else begin
            th_blink <= th_blink_10;
          end
        end
        th_blink_3: begin
          if(_tmp_0) begin
            _tmp_1 <= myram_0_rdata;
          end 
          if(_tmp_0) begin
            th_blink <= th_blink_4;
          end 
        end
        th_blink_4: begin
          _th_blink_rdata_2 <= _tmp_1;
          th_blink <= th_blink_5;
        end
        th_blink_5: begin
          $display("rdata = %d", _th_blink_rdata_2);
          th_blink <= th_blink_6;
        end
        th_blink_6: begin
          _th_blink_wdata_3 <= _th_blink_rdata_2 + 1;
          th_blink <= th_blink_7;
        end
        th_blink_7: begin
          th_blink <= th_blink_8;
        end
        th_blink_8: begin
          $display("wdata = %d", _th_blink_wdata_3);
          th_blink <= th_blink_9;
        end
        th_blink_9: begin
          _th_blink_i_1 <= _th_blink_i_1 + 1;
          th_blink <= th_blink_2;
        end
        th_blink_10: begin
          _th_blink_sum_4 <= 0;
          th_blink <= th_blink_11;
        end
        th_blink_11: begin
          _th_blink_i_1 <= 0;
          th_blink <= th_blink_12;
        end
        th_blink_12: begin
          if(_th_blink_i_1 < _th_blink_times_0) begin
            th_blink <= th_blink_13;
          end else begin
            th_blink <= th_blink_18;
          end
        end
        th_blink_13: begin
          if(_tmp_2) begin
            _tmp_3 <= myram_0_rdata;
          end 
          if(_tmp_2) begin
            th_blink <= th_blink_14;
          end 
        end
        th_blink_14: begin
          _th_blink_rdata_2 <= _tmp_3;
          th_blink <= th_blink_15;
        end
        th_blink_15: begin
          _th_blink_sum_4 <= _th_blink_sum_4 + _th_blink_rdata_2;
          th_blink <= th_blink_16;
        end
        th_blink_16: begin
          $display("rdata = %d", _th_blink_rdata_2);
          th_blink <= th_blink_17;
        end
        th_blink_17: begin
          _th_blink_i_1 <= _th_blink_i_1 + 1;
          th_blink <= th_blink_12;
        end
        th_blink_18: begin
          $display("sum = %d", _th_blink_sum_4);
          th_blink <= th_blink_19;
        end
      endcase
    end
  end


endmodule



module myram
(
  input CLK,
  input [10-1:0] myram_0_addr,
  output [32-1:0] myram_0_rdata,
  input [32-1:0] myram_0_wdata,
  input myram_0_wenable
);

  reg [10-1:0] myram_0_daddr;
  reg [32-1:0] mem [0:1024-1];

  initial begin
    mem[0] = { 16'd0, 12'd0, 4'd0 };
    mem[1] = { 16'd0, 12'd1, 4'd0 };
    mem[2] = { 16'd0, 12'd2, 4'd0 };
    mem[3] = { 16'd0, 12'd3, 4'd0 };
    mem[4] = { 16'd0, 12'd4, 4'd0 };
    mem[5] = { 16'd0, 12'd5, 4'd0 };
    mem[6] = { 16'd0, 12'd6, 4'd0 };
    mem[7] = { 16'd0, 12'd7, 4'd0 };
    mem[8] = { 16'd0, 12'd8, 4'd0 };
    mem[9] = { 16'd0, 12'd9, 4'd0 };
    mem[10] = { 16'd0, 12'd10, 4'd0 };
    mem[11] = { 16'd0, 12'd11, 4'd0 };
    mem[12] = { 16'd0, 12'd12, 4'd0 };
    mem[13] = { 16'd0, 12'd13, 4'd0 };
    mem[14] = { 16'd0, 12'd14, 4'd0 };
    mem[15] = { 16'd0, 12'd15, 4'd0 };
    mem[16] = { 16'd0, 12'd16, 4'd0 };
    mem[17] = { 16'd0, 12'd17, 4'd0 };
    mem[18] = { 16'd0, 12'd18, 4'd0 };
    mem[19] = { 16'd0, 12'd19, 4'd0 };
    mem[20] = { 16'd0, 12'd20, 4'd0 };
    mem[21] = { 16'd0, 12'd21, 4'd0 };
    mem[22] = { 16'd0, 12'd22, 4'd0 };
    mem[23] = { 16'd0, 12'd23, 4'd0 };
    mem[24] = { 16'd0, 12'd24, 4'd0 };
    mem[25] = { 16'd0, 12'd25, 4'd0 };
    mem[26] = { 16'd0, 12'd26, 4'd0 };
    mem[27] = { 16'd0, 12'd27, 4'd0 };
    mem[28] = { 16'd0, 12'd28, 4'd0 };
    mem[29] = { 16'd0, 12'd29, 4'd0 };
    mem[30] = { 16'd0, 12'd30, 4'd0 };
    mem[31] = { 16'd0, 12'd31, 4'd0 };
    mem[32] = { 16'd0, 12'd32, 4'd0 };
    mem[33] = { 16'd0, 12'd33, 4'd0 };
    mem[34] = { 16'd0, 12'd34, 4'd0 };
    mem[35] = { 16'd0, 12'd35, 4'd0 };
    mem[36] = { 16'd0, 12'd36, 4'd0 };
    mem[37] = { 16'd0, 12'd37, 4'd0 };
    mem[38] = { 16'd0, 12'd38, 4'd0 };
    mem[39] = { 16'd0, 12'd39, 4'd0 };
    mem[40] = { 16'd0, 12'd40, 4'd0 };
    mem[41] = { 16'd0, 12'd41, 4'd0 };
    mem[42] = { 16'd0, 12'd42, 4'd0 };
    mem[43] = { 16'd0, 12'd43, 4'd0 };
    mem[44] = { 16'd0, 12'd44, 4'd0 };
    mem[45] = { 16'd0, 12'd45, 4'd0 };
    mem[46] = { 16'd0, 12'd46, 4'd0 };
    mem[47] = { 16'd0, 12'd47, 4'd0 };
    mem[48] = { 16'd0, 12'd48, 4'd0 };
    mem[49] = { 16'd0, 12'd49, 4'd0 };
    mem[50] = { 16'd0, 12'd50, 4'd0 };
    mem[51] = { 16'd0, 12'd51, 4'd0 };
    mem[52] = { 16'd0, 12'd52, 4'd0 };
    mem[53] = { 16'd0, 12'd53, 4'd0 };
    mem[54] = { 16'd0, 12'd54, 4'd0 };
    mem[55] = { 16'd0, 12'd55, 4'd0 };
    mem[56] = { 16'd0, 12'd56, 4'd0 };
    mem[57] = { 16'd0, 12'd57, 4'd0 };
    mem[58] = { 16'd0, 12'd58, 4'd0 };
    mem[59] = { 16'd0, 12'd59, 4'd0 };
    mem[60] = { 16'd0, 12'd60, 4'd0 };
    mem[61] = { 16'd0, 12'd61, 4'd0 };
    mem[62] = { 16'd0, 12'd62, 4'd0 };
    mem[63] = { 16'd0, 12'd63, 4'd0 };
    mem[64] = { 16'd0, 12'd64, 4'd0 };
    mem[65] = { 16'd0, 12'd65, 4'd0 };
    mem[66] = { 16'd0, 12'd66, 4'd0 };
    mem[67] = { 16'd0, 12'd67, 4'd0 };
    mem[68] = { 16'd0, 12'd68, 4'd0 };
    mem[69] = { 16'd0, 12'd69, 4'd0 };
    mem[70] = { 16'd0, 12'd70, 4'd0 };
    mem[71] = { 16'd0, 12'd71, 4'd0 };
    mem[72] = { 16'd0, 12'd72, 4'd0 };
    mem[73] = { 16'd0, 12'd73, 4'd0 };
    mem[74] = { 16'd0, 12'd74, 4'd0 };
    mem[75] = { 16'd0, 12'd75, 4'd0 };
    mem[76] = { 16'd0, 12'd76, 4'd0 };
    mem[77] = { 16'd0, 12'd77, 4'd0 };
    mem[78] = { 16'd0, 12'd78, 4'd0 };
    mem[79] = { 16'd0, 12'd79, 4'd0 };
    mem[80] = { 16'd0, 12'd80, 4'd0 };
    mem[81] = { 16'd0, 12'd81, 4'd0 };
    mem[82] = { 16'd0, 12'd82, 4'd0 };
    mem[83] = { 16'd0, 12'd83, 4'd0 };
    mem[84] = { 16'd0, 12'd84, 4'd0 };
    mem[85] = { 16'd0, 12'd85, 4'd0 };
    mem[86] = { 16'd0, 12'd86, 4'd0 };
    mem[87] = { 16'd0, 12'd87, 4'd0 };
    mem[88] = { 16'd0, 12'd88, 4'd0 };
    mem[89] = { 16'd0, 12'd89, 4'd0 };
    mem[90] = { 16'd0, 12'd90, 4'd0 };
    mem[91] = { 16'd0, 12'd91, 4'd0 };
    mem[92] = { 16'd0, 12'd92, 4'd0 };
    mem[93] = { 16'd0, 12'd93, 4'd0 };
    mem[94] = { 16'd0, 12'd94, 4'd0 };
    mem[95] = { 16'd0, 12'd95, 4'd0 };
    mem[96] = { 16'd0, 12'd96, 4'd0 };
    mem[97] = { 16'd0, 12'd97, 4'd0 };
    mem[98] = { 16'd0, 12'd98, 4'd0 };
    mem[99] = { 16'd0, 12'd99, 4'd0 };
    mem[100] = { 16'd0, 12'd100, 4'd0 };
    mem[101] = { 16'd0, 12'd101, 4'd0 };
    mem[102] = { 16'd0, 12'd102, 4'd0 };
    mem[103] = { 16'd0, 12'd103, 4'd0 };
    mem[104] = { 16'd0, 12'd104, 4'd0 };
    mem[105] = { 16'd0, 12'd105, 4'd0 };
    mem[106] = { 16'd0, 12'd106, 4'd0 };
    mem[107] = { 16'd0, 12'd107, 4'd0 };
    mem[108] = { 16'd0, 12'd108, 4'd0 };
    mem[109] = { 16'd0, 12'd109, 4'd0 };
    mem[110] = { 16'd0, 12'd110, 4'd0 };
    mem[111] = { 16'd0, 12'd111, 4'd0 };
    mem[112] = { 16'd0, 12'd112, 4'd0 };
    mem[113] = { 16'd0, 12'd113, 4'd0 };
    mem[114] = { 16'd0, 12'd114, 4'd0 };
    mem[115] = { 16'd0, 12'd115, 4'd0 };
    mem[116] = { 16'd0, 12'd116, 4'd0 };
    mem[117] = { 16'd0, 12'd117, 4'd0 };
    mem[118] = { 16'd0, 12'd118, 4'd0 };
    mem[119] = { 16'd0, 12'd119, 4'd0 };
    mem[120] = { 16'd0, 12'd120, 4'd0 };
    mem[121] = { 16'd0, 12'd121, 4'd0 };
    mem[122] = { 16'd0, 12'd122, 4'd0 };
    mem[123] = { 16'd0, 12'd123, 4'd0 };
    mem[124] = { 16'd0, 12'd124, 4'd0 };
    mem[125] = { 16'd0, 12'd125, 4'd0 };
    mem[126] = { 16'd0, 12'd126, 4'd0 };
    mem[127] = { 16'd0, 12'd127, 4'd0 };
    mem[128] = { 16'd0, 12'd128, 4'd0 };
    mem[129] = { 16'd0, 12'd129, 4'd0 };
    mem[130] = { 16'd0, 12'd130, 4'd0 };
    mem[131] = { 16'd0, 12'd131, 4'd0 };
    mem[132] = { 16'd0, 12'd132, 4'd0 };
    mem[133] = { 16'd0, 12'd133, 4'd0 };
    mem[134] = { 16'd0, 12'd134, 4'd0 };
    mem[135] = { 16'd0, 12'd135, 4'd0 };
    mem[136] = { 16'd0, 12'd136, 4'd0 };
    mem[137] = { 16'd0, 12'd137, 4'd0 };
    mem[138] = { 16'd0, 12'd138, 4'd0 };
    mem[139] = { 16'd0, 12'd139, 4'd0 };
    mem[140] = { 16'd0, 12'd140, 4'd0 };
    mem[141] = { 16'd0, 12'd141, 4'd0 };
    mem[142] = { 16'd0, 12'd142, 4'd0 };
    mem[143] = { 16'd0, 12'd143, 4'd0 };
    mem[144] = { 16'd0, 12'd144, 4'd0 };
    mem[145] = { 16'd0, 12'd145, 4'd0 };
    mem[146] = { 16'd0, 12'd146, 4'd0 };
    mem[147] = { 16'd0, 12'd147, 4'd0 };
    mem[148] = { 16'd0, 12'd148, 4'd0 };
    mem[149] = { 16'd0, 12'd149, 4'd0 };
    mem[150] = { 16'd0, 12'd150, 4'd0 };
    mem[151] = { 16'd0, 12'd151, 4'd0 };
    mem[152] = { 16'd0, 12'd152, 4'd0 };
    mem[153] = { 16'd0, 12'd153, 4'd0 };
    mem[154] = { 16'd0, 12'd154, 4'd0 };
    mem[155] = { 16'd0, 12'd155, 4'd0 };
    mem[156] = { 16'd0, 12'd156, 4'd0 };
    mem[157] = { 16'd0, 12'd157, 4'd0 };
    mem[158] = { 16'd0, 12'd158, 4'd0 };
    mem[159] = { 16'd0, 12'd159, 4'd0 };
    mem[160] = { 16'd0, 12'd160, 4'd0 };
    mem[161] = { 16'd0, 12'd161, 4'd0 };
    mem[162] = { 16'd0, 12'd162, 4'd0 };
    mem[163] = { 16'd0, 12'd163, 4'd0 };
    mem[164] = { 16'd0, 12'd164, 4'd0 };
    mem[165] = { 16'd0, 12'd165, 4'd0 };
    mem[166] = { 16'd0, 12'd166, 4'd0 };
    mem[167] = { 16'd0, 12'd167, 4'd0 };
    mem[168] = { 16'd0, 12'd168, 4'd0 };
    mem[169] = { 16'd0, 12'd169, 4'd0 };
    mem[170] = { 16'd0, 12'd170, 4'd0 };
    mem[171] = { 16'd0, 12'd171, 4'd0 };
    mem[172] = { 16'd0, 12'd172, 4'd0 };
    mem[173] = { 16'd0, 12'd173, 4'd0 };
    mem[174] = { 16'd0, 12'd174, 4'd0 };
    mem[175] = { 16'd0, 12'd175, 4'd0 };
    mem[176] = { 16'd0, 12'd176, 4'd0 };
    mem[177] = { 16'd0, 12'd177, 4'd0 };
    mem[178] = { 16'd0, 12'd178, 4'd0 };
    mem[179] = { 16'd0, 12'd179, 4'd0 };
    mem[180] = { 16'd0, 12'd180, 4'd0 };
    mem[181] = { 16'd0, 12'd181, 4'd0 };
    mem[182] = { 16'd0, 12'd182, 4'd0 };
    mem[183] = { 16'd0, 12'd183, 4'd0 };
    mem[184] = { 16'd0, 12'd184, 4'd0 };
    mem[185] = { 16'd0, 12'd185, 4'd0 };
    mem[186] = { 16'd0, 12'd186, 4'd0 };
    mem[187] = { 16'd0, 12'd187, 4'd0 };
    mem[188] = { 16'd0, 12'd188, 4'd0 };
    mem[189] = { 16'd0, 12'd189, 4'd0 };
    mem[190] = { 16'd0, 12'd190, 4'd0 };
    mem[191] = { 16'd0, 12'd191, 4'd0 };
    mem[192] = { 16'd0, 12'd192, 4'd0 };
    mem[193] = { 16'd0, 12'd193, 4'd0 };
    mem[194] = { 16'd0, 12'd194, 4'd0 };
    mem[195] = { 16'd0, 12'd195, 4'd0 };
    mem[196] = { 16'd0, 12'd196, 4'd0 };
    mem[197] = { 16'd0, 12'd197, 4'd0 };
    mem[198] = { 16'd0, 12'd198, 4'd0 };
    mem[199] = { 16'd0, 12'd199, 4'd0 };
    mem[200] = { 16'd0, 12'd200, 4'd0 };
    mem[201] = { 16'd0, 12'd201, 4'd0 };
    mem[202] = { 16'd0, 12'd202, 4'd0 };
    mem[203] = { 16'd0, 12'd203, 4'd0 };
    mem[204] = { 16'd0, 12'd204, 4'd0 };
    mem[205] = { 16'd0, 12'd205, 4'd0 };
    mem[206] = { 16'd0, 12'd206, 4'd0 };
    mem[207] = { 16'd0, 12'd207, 4'd0 };
    mem[208] = { 16'd0, 12'd208, 4'd0 };
    mem[209] = { 16'd0, 12'd209, 4'd0 };
    mem[210] = { 16'd0, 12'd210, 4'd0 };
    mem[211] = { 16'd0, 12'd211, 4'd0 };
    mem[212] = { 16'd0, 12'd212, 4'd0 };
    mem[213] = { 16'd0, 12'd213, 4'd0 };
    mem[214] = { 16'd0, 12'd214, 4'd0 };
    mem[215] = { 16'd0, 12'd215, 4'd0 };
    mem[216] = { 16'd0, 12'd216, 4'd0 };
    mem[217] = { 16'd0, 12'd217, 4'd0 };
    mem[218] = { 16'd0, 12'd218, 4'd0 };
    mem[219] = { 16'd0, 12'd219, 4'd0 };
    mem[220] = { 16'd0, 12'd220, 4'd0 };
    mem[221] = { 16'd0, 12'd221, 4'd0 };
    mem[222] = { 16'd0, 12'd222, 4'd0 };
    mem[223] = { 16'd0, 12'd223, 4'd0 };
    mem[224] = { 16'd0, 12'd224, 4'd0 };
    mem[225] = { 16'd0, 12'd225, 4'd0 };
    mem[226] = { 16'd0, 12'd226, 4'd0 };
    mem[227] = { 16'd0, 12'd227, 4'd0 };
    mem[228] = { 16'd0, 12'd228, 4'd0 };
    mem[229] = { 16'd0, 12'd229, 4'd0 };
    mem[230] = { 16'd0, 12'd230, 4'd0 };
    mem[231] = { 16'd0, 12'd231, 4'd0 };
    mem[232] = { 16'd0, 12'd232, 4'd0 };
    mem[233] = { 16'd0, 12'd233, 4'd0 };
    mem[234] = { 16'd0, 12'd234, 4'd0 };
    mem[235] = { 16'd0, 12'd235, 4'd0 };
    mem[236] = { 16'd0, 12'd236, 4'd0 };
    mem[237] = { 16'd0, 12'd237, 4'd0 };
    mem[238] = { 16'd0, 12'd238, 4'd0 };
    mem[239] = { 16'd0, 12'd239, 4'd0 };
    mem[240] = { 16'd0, 12'd240, 4'd0 };
    mem[241] = { 16'd0, 12'd241, 4'd0 };
    mem[242] = { 16'd0, 12'd242, 4'd0 };
    mem[243] = { 16'd0, 12'd243, 4'd0 };
    mem[244] = { 16'd0, 12'd244, 4'd0 };
    mem[245] = { 16'd0, 12'd245, 4'd0 };
    mem[246] = { 16'd0, 12'd246, 4'd0 };
    mem[247] = { 16'd0, 12'd247, 4'd0 };
    mem[248] = { 16'd0, 12'd248, 4'd0 };
    mem[249] = { 16'd0, 12'd249, 4'd0 };
    mem[250] = { 16'd0, 12'd250, 4'd0 };
    mem[251] = { 16'd0, 12'd251, 4'd0 };
    mem[252] = { 16'd0, 12'd252, 4'd0 };
    mem[253] = { 16'd0, 12'd253, 4'd0 };
    mem[254] = { 16'd0, 12'd254, 4'd0 };
    mem[255] = { 16'd0, 12'd255, 4'd0 };
    mem[256] = { 16'd0, 12'd256, 4'd0 };
    mem[257] = { 16'd0, 12'd257, 4'd0 };
    mem[258] = { 16'd0, 12'd258, 4'd0 };
    mem[259] = { 16'd0, 12'd259, 4'd0 };
    mem[260] = { 16'd0, 12'd260, 4'd0 };
    mem[261] = { 16'd0, 12'd261, 4'd0 };
    mem[262] = { 16'd0, 12'd262, 4'd0 };
    mem[263] = { 16'd0, 12'd263, 4'd0 };
    mem[264] = { 16'd0, 12'd264, 4'd0 };
    mem[265] = { 16'd0, 12'd265, 4'd0 };
    mem[266] = { 16'd0, 12'd266, 4'd0 };
    mem[267] = { 16'd0, 12'd267, 4'd0 };
    mem[268] = { 16'd0, 12'd268, 4'd0 };
    mem[269] = { 16'd0, 12'd269, 4'd0 };
    mem[270] = { 16'd0, 12'd270, 4'd0 };
    mem[271] = { 16'd0, 12'd271, 4'd0 };
    mem[272] = { 16'd0, 12'd272, 4'd0 };
    mem[273] = { 16'd0, 12'd273, 4'd0 };
    mem[274] = { 16'd0, 12'd274, 4'd0 };
    mem[275] = { 16'd0, 12'd275, 4'd0 };
    mem[276] = { 16'd0, 12'd276, 4'd0 };
    mem[277] = { 16'd0, 12'd277, 4'd0 };
    mem[278] = { 16'd0, 12'd278, 4'd0 };
    mem[279] = { 16'd0, 12'd279, 4'd0 };
    mem[280] = { 16'd0, 12'd280, 4'd0 };
    mem[281] = { 16'd0, 12'd281, 4'd0 };
    mem[282] = { 16'd0, 12'd282, 4'd0 };
    mem[283] = { 16'd0, 12'd283, 4'd0 };
    mem[284] = { 16'd0, 12'd284, 4'd0 };
    mem[285] = { 16'd0, 12'd285, 4'd0 };
    mem[286] = { 16'd0, 12'd286, 4'd0 };
    mem[287] = { 16'd0, 12'd287, 4'd0 };
    mem[288] = { 16'd0, 12'd288, 4'd0 };
    mem[289] = { 16'd0, 12'd289, 4'd0 };
    mem[290] = { 16'd0, 12'd290, 4'd0 };
    mem[291] = { 16'd0, 12'd291, 4'd0 };
    mem[292] = { 16'd0, 12'd292, 4'd0 };
    mem[293] = { 16'd0, 12'd293, 4'd0 };
    mem[294] = { 16'd0, 12'd294, 4'd0 };
    mem[295] = { 16'd0, 12'd295, 4'd0 };
    mem[296] = { 16'd0, 12'd296, 4'd0 };
    mem[297] = { 16'd0, 12'd297, 4'd0 };
    mem[298] = { 16'd0, 12'd298, 4'd0 };
    mem[299] = { 16'd0, 12'd299, 4'd0 };
    mem[300] = { 16'd0, 12'd300, 4'd0 };
    mem[301] = { 16'd0, 12'd301, 4'd0 };
    mem[302] = { 16'd0, 12'd302, 4'd0 };
    mem[303] = { 16'd0, 12'd303, 4'd0 };
    mem[304] = { 16'd0, 12'd304, 4'd0 };
    mem[305] = { 16'd0, 12'd305, 4'd0 };
    mem[306] = { 16'd0, 12'd306, 4'd0 };
    mem[307] = { 16'd0, 12'd307, 4'd0 };
    mem[308] = { 16'd0, 12'd308, 4'd0 };
    mem[309] = { 16'd0, 12'd309, 4'd0 };
    mem[310] = { 16'd0, 12'd310, 4'd0 };
    mem[311] = { 16'd0, 12'd311, 4'd0 };
    mem[312] = { 16'd0, 12'd312, 4'd0 };
    mem[313] = { 16'd0, 12'd313, 4'd0 };
    mem[314] = { 16'd0, 12'd314, 4'd0 };
    mem[315] = { 16'd0, 12'd315, 4'd0 };
    mem[316] = { 16'd0, 12'd316, 4'd0 };
    mem[317] = { 16'd0, 12'd317, 4'd0 };
    mem[318] = { 16'd0, 12'd318, 4'd0 };
    mem[319] = { 16'd0, 12'd319, 4'd0 };
    mem[320] = { 16'd0, 12'd320, 4'd0 };
    mem[321] = { 16'd0, 12'd321, 4'd0 };
    mem[322] = { 16'd0, 12'd322, 4'd0 };
    mem[323] = { 16'd0, 12'd323, 4'd0 };
    mem[324] = { 16'd0, 12'd324, 4'd0 };
    mem[325] = { 16'd0, 12'd325, 4'd0 };
    mem[326] = { 16'd0, 12'd326, 4'd0 };
    mem[327] = { 16'd0, 12'd327, 4'd0 };
    mem[328] = { 16'd0, 12'd328, 4'd0 };
    mem[329] = { 16'd0, 12'd329, 4'd0 };
    mem[330] = { 16'd0, 12'd330, 4'd0 };
    mem[331] = { 16'd0, 12'd331, 4'd0 };
    mem[332] = { 16'd0, 12'd332, 4'd0 };
    mem[333] = { 16'd0, 12'd333, 4'd0 };
    mem[334] = { 16'd0, 12'd334, 4'd0 };
    mem[335] = { 16'd0, 12'd335, 4'd0 };
    mem[336] = { 16'd0, 12'd336, 4'd0 };
    mem[337] = { 16'd0, 12'd337, 4'd0 };
    mem[338] = { 16'd0, 12'd338, 4'd0 };
    mem[339] = { 16'd0, 12'd339, 4'd0 };
    mem[340] = { 16'd0, 12'd340, 4'd0 };
    mem[341] = { 16'd0, 12'd341, 4'd0 };
    mem[342] = { 16'd0, 12'd342, 4'd0 };
    mem[343] = { 16'd0, 12'd343, 4'd0 };
    mem[344] = { 16'd0, 12'd344, 4'd0 };
    mem[345] = { 16'd0, 12'd345, 4'd0 };
    mem[346] = { 16'd0, 12'd346, 4'd0 };
    mem[347] = { 16'd0, 12'd347, 4'd0 };
    mem[348] = { 16'd0, 12'd348, 4'd0 };
    mem[349] = { 16'd0, 12'd349, 4'd0 };
    mem[350] = { 16'd0, 12'd350, 4'd0 };
    mem[351] = { 16'd0, 12'd351, 4'd0 };
    mem[352] = { 16'd0, 12'd352, 4'd0 };
    mem[353] = { 16'd0, 12'd353, 4'd0 };
    mem[354] = { 16'd0, 12'd354, 4'd0 };
    mem[355] = { 16'd0, 12'd355, 4'd0 };
    mem[356] = { 16'd0, 12'd356, 4'd0 };
    mem[357] = { 16'd0, 12'd357, 4'd0 };
    mem[358] = { 16'd0, 12'd358, 4'd0 };
    mem[359] = { 16'd0, 12'd359, 4'd0 };
    mem[360] = { 16'd0, 12'd360, 4'd0 };
    mem[361] = { 16'd0, 12'd361, 4'd0 };
    mem[362] = { 16'd0, 12'd362, 4'd0 };
    mem[363] = { 16'd0, 12'd363, 4'd0 };
    mem[364] = { 16'd0, 12'd364, 4'd0 };
    mem[365] = { 16'd0, 12'd365, 4'd0 };
    mem[366] = { 16'd0, 12'd366, 4'd0 };
    mem[367] = { 16'd0, 12'd367, 4'd0 };
    mem[368] = { 16'd0, 12'd368, 4'd0 };
    mem[369] = { 16'd0, 12'd369, 4'd0 };
    mem[370] = { 16'd0, 12'd370, 4'd0 };
    mem[371] = { 16'd0, 12'd371, 4'd0 };
    mem[372] = { 16'd0, 12'd372, 4'd0 };
    mem[373] = { 16'd0, 12'd373, 4'd0 };
    mem[374] = { 16'd0, 12'd374, 4'd0 };
    mem[375] = { 16'd0, 12'd375, 4'd0 };
    mem[376] = { 16'd0, 12'd376, 4'd0 };
    mem[377] = { 16'd0, 12'd377, 4'd0 };
    mem[378] = { 16'd0, 12'd378, 4'd0 };
    mem[379] = { 16'd0, 12'd379, 4'd0 };
    mem[380] = { 16'd0, 12'd380, 4'd0 };
    mem[381] = { 16'd0, 12'd381, 4'd0 };
    mem[382] = { 16'd0, 12'd382, 4'd0 };
    mem[383] = { 16'd0, 12'd383, 4'd0 };
    mem[384] = { 16'd0, 12'd384, 4'd0 };
    mem[385] = { 16'd0, 12'd385, 4'd0 };
    mem[386] = { 16'd0, 12'd386, 4'd0 };
    mem[387] = { 16'd0, 12'd387, 4'd0 };
    mem[388] = { 16'd0, 12'd388, 4'd0 };
    mem[389] = { 16'd0, 12'd389, 4'd0 };
    mem[390] = { 16'd0, 12'd390, 4'd0 };
    mem[391] = { 16'd0, 12'd391, 4'd0 };
    mem[392] = { 16'd0, 12'd392, 4'd0 };
    mem[393] = { 16'd0, 12'd393, 4'd0 };
    mem[394] = { 16'd0, 12'd394, 4'd0 };
    mem[395] = { 16'd0, 12'd395, 4'd0 };
    mem[396] = { 16'd0, 12'd396, 4'd0 };
    mem[397] = { 16'd0, 12'd397, 4'd0 };
    mem[398] = { 16'd0, 12'd398, 4'd0 };
    mem[399] = { 16'd0, 12'd399, 4'd0 };
    mem[400] = { 16'd0, 12'd400, 4'd0 };
    mem[401] = { 16'd0, 12'd401, 4'd0 };
    mem[402] = { 16'd0, 12'd402, 4'd0 };
    mem[403] = { 16'd0, 12'd403, 4'd0 };
    mem[404] = { 16'd0, 12'd404, 4'd0 };
    mem[405] = { 16'd0, 12'd405, 4'd0 };
    mem[406] = { 16'd0, 12'd406, 4'd0 };
    mem[407] = { 16'd0, 12'd407, 4'd0 };
    mem[408] = { 16'd0, 12'd408, 4'd0 };
    mem[409] = { 16'd0, 12'd409, 4'd0 };
    mem[410] = { 16'd0, 12'd410, 4'd0 };
    mem[411] = { 16'd0, 12'd411, 4'd0 };
    mem[412] = { 16'd0, 12'd412, 4'd0 };
    mem[413] = { 16'd0, 12'd413, 4'd0 };
    mem[414] = { 16'd0, 12'd414, 4'd0 };
    mem[415] = { 16'd0, 12'd415, 4'd0 };
    mem[416] = { 16'd0, 12'd416, 4'd0 };
    mem[417] = { 16'd0, 12'd417, 4'd0 };
    mem[418] = { 16'd0, 12'd418, 4'd0 };
    mem[419] = { 16'd0, 12'd419, 4'd0 };
    mem[420] = { 16'd0, 12'd420, 4'd0 };
    mem[421] = { 16'd0, 12'd421, 4'd0 };
    mem[422] = { 16'd0, 12'd422, 4'd0 };
    mem[423] = { 16'd0, 12'd423, 4'd0 };
    mem[424] = { 16'd0, 12'd424, 4'd0 };
    mem[425] = { 16'd0, 12'd425, 4'd0 };
    mem[426] = { 16'd0, 12'd426, 4'd0 };
    mem[427] = { 16'd0, 12'd427, 4'd0 };
    mem[428] = { 16'd0, 12'd428, 4'd0 };
    mem[429] = { 16'd0, 12'd429, 4'd0 };
    mem[430] = { 16'd0, 12'd430, 4'd0 };
    mem[431] = { 16'd0, 12'd431, 4'd0 };
    mem[432] = { 16'd0, 12'd432, 4'd0 };
    mem[433] = { 16'd0, 12'd433, 4'd0 };
    mem[434] = { 16'd0, 12'd434, 4'd0 };
    mem[435] = { 16'd0, 12'd435, 4'd0 };
    mem[436] = { 16'd0, 12'd436, 4'd0 };
    mem[437] = { 16'd0, 12'd437, 4'd0 };
    mem[438] = { 16'd0, 12'd438, 4'd0 };
    mem[439] = { 16'd0, 12'd439, 4'd0 };
    mem[440] = { 16'd0, 12'd440, 4'd0 };
    mem[441] = { 16'd0, 12'd441, 4'd0 };
    mem[442] = { 16'd0, 12'd442, 4'd0 };
    mem[443] = { 16'd0, 12'd443, 4'd0 };
    mem[444] = { 16'd0, 12'd444, 4'd0 };
    mem[445] = { 16'd0, 12'd445, 4'd0 };
    mem[446] = { 16'd0, 12'd446, 4'd0 };
    mem[447] = { 16'd0, 12'd447, 4'd0 };
    mem[448] = { 16'd0, 12'd448, 4'd0 };
    mem[449] = { 16'd0, 12'd449, 4'd0 };
    mem[450] = { 16'd0, 12'd450, 4'd0 };
    mem[451] = { 16'd0, 12'd451, 4'd0 };
    mem[452] = { 16'd0, 12'd452, 4'd0 };
    mem[453] = { 16'd0, 12'd453, 4'd0 };
    mem[454] = { 16'd0, 12'd454, 4'd0 };
    mem[455] = { 16'd0, 12'd455, 4'd0 };
    mem[456] = { 16'd0, 12'd456, 4'd0 };
    mem[457] = { 16'd0, 12'd457, 4'd0 };
    mem[458] = { 16'd0, 12'd458, 4'd0 };
    mem[459] = { 16'd0, 12'd459, 4'd0 };
    mem[460] = { 16'd0, 12'd460, 4'd0 };
    mem[461] = { 16'd0, 12'd461, 4'd0 };
    mem[462] = { 16'd0, 12'd462, 4'd0 };
    mem[463] = { 16'd0, 12'd463, 4'd0 };
    mem[464] = { 16'd0, 12'd464, 4'd0 };
    mem[465] = { 16'd0, 12'd465, 4'd0 };
    mem[466] = { 16'd0, 12'd466, 4'd0 };
    mem[467] = { 16'd0, 12'd467, 4'd0 };
    mem[468] = { 16'd0, 12'd468, 4'd0 };
    mem[469] = { 16'd0, 12'd469, 4'd0 };
    mem[470] = { 16'd0, 12'd470, 4'd0 };
    mem[471] = { 16'd0, 12'd471, 4'd0 };
    mem[472] = { 16'd0, 12'd472, 4'd0 };
    mem[473] = { 16'd0, 12'd473, 4'd0 };
    mem[474] = { 16'd0, 12'd474, 4'd0 };
    mem[475] = { 16'd0, 12'd475, 4'd0 };
    mem[476] = { 16'd0, 12'd476, 4'd0 };
    mem[477] = { 16'd0, 12'd477, 4'd0 };
    mem[478] = { 16'd0, 12'd478, 4'd0 };
    mem[479] = { 16'd0, 12'd479, 4'd0 };
    mem[480] = { 16'd0, 12'd480, 4'd0 };
    mem[481] = { 16'd0, 12'd481, 4'd0 };
    mem[482] = { 16'd0, 12'd482, 4'd0 };
    mem[483] = { 16'd0, 12'd483, 4'd0 };
    mem[484] = { 16'd0, 12'd484, 4'd0 };
    mem[485] = { 16'd0, 12'd485, 4'd0 };
    mem[486] = { 16'd0, 12'd486, 4'd0 };
    mem[487] = { 16'd0, 12'd487, 4'd0 };
    mem[488] = { 16'd0, 12'd488, 4'd0 };
    mem[489] = { 16'd0, 12'd489, 4'd0 };
    mem[490] = { 16'd0, 12'd490, 4'd0 };
    mem[491] = { 16'd0, 12'd491, 4'd0 };
    mem[492] = { 16'd0, 12'd492, 4'd0 };
    mem[493] = { 16'd0, 12'd493, 4'd0 };
    mem[494] = { 16'd0, 12'd494, 4'd0 };
    mem[495] = { 16'd0, 12'd495, 4'd0 };
    mem[496] = { 16'd0, 12'd496, 4'd0 };
    mem[497] = { 16'd0, 12'd497, 4'd0 };
    mem[498] = { 16'd0, 12'd498, 4'd0 };
    mem[499] = { 16'd0, 12'd499, 4'd0 };
    mem[500] = { 16'd0, 12'd500, 4'd0 };
    mem[501] = { 16'd0, 12'd501, 4'd0 };
    mem[502] = { 16'd0, 12'd502, 4'd0 };
    mem[503] = { 16'd0, 12'd503, 4'd0 };
    mem[504] = { 16'd0, 12'd504, 4'd0 };
    mem[505] = { 16'd0, 12'd505, 4'd0 };
    mem[506] = { 16'd0, 12'd506, 4'd0 };
    mem[507] = { 16'd0, 12'd507, 4'd0 };
    mem[508] = { 16'd0, 12'd508, 4'd0 };
    mem[509] = { 16'd0, 12'd509, 4'd0 };
    mem[510] = { 16'd0, 12'd510, 4'd0 };
    mem[511] = { 16'd0, 12'd511, 4'd0 };
    mem[512] = { 16'd0, 12'd512, 4'd0 };
    mem[513] = { 16'd0, 12'd513, 4'd0 };
    mem[514] = { 16'd0, 12'd514, 4'd0 };
    mem[515] = { 16'd0, 12'd515, 4'd0 };
    mem[516] = { 16'd0, 12'd516, 4'd0 };
    mem[517] = { 16'd0, 12'd517, 4'd0 };
    mem[518] = { 16'd0, 12'd518, 4'd0 };
    mem[519] = { 16'd0, 12'd519, 4'd0 };
    mem[520] = { 16'd0, 12'd520, 4'd0 };
    mem[521] = { 16'd0, 12'd521, 4'd0 };
    mem[522] = { 16'd0, 12'd522, 4'd0 };
    mem[523] = { 16'd0, 12'd523, 4'd0 };
    mem[524] = { 16'd0, 12'd524, 4'd0 };
    mem[525] = { 16'd0, 12'd525, 4'd0 };
    mem[526] = { 16'd0, 12'd526, 4'd0 };
    mem[527] = { 16'd0, 12'd527, 4'd0 };
    mem[528] = { 16'd0, 12'd528, 4'd0 };
    mem[529] = { 16'd0, 12'd529, 4'd0 };
    mem[530] = { 16'd0, 12'd530, 4'd0 };
    mem[531] = { 16'd0, 12'd531, 4'd0 };
    mem[532] = { 16'd0, 12'd532, 4'd0 };
    mem[533] = { 16'd0, 12'd533, 4'd0 };
    mem[534] = { 16'd0, 12'd534, 4'd0 };
    mem[535] = { 16'd0, 12'd535, 4'd0 };
    mem[536] = { 16'd0, 12'd536, 4'd0 };
    mem[537] = { 16'd0, 12'd537, 4'd0 };
    mem[538] = { 16'd0, 12'd538, 4'd0 };
    mem[539] = { 16'd0, 12'd539, 4'd0 };
    mem[540] = { 16'd0, 12'd540, 4'd0 };
    mem[541] = { 16'd0, 12'd541, 4'd0 };
    mem[542] = { 16'd0, 12'd542, 4'd0 };
    mem[543] = { 16'd0, 12'd543, 4'd0 };
    mem[544] = { 16'd0, 12'd544, 4'd0 };
    mem[545] = { 16'd0, 12'd545, 4'd0 };
    mem[546] = { 16'd0, 12'd546, 4'd0 };
    mem[547] = { 16'd0, 12'd547, 4'd0 };
    mem[548] = { 16'd0, 12'd548, 4'd0 };
    mem[549] = { 16'd0, 12'd549, 4'd0 };
    mem[550] = { 16'd0, 12'd550, 4'd0 };
    mem[551] = { 16'd0, 12'd551, 4'd0 };
    mem[552] = { 16'd0, 12'd552, 4'd0 };
    mem[553] = { 16'd0, 12'd553, 4'd0 };
    mem[554] = { 16'd0, 12'd554, 4'd0 };
    mem[555] = { 16'd0, 12'd555, 4'd0 };
    mem[556] = { 16'd0, 12'd556, 4'd0 };
    mem[557] = { 16'd0, 12'd557, 4'd0 };
    mem[558] = { 16'd0, 12'd558, 4'd0 };
    mem[559] = { 16'd0, 12'd559, 4'd0 };
    mem[560] = { 16'd0, 12'd560, 4'd0 };
    mem[561] = { 16'd0, 12'd561, 4'd0 };
    mem[562] = { 16'd0, 12'd562, 4'd0 };
    mem[563] = { 16'd0, 12'd563, 4'd0 };
    mem[564] = { 16'd0, 12'd564, 4'd0 };
    mem[565] = { 16'd0, 12'd565, 4'd0 };
    mem[566] = { 16'd0, 12'd566, 4'd0 };
    mem[567] = { 16'd0, 12'd567, 4'd0 };
    mem[568] = { 16'd0, 12'd568, 4'd0 };
    mem[569] = { 16'd0, 12'd569, 4'd0 };
    mem[570] = { 16'd0, 12'd570, 4'd0 };
    mem[571] = { 16'd0, 12'd571, 4'd0 };
    mem[572] = { 16'd0, 12'd572, 4'd0 };
    mem[573] = { 16'd0, 12'd573, 4'd0 };
    mem[574] = { 16'd0, 12'd574, 4'd0 };
    mem[575] = { 16'd0, 12'd575, 4'd0 };
    mem[576] = { 16'd0, 12'd576, 4'd0 };
    mem[577] = { 16'd0, 12'd577, 4'd0 };
    mem[578] = { 16'd0, 12'd578, 4'd0 };
    mem[579] = { 16'd0, 12'd579, 4'd0 };
    mem[580] = { 16'd0, 12'd580, 4'd0 };
    mem[581] = { 16'd0, 12'd581, 4'd0 };
    mem[582] = { 16'd0, 12'd582, 4'd0 };
    mem[583] = { 16'd0, 12'd583, 4'd0 };
    mem[584] = { 16'd0, 12'd584, 4'd0 };
    mem[585] = { 16'd0, 12'd585, 4'd0 };
    mem[586] = { 16'd0, 12'd586, 4'd0 };
    mem[587] = { 16'd0, 12'd587, 4'd0 };
    mem[588] = { 16'd0, 12'd588, 4'd0 };
    mem[589] = { 16'd0, 12'd589, 4'd0 };
    mem[590] = { 16'd0, 12'd590, 4'd0 };
    mem[591] = { 16'd0, 12'd591, 4'd0 };
    mem[592] = { 16'd0, 12'd592, 4'd0 };
    mem[593] = { 16'd0, 12'd593, 4'd0 };
    mem[594] = { 16'd0, 12'd594, 4'd0 };
    mem[595] = { 16'd0, 12'd595, 4'd0 };
    mem[596] = { 16'd0, 12'd596, 4'd0 };
    mem[597] = { 16'd0, 12'd597, 4'd0 };
    mem[598] = { 16'd0, 12'd598, 4'd0 };
    mem[599] = { 16'd0, 12'd599, 4'd0 };
    mem[600] = { 16'd0, 12'd600, 4'd0 };
    mem[601] = { 16'd0, 12'd601, 4'd0 };
    mem[602] = { 16'd0, 12'd602, 4'd0 };
    mem[603] = { 16'd0, 12'd603, 4'd0 };
    mem[604] = { 16'd0, 12'd604, 4'd0 };
    mem[605] = { 16'd0, 12'd605, 4'd0 };
    mem[606] = { 16'd0, 12'd606, 4'd0 };
    mem[607] = { 16'd0, 12'd607, 4'd0 };
    mem[608] = { 16'd0, 12'd608, 4'd0 };
    mem[609] = { 16'd0, 12'd609, 4'd0 };
    mem[610] = { 16'd0, 12'd610, 4'd0 };
    mem[611] = { 16'd0, 12'd611, 4'd0 };
    mem[612] = { 16'd0, 12'd612, 4'd0 };
    mem[613] = { 16'd0, 12'd613, 4'd0 };
    mem[614] = { 16'd0, 12'd614, 4'd0 };
    mem[615] = { 16'd0, 12'd615, 4'd0 };
    mem[616] = { 16'd0, 12'd616, 4'd0 };
    mem[617] = { 16'd0, 12'd617, 4'd0 };
    mem[618] = { 16'd0, 12'd618, 4'd0 };
    mem[619] = { 16'd0, 12'd619, 4'd0 };
    mem[620] = { 16'd0, 12'd620, 4'd0 };
    mem[621] = { 16'd0, 12'd621, 4'd0 };
    mem[622] = { 16'd0, 12'd622, 4'd0 };
    mem[623] = { 16'd0, 12'd623, 4'd0 };
    mem[624] = { 16'd0, 12'd624, 4'd0 };
    mem[625] = { 16'd0, 12'd625, 4'd0 };
    mem[626] = { 16'd0, 12'd626, 4'd0 };
    mem[627] = { 16'd0, 12'd627, 4'd0 };
    mem[628] = { 16'd0, 12'd628, 4'd0 };
    mem[629] = { 16'd0, 12'd629, 4'd0 };
    mem[630] = { 16'd0, 12'd630, 4'd0 };
    mem[631] = { 16'd0, 12'd631, 4'd0 };
    mem[632] = { 16'd0, 12'd632, 4'd0 };
    mem[633] = { 16'd0, 12'd633, 4'd0 };
    mem[634] = { 16'd0, 12'd634, 4'd0 };
    mem[635] = { 16'd0, 12'd635, 4'd0 };
    mem[636] = { 16'd0, 12'd636, 4'd0 };
    mem[637] = { 16'd0, 12'd637, 4'd0 };
    mem[638] = { 16'd0, 12'd638, 4'd0 };
    mem[639] = { 16'd0, 12'd639, 4'd0 };
    mem[640] = { 16'd0, 12'd640, 4'd0 };
    mem[641] = { 16'd0, 12'd641, 4'd0 };
    mem[642] = { 16'd0, 12'd642, 4'd0 };
    mem[643] = { 16'd0, 12'd643, 4'd0 };
    mem[644] = { 16'd0, 12'd644, 4'd0 };
    mem[645] = { 16'd0, 12'd645, 4'd0 };
    mem[646] = { 16'd0, 12'd646, 4'd0 };
    mem[647] = { 16'd0, 12'd647, 4'd0 };
    mem[648] = { 16'd0, 12'd648, 4'd0 };
    mem[649] = { 16'd0, 12'd649, 4'd0 };
    mem[650] = { 16'd0, 12'd650, 4'd0 };
    mem[651] = { 16'd0, 12'd651, 4'd0 };
    mem[652] = { 16'd0, 12'd652, 4'd0 };
    mem[653] = { 16'd0, 12'd653, 4'd0 };
    mem[654] = { 16'd0, 12'd654, 4'd0 };
    mem[655] = { 16'd0, 12'd655, 4'd0 };
    mem[656] = { 16'd0, 12'd656, 4'd0 };
    mem[657] = { 16'd0, 12'd657, 4'd0 };
    mem[658] = { 16'd0, 12'd658, 4'd0 };
    mem[659] = { 16'd0, 12'd659, 4'd0 };
    mem[660] = { 16'd0, 12'd660, 4'd0 };
    mem[661] = { 16'd0, 12'd661, 4'd0 };
    mem[662] = { 16'd0, 12'd662, 4'd0 };
    mem[663] = { 16'd0, 12'd663, 4'd0 };
    mem[664] = { 16'd0, 12'd664, 4'd0 };
    mem[665] = { 16'd0, 12'd665, 4'd0 };
    mem[666] = { 16'd0, 12'd666, 4'd0 };
    mem[667] = { 16'd0, 12'd667, 4'd0 };
    mem[668] = { 16'd0, 12'd668, 4'd0 };
    mem[669] = { 16'd0, 12'd669, 4'd0 };
    mem[670] = { 16'd0, 12'd670, 4'd0 };
    mem[671] = { 16'd0, 12'd671, 4'd0 };
    mem[672] = { 16'd0, 12'd672, 4'd0 };
    mem[673] = { 16'd0, 12'd673, 4'd0 };
    mem[674] = { 16'd0, 12'd674, 4'd0 };
    mem[675] = { 16'd0, 12'd675, 4'd0 };
    mem[676] = { 16'd0, 12'd676, 4'd0 };
    mem[677] = { 16'd0, 12'd677, 4'd0 };
    mem[678] = { 16'd0, 12'd678, 4'd0 };
    mem[679] = { 16'd0, 12'd679, 4'd0 };
    mem[680] = { 16'd0, 12'd680, 4'd0 };
    mem[681] = { 16'd0, 12'd681, 4'd0 };
    mem[682] = { 16'd0, 12'd682, 4'd0 };
    mem[683] = { 16'd0, 12'd683, 4'd0 };
    mem[684] = { 16'd0, 12'd684, 4'd0 };
    mem[685] = { 16'd0, 12'd685, 4'd0 };
    mem[686] = { 16'd0, 12'd686, 4'd0 };
    mem[687] = { 16'd0, 12'd687, 4'd0 };
    mem[688] = { 16'd0, 12'd688, 4'd0 };
    mem[689] = { 16'd0, 12'd689, 4'd0 };
    mem[690] = { 16'd0, 12'd690, 4'd0 };
    mem[691] = { 16'd0, 12'd691, 4'd0 };
    mem[692] = { 16'd0, 12'd692, 4'd0 };
    mem[693] = { 16'd0, 12'd693, 4'd0 };
    mem[694] = { 16'd0, 12'd694, 4'd0 };
    mem[695] = { 16'd0, 12'd695, 4'd0 };
    mem[696] = { 16'd0, 12'd696, 4'd0 };
    mem[697] = { 16'd0, 12'd697, 4'd0 };
    mem[698] = { 16'd0, 12'd698, 4'd0 };
    mem[699] = { 16'd0, 12'd699, 4'd0 };
    mem[700] = { 16'd0, 12'd700, 4'd0 };
    mem[701] = { 16'd0, 12'd701, 4'd0 };
    mem[702] = { 16'd0, 12'd702, 4'd0 };
    mem[703] = { 16'd0, 12'd703, 4'd0 };
    mem[704] = { 16'd0, 12'd704, 4'd0 };
    mem[705] = { 16'd0, 12'd705, 4'd0 };
    mem[706] = { 16'd0, 12'd706, 4'd0 };
    mem[707] = { 16'd0, 12'd707, 4'd0 };
    mem[708] = { 16'd0, 12'd708, 4'd0 };
    mem[709] = { 16'd0, 12'd709, 4'd0 };
    mem[710] = { 16'd0, 12'd710, 4'd0 };
    mem[711] = { 16'd0, 12'd711, 4'd0 };
    mem[712] = { 16'd0, 12'd712, 4'd0 };
    mem[713] = { 16'd0, 12'd713, 4'd0 };
    mem[714] = { 16'd0, 12'd714, 4'd0 };
    mem[715] = { 16'd0, 12'd715, 4'd0 };
    mem[716] = { 16'd0, 12'd716, 4'd0 };
    mem[717] = { 16'd0, 12'd717, 4'd0 };
    mem[718] = { 16'd0, 12'd718, 4'd0 };
    mem[719] = { 16'd0, 12'd719, 4'd0 };
    mem[720] = { 16'd0, 12'd720, 4'd0 };
    mem[721] = { 16'd0, 12'd721, 4'd0 };
    mem[722] = { 16'd0, 12'd722, 4'd0 };
    mem[723] = { 16'd0, 12'd723, 4'd0 };
    mem[724] = { 16'd0, 12'd724, 4'd0 };
    mem[725] = { 16'd0, 12'd725, 4'd0 };
    mem[726] = { 16'd0, 12'd726, 4'd0 };
    mem[727] = { 16'd0, 12'd727, 4'd0 };
    mem[728] = { 16'd0, 12'd728, 4'd0 };
    mem[729] = { 16'd0, 12'd729, 4'd0 };
    mem[730] = { 16'd0, 12'd730, 4'd0 };
    mem[731] = { 16'd0, 12'd731, 4'd0 };
    mem[732] = { 16'd0, 12'd732, 4'd0 };
    mem[733] = { 16'd0, 12'd733, 4'd0 };
    mem[734] = { 16'd0, 12'd734, 4'd0 };
    mem[735] = { 16'd0, 12'd735, 4'd0 };
    mem[736] = { 16'd0, 12'd736, 4'd0 };
    mem[737] = { 16'd0, 12'd737, 4'd0 };
    mem[738] = { 16'd0, 12'd738, 4'd0 };
    mem[739] = { 16'd0, 12'd739, 4'd0 };
    mem[740] = { 16'd0, 12'd740, 4'd0 };
    mem[741] = { 16'd0, 12'd741, 4'd0 };
    mem[742] = { 16'd0, 12'd742, 4'd0 };
    mem[743] = { 16'd0, 12'd743, 4'd0 };
    mem[744] = { 16'd0, 12'd744, 4'd0 };
    mem[745] = { 16'd0, 12'd745, 4'd0 };
    mem[746] = { 16'd0, 12'd746, 4'd0 };
    mem[747] = { 16'd0, 12'd747, 4'd0 };
    mem[748] = { 16'd0, 12'd748, 4'd0 };
    mem[749] = { 16'd0, 12'd749, 4'd0 };
    mem[750] = { 16'd0, 12'd750, 4'd0 };
    mem[751] = { 16'd0, 12'd751, 4'd0 };
    mem[752] = { 16'd0, 12'd752, 4'd0 };
    mem[753] = { 16'd0, 12'd753, 4'd0 };
    mem[754] = { 16'd0, 12'd754, 4'd0 };
    mem[755] = { 16'd0, 12'd755, 4'd0 };
    mem[756] = { 16'd0, 12'd756, 4'd0 };
    mem[757] = { 16'd0, 12'd757, 4'd0 };
    mem[758] = { 16'd0, 12'd758, 4'd0 };
    mem[759] = { 16'd0, 12'd759, 4'd0 };
    mem[760] = { 16'd0, 12'd760, 4'd0 };
    mem[761] = { 16'd0, 12'd761, 4'd0 };
    mem[762] = { 16'd0, 12'd762, 4'd0 };
    mem[763] = { 16'd0, 12'd763, 4'd0 };
    mem[764] = { 16'd0, 12'd764, 4'd0 };
    mem[765] = { 16'd0, 12'd765, 4'd0 };
    mem[766] = { 16'd0, 12'd766, 4'd0 };
    mem[767] = { 16'd0, 12'd767, 4'd0 };
    mem[768] = { 16'd0, 12'd768, 4'd0 };
    mem[769] = { 16'd0, 12'd769, 4'd0 };
    mem[770] = { 16'd0, 12'd770, 4'd0 };
    mem[771] = { 16'd0, 12'd771, 4'd0 };
    mem[772] = { 16'd0, 12'd772, 4'd0 };
    mem[773] = { 16'd0, 12'd773, 4'd0 };
    mem[774] = { 16'd0, 12'd774, 4'd0 };
    mem[775] = { 16'd0, 12'd775, 4'd0 };
    mem[776] = { 16'd0, 12'd776, 4'd0 };
    mem[777] = { 16'd0, 12'd777, 4'd0 };
    mem[778] = { 16'd0, 12'd778, 4'd0 };
    mem[779] = { 16'd0, 12'd779, 4'd0 };
    mem[780] = { 16'd0, 12'd780, 4'd0 };
    mem[781] = { 16'd0, 12'd781, 4'd0 };
    mem[782] = { 16'd0, 12'd782, 4'd0 };
    mem[783] = { 16'd0, 12'd783, 4'd0 };
    mem[784] = { 16'd0, 12'd784, 4'd0 };
    mem[785] = { 16'd0, 12'd785, 4'd0 };
    mem[786] = { 16'd0, 12'd786, 4'd0 };
    mem[787] = { 16'd0, 12'd787, 4'd0 };
    mem[788] = { 16'd0, 12'd788, 4'd0 };
    mem[789] = { 16'd0, 12'd789, 4'd0 };
    mem[790] = { 16'd0, 12'd790, 4'd0 };
    mem[791] = { 16'd0, 12'd791, 4'd0 };
    mem[792] = { 16'd0, 12'd792, 4'd0 };
    mem[793] = { 16'd0, 12'd793, 4'd0 };
    mem[794] = { 16'd0, 12'd794, 4'd0 };
    mem[795] = { 16'd0, 12'd795, 4'd0 };
    mem[796] = { 16'd0, 12'd796, 4'd0 };
    mem[797] = { 16'd0, 12'd797, 4'd0 };
    mem[798] = { 16'd0, 12'd798, 4'd0 };
    mem[799] = { 16'd0, 12'd799, 4'd0 };
    mem[800] = { 16'd0, 12'd800, 4'd0 };
    mem[801] = { 16'd0, 12'd801, 4'd0 };
    mem[802] = { 16'd0, 12'd802, 4'd0 };
    mem[803] = { 16'd0, 12'd803, 4'd0 };
    mem[804] = { 16'd0, 12'd804, 4'd0 };
    mem[805] = { 16'd0, 12'd805, 4'd0 };
    mem[806] = { 16'd0, 12'd806, 4'd0 };
    mem[807] = { 16'd0, 12'd807, 4'd0 };
    mem[808] = { 16'd0, 12'd808, 4'd0 };
    mem[809] = { 16'd0, 12'd809, 4'd0 };
    mem[810] = { 16'd0, 12'd810, 4'd0 };
    mem[811] = { 16'd0, 12'd811, 4'd0 };
    mem[812] = { 16'd0, 12'd812, 4'd0 };
    mem[813] = { 16'd0, 12'd813, 4'd0 };
    mem[814] = { 16'd0, 12'd814, 4'd0 };
    mem[815] = { 16'd0, 12'd815, 4'd0 };
    mem[816] = { 16'd0, 12'd816, 4'd0 };
    mem[817] = { 16'd0, 12'd817, 4'd0 };
    mem[818] = { 16'd0, 12'd818, 4'd0 };
    mem[819] = { 16'd0, 12'd819, 4'd0 };
    mem[820] = { 16'd0, 12'd820, 4'd0 };
    mem[821] = { 16'd0, 12'd821, 4'd0 };
    mem[822] = { 16'd0, 12'd822, 4'd0 };
    mem[823] = { 16'd0, 12'd823, 4'd0 };
    mem[824] = { 16'd0, 12'd824, 4'd0 };
    mem[825] = { 16'd0, 12'd825, 4'd0 };
    mem[826] = { 16'd0, 12'd826, 4'd0 };
    mem[827] = { 16'd0, 12'd827, 4'd0 };
    mem[828] = { 16'd0, 12'd828, 4'd0 };
    mem[829] = { 16'd0, 12'd829, 4'd0 };
    mem[830] = { 16'd0, 12'd830, 4'd0 };
    mem[831] = { 16'd0, 12'd831, 4'd0 };
    mem[832] = { 16'd0, 12'd832, 4'd0 };
    mem[833] = { 16'd0, 12'd833, 4'd0 };
    mem[834] = { 16'd0, 12'd834, 4'd0 };
    mem[835] = { 16'd0, 12'd835, 4'd0 };
    mem[836] = { 16'd0, 12'd836, 4'd0 };
    mem[837] = { 16'd0, 12'd837, 4'd0 };
    mem[838] = { 16'd0, 12'd838, 4'd0 };
    mem[839] = { 16'd0, 12'd839, 4'd0 };
    mem[840] = { 16'd0, 12'd840, 4'd0 };
    mem[841] = { 16'd0, 12'd841, 4'd0 };
    mem[842] = { 16'd0, 12'd842, 4'd0 };
    mem[843] = { 16'd0, 12'd843, 4'd0 };
    mem[844] = { 16'd0, 12'd844, 4'd0 };
    mem[845] = { 16'd0, 12'd845, 4'd0 };
    mem[846] = { 16'd0, 12'd846, 4'd0 };
    mem[847] = { 16'd0, 12'd847, 4'd0 };
    mem[848] = { 16'd0, 12'd848, 4'd0 };
    mem[849] = { 16'd0, 12'd849, 4'd0 };
    mem[850] = { 16'd0, 12'd850, 4'd0 };
    mem[851] = { 16'd0, 12'd851, 4'd0 };
    mem[852] = { 16'd0, 12'd852, 4'd0 };
    mem[853] = { 16'd0, 12'd853, 4'd0 };
    mem[854] = { 16'd0, 12'd854, 4'd0 };
    mem[855] = { 16'd0, 12'd855, 4'd0 };
    mem[856] = { 16'd0, 12'd856, 4'd0 };
    mem[857] = { 16'd0, 12'd857, 4'd0 };
    mem[858] = { 16'd0, 12'd858, 4'd0 };
    mem[859] = { 16'd0, 12'd859, 4'd0 };
    mem[860] = { 16'd0, 12'd860, 4'd0 };
    mem[861] = { 16'd0, 12'd861, 4'd0 };
    mem[862] = { 16'd0, 12'd862, 4'd0 };
    mem[863] = { 16'd0, 12'd863, 4'd0 };
    mem[864] = { 16'd0, 12'd864, 4'd0 };
    mem[865] = { 16'd0, 12'd865, 4'd0 };
    mem[866] = { 16'd0, 12'd866, 4'd0 };
    mem[867] = { 16'd0, 12'd867, 4'd0 };
    mem[868] = { 16'd0, 12'd868, 4'd0 };
    mem[869] = { 16'd0, 12'd869, 4'd0 };
    mem[870] = { 16'd0, 12'd870, 4'd0 };
    mem[871] = { 16'd0, 12'd871, 4'd0 };
    mem[872] = { 16'd0, 12'd872, 4'd0 };
    mem[873] = { 16'd0, 12'd873, 4'd0 };
    mem[874] = { 16'd0, 12'd874, 4'd0 };
    mem[875] = { 16'd0, 12'd875, 4'd0 };
    mem[876] = { 16'd0, 12'd876, 4'd0 };
    mem[877] = { 16'd0, 12'd877, 4'd0 };
    mem[878] = { 16'd0, 12'd878, 4'd0 };
    mem[879] = { 16'd0, 12'd879, 4'd0 };
    mem[880] = { 16'd0, 12'd880, 4'd0 };
    mem[881] = { 16'd0, 12'd881, 4'd0 };
    mem[882] = { 16'd0, 12'd882, 4'd0 };
    mem[883] = { 16'd0, 12'd883, 4'd0 };
    mem[884] = { 16'd0, 12'd884, 4'd0 };
    mem[885] = { 16'd0, 12'd885, 4'd0 };
    mem[886] = { 16'd0, 12'd886, 4'd0 };
    mem[887] = { 16'd0, 12'd887, 4'd0 };
    mem[888] = { 16'd0, 12'd888, 4'd0 };
    mem[889] = { 16'd0, 12'd889, 4'd0 };
    mem[890] = { 16'd0, 12'd890, 4'd0 };
    mem[891] = { 16'd0, 12'd891, 4'd0 };
    mem[892] = { 16'd0, 12'd892, 4'd0 };
    mem[893] = { 16'd0, 12'd893, 4'd0 };
    mem[894] = { 16'd0, 12'd894, 4'd0 };
    mem[895] = { 16'd0, 12'd895, 4'd0 };
    mem[896] = { 16'd0, 12'd896, 4'd0 };
    mem[897] = { 16'd0, 12'd897, 4'd0 };
    mem[898] = { 16'd0, 12'd898, 4'd0 };
    mem[899] = { 16'd0, 12'd899, 4'd0 };
    mem[900] = { 16'd0, 12'd900, 4'd0 };
    mem[901] = { 16'd0, 12'd901, 4'd0 };
    mem[902] = { 16'd0, 12'd902, 4'd0 };
    mem[903] = { 16'd0, 12'd903, 4'd0 };
    mem[904] = { 16'd0, 12'd904, 4'd0 };
    mem[905] = { 16'd0, 12'd905, 4'd0 };
    mem[906] = { 16'd0, 12'd906, 4'd0 };
    mem[907] = { 16'd0, 12'd907, 4'd0 };
    mem[908] = { 16'd0, 12'd908, 4'd0 };
    mem[909] = { 16'd0, 12'd909, 4'd0 };
    mem[910] = { 16'd0, 12'd910, 4'd0 };
    mem[911] = { 16'd0, 12'd911, 4'd0 };
    mem[912] = { 16'd0, 12'd912, 4'd0 };
    mem[913] = { 16'd0, 12'd913, 4'd0 };
    mem[914] = { 16'd0, 12'd914, 4'd0 };
    mem[915] = { 16'd0, 12'd915, 4'd0 };
    mem[916] = { 16'd0, 12'd916, 4'd0 };
    mem[917] = { 16'd0, 12'd917, 4'd0 };
    mem[918] = { 16'd0, 12'd918, 4'd0 };
    mem[919] = { 16'd0, 12'd919, 4'd0 };
    mem[920] = { 16'd0, 12'd920, 4'd0 };
    mem[921] = { 16'd0, 12'd921, 4'd0 };
    mem[922] = { 16'd0, 12'd922, 4'd0 };
    mem[923] = { 16'd0, 12'd923, 4'd0 };
    mem[924] = 32'h0;
    mem[925] = 32'h0;
    mem[926] = 32'h0;
    mem[927] = 32'h0;
    mem[928] = 32'h0;
    mem[929] = 32'h0;
    mem[930] = 32'h0;
    mem[931] = 32'h0;
    mem[932] = 32'h0;
    mem[933] = 32'h0;
    mem[934] = 32'h0;
    mem[935] = 32'h0;
    mem[936] = 32'h0;
    mem[937] = 32'h0;
    mem[938] = 32'h0;
    mem[939] = 32'h0;
    mem[940] = 32'h0;
    mem[941] = 32'h0;
    mem[942] = 32'h0;
    mem[943] = 32'h0;
    mem[944] = 32'h0;
    mem[945] = 32'h0;
    mem[946] = 32'h0;
    mem[947] = 32'h0;
    mem[948] = 32'h0;
    mem[949] = 32'h0;
    mem[950] = 32'h0;
    mem[951] = 32'h0;
    mem[952] = 32'h0;
    mem[953] = 32'h0;
    mem[954] = 32'h0;
    mem[955] = 32'h0;
    mem[956] = 32'h0;
    mem[957] = 32'h0;
    mem[958] = 32'h0;
    mem[959] = 32'h0;
    mem[960] = 32'h0;
    mem[961] = 32'h0;
    mem[962] = 32'h0;
    mem[963] = 32'h0;
    mem[964] = 32'h0;
    mem[965] = 32'h0;
    mem[966] = 32'h0;
    mem[967] = 32'h0;
    mem[968] = 32'h0;
    mem[969] = 32'h0;
    mem[970] = 32'h0;
    mem[971] = 32'h0;
    mem[972] = 32'h0;
    mem[973] = 32'h0;
    mem[974] = 32'h0;
    mem[975] = 32'h0;
    mem[976] = 32'h0;
    mem[977] = 32'h0;
    mem[978] = 32'h0;
    mem[979] = 32'h0;
    mem[980] = 32'h0;
    mem[981] = 32'h0;
    mem[982] = 32'h0;
    mem[983] = 32'h0;
    mem[984] = 32'h0;
    mem[985] = 32'h0;
    mem[986] = 32'h0;
    mem[987] = 32'h0;
    mem[988] = 32'h0;
    mem[989] = 32'h0;
    mem[990] = 32'h0;
    mem[991] = 32'h0;
    mem[992] = 32'h0;
    mem[993] = 32'h0;
    mem[994] = 32'h0;
    mem[995] = 32'h0;
    mem[996] = 32'h0;
    mem[997] = 32'h0;
    mem[998] = 32'h0;
    mem[999] = 32'h0;
    mem[1000] = 32'h0;
    mem[1001] = 32'h0;
    mem[1002] = 32'h0;
    mem[1003] = 32'h0;
    mem[1004] = 32'h0;
    mem[1005] = 32'h0;
    mem[1006] = 32'h0;
    mem[1007] = 32'h0;
    mem[1008] = 32'h0;
    mem[1009] = 32'h0;
    mem[1010] = 32'h0;
    mem[1011] = 32'h0;
    mem[1012] = 32'h0;
    mem[1013] = 32'h0;
    mem[1014] = 32'h0;
    mem[1015] = 32'h0;
    mem[1016] = 32'h0;
    mem[1017] = 32'h0;
    mem[1018] = 32'h0;
    mem[1019] = 32'h0;
    mem[1020] = 32'h0;
    mem[1021] = 32'h0;
    mem[1022] = 32'h0;
    mem[1023] = 32'h0;
  end


  always @(posedge CLK) begin
    if(myram_0_wenable) begin
      mem[myram_0_addr] <= myram_0_wdata;
    end 
    myram_0_daddr <= myram_0_addr;
  end

  assign myram_0_rdata = mem[myram_0_daddr];

endmodule
"""


def test():
    veriloggen.reset()
    test_module = thread_ram_initvals_nocheck.mkTest()
    code = test_module.to_verilog()

    from pyverilog.vparser.parser import VerilogParser
    from pyverilog.ast_code_generator.codegen import ASTCodeGenerator
    parser = VerilogParser()
    expected_ast = parser.parse(expected_verilog)
    codegen = ASTCodeGenerator()
    expected_code = codegen.visit(expected_ast)

    assert(expected_code == code)
