# Generated by Django 4.1.7 on 2023-03-15 11:45

from django.db import migrations, models
import logpipe.settings


class Migration(migrations.Migration):

    dependencies = [
        ("logpipe", "0005_auto_20180917_1348"),
    ]

    operations = [
        migrations.AlterModelOptions(
            name="kafkaoffset",
            options={
                "ordering": ("topic", "partition", "offset"),
                "verbose_name": "Kafka Offset",
                "verbose_name_plural": "Kafka Offsets",
            },
        ),
        migrations.AlterModelOptions(
            name="kinesisoffset",
            options={
                "ordering": ("stream", "shard", "sequence_number"),
                "verbose_name": "AWS Kinesis Offset",
                "verbose_name_plural": "AWS Kinesis Offsets",
            },
        ),
        migrations.AlterField(
            model_name="kafkaoffset",
            name="offset",
            field=models.PositiveIntegerField(
                default=0,
                help_text="The current offset in the Kafka partition",
                verbose_name="Kafka Offset",
            ),
        ),
        migrations.AlterField(
            model_name="kafkaoffset",
            name="partition",
            field=models.PositiveIntegerField(
                help_text="The Kafka partition identifier",
                verbose_name="Kafka Partition ID",
            ),
        ),
        migrations.AlterField(
            model_name="kafkaoffset",
            name="topic",
            field=models.CharField(
                help_text="The Kafka topic name",
                max_length=200,
                verbose_name="Kafka Topic Name",
            ),
        ),
        migrations.AlterField(
            model_name="kinesisoffset",
            name="region",
            field=models.CharField(
                choices=[
                    ("us-east-1", "US East (N. Virginia)"),
                    ("us-east-2", "US East (Ohio)"),
                    ("us-west-1", "US West (N. California)"),
                    ("us-west-2", "US West (Oregon)"),
                    ("ap-south-1", "Asia Pacific (Mumbai)"),
                    ("ap-northeast-2", "Asia Pacific (Seoul)"),
                    ("ap-southeast-1", "Asia Pacific (Singapore)"),
                    ("ap-southeast-2", "Asia Pacific (Sydney)"),
                    ("ap-northeast-1", "Asia Pacific (Tokyo)"),
                    ("ca-central-1", "Canada (Central)"),
                    ("eu-central-1", "EU (Frankfurt)"),
                    ("eu-west-1", "EU (Ireland)"),
                    ("eu-west-2", "EU (London)"),
                    ("eu-west-3", "EU (Paris)"),
                    ("sa-east-1", "South America (São Paulo)"),
                    ("cn-north-1", "China (Beijing)"),
                    ("us-gov-west-1", "AWS GovCloud (US)"),
                ],
                default=logpipe.settings.get_aws_region,
                help_text="The Kinesis stream region name",
                max_length=20,
                verbose_name="AWS Region",
            ),
        ),
        migrations.AlterField(
            model_name="kinesisoffset",
            name="sequence_number",
            field=models.CharField(
                help_text="The current sequence number in the Kinesis shard",
                max_length=200,
                verbose_name="Kinesis Sequence Number",
            ),
        ),
        migrations.AlterField(
            model_name="kinesisoffset",
            name="shard",
            field=models.CharField(
                help_text="The Kinesis shard ID",
                max_length=200,
                verbose_name="Kinesis Shard ID",
            ),
        ),
        migrations.AlterField(
            model_name="kinesisoffset",
            name="stream",
            field=models.CharField(
                help_text="The Kinesis stream name",
                max_length=200,
                verbose_name="Kinesis Stream Name",
            ),
        ),
    ]
