#!/usr/bin/env python
from setuptools import setup, find_packages, Distribution
import codecs
import os.path

# Make sure versiontag exists before going any further
Distribution().fetch_build_eggs("versiontag>=1.2.0")

from versiontag import get_version, cache_git_tag  # NOQA


packages = find_packages("src")

install_requires = [
    "Django>=3.2",
    "djangorestframework>=3.11",
    "lru-dict>=1.1.6",
]

extras_require = {
    "development": [
        "flake8",
        "moto",
        "boto3",
        "psycopg2-binary",
        "tox",
        "versiontag",
        "pytz",
    ],
    "kafka": [
        "kafka-python",
    ],
    "kinesis": [
        "boto3",
    ],
    "msgpack": [
        "msgpack-python",
    ],
}


def fpath(name):
    return os.path.join(os.path.dirname(__file__), name)


def read(fname):
    return codecs.open(fpath(fname), encoding="utf-8").read()


cache_git_tag()

setup(
    name="django-logpipe",
    description="Move data around between Python services using Kafka and/or AWS Kinesis and Django Rest Framework serializers.",
    version=get_version(pypi=True),
    long_description=open("README.rst").read(),
    classifiers=[
        "Development Status :: 5 - Production/Stable",
        "Environment :: Console",
        "Environment :: Web Environment",
        "Framework :: Django",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: ISC License (ISCL)",
        "Operating System :: Unix",
        "Operating System :: MacOS :: MacOS X",
        "Programming Language :: Python",
        "Programming Language :: Python :: 3",
    ],
    author="thelabnyc",
    author_email="thelabdev@thelabnyc.com",
    url="https://gitlab.com/thelabnyc/django-logpipe",
    license="ISC",
    package_dir={"": "src"},
    packages=packages,
    include_package_data=True,
    install_requires=install_requires,
    extras_require=extras_require,
)
