# -*- coding:utf-8 -*-
from pathlib import Path
from typing import Union, List

from DataRecorder import ByteRecorder

from .downloadKit import DownloadKit


class MissionData(object):
    """保存任务数据的对象"""

    def __init__(self, url: str,
                 goal_path: Union[str, Path],
                 rename: Union[str, None],
                 file_exists: str,
                 data: Union[str, dict, None],
                 json: Union[str, dict, None],
                 split: bool,
                 kwargs: dict):
        self.url: str = ...
        self.goal_path: Union[str, Path] = ...
        self.rename: Union[str, None] = ...
        self.file_exists: str = ...
        self.post_data: Union[str, dict, None] = ...
        self.post_json: Union[str, dict, None] = ...
        self.split: bool = ...
        self.kwargs: dict = ...


class BaseTask(object):
    """任务类基类"""
    _DONE: str = ...

    def __init__(self, ID: Union[int, str]):
        self._id: str = ...
        self.state: str = ...

    @property
    def id(self) -> Union[int, str]: ...

    @property
    def data(self): ...

    @property
    def is_done(self) -> bool: ...

    def set_states(self,
                   result: Union[bool, None, str] = None,
                   info: str = None,
                   state: str = 'done') -> None: ...


class Mission(BaseTask):
    """任务类"""

    def __init__(self, ID: int, data: MissionData, download_kit: DownloadKit):
        self.info: str = ...
        self.file_name: str = ...
        self._data: MissionData = ...
        self._path: Union[str, Path] = ...
        self._recorder: ByteRecorder = ...
        self.size: float = ...
        self.done_tasks_count: int = ...
        self.tasks_count: int = ...
        self.tasks: List[Task] = ...
        self.download_kit: DownloadKit = ...
        self.result: Union[str, None, bool] = ...

    def __repr__(self) -> str: ...

    @property
    def data(self) -> MissionData: ...

    @property
    def path(self) -> Union[str, Path]: ...

    @path.setter
    def path(self, path: Union[str, Path, None]) -> None: ...

    @property
    def recorder(self) -> ByteRecorder: ...

    @property
    def rate(self) -> Union[float, None]: ...

    def set_done(self, result: Union[bool, None, str], info: str) -> None: ...

    def a_task_done(self, is_success: bool, info: str) -> None: ...

    def break_mission(self, result: Union[bool, None, str], info: str) -> None: ...

    def cancel(self) -> None: ...

    def del_file(self): ...

    def wait(self, show: bool = True, timeout: float = 0) -> tuple: ...


class Task(BaseTask):
    """子任务类"""

    def __init__(self, mission: Mission, range_: Union[list, None], ID: str):
        self._id: str = ...
        self.info: str = ...
        self.mission: Mission = ...
        self.range: Union[list, None] = ...

    def __repr__(self) -> str: ...

    @property
    def mid(self) -> int: ...

    @property
    def data(self) -> MissionData: ...

    @property
    def path(self) -> str: ...

    @property
    def file_name(self) -> str: ...

    def add_data(self, data: bytes, seek: int = None) -> None: ...

    def set_done(self, result: Union[bool, None, str], info: str) -> None: ...
