/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.commons.lang.standardization;

import java.util.ArrayList;
import java.util.List;

public class SentencesUtil {
    public List<String> toSentenceList(String content) {
        return this.toSentenceList(content.toCharArray());
    }

    public List<String> toSentenceList(char[] chars) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> sentences = new ArrayList<String>();
        block5: for (int i = 0; i < chars.length; ++i) {
            if (sb.length() == 0 && (Character.isWhitespace(chars[i]) || chars[i] == ' ')) continue;
            sb.append(chars[i]);
            switch (chars[i]) {
                case '.': {
                    if (i >= chars.length - 1 || chars[i + 1] <= '\u0080') continue block5;
                    this.insertIntoList(sb, sentences);
                    sb = new StringBuilder();
                    continue block5;
                }
                case '\u2026': {
                    this.insertIntoList(sb, sentences);
                    sb = new StringBuilder("\u2026");
                    continue block5;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case '!': 
                case ';': 
                case '?': 
                case '\u3002': 
                case '\uff01': 
                case '\uff1b': 
                case '\uff1f': {
                    this.insertIntoList(sb, sentences);
                    sb = new StringBuilder();
                }
            }
        }
        if (sb.length() > 0) {
            this.insertIntoList(sb, sentences);
        }
        return sentences;
    }

    private void insertIntoList(StringBuilder sb, List<String> sentences) {
        String content = sb.toString().trim();
        if (content.length() > 0) {
            sentences.add(content);
        }
    }
}

