/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.commons.lang.bloomFilter.iface;

import org.nlpcn.commons.lang.bloomFilter.bitMap.IntMap;
import org.nlpcn.commons.lang.bloomFilter.bitMap.LongMap;
import org.nlpcn.commons.lang.bloomFilter.iface.BitMap;

public abstract class Filter {
    protected BitMap bm = null;
    protected long size = 0L;

    public Filter(long maxValue, MACHINENUM X) throws Exception {
        this.size = maxValue;
        if (X == MACHINENUM.X86) {
            this.bm = new IntMap((int)(this.size / 32L));
        } else if (X == MACHINENUM.X64) {
            this.bm = new LongMap((int)(this.size / 64L));
        } else {
            throw new Exception("unknow math num!");
        }
    }

    public Filter(long maxValue) throws Exception {
        this.size = maxValue;
        this.bm = new IntMap((int)(this.size / 32L));
    }

    public boolean contains(String str) {
        long hash = this.myHashCode(str);
        return this.bm.contains(hash);
    }

    public void add(String str) {
        long hash = this.myHashCode(str);
        this.bm.add(hash);
    }

    public boolean containsAndAdd(String str) {
        long hash = this.myHashCode(str);
        if (this.bm.contains(hash)) {
            return true;
        }
        this.bm.add(hash);
        return false;
    }

    public abstract long myHashCode(String var1);

    public static enum MACHINENUM {
        X86,
        X64;

    }
}

