/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.library;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.ansj.library.DATDictionary;
import org.ansj.util.MyStaticValue;
import org.nlpcn.commons.lang.tire.domain.Forest;
import org.nlpcn.commons.lang.tire.domain.SmartForest;
import org.nlpcn.commons.lang.tire.domain.Value;
import org.nlpcn.commons.lang.tire.library.Library;
import org.nlpcn.commons.lang.util.IOUtil;
import org.nlpcn.commons.lang.util.StringUtil;

public class UserDefineLibrary {
    public static final String DEFAULT_NATURE = "userDefine";
    public static final Integer DEFAULT_FREQ = 1000;
    public static final String DEFAULT_FREQ_STR = "1000";
    public static Forest FOREST = null;
    public static Forest ambiguityForest = null;

    public static void insertWord(String keyword, String nature, int freq) {
        if (FOREST == null) {
            FOREST = new Forest();
        }
        String[] paramers = new String[]{nature, String.valueOf(freq)};
        Value value = new Value(keyword, paramers);
        Library.insertWord(FOREST, value);
    }

    public static void insertWord(String keyword) {
        UserDefineLibrary.insertWord(keyword, DEFAULT_NATURE, DEFAULT_FREQ);
    }

    private static void initAmbiguityLibrary() {
        String ambiguityLibrary = MyStaticValue.ambiguityLibrary;
        if (StringUtil.isBlank(ambiguityLibrary)) {
            MyStaticValue.LIBRARYLOG.warn("init ambiguity  warning :{} because : file not found or failed to read !", (Object)ambiguityLibrary);
            return;
        }
        ambiguityLibrary = MyStaticValue.ambiguityLibrary;
        ambiguityForest = new Forest();
        try {
            BufferedReader br = IOUtil.getReader(ambiguityLibrary, "utf-8");
            Throwable throwable = null;
            try {
                String temp = null;
                boolean first = true;
                while ((temp = br.readLine()) != null) {
                    if (StringUtil.isBlank(temp)) continue;
                    if (first) {
                        temp = StringUtil.trim(temp);
                    }
                    String[] split = temp.split("\t");
                    StringBuilder sb = new StringBuilder();
                    if (split.length % 2 != 0) {
                        MyStaticValue.LIBRARYLOG.error("init ambiguity  error in line :" + temp + " format err !");
                    }
                    for (int i = 0; i < split.length; i += 2) {
                        sb.append(split[i]);
                    }
                    ambiguityForest.addBranch(sb.toString(), split);
                }
                MyStaticValue.LIBRARYLOG.info("init ambiguityLibrary ok!");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (br != null) {
                    if (throwable != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable3) {
                        }
                    } else {
                        br.close();
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            MyStaticValue.LIBRARYLOG.warn("init ambiguity  error :{} because : not find that file or can not found!", (Object)new File(ambiguityLibrary).getAbsolutePath());
        }
        catch (UnsupportedEncodingException e) {
            MyStaticValue.LIBRARYLOG.warn("\u4e0d\u652f\u6301\u7684\u7f16\u7801", e);
        }
        catch (IOException e) {
            MyStaticValue.LIBRARYLOG.warn("init ambiguity  error :{} because : not find that file or can not to read!", (Object)new File(ambiguityLibrary).getAbsolutePath());
        }
    }

    private static void initUserLibrary() {
        FOREST = MyStaticValue.getDicForest();
    }

    public static void loadFile(Forest forest, File file) {
        if (!file.canRead()) {
            MyStaticValue.LIBRARYLOG.warn("file in path " + file.getAbsolutePath() + " can not to read!");
            return;
        }
        String temp = null;
        String[] strs = null;
        Value value = null;
        try {
            BufferedReader br = IOUtil.getReader(new FileInputStream(file), "UTF-8");
            Throwable throwable = null;
            try {
                while ((temp = br.readLine()) != null) {
                    if (StringUtil.isBlank(temp)) continue;
                    strs = temp.split("\t");
                    strs[0] = strs[0].toLowerCase();
                    if (MyStaticValue.isSkipUserDefine && DATDictionary.getId(strs[0]) > 0) continue;
                    value = strs.length != 3 ? new Value(strs[0], DEFAULT_NATURE, DEFAULT_FREQ_STR) : new Value(strs[0], strs[1], strs[2]);
                    Library.insertWord(forest, value);
                }
                MyStaticValue.LIBRARYLOG.info("init user userLibrary ok path is : {}", (Object)file.getAbsolutePath());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (br != null) {
                    if (throwable != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable3) {
                        }
                    } else {
                        br.close();
                    }
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            MyStaticValue.LIBRARYLOG.warn("\u4e0d\u652f\u6301\u7684\u7f16\u7801", e);
        }
        catch (IOException e) {
            MyStaticValue.LIBRARYLOG.warn("IO\u5f02\u5e38", e);
        }
    }

    public static void loadLibrary(Forest forest, String path) {
        if (path != null) {
            URL url;
            File file = new File(path);
            if (!file.exists() && (url = UserDefineLibrary.class.getClassLoader().getResource(path)) != null) {
                file = new File(url.getPath());
            }
            if (!file.canRead() || file.isHidden()) {
                MyStaticValue.LIBRARYLOG.warn("init userLibrary  warning :{} because : file not found or failed to read !", (Object)file.getAbsolutePath());
                return;
            }
            if (file.isFile()) {
                UserDefineLibrary.loadFile(forest, file);
            } else if (file.isDirectory()) {
                File[] files = file.listFiles();
                if (files == null) {
                    return;
                }
                List<File> fileList = Arrays.asList(files);
                Collections.sort(fileList, new Comparator<File>(){

                    @Override
                    public int compare(File target, File source) {
                        return target.getName().compareTo(source.getName());
                    }
                });
                for (File dicFile : fileList) {
                    if (!dicFile.getName().trim().endsWith(".dic")) continue;
                    UserDefineLibrary.loadFile(forest, dicFile);
                }
            } else {
                MyStaticValue.LIBRARYLOG.warn("init user library  error :{} because : not find that file !", (Object)file.getAbsolutePath());
            }
        }
    }

    public static void removeWord(String word) {
        Library.removeWord(FOREST, word);
    }

    public static String[] getParams(String word) {
        return UserDefineLibrary.getParams(FOREST, word);
    }

    public static String[] getParams(Forest forest, String word) {
        SmartForest temp = forest;
        for (int i = 0; i < word.length(); ++i) {
            if ((temp = ((SmartForest)temp).get(word.charAt(i))) != null) continue;
            return null;
        }
        if (temp.getStatus() > 1) {
            return (String[])temp.getParam();
        }
        return null;
    }

    public static boolean contains(String word) {
        return UserDefineLibrary.getParams(word) != null;
    }

    public static void clear() {
        FOREST.clear();
    }

    static {
        UserDefineLibrary.initUserLibrary();
        UserDefineLibrary.initAmbiguityLibrary();
    }
}

