/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.app.crf;

import java.util.ArrayList;
import java.util.List;
import org.ansj.app.crf.pojo.Element;
import org.nlpcn.commons.lang.util.WordAlert;

public class Config {
    public String splitStr = "\\s+";
    public static final int TAG_NUM = 4;
    public static final char BEGIN = '\u0080';
    public static final char END = '\u0081';
    public static final char NUM_BEGIN = '\u0082';
    public static final char EN_BEGIN = '\u008c';
    public static final char FEATURE_BEGIN = '\u0096';
    public static int S = 0;
    public static int B = 1;
    public static int M = 2;
    public static int E = 3;
    private int[][] template = new int[][]{{-2}, {-1}, {0}, {1}, {2}, {-2, -1}, {-1, 0}, {0, 1}, {1, 2}, {-1, 1}};

    public Config(int[][] template) {
        this.template = template;
    }

    public static char getNum(String str) {
        if (str.length() > 9) {
            return '\u0082';
        }
        return (char)(130 + str.length());
    }

    public static char getEn(String str) {
        if (str.length() > 9) {
            return '\u008c';
        }
        return (char)(140 + str.length());
    }

    public int[][] getTemplate() {
        return this.template;
    }

    public void setTemplate(int[][] template) {
        this.template = template;
    }

    public static List<Element> wordAlert(String word) {
        char[] chars = WordAlert.alertStr(word);
        ArrayList<Element> list = new ArrayList<Element>();
        StringBuilder tempSb = new StringBuilder();
        int status = 0;
        Element element = null;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] >= '0' && chars[i] <= '9') {
                if (status == 2) {
                    element = new Element(Config.getNum(tempSb.toString()));
                    element.len = tempSb.length();
                    list.add(element);
                    tempSb = new StringBuilder();
                }
                tempSb.append(chars[i]);
                status = 1;
                continue;
            }
            if (chars[i] >= 'A' && chars[i] <= 'z') {
                if (status == 1) {
                    element = new Element(Config.getEn(tempSb.toString()));
                    element.len = tempSb.length();
                    list.add(element);
                    tempSb = new StringBuilder();
                }
                tempSb.append(chars[i]);
                status = 2;
                continue;
            }
            if (status == 1) {
                element = new Element(Config.getNum(tempSb.toString()));
                element.len = tempSb.length();
                list.add(element);
            } else if (status == 2) {
                element = new Element(Config.getEn(tempSb.toString()));
                element.len = tempSb.length();
                list.add(element);
            }
            tempSb = new StringBuilder();
            list.add(new Element(chars[i]));
            status = 0;
        }
        if (tempSb.length() > 0) {
            if (status == 1) {
                element = new Element(Config.getNum(tempSb.toString()));
                element.len = tempSb.length();
                list.add(element);
            } else if (status == 2) {
                element = new Element(Config.getEn(tempSb.toString()));
                element.len = tempSb.length();
                list.add(element);
            } else {
                System.out.println("err!");
            }
        }
        return list;
    }

    public static List<Element> makeToElementList(String temp, String splitStr) {
        String[] split = temp.split(splitStr);
        ArrayList<Element> list = new ArrayList<Element>(temp.length());
        for (String word : split) {
            List<Element> wordAlert = Config.wordAlert(word);
            int len = wordAlert.size();
            if (len == 1) {
                wordAlert.get(0).updateTag(S);
            } else if (len == 2) {
                wordAlert.get(0).updateTag(B);
                wordAlert.get(1).updateTag(E);
            } else if (len > 2) {
                wordAlert.get(0).updateTag(B);
                for (int i = 1; i < len - 1; ++i) {
                    wordAlert.get(i).updateTag(M);
                }
                wordAlert.get(len - 1).updateTag(E);
            }
            list.addAll(wordAlert);
        }
        return list;
    }

    public List<Element> makeToElementList(String temp) {
        return Config.wordAlert(temp);
    }

    public char getNameIfOutArr(List<Element> list, int index) {
        if (index < 0) {
            return '\u0080';
        }
        if (index >= list.size()) {
            return '\u0081';
        }
        return list.get((int)index).name;
    }

    public char getTagIfOutArr(List<Element> list, int index) {
        if (index < 0 || index >= list.size()) {
            return '\u0000';
        }
        return (char)list.get(index).getTag();
    }

    public char[][] makeFeatureArr(List<Element> list, int index) {
        char[][] result = new char[this.template.length][];
        char[] chars = null;
        int len = 0;
        for (int i = 0; i < this.template.length; ++i) {
            if (this.template[i].length == 0) continue;
            chars = new char[this.template[i].length + 1];
            len = chars.length - 1;
            for (int j = 0; j < len; ++j) {
                chars[j] = this.getNameIfOutArr(list, index + this.template[i][j]);
            }
            chars[len] = (char)(150 + i);
            result[i] = chars;
        }
        return result;
    }

    public static char getTagName(int tag) {
        switch (tag) {
            case 0: {
                return 'S';
            }
            case 1: {
                return 'B';
            }
            case 2: {
                return 'M';
            }
            case 3: {
                return 'E';
            }
        }
        return '?';
    }
}

