/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.wordseg;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public class CorpusChar {
    private static final Redwood.RedwoodChannels logger = Redwood.channels(CorpusChar.class);
    private Map<String, Set<String>> charMap;

    public CorpusChar(String charlistFilename) {
        this.charMap = CorpusChar.readDict(charlistFilename);
    }

    private Map<String, Set<String>> getCharMap() {
        return this.charMap;
    }

    private static Map<String, Set<String>> readDict(String filename) {
        Map<String, Set<String>> char_dict;
        try {
            String detectorLine;
            BufferedReader detectorReader = IOUtils.readerFromString(filename, "UTF-8");
            char_dict = Generics.newHashMap();
            while ((detectorLine = detectorReader.readLine()) != null) {
                String[] fields = detectorLine.split("\t");
                String tag = fields[0];
                Set<String> chars = (Set<String>)char_dict.get(tag);
                if (chars == null) {
                    chars = Generics.newHashSet();
                    char_dict.put(tag, chars);
                }
                chars.add(fields[1]);
            }
            detectorReader.close();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        logger.info("Loading character dictionary file from " + filename + " [done].");
        return char_dict;
    }

    public String getTag(String a1, String a2) {
        Map<String, Set<String>> h1 = this.getCharMap();
        Set<String> h2 = h1.get(a1);
        if (h2 == null) {
            return "0";
        }
        if (h2.contains(a2)) {
            return "1";
        }
        return "0";
    }
}

