/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.gui;

import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.tregex.gui.FileTreeModel;
import edu.stanford.nlp.trees.tregex.gui.Preferences;
import edu.stanford.nlp.trees.tregex.gui.TregexGUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PreferencesPanel
extends JDialog {
    private static final String FONT_ERROR = "font";
    private static final String HISTORY_ERROR = "history";
    private static final String MAX_MATCH_ERROR = "maxMatch";
    private TregexGUI gui;
    final JButton highlightButton;
    private JTextField setEncoding;

    public PreferencesPanel(TregexGUI gui) {
        super((Frame)gui, "Preferences");
        JButton cancel;
        this.gui = gui;
        this.setResizable(false);
        final JPanel prefPanel = new JPanel();
        prefPanel.setLayout(new GridBagLayout());
        Box displayPrefs = Box.createVerticalBox();
        displayPrefs.setBorder(BorderFactory.createTitledBorder("Display"));
        JPanel displayOptions = new JPanel();
        displayOptions.setLayout(new GridLayout(3, 2, 0, 2));
        JLabel historyLabel = new JLabel("Recent matches length: ");
        final JTextField historySizeField = new JTextField(Integer.toString(Preferences.getHistorySize()));
        displayOptions.add(historyLabel);
        displayOptions.add(historySizeField);
        JLabel maxMatchesLabel = new JLabel("Max displayed trees: ");
        final JTextField maxMatchesSizeField = new JTextField(Integer.toString(Preferences.getMaxMatches()));
        displayOptions.add(maxMatchesLabel);
        displayOptions.add(maxMatchesSizeField);
        JLabel highlightLabel = new JLabel("Highlight color:");
        this.highlightButton = PreferencesPanel.makeColorButton("Pick a new highlight color: ", Preferences.getHighlightColor(), prefPanel);
        this.highlightButton.putClientProperty("JButton.buttonType", "icon");
        displayOptions.add(highlightLabel);
        displayOptions.add(this.highlightButton);
        displayPrefs.add(displayOptions);
        Box treeDisplayPrefs = Box.createVerticalBox();
        treeDisplayPrefs.setBorder(BorderFactory.createTitledBorder("Tree Display"));
        JPanel treeDisplayOptions = new JPanel();
        treeDisplayOptions.setLayout(new GridLayout(4, 2));
        JLabel fontName = new JLabel("Font: ");
        final JComboBox<String> fontPicker = new JComboBox<String>(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        fontPicker.setSelectedItem(Preferences.getFont());
        JLabel sizeLabel = new JLabel("Font size: ");
        final JTextField size = new JTextField(Integer.toString(Preferences.getFontSize()));
        treeDisplayOptions.add(fontName);
        treeDisplayOptions.add(fontPicker);
        treeDisplayOptions.add(sizeLabel);
        treeDisplayOptions.add(size);
        JLabel defaultColorLabel = new JLabel("Tree color: ");
        final JButton defaultColorButton = PreferencesPanel.makeColorButton("Pick a new tree color: ", Preferences.getTreeColor(), prefPanel);
        treeDisplayOptions.add(defaultColorLabel);
        treeDisplayOptions.add(defaultColorButton);
        JLabel matchedLabel = new JLabel("Matched node color: ");
        final JButton matchedButton = PreferencesPanel.makeColorButton("Pick a new color for matched nodes: ", Preferences.getMatchedColor(), prefPanel);
        treeDisplayOptions.add(matchedLabel);
        treeDisplayOptions.add(matchedButton);
        treeDisplayPrefs.add(treeDisplayOptions);
        JPanel advOptions = new JPanel();
        advOptions.setBorder(BorderFactory.createTitledBorder("Advanced "));
        advOptions.setLayout(new GridLayout(3, 2, 0, 4));
        JLabel headfinderName = new JLabel("Head finder:");
        final JComboBox<String> headfinderPicker = new JComboBox<String>(new String[]{"ArabicHeadFinder", "BikelChineseHeadFinder", "ChineseHeadFinder", "ChineseSemanticHeadFinder", "CollinsHeadFinder", "DybroFrenchHeadFinder", "LeftHeadFinder", "ModCollinsHeadFinder", "NegraHeadFinder", "SemanticHeadFinder", "SunJurafskyChineseHeadFinder", "TueBaDZHeadFinder", "UniversalSemanticHeadFinder"});
        headfinderPicker.setEditable(true);
        headfinderPicker.setSelectedItem(Preferences.getHeadFinder().getClass().getSimpleName());
        JLabel treeReaderFactoryName = new JLabel("Tree reader factory:");
        final JComboBox<String> trfPicker = new JComboBox<String>(new String[]{"ArabicTreeReaderFactory", "ArabicTreeReaderFactory.ArabicRawTreeReaderFactory", "CTBTreeReaderFactory", "Basic categories only (LabeledScoredTreeReaderFactory)", "FrenchTreeReaderFactory", "NoEmptiesCTBTreeReaderFactory", "PennTreeReaderFactory", "TregexTreeReaderFactory"});
        trfPicker.setEditable(true);
        trfPicker.setSelectedItem(Preferences.getTreeReaderFactory().getClass().getSimpleName());
        JLabel encodingLabel = new JLabel("Character encoding: ");
        this.setEncoding = new JTextField(Preferences.getEncoding());
        this.setEncoding.setPreferredSize(headfinderName.getPreferredSize());
        advOptions.add(headfinderName);
        advOptions.add(headfinderPicker);
        advOptions.add(treeReaderFactoryName);
        advOptions.add(trfPicker);
        advOptions.add(encodingLabel);
        advOptions.add(this.setEncoding);
        final JCheckBox tsurgeonCheck = new JCheckBox("Enable Tsurgeon");
        tsurgeonCheck.setSelected(Preferences.getEnableTsurgeon());
        final JCheckBox matchPortion = new JCheckBox("Show only matched portions of tree");
        matchPortion.setSelected(Preferences.getMatchPortionOnly());
        GridBagConstraints c = new GridBagConstraints();
        c.ipady = 3;
        c.fill = 1;
        c.weightx = 1.0;
        c.gridwidth = 0;
        prefPanel.add((Component)displayPrefs, c);
        prefPanel.add((Component)treeDisplayPrefs, c);
        prefPanel.add((Component)advOptions, c);
        prefPanel.add((Component)tsurgeonCheck, c);
        c.gridheight = 0;
        prefPanel.add((Component)matchPortion, c);
        Object[] options = new JButton[2];
        JButton okay = new JButton("Okay");
        options[1] = cancel = new JButton("Cancel");
        options[0] = okay;
        JOptionPane prefPane = new JOptionPane();
        prefPane.setMessage(prefPanel);
        prefPane.setOptions(options);
        prefPane.setOpaque(true);
        this.setContentPane(prefPane);
        this.getRootPane().setDefaultButton(okay);
        okay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    HeadFinder hf = Preferences.lookupHeadFinder(headfinderPicker.getSelectedItem().toString());
                    if (hf == null) {
                        JOptionPane.showMessageDialog(PreferencesPanel.this, "Sorry, there was an error finding or instantiating the head finder. Please choose another head finder.", "Head Finder Error", 0);
                        throw new Exception("Headfinder error");
                    }
                    TreeReaderFactory trf = Preferences.lookupTreeReaderFactory(trfPicker.getSelectedItem().toString());
                    if (trf == null) {
                        JOptionPane.showMessageDialog(PreferencesPanel.this, "Sorry, there was an error finding or instantiating the tree reader factory. Please choose another tree reader factory.", "Tree Reader Factory Error", 0);
                        throw new Exception("Tree reader factory error");
                    }
                    Integer historySize = PreferencesPanel.checkNumberFormat(historySizeField, PreferencesPanel.HISTORY_ERROR);
                    Integer maxMatchSize = PreferencesPanel.checkNumberFormat(maxMatchesSizeField, PreferencesPanel.MAX_MATCH_ERROR);
                    Integer textSize = PreferencesPanel.checkNumberFormat(size, PreferencesPanel.FONT_ERROR);
                    PreferencesPanel.this.syncFromPrefPanel(fontPicker.getSelectedItem().toString(), textSize, ((ColorIcon)defaultColorButton.getIcon()).getColor(), ((ColorIcon)matchedButton.getIcon()).getColor(), ((ColorIcon)PreferencesPanel.this.highlightButton.getIcon()).getColor(), historySize, maxMatchSize, tsurgeonCheck.isSelected(), matchPortion.isSelected(), hf, trf, PreferencesPanel.this.setEncoding.getText().trim());
                    PreferencesPanel.this.setVisible(false);
                }
                catch (NumberFormatException e) {
                    if (e.getMessage() == PreferencesPanel.FONT_ERROR) {
                        JOptionPane.showMessageDialog(prefPanel, "Please enter an integer greater than 0 for the font size.", "Font size error", 0);
                    } else if (e.getMessage() == PreferencesPanel.HISTORY_ERROR) {
                        JOptionPane.showMessageDialog(prefPanel, "Please enter an integer greater than or equal to 0 for the number of recent matches to remember.", "History size error", 0);
                    } else if (e.getMessage() == PreferencesPanel.HISTORY_ERROR) {
                        JOptionPane.showMessageDialog(prefPanel, "Please enter an integer greater than or equal to 0 for the maximum number of matches to display.", "Max Matches size error", 0);
                    } else {
                        JOptionPane.showMessageDialog(prefPanel, "Please check that the font size, max matches to display, and number of recent matches to remember are all integers greater than 0.", "Size error", 0);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        cancel.addActionListener(arg0 -> this.setVisible(false));
    }

    private static Integer checkNumberFormat(JTextField component, String errorType) throws NumberFormatException {
        Integer number = null;
        String txt = component.getText();
        if (txt != null && !"".equals(txt)) {
            try {
                number = Integer.parseInt(txt);
                if (number <= 0) {
                    throw new NumberFormatException(errorType);
                }
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException(errorType);
            }
        }
        return number;
    }

    public static void alignLeft(JComponent box) {
        for (Component comp : box.getComponents()) {
            ((JComponent)comp).setAlignmentX(0.0f);
        }
    }

    private void syncFromPrefPanel(String font, Integer fontSize, Color treeColor, Color matchedColor, Color highlightColor, Integer historySize, Integer maxMatches, boolean enableTsurgeon, boolean matchPortionOnly, HeadFinder hf, TreeReaderFactory trf, String encoding) {
        Preferences.setFont(font);
        Preferences.setFontSize(fontSize == null ? 0 : fontSize);
        Preferences.setTreeColor(treeColor);
        Preferences.setMatchedColor(matchedColor);
        Preferences.setHighlightColor(highlightColor);
        Preferences.setHistorySize(historySize == null ? 0 : historySize);
        Preferences.setMaxMatches(maxMatches == null ? 0 : maxMatches);
        Preferences.setEnableTsurgeon(enableTsurgeon);
        Preferences.setMatchPortionOnly(matchPortionOnly);
        Preferences.setHeadFinder(hf);
        Preferences.setTreeReaderFactory(trf);
        Preferences.setEncoding(encoding);
        this.gui.loadPreferences();
    }

    void checkEncodingAndDisplay(String headFinder, String trf) {
        boolean prompt = false;
        String defaultEncoding = "";
        String curEncoding = FileTreeModel.getCurEncoding();
        if (PreferencesPanel.isChinese(headFinder, trf)) {
            if (!curEncoding.equals("GB18030")) {
                prompt = true;
                defaultEncoding = "GB18030";
            }
        } else if (PreferencesPanel.isNegra(headFinder, trf)) {
            if (!curEncoding.equals(" ISO-8859-1")) {
                prompt = true;
                defaultEncoding = " ISO-8859-1";
            }
        } else if (!curEncoding.equals("UTF-8")) {
            prompt = true;
            defaultEncoding = "UTF-8";
        }
        if (prompt) {
            this.doEncodingPrompt(defaultEncoding, curEncoding);
        }
    }

    private void doEncodingPrompt(String encoding, String oldEncoding) {
        JPanel encodingPanel = new JPanel();
        encodingPanel.setLayout(new BoxLayout(encodingPanel, 3));
        JLabel text = new JLabel("<html>A head finder or tree reader was selected that has the default encoding " + encoding + "; this differs from " + oldEncoding + ", which was being used. If the encoding is changed, all newly loaded" + "treebanks will be read using the new encoding. Choosing an encoding that is not the true encoding of your tree " + "files may cause errors and unexpected behavior.</html>");
        text.setAlignmentX(10.0f);
        JPanel textPanel = new JPanel(new BorderLayout());
        textPanel.setPreferredSize(new Dimension(100, 100));
        textPanel.add(text);
        encodingPanel.add(textPanel);
        encodingPanel.add(Box.createVerticalStrut(5));
        JOptionPane fileFilterDialog = new JOptionPane();
        fileFilterDialog.setMessage(encodingPanel);
        Object[] options = new JButton[3];
        JButton useNewEncoding = new JButton("Use " + encoding);
        JButton useOldEncoding = new JButton("Use " + oldEncoding);
        JButton useAnotherEncoding = new JButton("Use encoding...");
        options[0] = useNewEncoding;
        options[1] = useOldEncoding;
        options[2] = useAnotherEncoding;
        fileFilterDialog.setOptions(options);
        JDialog dialog = fileFilterDialog.createDialog(null, "Default encoding changed...");
        useNewEncoding.addActionListener(arg0 -> {
            FileTreeModel.setCurEncoding(encoding);
            if (this.setEncoding == null) {
                System.out.println("encoding null!!");
            }
            this.setEncoding.setText(encoding);
            dialog.setVisible(false);
        });
        useOldEncoding.addActionListener(e -> dialog.setVisible(false));
        useAnotherEncoding.addActionListener(e -> {
            dialog.setVisible(false);
            this.alternateEncodingPrompt(encoding);
        });
        dialog.getRootPane().setDefaultButton(useNewEncoding);
        dialog.pack();
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private void alternateEncodingPrompt(String newDefaultEncoding) {
        String response = (String)JOptionPane.showInputDialog(this, "Please enter a text encoding: ", "Set Encoding...", 3, null, null, newDefaultEncoding);
        FileTreeModel.setCurEncoding(response.trim());
        this.setEncoding.setText(response.trim());
    }

    static boolean isNegra(String headFinder, String trf) {
        return headFinder.startsWith("Negra");
    }

    static boolean isChinese(String headFinder, String trf) {
        return headFinder.startsWith("Chinese") || headFinder.startsWith("OldChinese") || trf.equalsIgnoreCase("CTBTreeReaderFactory") || trf.equalsIgnoreCase("NoEmptiesCTBTreeReaderFactory");
    }

    static boolean isArabic(String headFinder, String trf) {
        return headFinder.startsWith("Arabic") || trf.startsWith("Arabic");
    }

    public static JButton makeColorButton(String promptText, Color iconColor, JPanel parent) {
        ColorIcon icon = new ColorIcon(iconColor);
        JButton button = new JButton(icon);
        button.addActionListener(arg0 -> {
            Color newColor = JColorChooser.showDialog(parent, promptText, icon.getColor());
            if (newColor != null) {
                icon.setColor(newColor);
                parent.repaint();
            }
        });
        return button;
    }

    private static class ColorIcon
    implements Icon {
        private static final int iconHeight = 8;
        private static final int iconWidth = 15;
        private Color color;

        public ColorIcon(Color c) {
            this.color = c;
        }

        @Override
        public int getIconHeight() {
            return 8;
        }

        @Override
        public int getIconWidth() {
            return 15;
        }

        public void setColor(Color c) {
            this.color = c;
        }

        public Color getColor() {
            return this.color;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color oldColor = g.getColor();
            g.setColor(this.color);
            g.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
            g.setColor(oldColor);
        }
    }
}

