/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.swing;

import edu.stanford.nlp.util.logging.Redwood;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.List;

public class FontDetector {
    private static Redwood.RedwoodChannels log = Redwood.channels(FontDetector.class);
    public static final int NUM_LANGUAGES = 2;
    public static final int CHINESE = 0;
    public static final int ARABIC = 1;
    private static final String[][] unicodeRanges = new String[2][];

    private FontDetector() {
    }

    public static List<Font> supportedFonts(int language) {
        Font[] systemFonts;
        if (language < 0 || language > 2) {
            throw new IllegalArgumentException();
        }
        ArrayList<Font> fonts = new ArrayList<Font>();
        for (Font systemFont : systemFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
            boolean canDisplay = true;
            for (int j = 0; j < unicodeRanges[language].length; ++j) {
                if (systemFont.canDisplayUpTo(unicodeRanges[language][j]) == -1) continue;
                canDisplay = false;
                break;
            }
            if (!canDisplay) continue;
            fonts.add(systemFont);
        }
        return fonts;
    }

    public static boolean hasFont(String fontName) {
        Font[] systemFonts;
        for (Font systemFont : systemFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
            if (!systemFont.getName().equalsIgnoreCase(fontName)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        List<Font> fonts = FontDetector.supportedFonts(1);
        log.info("Has MS Mincho? " + FontDetector.hasFont("MS Mincho"));
        for (Font font : fonts) {
            System.out.println(font.getName());
        }
    }

    static {
        FontDetector.unicodeRanges[0] = new String[]{"\u3001", "\uff01", "\uffee", "\u0374", "\u3126"};
        FontDetector.unicodeRanges[1] = new String[]{"\ufb50", "\ufe70"};
    }
}

