/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.quoteattribution.Sieves.QMSieves;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.QuoteAttributionAnnotator;
import edu.stanford.nlp.quoteattribution.Person;
import edu.stanford.nlp.quoteattribution.QuoteAttributionUtils;
import edu.stanford.nlp.quoteattribution.Sieves.QMSieves.QMSieve;
import edu.stanford.nlp.quoteattribution.Sieves.Sieve;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ParagraphEndQuoteClosestSieve
extends QMSieve {
    public ParagraphEndQuoteClosestSieve(Annotation doc, Map<String, List<Person>> characterMap, Map<Integer, String> pronounCorefMap, Set<String> animacySet) {
        super(doc, characterMap, pronounCorefMap, animacySet, "Deterministic endQuoteClosestBefore");
    }

    @Override
    public void doQuoteToMention(Annotation doc) {
        this.paragraphEndQuoteClosestBefore(doc);
        this.oneSpeakerSentence(doc);
    }

    public void paragraphEndQuoteClosestBefore(Annotation doc) {
        List tokens = (List)doc.get(CoreAnnotations.TokensAnnotation.class);
        List quotes = (List)doc.get(CoreAnnotations.QuotationsAnnotation.class);
        for (CoreMap quote : quotes) {
            Sieve.MentionData closestMention;
            CoreMap nextQuote;
            int nextQuoteParagraph;
            CoreMap prevQuote;
            int prevQuoteParagraph;
            Pair<Integer, Integer> range;
            if (quote.get(QuoteAttributionAnnotator.MentionAnnotation.class) != null || (range = QuoteAttributionUtils.getRemainderInSentence(doc, quote)) == null) continue;
            Pair<ArrayList<String>, ArrayList<Pair<Integer, Integer>>> namesAndNameIndices = this.scanForNames(range);
            ArrayList names = (ArrayList)namesAndNameIndices.first;
            int quoteBeginTokenIndex = (Integer)quote.get(CoreAnnotations.TokenBeginAnnotation.class);
            boolean isBefore = ((Integer)range.second).equals(quoteBeginTokenIndex - 1);
            int quoteParagraph = QuoteAttributionUtils.getQuoteParagraphIndex(doc, quote);
            int quoteIndex = (Integer)quote.get(CoreAnnotations.QuotationIndexAnnotation.class);
            boolean isOnlyQuoteInParagraph = true;
            if (quoteIndex > 0 && (prevQuoteParagraph = QuoteAttributionUtils.getQuoteParagraphIndex(doc, prevQuote = (CoreMap)quotes.get(quoteIndex - 1))) == quoteParagraph) {
                isOnlyQuoteInParagraph = false;
            }
            if (quoteIndex < quotes.size() - 1 && (nextQuoteParagraph = QuoteAttributionUtils.getQuoteParagraphIndex(doc, nextQuote = (CoreMap)quotes.get(quoteIndex + 1))) == quoteParagraph) {
                isOnlyQuoteInParagraph = false;
            }
            if (!isBefore || !((CoreLabel)tokens.get((Integer)range.second)).word().equals(",") || !isOnlyQuoteInParagraph || (closestMention = this.findClosestMentionInSpanBackward(range)) == null || closestMention.type.equals("animate noun")) continue;
            ParagraphEndQuoteClosestSieve.fillInMention(quote, closestMention, this.sieveName);
        }
    }
}

