/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ie.NERClassifierCombiner;
import edu.stanford.nlp.ie.regexp.NumberSequenceClassifier;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.tokensregex.types.Tags;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.SentenceAnnotator;
import edu.stanford.nlp.time.TimeAnnotations;
import edu.stanford.nlp.time.TimeExpression;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.RuntimeInterruptedException;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class NERCombinerAnnotator
extends SentenceAnnotator {
    private static final Redwood.RedwoodChannels log = Redwood.channels(NERCombinerAnnotator.class);
    private final NERClassifierCombiner ner;
    private final boolean VERBOSE;
    private final long maxTime;
    private final int nThreads;
    private final int maxSentenceLength;

    public NERCombinerAnnotator(Properties properties) throws IOException {
        ArrayList<String> models = new ArrayList<String>();
        String modelNames = properties.getProperty("ner.model");
        if (modelNames == null) {
            modelNames = "edu/stanford/nlp/models/ner/english.all.3class.distsim.crf.ser.gz,edu/stanford/nlp/models/ner/english.muc.7class.distsim.crf.ser.gz,edu/stanford/nlp/models/ner/english.conll.4class.distsim.crf.ser.gz";
        }
        if (!modelNames.isEmpty()) {
            models.addAll(Arrays.asList(modelNames.split(",")));
        }
        if (models.isEmpty()) {
            log.info("WARNING: no NER models specified");
        }
        boolean applyNumericClassifiers = PropertiesUtils.getBool(properties, "ner.applyNumericClassifiers", true);
        boolean applyRegexner = PropertiesUtils.getBool(properties, "ner.regex", false);
        boolean useSUTime = PropertiesUtils.getBool(properties, "ner.useSUTime", NumberSequenceClassifier.USE_SUTIME_DEFAULT);
        NERClassifierCombiner.Language nerLanguage = NERClassifierCombiner.Language.fromString(PropertiesUtils.getString(properties, "ner.language", null), NERClassifierCombiner.NER_LANGUAGE_DEFAULT);
        boolean verbose = PropertiesUtils.getBool(properties, "ner.verbose", false);
        String[] loadPaths = models.toArray(new String[models.size()]);
        Properties combinerProperties = PropertiesUtils.extractSelectedProperties(properties, NERClassifierCombiner.DEFAULT_PASS_DOWN_PROPERTIES);
        if (useSUTime) {
            Properties sutimeProps = PropertiesUtils.extractPrefixedProperties(properties, "sutime.", true);
            PropertiesUtils.overWriteProperties(combinerProperties, sutimeProps);
        }
        NERClassifierCombiner nerCombiner = new NERClassifierCombiner(applyNumericClassifiers, nerLanguage, useSUTime, applyRegexner, combinerProperties, loadPaths);
        int nThreads = PropertiesUtils.getInt(properties, "ner.nthreads", PropertiesUtils.getInt(properties, "nthreads", 1));
        long maxTime = PropertiesUtils.getLong(properties, "ner.maxtime", 0L);
        int maxSentenceLength = PropertiesUtils.getInt(properties, "ner.maxlen", Integer.MAX_VALUE);
        this.VERBOSE = verbose;
        this.ner = nerCombiner;
        this.maxTime = maxTime;
        this.nThreads = nThreads;
        this.maxSentenceLength = maxSentenceLength;
    }

    public NERCombinerAnnotator() throws IOException, ClassNotFoundException {
        this(true);
    }

    public NERCombinerAnnotator(boolean verbose) throws IOException, ClassNotFoundException {
        this(new NERClassifierCombiner(new Properties()), verbose);
    }

    public NERCombinerAnnotator(boolean verbose, String ... classifiers) throws IOException, ClassNotFoundException {
        this(new NERClassifierCombiner(classifiers), verbose);
    }

    public NERCombinerAnnotator(NERClassifierCombiner ner, boolean verbose) {
        this(ner, verbose, 1, 0L, Integer.MAX_VALUE);
    }

    public NERCombinerAnnotator(NERClassifierCombiner ner, boolean verbose, int nThreads, long maxTime) {
        this(ner, verbose, nThreads, maxTime, Integer.MAX_VALUE);
    }

    public NERCombinerAnnotator(NERClassifierCombiner ner, boolean verbose, int nThreads, long maxTime, int maxSentenceLength) {
        this.VERBOSE = verbose;
        this.ner = ner;
        this.maxTime = maxTime;
        this.nThreads = nThreads;
        this.maxSentenceLength = maxSentenceLength;
    }

    @Override
    protected int nThreads() {
        return this.nThreads;
    }

    @Override
    protected long maxTime() {
        return this.maxTime;
    }

    @Override
    public void annotate(Annotation annotation) {
        if (this.VERBOSE) {
            log.info("Adding NER Combiner annotation ... ");
        }
        super.annotate(annotation);
        this.ner.finalizeAnnotation(annotation);
        if (this.VERBOSE) {
            log.info("done.");
        }
    }

    @Override
    public void doOneSentence(Annotation annotation, CoreMap sentence) {
        List output;
        List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
        if (tokens.size() <= this.maxSentenceLength) {
            try {
                output = this.ner.classifySentenceWithGlobalInformation(tokens, annotation, sentence);
            }
            catch (RuntimeInterruptedException e) {
                output = null;
            }
        } else {
            output = null;
        }
        if (output == null) {
            this.doOneFailedSentence(annotation, sentence);
        } else {
            int sz = tokens.size();
            for (int i = 0; i < sz; ++i) {
                String neTag = (String)((CoreLabel)output.get(i)).get(CoreAnnotations.NamedEntityTagAnnotation.class);
                String normNeTag = (String)((CoreLabel)output.get(i)).get(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class);
                ((CoreLabel)tokens.get(i)).setNER(neTag);
                if (normNeTag != null) {
                    ((CoreLabel)tokens.get(i)).set(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class, normNeTag);
                }
                NumberSequenceClassifier.transferAnnotations((CoreLabel)output.get(i), (CoreLabel)tokens.get(i));
            }
            if (this.VERBOSE) {
                boolean first = true;
                StringBuilder sb = new StringBuilder("NERCombinerAnnotator output: [");
                for (CoreLabel w : tokens) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(w.toShorterString("Text", "NamedEntityTag", "NormalizedNamedEntityTag"));
                }
                sb.append(']');
                log.info(sb);
            }
        }
    }

    @Override
    public void doOneFailedSentence(Annotation annotation, CoreMap sentence) {
        List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
        for (CoreLabel token : tokens) {
            if (token.ner() != null) continue;
            token.setNER(this.ner.backgroundSymbol());
        }
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requires() {
        if (this.ner.usesSUTime() || this.ner.appliesNumericClassifiers()) {
            return Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(CoreAnnotations.TextAnnotation.class, CoreAnnotations.TokensAnnotation.class, CoreAnnotations.SentencesAnnotation.class, CoreAnnotations.CharacterOffsetBeginAnnotation.class, CoreAnnotations.CharacterOffsetEndAnnotation.class, CoreAnnotations.PartOfSpeechAnnotation.class, CoreAnnotations.LemmaAnnotation.class, CoreAnnotations.BeforeAnnotation.class, CoreAnnotations.AfterAnnotation.class, CoreAnnotations.TokenBeginAnnotation.class, CoreAnnotations.TokenEndAnnotation.class, CoreAnnotations.IndexAnnotation.class, CoreAnnotations.OriginalTextAnnotation.class, CoreAnnotations.SentenceIndexAnnotation.class)));
        }
        return Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(CoreAnnotations.TextAnnotation.class, CoreAnnotations.TokensAnnotation.class, CoreAnnotations.SentencesAnnotation.class, CoreAnnotations.CharacterOffsetBeginAnnotation.class, CoreAnnotations.CharacterOffsetEndAnnotation.class, CoreAnnotations.BeforeAnnotation.class, CoreAnnotations.AfterAnnotation.class, CoreAnnotations.TokenBeginAnnotation.class, CoreAnnotations.TokenEndAnnotation.class, CoreAnnotations.IndexAnnotation.class, CoreAnnotations.OriginalTextAnnotation.class, CoreAnnotations.SentenceIndexAnnotation.class)));
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return new HashSet<Class<? extends CoreAnnotation>>(Arrays.asList(CoreAnnotations.NamedEntityTagAnnotation.class, CoreAnnotations.NormalizedNamedEntityTagAnnotation.class, CoreAnnotations.ValueAnnotation.class, TimeExpression.Annotation.class, TimeExpression.TimeIndexAnnotation.class, CoreAnnotations.DistSimAnnotation.class, CoreAnnotations.NumericCompositeTypeAnnotation.class, TimeAnnotations.TimexAnnotation.class, CoreAnnotations.NumericValueAnnotation.class, TimeExpression.ChildrenAnnotation.class, CoreAnnotations.NumericTypeAnnotation.class, CoreAnnotations.ShapeAnnotation.class, Tags.TagsAnnotation.class, CoreAnnotations.NumerizedTokensAnnotation.class, CoreAnnotations.AnswerAnnotation.class, CoreAnnotations.NumericCompositeValueAnnotation.class));
    }
}

