/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.parser.nndep.DependencyParser;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.SentenceAnnotator;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.semgraph.SemanticGraphFactory;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.util.ArraySet;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.MetaClass;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;

public class DependencyParseAnnotator
extends SentenceAnnotator {
    private static Redwood.RedwoodChannels log = Redwood.channels(DependencyParseAnnotator.class);
    private final DependencyParser parser;
    private final int nThreads;
    private static final int DEFAULT_NTHREADS = 1;
    private final long maxTime;
    private static final long DEFAULT_MAXTIME = -1L;
    private final GrammaticalStructure.Extras extraDependencies;

    public DependencyParseAnnotator() {
        this(new Properties());
    }

    public DependencyParseAnnotator(Properties properties) {
        String modelPath = PropertiesUtils.getString(properties, "model", "edu/stanford/nlp/models/parser/nndep/english_UD.gz");
        this.parser = DependencyParser.loadFromModelFile(modelPath, properties);
        this.nThreads = PropertiesUtils.getInt(properties, "testThreads", 1);
        this.maxTime = PropertiesUtils.getLong(properties, "sentenceTimeout", -1L);
        this.extraDependencies = (GrammaticalStructure.Extras)((Object)MetaClass.cast(properties.getProperty("extradependencies", "NONE"), GrammaticalStructure.Extras.class));
    }

    @Override
    protected int nThreads() {
        return this.nThreads;
    }

    @Override
    protected long maxTime() {
        return this.maxTime;
    }

    @Override
    protected void doOneSentence(Annotation annotation, CoreMap sentence) {
        GrammaticalStructure gs = this.parser.predict(sentence);
        SemanticGraph deps = SemanticGraphFactory.makeFromTree(gs, SemanticGraphFactory.Mode.COLLAPSED, this.extraDependencies, null);
        SemanticGraph uncollapsedDeps = SemanticGraphFactory.makeFromTree(gs, SemanticGraphFactory.Mode.BASIC, this.extraDependencies, null);
        SemanticGraph ccDeps = SemanticGraphFactory.makeFromTree(gs, SemanticGraphFactory.Mode.CCPROCESSED, this.extraDependencies, null);
        SemanticGraph enhancedDeps = SemanticGraphFactory.makeFromTree(gs, SemanticGraphFactory.Mode.ENHANCED, this.extraDependencies, null);
        SemanticGraph enhancedPlusPlusDeps = SemanticGraphFactory.makeFromTree(gs, SemanticGraphFactory.Mode.ENHANCED_PLUS_PLUS, this.extraDependencies, null);
        sentence.set(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class, deps);
        sentence.set(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class, uncollapsedDeps);
        sentence.set(SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class, ccDeps);
        sentence.set(SemanticGraphCoreAnnotations.EnhancedDependenciesAnnotation.class, enhancedDeps);
        sentence.set(SemanticGraphCoreAnnotations.EnhancedPlusPlusDependenciesAnnotation.class, enhancedPlusPlusDeps);
    }

    @Override
    protected void doOneFailedSentence(Annotation annotation, CoreMap sentence) {
        log.info("fail");
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requires() {
        return Collections.unmodifiableSet(new ArraySet<Class>(Arrays.asList(CoreAnnotations.TextAnnotation.class, CoreAnnotations.IndexAnnotation.class, CoreAnnotations.ValueAnnotation.class, CoreAnnotations.TokensAnnotation.class, CoreAnnotations.SentencesAnnotation.class, CoreAnnotations.SentenceIndexAnnotation.class, CoreAnnotations.PartOfSpeechAnnotation.class)));
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return Collections.unmodifiableSet(new ArraySet<Class>(Arrays.asList(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class, SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class, SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class, SemanticGraphCoreAnnotations.EnhancedDependenciesAnnotation.class, SemanticGraphCoreAnnotations.EnhancedPlusPlusDependenciesAnnotation.class)));
    }
}

