/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.patterns;

import edu.stanford.nlp.patterns.CandidatePhrase;
import edu.stanford.nlp.patterns.ConstantsAndVariables;
import edu.stanford.nlp.patterns.Data;
import edu.stanford.nlp.patterns.GetPatternsFromDataMultiClass;
import edu.stanford.nlp.patterns.Pattern;
import edu.stanford.nlp.patterns.PhraseScorer;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.stats.TwoDimensionalCounter;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ScorePhrasesAverageFeatures<E extends Pattern>
extends PhraseScorer<E> {
    private static Redwood.RedwoodChannels log = Redwood.channels(ScorePhrasesAverageFeatures.class);
    private TwoDimensionalCounter<CandidatePhrase, ConstantsAndVariables.ScorePhraseMeasures> phraseScoresNormalized = new TwoDimensionalCounter();

    public ScorePhrasesAverageFeatures(ConstantsAndVariables constvar) {
        super(constvar);
    }

    @Override
    public Counter<CandidatePhrase> scorePhrases(String label, TwoDimensionalCounter<CandidatePhrase, E> terms, TwoDimensionalCounter<CandidatePhrase, E> wordsPatExtracted, Counter<E> allSelectedPatterns, Set<CandidatePhrase> alreadyIdentifiedWords, boolean forLearningPatterns) {
        HashMap scores = new HashMap();
        if (Data.domainNGramsFile != null) {
            Data.loadDomainNGrams();
        }
        Redwood.log(ConstantsAndVariables.extremedebug, "Considering terms: " + terms.firstKeySet());
        ClassicCounter<CandidatePhrase> tfidfScores = new ClassicCounter<CandidatePhrase>();
        if (this.constVars.usePhraseEvalPatWtByFreq) {
            for (Map.Entry<CandidatePhrase, ClassicCounter<E>> en : terms.entrySet()) {
                double score = this.getPatTFIDFScore(en.getKey(), en.getValue(), allSelectedPatterns);
                tfidfScores.setCount(en.getKey(), score);
            }
            Redwood.log(ConstantsAndVariables.extremedebug, "BEFORE IDF " + Counters.toSortedString(tfidfScores, 100, "%1$s:%2$f", "\t"));
            Counters.divideInPlace(tfidfScores, Data.processedDataFreq);
        }
        Counter<CandidatePhrase> externalFeatWtsNormalized = new ClassicCounter();
        Counter<CandidatePhrase> domainNgramNormScores = new ClassicCounter();
        Counter<CandidatePhrase> googleNgramNormScores = new ClassicCounter<CandidatePhrase>();
        ClassicCounter<CandidatePhrase> editDistanceOtherBinaryScores = new ClassicCounter<CandidatePhrase>();
        ClassicCounter<CandidatePhrase> editDistanceSameBinaryScores = new ClassicCounter<CandidatePhrase>();
        for (CandidatePhrase gc : terms.firstKeySet()) {
            String g = gc.getPhrase();
            if (this.constVars.usePhraseEvalEditDistOther) {
                editDistanceOtherBinaryScores.setCount(gc, 1.0 - this.constVars.getEditDistanceScoresOtherClassThreshold(label, g));
            }
            if (this.constVars.usePhraseEvalEditDistSame) {
                editDistanceSameBinaryScores.setCount(gc, this.constVars.getEditDistanceScoresThisClassThreshold(label, g));
            }
            if (this.constVars.usePhraseEvalDomainNgram) {
                if (Data.domainNGramRawFreq.containsKey(g)) {
                    assert (Data.rawFreq.containsKey(gc));
                    domainNgramNormScores.setCount(gc, this.getDomainNgramScore(g));
                } else {
                    log.info("why is " + (String)g + " not present in domainNgram");
                }
            }
            if (this.constVars.usePhraseEvalGoogleNgram) {
                googleNgramNormScores.setCount(gc, ScorePhrasesAverageFeatures.getGoogleNgramScore(gc));
            }
            if (!this.constVars.usePhraseEvalWordClass) continue;
            Integer num = this.constVars.getWordClassClusters().get(g);
            if (num == null) {
                num = this.constVars.getWordClassClusters().get(g.toLowerCase());
            }
            if (num != null && this.constVars.distSimWeights.get(label).containsKey(num)) {
                externalFeatWtsNormalized.setCount(gc, this.constVars.distSimWeights.get(label).getCount(num));
                continue;
            }
            externalFeatWtsNormalized.setCount(gc, this.OOVExternalFeatWt);
        }
        Counter<CandidatePhrase> normTFIDFScores = GetPatternsFromDataMultiClass.normalizeSoftMaxMinMaxScores(tfidfScores, true, true, false);
        Counter<CandidatePhrase> dictOdddsScores = null;
        if (this.constVars.usePhraseEvalSemanticOdds) {
            assert (this.constVars.dictOddsWeights != null) : "usePhraseEvalSemanticOdds is true but dictOddsWeights is null for the label " + label;
            dictOdddsScores = GetPatternsFromDataMultiClass.normalizeSoftMaxMinMaxScores(this.constVars.dictOddsWeights.get(label), true, true, false);
        }
        domainNgramNormScores = GetPatternsFromDataMultiClass.normalizeSoftMaxMinMaxScores(domainNgramNormScores, true, true, false);
        googleNgramNormScores = GetPatternsFromDataMultiClass.normalizeSoftMaxMinMaxScores(googleNgramNormScores, true, true, false);
        externalFeatWtsNormalized = GetPatternsFromDataMultiClass.normalizeSoftMaxMinMaxScores(externalFeatWtsNormalized, true, true, false);
        for (CandidatePhrase word : terms.firstKeySet()) {
            if (alreadyIdentifiedWords.contains(word)) continue;
            ClassicCounter<ConstantsAndVariables.ScorePhraseMeasures> scoreslist = new ClassicCounter<ConstantsAndVariables.ScorePhraseMeasures>();
            assert (normTFIDFScores.containsKey(word)) : "NormTFIDF score does not contain" + word;
            double tfscore = normTFIDFScores.getCount(word);
            scoreslist.setCount(ConstantsAndVariables.ScorePhraseMeasures.PATWTBYFREQ, tfscore);
            if (this.constVars.usePhraseEvalSemanticOdds) {
                double dscore = dictOdddsScores.containsKey(word) ? dictOdddsScores.getCount(word) : this.getPhraseWeightFromWords(dictOdddsScores, word, this.OOVdictOdds);
                scoreslist.setCount(ConstantsAndVariables.ScorePhraseMeasures.SEMANTICODDS, dscore);
            }
            if (this.constVars.usePhraseEvalDomainNgram) {
                double domainscore = domainNgramNormScores.containsKey(word) ? domainNgramNormScores.getCount(word) : this.getPhraseWeightFromWords(domainNgramNormScores, word, this.OOVDomainNgramScore);
                scoreslist.setCount(ConstantsAndVariables.ScorePhraseMeasures.DOMAINNGRAM, domainscore);
            }
            if (this.constVars.usePhraseEvalGoogleNgram) {
                double googlescore = googleNgramNormScores.containsKey(word) ? googleNgramNormScores.getCount(word) : this.getPhraseWeightFromWords(googleNgramNormScores, word, this.OOVGoogleNgramScore);
                scoreslist.setCount(ConstantsAndVariables.ScorePhraseMeasures.GOOGLENGRAM, googlescore);
            }
            if (this.constVars.usePhraseEvalWordClass) {
                double externalFeatureWt = externalFeatWtsNormalized.containsKey(word) ? externalFeatWtsNormalized.getCount(word) : this.getPhraseWeightFromWords(externalFeatWtsNormalized, word, this.OOVExternalFeatWt);
                scoreslist.setCount(ConstantsAndVariables.ScorePhraseMeasures.DISTSIM, externalFeatureWt);
            }
            if (this.constVars.usePhraseEvalEditDistOther) {
                assert (editDistanceOtherBinaryScores.containsKey(word)) : "How come no edit distance info?";
                double editD = editDistanceOtherBinaryScores.getCount(word);
                scoreslist.setCount(ConstantsAndVariables.ScorePhraseMeasures.EDITDISTOTHER, editD);
            }
            if (this.constVars.usePhraseEvalEditDistSame) {
                double editDSame = editDistanceSameBinaryScores.getCount(word);
                scoreslist.setCount(ConstantsAndVariables.ScorePhraseMeasures.EDITDISTSAME, editDSame);
            }
            if (this.constVars.usePhraseEvalWordShape) {
                scoreslist.setCount(ConstantsAndVariables.ScorePhraseMeasures.WORDSHAPE, this.getWordShapeScore(word.getPhrase(), label));
            }
            scores.put(word, scoreslist);
            this.phraseScoresNormalized.setCounter(word, scoreslist);
        }
        ClassicCounter<CandidatePhrase> phraseScores = new ClassicCounter<CandidatePhrase>();
        for (Map.Entry wEn : scores.entrySet()) {
            Double avgScore = Counters.mean((Counter)wEn.getValue());
            if (!avgScore.isInfinite() && !avgScore.isNaN()) {
                phraseScores.setCount((CandidatePhrase)wEn.getKey(), avgScore);
                continue;
            }
            Redwood.log(new Object[]{Redwood.DBG, "Ignoring " + wEn.getKey() + " because score is " + avgScore});
        }
        return phraseScores;
    }

    @Override
    public Counter<CandidatePhrase> scorePhrases(String label, Set<CandidatePhrase> terms, boolean forLearningPatterns) throws IOException {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void printReasonForChoosing(Counter<CandidatePhrase> phrases) {
    }
}

