/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.international.french.FrenchMorphoFeatureSpecification;
import edu.stanford.nlp.international.morph.MorphoFeatureSpecification;
import edu.stanford.nlp.international.morph.MorphoFeatures;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.SentenceUtils;
import edu.stanford.nlp.parser.lexparser.BaseLexicon;
import edu.stanford.nlp.parser.lexparser.FactoredLexicon;
import edu.stanford.nlp.parser.lexparser.Lexicon;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.TreeCollinizer;
import edu.stanford.nlp.parser.lexparser.TregexPoweredTreebankParserParams;
import edu.stanford.nlp.process.SerializableFunction;
import edu.stanford.nlp.stats.TwoDimensionalCounter;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.international.french.DybroFrenchHeadFinder;
import edu.stanford.nlp.trees.international.french.FrenchTreeReaderFactory;
import edu.stanford.nlp.trees.international.french.FrenchTreebankLanguagePack;
import edu.stanford.nlp.trees.international.french.FrenchXMLTreeReaderFactory;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class FrenchTreebankParserParams
extends TregexPoweredTreebankParserParams {
    private static Redwood.RedwoodChannels log = Redwood.channels(FrenchTreebankParserParams.class);
    private static final long serialVersionUID = -6976724734594763986L;
    private final StringBuilder optionsString;
    private HeadFinder headFinder;
    private boolean readPennFormat = true;
    private boolean collinizerRetainsPunctuation = false;
    private TwoDimensionalCounter<String, String> mwCounter;
    private MorphoFeatureSpecification morphoSpec;
    private MorphoFeatureSpecification tagSpec;
    private static final String[] factoredFeatures = new String[]{"-tagPAFr", "-markInf", "-markPart", "-markVN", "-coord1", "-de2", "-markP1", "-MWAdvS", "-MWADVSel1", "-MWADVSel2", "-MWNSel1", "-MWNSel2", "-splitPUNC"};

    public FrenchTreebankParserParams() {
        super(new FrenchTreebankLanguagePack());
        this.setInputEncoding("UTF-8");
        this.optionsString = new StringBuilder();
        this.optionsString.append("FrenchTreebankParserParams\n");
        this.initializeAnnotationPatterns();
    }

    @Override
    protected String[] baselineAnnotationFeatures() {
        return new String[0];
    }

    private void initializeAnnotationPatterns() {
        this.annotations.put("-markInf", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@V > (@VN > @VPinf)", new TregexPoweredTreebankParserParams.SimpleStringFunction("-infinitive")));
        this.annotations.put("-markPart", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@V > (@VN > @VPpart)", new TregexPoweredTreebankParserParams.SimpleStringFunction("-participle")));
        this.annotations.put("-markVN", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("__ << @VN", new TregexPoweredTreebankParserParams.SimpleStringFunction("-withVN")));
        this.annotations.put("-tagPAFr", new Pair<String, AddRelativeNodeFunction>("!@PUNC < (__ !< __) > __=parent", new AddRelativeNodeFunction("-", "parent", true)));
        this.annotations.put("-coord1", new Pair<String, AddRelativeNodeFunction>("@COORD <2 __=word", new AddRelativeNodeFunction("-", "word", true)));
        this.annotations.put("-de2", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@P < /^([Dd]es?|du|d')$/", new TregexPoweredTreebankParserParams.SimpleStringFunction("-de2")));
        this.annotations.put("-de3", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@NP|PP|COORD >+(@NP|PP) (@PP <, (@P < /^([Dd]es?|du|d')$/))", new TregexPoweredTreebankParserParams.SimpleStringFunction("-de3")));
        this.annotations.put("-markP1", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@P > (@PP > @NP)", new TregexPoweredTreebankParserParams.SimpleStringFunction("-n")));
        this.annotations.put("-MWAdvS", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@MWADV > /S/", new TregexPoweredTreebankParserParams.SimpleStringFunction("-mwadv-s")));
        this.annotations.put("-MWADVSel1", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@MWADV <1 @P <2 @N !<3 __", new TregexPoweredTreebankParserParams.SimpleStringFunction("-mwadv1")));
        this.annotations.put("-MWADVSel2", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@MWADV <1 @P <2 @D <3 @N !<4 __", new TregexPoweredTreebankParserParams.SimpleStringFunction("-mwadv2")));
        this.annotations.put("-MWNSel1", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@MWN <1 @N <2 @A !<3 __", new TregexPoweredTreebankParserParams.SimpleStringFunction("-mwn1")));
        this.annotations.put("-MWNSel2", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@MWN <1 @N <2 @P <3 @N !<4 __", new TregexPoweredTreebankParserParams.SimpleStringFunction("-mwn2")));
        this.annotations.put("-MWNSel3", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@MWN <1 @N <2 @- <3 @N !<4 __", new TregexPoweredTreebankParserParams.SimpleStringFunction("-mwn3")));
        this.annotations.put("-splitPUNC", new Pair<String, AnnotatePunctuationFunction>("@PUNC < __=term", new AnnotatePunctuationFunction()));
        this.annotations.put("-mweTag", new Pair<String, AddRelativeNodeFunction>("!@PUNC < (__ !< __) > /MW/=parent", new AddRelativeNodeFunction("-", "parent", true)));
        this.annotations.put("-sq", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@SENT << /\\?/", new TregexPoweredTreebankParserParams.SimpleStringFunction("-Q")));
        this.annotations.put("-hasVP", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("!@ROOT|SENT << /^VP/", new TregexPoweredTreebankParserParams.SimpleStringFunction("-hasVP")));
        this.annotations.put("-hasVP2", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("__ << /^VP/", new TregexPoweredTreebankParserParams.SimpleStringFunction("-hasVP")));
        this.annotations.put("-npCOORD", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@NP < @COORD", new TregexPoweredTreebankParserParams.SimpleStringFunction("-coord")));
        this.annotations.put("-npVP", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@NP < /VP/", new TregexPoweredTreebankParserParams.SimpleStringFunction("-vp")));
        this.annotations.put("-baseNP1", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@NP <1 @D <2 @N !<3 __", new TregexPoweredTreebankParserParams.SimpleStringFunction("-np1")));
        this.annotations.put("-baseNP2", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@NP <1 @D <2 @MWN !<3 __", new TregexPoweredTreebankParserParams.SimpleStringFunction("-np2")));
        this.annotations.put("-baseNP3", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@NP <1 @MWD <2 @N !<3 __ ", new TregexPoweredTreebankParserParams.SimpleStringFunction("-np3")));
        this.annotations.put("-npMWN1", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@NP < (@MWN < @A)", new TregexPoweredTreebankParserParams.SimpleStringFunction("-mwna")));
        this.annotations.put("-npMWN2", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@NP <1 @D <2 @MWN <3 @PP !<4 __", new TregexPoweredTreebankParserParams.SimpleStringFunction("-mwn2")));
        this.annotations.put("-npMWN3", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@NP <1 @D <2 (@MWN <1 @N <2 @A !<3 __) !<3 __", new TregexPoweredTreebankParserParams.SimpleStringFunction("-mwn3")));
        this.annotations.put("-npMWN4", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@PP <, @P <2 (@NP <1 @D <2 (@MWN <1 @N <2 @A !<3 __) !<3 __) !<3 __", new TregexPoweredTreebankParserParams.SimpleStringFunction("-mwn3")));
        this.annotations.put("-MWNSel", new Pair<String, AddPOSSequenceFunction>("@MWN", new AddPOSSequenceFunction("-", 600, true)));
        this.annotations.put("-MWADVSel", new Pair<String, AddPOSSequenceFunction>("@MWADV", new AddPOSSequenceFunction("-", 500, true)));
        this.annotations.put("-MWASel", new Pair<String, AddPOSSequenceFunction>("@MWA", new AddPOSSequenceFunction("-", 100, true)));
        this.annotations.put("-MWCSel", new Pair<String, AddPOSSequenceFunction>("@MWC", new AddPOSSequenceFunction("-", 400, true)));
        this.annotations.put("-MWDSel", new Pair<String, AddPOSSequenceFunction>("@MWD", new AddPOSSequenceFunction("-", 100, true)));
        this.annotations.put("-MWPSel", new Pair<String, AddPOSSequenceFunction>("@MWP", new AddPOSSequenceFunction("-", 600, true)));
        this.annotations.put("-MWPROSel", new Pair<String, AddPOSSequenceFunction>("@MWPRO", new AddPOSSequenceFunction("-", 60, true)));
        this.annotations.put("-MWVSel", new Pair<String, AddPOSSequenceFunction>("@MWV", new AddPOSSequenceFunction("-", 200, true)));
        this.annotations.put("-mwn1", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@MWN <1 @N <2 @A !<3 __", new TregexPoweredTreebankParserParams.SimpleStringFunction("-na")));
        this.annotations.put("-mwn2", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@MWN <1 @N <2 @P <3 @N !<4 __", new TregexPoweredTreebankParserParams.SimpleStringFunction("-npn")));
        this.annotations.put("-mwn3", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@MWN <1 @N <2 @- <3 @N !<4 __", new TregexPoweredTreebankParserParams.SimpleStringFunction("-n-n")));
        this.annotations.put("-mwn4", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@MWN <1 @N <2 @N !<3 __", new TregexPoweredTreebankParserParams.SimpleStringFunction("-nn")));
        this.annotations.put("-mwn5", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@MWN <1 @D <2 @N !<3 __", new TregexPoweredTreebankParserParams.SimpleStringFunction("-dn")));
        this.annotations.put("-hasWH", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("__ < /^(qui|quoi|comment|quel|quelle|quels|quelles|o\u00f9|combien|que|pourquoi|quand)$/", new TregexPoweredTreebankParserParams.SimpleStringFunction("-wh")));
        this.annotations.put("-markNNP2", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@N < /^[A-Z]/", new TregexPoweredTreebankParserParams.SimpleStringFunction("-nnp")));
        this.annotations.put("-markD1", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@D > (__ > @PP)", new TregexPoweredTreebankParserParams.SimpleStringFunction("-p")));
        this.annotations.put("-markD2", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@D > (__ > @NP)", new TregexPoweredTreebankParserParams.SimpleStringFunction("-n")));
        this.annotations.put("-markD3", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@D > (__ > /^VP/)", new TregexPoweredTreebankParserParams.SimpleStringFunction("-v")));
        this.annotations.put("-markD4", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@D > (__ > /^S/)", new TregexPoweredTreebankParserParams.SimpleStringFunction("-s")));
        this.annotations.put("-markD5", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@D > (__ > @COORD)", new TregexPoweredTreebankParserParams.SimpleStringFunction("-c")));
        this.annotations.put("-app1", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@NP < /[,]/", new TregexPoweredTreebankParserParams.SimpleStringFunction("-app1")));
        this.annotations.put("-app2", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("/[^,\\-:;\"]/ > (@NP < /^[,]$/) $,, /^[,]$/", new TregexPoweredTreebankParserParams.SimpleStringFunction("-app2")));
        this.annotations.put("-coord2", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@COORD !< @C", new TregexPoweredTreebankParserParams.SimpleStringFunction("-nonC")));
        this.annotations.put("-hasCOORD", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("__ < @COORD", new TregexPoweredTreebankParserParams.SimpleStringFunction("-hasCOORD")));
        this.annotations.put("-hasCOORDLS", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@SENT <, @COORD", new TregexPoweredTreebankParserParams.SimpleStringFunction("-hasCOORDLS")));
        this.annotations.put("-hasCOORDNonS", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("__ < @COORD !<, @COORD", new TregexPoweredTreebankParserParams.SimpleStringFunction("-hasCOORDNonS")));
        this.annotations.put("-pp1", new Pair<String, AddRelativeNodeFunction>("@P < /^(du|des|au|aux)$/=word", new AddRelativeNodeFunction("-", "word", false)));
        this.annotations.put("-vpinf1", new Pair<String, AddRelativeNodeFunction>("@VPinf <, __=word", new AddRelativeNodeFunction("-", "word", false)));
        this.annotations.put("-vpinf2", new Pair<String, AddRelativeNodeFunction>("@VPinf <, __=word", new AddRelativeNodeFunction("-", "word", true)));
        this.annotations.put("-splitIN", new Pair<String, AddRelativeNodeFunction>("@PP <, (P < /^([Dd]e|[Dd]'|[Dd]es|[Dd]u|\u00e0|[Aa]u|[Aa]ux|[Ee]n|[Dd]ans|[Pp]ar|[Ss]ur|[Pp]our|[Aa]vec|[Ee]ntre)$/=word)", new AddRelativeNodeFunction("-", "word", false, true)));
        this.annotations.put("-splitP", new Pair<String, AddRelativeNodeFunction>("@P < /^([Dd]e|[Dd]'|[Dd]es|[Dd]u|\u00e0|[Aa]u|[Aa]ux|[Ee]n|[Dd]ans|[Pp]ar|[Ss]ur|[Pp]our|[Aa]vec|[Ee]ntre)$/=word", new AddRelativeNodeFunction("-", "word", false, true)));
        this.annotations.put("-hasde", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@NP|PP <+(@NP|PP) (P < de)", new TregexPoweredTreebankParserParams.SimpleStringFunction("-hasDE")));
        this.annotations.put("-hasde2", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@PP < de", new TregexPoweredTreebankParserParams.SimpleStringFunction("-hasDE2")));
        this.annotations.put("-np1", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@NP < /^,$/", new TregexPoweredTreebankParserParams.SimpleStringFunction("-np1")));
        this.annotations.put("-np2", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@NP <, (@D < le|la|les)", new TregexPoweredTreebankParserParams.SimpleStringFunction("-np2")));
        this.annotations.put("-np3", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@D < le|la|les", new TregexPoweredTreebankParserParams.SimpleStringFunction("-def")));
        this.annotations.put("-baseNP", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@NP <, @D <- (@N , @D)", new TregexPoweredTreebankParserParams.SimpleStringFunction("-baseNP")));
        this.annotations.put("-markP2", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@P > (@PP > @AP)", new TregexPoweredTreebankParserParams.SimpleStringFunction("-a")));
        this.annotations.put("-markP3", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@P > (@PP > @SENT|Ssub|VPinf|VPpart)", new TregexPoweredTreebankParserParams.SimpleStringFunction("-v")));
        this.annotations.put("-markP4", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@P > (@PP > @Srel)", new TregexPoweredTreebankParserParams.SimpleStringFunction("-r")));
        this.annotations.put("-markP5", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@P > (@PP > @COORD)", new TregexPoweredTreebankParserParams.SimpleStringFunction("-c")));
        this.annotations.put("-markP6", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@P > @VPinf", new TregexPoweredTreebankParserParams.SimpleStringFunction("-b")));
        this.annotations.put("-markP7", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@P > @VPpart", new TregexPoweredTreebankParserParams.SimpleStringFunction("-b")));
        this.annotations.put("-markP8", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@P > /^MW|NP/", new TregexPoweredTreebankParserParams.SimpleStringFunction("-internal")));
        this.annotations.put("-markP9", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@P > @COORD", new TregexPoweredTreebankParserParams.SimpleStringFunction("-c")));
        this.annotations.put("-hasMWP", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("!/S/ < @MWP", new TregexPoweredTreebankParserParams.SimpleStringFunction("-mwp")));
        this.annotations.put("-hasMWP2", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@PP < @MWP", new TregexPoweredTreebankParserParams.SimpleStringFunction("-mwp2")));
        this.annotations.put("-hasMWN2", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@PP <+(@NP) @MWN", new TregexPoweredTreebankParserParams.SimpleStringFunction("-hasMWN2")));
        this.annotations.put("-hasMWN3", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@NP < @MWN", new TregexPoweredTreebankParserParams.SimpleStringFunction("-hasMWN3")));
        this.annotations.put("-hasMWADV", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("/^A/ < @MWADV", new TregexPoweredTreebankParserParams.SimpleStringFunction("-hasmwadv")));
        this.annotations.put("-hasC1", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("__ < @MWC", new TregexPoweredTreebankParserParams.SimpleStringFunction("-hasc1")));
        this.annotations.put("-hasC2", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@MWC > /S/", new TregexPoweredTreebankParserParams.SimpleStringFunction("-hasc2")));
        this.annotations.put("-hasC3", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@COORD < @MWC", new TregexPoweredTreebankParserParams.SimpleStringFunction("-hasc3")));
        this.annotations.put("-uMWN", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@NP <: @MWN", new TregexPoweredTreebankParserParams.SimpleStringFunction("-umwn")));
        this.annotations.put("-splitC", new Pair<String, AddRelativeNodeFunction>("@C < __=word", new AddRelativeNodeFunction("-", "word", false)));
        this.annotations.put("-splitD", new Pair<String, AddRelativeNodeFunction>("@D < /^[^\\d+]{1,4}$/=word", new AddRelativeNodeFunction("-", "word", false)));
        this.annotations.put("-de1", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@D < /^([Dd]es?|du|d')$/", new TregexPoweredTreebankParserParams.SimpleStringFunction("-de1")));
        this.annotations.put("-markNNP1", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@NP < (N < /^[A-Z]/) !< /^[^NA]/", new TregexPoweredTreebankParserParams.SimpleStringFunction("-nnp")));
        this.annotations.put("-markPP1", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@PP > @NP", new TregexPoweredTreebankParserParams.SimpleStringFunction("-n")));
        this.annotations.put("-markPP2", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@PP > @AP", new TregexPoweredTreebankParserParams.SimpleStringFunction("-a")));
        this.annotations.put("-markPP3", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@PP > @SENT|Ssub|VPinf|VPpart", new TregexPoweredTreebankParserParams.SimpleStringFunction("-v")));
        this.annotations.put("-markPP4", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@PP > @Srel", new TregexPoweredTreebankParserParams.SimpleStringFunction("-r")));
        this.annotations.put("-markPP5", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@PP > @COORD", new TregexPoweredTreebankParserParams.SimpleStringFunction("-c")));
        this.annotations.put("-dominateCC", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("__ << @COORD", new TregexPoweredTreebankParserParams.SimpleStringFunction("-withCC")));
        this.annotations.put("-dominateIN", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("__ << @PP", new TregexPoweredTreebankParserParams.SimpleStringFunction("-withPP")));
        this.annotations.put("-markContainsVP", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("__ << /^VP/", new TregexPoweredTreebankParserParams.SimpleStringFunction("-hasV")));
        this.annotations.put("-markContainsVP2", new Pair<String, AddRelativeNodeFunction>("__ << /^VP/=word", new AddRelativeNodeFunction("-hasV-", "word", false)));
        this.annotations.put("-markVNArgs", new Pair<String, AddRelativeNodeFunction>("@VN $+ __=word1", new AddRelativeNodeFunction("-", "word1", false)));
        this.annotations.put("-markVNArgs2", new Pair<String, AddRelativeNodeFunction>("@VN > __=word1 $+ __=word2", new AddRelativeNodeFunction("-", "word1", "word2", false)));
        this.annotations.put("-markContainsMW", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("__ << /^MW/", new TregexPoweredTreebankParserParams.SimpleStringFunction("-hasMW")));
        this.annotations.put("-markContainsMW2", new Pair<String, AddRelativeNodeFunction>("__ << /^MW/=word", new AddRelativeNodeFunction("-has-", "word", false)));
        this.annotations.put("-mwStart", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("__ >, /^MW/", new TregexPoweredTreebankParserParams.SimpleStringFunction("-mwStart")));
        this.annotations.put("-mwMiddle", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("__ !>- /^MW/ !>, /^MW/ > /^MW/", new TregexPoweredTreebankParserParams.SimpleStringFunction("-mwMid")));
        this.annotations.put("-mwMiddle2", new Pair<String, AddRelativeNodeFunction>("__ !>- /^MW/ !>, /^MW/ > /^MW/ , __=pos", new AddRelativeNodeFunction("-", "pos", true)));
        this.annotations.put("-mwEnd", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("__ >- /^MW/", new TregexPoweredTreebankParserParams.SimpleStringFunction("-mwEnd")));
        this.annotations.put("-nonNAP", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@AP !$, @N|AP", new TregexPoweredTreebankParserParams.SimpleStringFunction("-nap")));
        this.annotations.put("-markNPTMP", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@NP < (@N < /^(lundi|mardi|mercredi|jeudi|vendredi|samedi|dimanche|Lundi|Mardi|Mercredi|Jeudi|Vendredi|Samedi|Dimanche|janvier|f\u00e9vrier|mars|avril|mai|juin|juillet|ao\u00fbt|septembre|octobre|novembre|d\u00e9cembre|Janvier|F\u00e9vrier|Mars|Avril|Mai|Juin|Juillet|Ao\u00fbt|Septembre|Octobre|Novembre|D\u00e9cembre)$/)", new TregexPoweredTreebankParserParams.SimpleStringFunction("-tmp")));
        this.annotations.put("-markSing1", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@NP < (D < /^(ce|cette|une|la|le|un|sa|son|ma|mon|ta|ton)$/)", new TregexPoweredTreebankParserParams.SimpleStringFunction("-sing")));
        this.annotations.put("-markSing2", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@AP < (A < (/[^sx]$/ !< __))", new TregexPoweredTreebankParserParams.SimpleStringFunction("-sing")));
        this.annotations.put("-markSing3", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@VPpart < (V < /(e|\u00e9)$/)", new TregexPoweredTreebankParserParams.SimpleStringFunction("-sing")));
        this.annotations.put("-markPl1", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@NP < (D < /s$/)", new TregexPoweredTreebankParserParams.SimpleStringFunction("-pl")));
        this.annotations.put("-markPl2", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@AP < (A < /[sx]$/)", new TregexPoweredTreebankParserParams.SimpleStringFunction("-pl")));
        this.annotations.put("-markPl3", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@VPpart < (V < /(es|\u00e9s)$/)", new TregexPoweredTreebankParserParams.SimpleStringFunction("-pl")));
        this.compileAnnotations(this.headFinder());
    }

    @Override
    public HeadFinder headFinder() {
        if (this.headFinder == null) {
            this.headFinder = new DybroFrenchHeadFinder(this.treebankLanguagePack());
        }
        return this.headFinder;
    }

    @Override
    public HeadFinder typedDependencyHeadFinder() {
        return this.headFinder();
    }

    private void setHeadFinder(HeadFinder hf) {
        if (hf == null) {
            throw new IllegalArgumentException();
        }
        this.headFinder = hf;
        this.compileAnnotations(hf);
    }

    @Override
    public Lexicon lex(Options op, Index<String> wordIndex, Index<String> tagIndex) {
        if (op.lexOptions.uwModelTrainer == null) {
            op.lexOptions.uwModelTrainer = "edu.stanford.nlp.parser.lexparser.FrenchUnknownWordModelTrainer";
        }
        if (this.morphoSpec != null) {
            return new FactoredLexicon(op, this.morphoSpec, wordIndex, tagIndex);
        }
        return new BaseLexicon(op, wordIndex, tagIndex);
    }

    @Override
    public String[] sisterSplitters() {
        return new String[0];
    }

    @Override
    public TreeTransformer collinizer() {
        return new TreeCollinizer(this.treebankLanguagePack());
    }

    @Override
    public TreeTransformer collinizerEvalb() {
        return new TreeCollinizer(this.treebankLanguagePack(), this.collinizerRetainsPunctuation, false);
    }

    @Override
    public DiskTreebank diskTreebank() {
        return new DiskTreebank(this.treeReaderFactory(), this.inputEncoding);
    }

    @Override
    public MemoryTreebank memoryTreebank() {
        return new MemoryTreebank(this.treeReaderFactory(), this.inputEncoding);
    }

    @Override
    public TreeReaderFactory treeReaderFactory() {
        return this.readPennFormat ? new FrenchTreeReaderFactory() : new FrenchXMLTreeReaderFactory(false);
    }

    public List<HasWord> defaultTestSentence() {
        String[] sent = new String[]{"Ceci", "est", "seulement", "un", "test", "."};
        return SentenceUtils.toWordList(sent);
    }

    @Override
    public Tree transformTree(Tree t, Tree root) {
        t = super.transformTree(t, root);
        String cat = t.value();
        if (t.isPreTerminal() && this.tagSpec != null) {
            if (!(t.firstChild().label() instanceof CoreLabel) || ((CoreLabel)t.firstChild().label()).originalText() == null) {
                throw new RuntimeException(String.format("%s: Term lacks morpho analysis: %s", this.getClass().getName(), t.toString()));
            }
            String morphoStr = ((CoreLabel)t.firstChild().label()).originalText();
            Pair<String, String> lemmaMorph = MorphoFeatureSpecification.splitMorphString("", morphoStr);
            MorphoFeatures feats = this.tagSpec.strToFeatures(lemmaMorph.second());
            cat = feats.getTag(cat);
        }
        t.setValue(cat);
        if (t.isPreTerminal() && t.label() instanceof HasTag) {
            ((HasTag)((Object)t.label())).setTag(cat);
        }
        return t;
    }

    private void loadMWMap(String filename) {
        this.mwCounter = new TwoDimensionalCounter();
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(filename)), "UTF-8"));
            int nLines = 0;
            while ((line = br.readLine()) != null) {
                String[] toks = line.split("\t");
                assert (toks.length == 3);
                this.mwCounter.setCount(toks[0].trim(), toks[1].trim(), Double.parseDouble(toks[2].trim()));
                ++nLines;
            }
            br.close();
            System.err.printf("%s: Loaded %d lines from %s into MWE counter%n", this.getClass().getName(), nLines, filename);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String setupMorphoFeatures(String activeFeats) {
        String[] feats = activeFeats.split(",");
        this.morphoSpec = this.tlp.morphFeatureSpec();
        for (String feat : feats) {
            MorphoFeatureSpecification.MorphoFeatureType fType = MorphoFeatureSpecification.MorphoFeatureType.valueOf(feat.trim());
            this.morphoSpec.activate(fType);
        }
        return this.morphoSpec.toString();
    }

    @Override
    public void display() {
        log.info(this.optionsString.toString());
    }

    @Override
    public int setOptionFlag(String[] args, int i) {
        if (this.annotations.containsKey(args[i])) {
            this.addFeature(args[i]);
            ++i;
        } else if (args[i].equals("-collinizerRetainsPunctuation")) {
            this.optionsString.append("Collinizer retains punctuation.\n");
            this.collinizerRetainsPunctuation = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-headFinder") && i + 1 < args.length) {
            try {
                HeadFinder hf = (HeadFinder)Class.forName(args[i + 1]).newInstance();
                this.setHeadFinder(hf);
                this.optionsString.append("HeadFinder: " + args[i + 1] + "\n");
            }
            catch (Exception e) {
                log.info(e);
                log.info(this.getClass().getName() + ": Could not load head finder " + args[i + 1]);
            }
            i += 2;
        } else if (args[i].equals("-xmlFormat")) {
            this.optionsString.append("Reading trees in XML format.\n");
            this.readPennFormat = false;
            this.setInputEncoding(this.tlp.getEncoding());
            ++i;
        } else if (args[i].equals("-frenchFactored")) {
            for (String feature : factoredFeatures) {
                this.addFeature(feature);
            }
            ++i;
        } else if (args[i].equals("-frenchMWMap")) {
            this.loadMWMap(args[i + 1]);
            i += 2;
        } else if (args[i].equals("-tsg")) {
            this.optionsString.append("Removing baseline features: -markVN, -coord1");
            this.removeFeature("-markVN");
            this.optionsString.append(" (removed -markVN)");
            this.removeFeature("-coord1");
            this.optionsString.append(" (removed -coord1)\n");
            ++i;
        } else if (args[i].equals("-factlex") && i + 1 < args.length) {
            String activeFeats = this.setupMorphoFeatures(args[i + 1]);
            this.optionsString.append("Factored Lexicon: active features: ").append(activeFeats);
            this.removeFeature("-tagPAFr");
            this.optionsString.append(" (removed -tagPAFr)\n");
            String[] option = new String[]{"-mweTag"};
            this.setOptionFlag(option, 0);
            i += 2;
        } else if (args[i].equals("-noFeatures")) {
            for (String feature : this.annotations.keySet()) {
                this.removeFeature(feature);
            }
            this.optionsString.append("Removed all manual features.\n");
            ++i;
        } else if (args[i].equals("-ccTagsetAnnotations")) {
            this.tagSpec = new FrenchMorphoFeatureSpecification();
            this.tagSpec.activate(MorphoFeatureSpecification.MorphoFeatureType.OTHER);
            this.optionsString.append("Adding CC tagset as POS state splits.\n");
            ++i;
        }
        return i;
    }

    private class AddPOSSequenceFunction
    implements SerializableFunction<TregexMatcher, String> {
        private final String annotationMark;
        private final boolean doBasicCat;
        private final double cutoff;
        private static final long serialVersionUID = 1L;

        public AddPOSSequenceFunction(String annotationMark, int cutoff, boolean basicCategory) {
            this.annotationMark = annotationMark;
            this.doBasicCat = basicCategory;
            this.cutoff = cutoff;
        }

        @Override
        public String apply(TregexMatcher m) {
            if (FrenchTreebankParserParams.this.mwCounter == null) {
                throw new RuntimeException("Cannot enable POSSequence features without POS sequence map. Use option -frenchMWMap.");
            }
            Tree t = m.getMatch();
            StringBuilder sb = new StringBuilder();
            for (Tree kid : t.children()) {
                if (!kid.isPreTerminal()) {
                    throw new RuntimeException("Not POS sequence for tree: " + t.toString());
                }
                String tag = this.doBasicCat ? FrenchTreebankParserParams.this.tlp.basicCategory(kid.value()) : kid.value();
                sb.append(tag).append(" ");
            }
            if (FrenchTreebankParserParams.this.mwCounter.getCount(t.value(), sb.toString().trim()) > this.cutoff) {
                return this.annotationMark + sb.toString().replaceAll("\\s+", "").toLowerCase();
            }
            return "";
        }

        public String toString() {
            return "AddPOSSequenceFunction[" + this.annotationMark + ',' + this.cutoff + ',' + this.doBasicCat + ']';
        }
    }

    private class AddRelativeNodeFunction
    implements SerializableFunction<TregexMatcher, String> {
        private String annotationMark;
        private String key;
        private String key2;
        private boolean doBasicCat = false;
        private boolean toLower = false;
        private static final long serialVersionUID = 1L;

        public AddRelativeNodeFunction(String annotationMark, String key, boolean basicCategory) {
            this.annotationMark = annotationMark;
            this.key = key;
            this.key2 = null;
            this.doBasicCat = basicCategory;
        }

        public AddRelativeNodeFunction(String annotationMark, String key1, String key2, boolean basicCategory) {
            this(annotationMark, key1, basicCategory);
            this.key2 = key2;
        }

        public AddRelativeNodeFunction(String annotationMark, String key1, boolean basicCategory, boolean toLower) {
            this(annotationMark, key1, basicCategory);
            this.toLower = toLower;
        }

        @Override
        public String apply(TregexMatcher m) {
            String tag;
            if (this.key2 == null) {
                tag = this.annotationMark + (this.doBasicCat ? FrenchTreebankParserParams.this.tlp.basicCategory(m.getNode(this.key).label().value()) : m.getNode(this.key).label().value());
            } else {
                String annot1 = this.doBasicCat ? FrenchTreebankParserParams.this.tlp.basicCategory(m.getNode(this.key).label().value()) : m.getNode(this.key).label().value();
                String annot2 = this.doBasicCat ? FrenchTreebankParserParams.this.tlp.basicCategory(m.getNode(this.key2).label().value()) : m.getNode(this.key2).label().value();
                tag = this.annotationMark + annot1 + this.annotationMark + annot2;
            }
            return this.toLower ? tag.toLowerCase() : tag;
        }

        public String toString() {
            if (this.key2 == null) {
                return "AddRelativeNodeFunction[" + this.annotationMark + ',' + this.key + ']';
            }
            return "AddRelativeNodeFunction[" + this.annotationMark + ',' + this.key + ',' + this.key2 + ']';
        }
    }

    private static class AnnotatePunctuationFunction
    implements SerializableFunction<TregexMatcher, String> {
        static final String key = "term";
        private static final long serialVersionUID = 1L;

        private AnnotatePunctuationFunction() {
        }

        @Override
        public String apply(TregexMatcher m) {
            String punc;
            switch (punc = m.getNode(key).value()) {
                case ".": {
                    return "-fs";
                }
                case "?": {
                    return "-quest";
                }
                case ",": {
                    return "-comma";
                }
                case ":": 
                case ";": {
                    return "-colon";
                }
            }
            return "";
        }

        public String toString() {
            return "AnnotatePunctuationFunction";
        }
    }
}

