/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling.tokensregex.matcher;

import edu.stanford.nlp.util.StringUtils;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class TrieMap<K, V>
extends AbstractMap<Iterable<K>, V> {
    protected Map<K, TrieMap<K, V>> children;
    protected V value;

    public TrieMap() {
    }

    public TrieMap(int initialCapacity) {
    }

    public TrieMap<K, V> getChildTrie(K key) {
        return this.children != null ? this.children.get(key) : null;
    }

    public TrieMap<K, V> getChildTrie(Iterable<K> key) {
        TrieMap<K, V> curTrie = this;
        for (K element : key) {
            curTrie = curTrie.children != null ? curTrie.children.get(element) : null;
            if (curTrie != null) continue;
            return null;
        }
        return curTrie;
    }

    public TrieMap<K, V> putChildTrie(Iterable<K> key, TrieMap<K, V> child) {
        TrieMap<K, V> parentTrie = null;
        TrieMap<K, V> curTrie = this;
        Iterator<K> keyIter = key.iterator();
        while (keyIter.hasNext()) {
            boolean isLast;
            K element = keyIter.next();
            boolean bl = isLast = !keyIter.hasNext();
            if (curTrie.children == null) {
                curTrie.children = new ConcurrentHashMap<K, TrieMap<K, V>>();
            }
            parentTrie = curTrie;
            curTrie = curTrie.children.get(element);
            if (isLast) {
                parentTrie.children.put(element, child);
                continue;
            }
            if (curTrie != null) continue;
            curTrie = new TrieMap<K, V>();
            parentTrie.children.put(element, curTrie);
        }
        if (parentTrie == null) {
            throw new IllegalArgumentException("Cannot put a child trie with no keys");
        }
        return curTrie;
    }

    public Map<K, TrieMap<K, V>> getChildren() {
        return this.children;
    }

    public V getValue() {
        return this.value;
    }

    public boolean isLeaf() {
        return this.value != null;
    }

    public String toFormattedString() {
        LinkedList<String> strings = new LinkedList<String>();
        this.updateTrieStrings(strings, "");
        return StringUtils.join(strings, "\n");
    }

    protected void updateTrieStrings(List<String> strings, String prefix) {
        if (this.children != null) {
            for (Map.Entry<K, TrieMap<K, V>> kTrieMapEntry : this.children.entrySet()) {
                kTrieMapEntry.getValue().updateTrieStrings(strings, prefix + " - " + kTrieMapEntry.getKey());
            }
        }
        if (this.isLeaf()) {
            strings.add(prefix + " -> " + this.value);
        }
    }

    @Override
    public int size() {
        int s = 0;
        if (this.children != null) {
            for (Map.Entry<K, TrieMap<K, V>> kTrieMapEntry : this.children.entrySet()) {
                s += kTrieMapEntry.getValue().size();
            }
        }
        if (this.isLeaf()) {
            ++s;
        }
        return s;
    }

    @Override
    public boolean isEmpty() {
        return this.children == null && !this.isLeaf();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    @Override
    public V get(Object key) {
        if (key instanceof Iterable) {
            return this.get((Iterable)key);
        }
        if (key instanceof Object[]) {
            return this.get(Arrays.asList((Object[])key));
        }
        return null;
    }

    public V get(Iterable<K> key) {
        TrieMap<K, V> curTrie = this.getChildTrie(key);
        return curTrie != null ? (V)curTrie.value : null;
    }

    public V get(K[] key) {
        return this.get(Arrays.asList(key));
    }

    @Override
    public V put(Iterable<K> key, V value) {
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        TrieMap<K, V> curTrie = this;
        for (K element : key) {
            if (curTrie.children == null) {
                curTrie.children = new ConcurrentHashMap<K, TrieMap<K, V>>();
            }
            TrieMap<K, V> parent = curTrie;
            curTrie = curTrie.children.get(element);
            if (curTrie != null) continue;
            curTrie = new TrieMap<K, V>();
            parent.children.put(element, curTrie);
        }
        V oldValue = curTrie.value;
        curTrie.value = value;
        return oldValue;
    }

    @Override
    public V put(K[] key, V value) {
        return this.put((Iterable<K>)Arrays.asList(key), value);
    }

    @Override
    public V remove(Object key) {
        if (key instanceof Iterable) {
            return this.remove((Iterable)key);
        }
        return null;
    }

    public V remove(Iterable key) {
        TrieMap<K, V> parent = null;
        TrieMap<K, V> curTrie = this;
        Object lastKey = null;
        for (Object element : key) {
            if (curTrie.children == null) {
                return null;
            }
            lastKey = element;
            parent = curTrie;
            curTrie = curTrie.children.get(element);
            if (curTrie != null) continue;
            return null;
        }
        V v = curTrie.value;
        if (parent != null) {
            parent.children.remove(lastKey);
        } else {
            this.value = null;
        }
        return v;
    }

    public V remove(K[] key) {
        return this.remove(Arrays.asList(key));
    }

    @Override
    public void putAll(Map<? extends Iterable<K>, ? extends V> m) {
        for (Map.Entry<Iterable<K>, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.value = null;
        this.children = null;
    }

    @Override
    public Set<Iterable<K>> keySet() {
        LinkedHashSet<Iterable<K>> keys = new LinkedHashSet<Iterable<K>>();
        this.updateKeys(keys, new ArrayList());
        return keys;
    }

    protected void updateKeys(Set<Iterable<K>> keys, List<K> prefix) {
        if (this.children != null) {
            for (Map.Entry<K, TrieMap<K, V>> kTrieMapEntry : this.children.entrySet()) {
                ArrayList<K> p = new ArrayList<K>(prefix.size() + 1);
                p.addAll(prefix);
                p.add(kTrieMapEntry.getKey());
                kTrieMapEntry.getValue().updateKeys(keys, p);
            }
        }
        if (this.value != null) {
            keys.add(prefix);
        }
    }

    @Override
    public Collection<V> values() {
        ArrayList values = new ArrayList();
        this.updateValues(values);
        return values;
    }

    protected void updateValues(List<V> values) {
        if (this.children != null) {
            for (Map.Entry<K, TrieMap<K, V>> kTrieMapEntry : this.children.entrySet()) {
                kTrieMapEntry.getValue().updateValues(values);
            }
        }
        if (this.value != null) {
            values.add(this.value);
        }
    }

    @Override
    public Set<Map.Entry<Iterable<K>, V>> entrySet() {
        LinkedHashSet<Map.Entry<Iterable<K>, V>> entries = new LinkedHashSet<Map.Entry<Iterable<K>, V>>();
        this.updateEntries(entries, new ArrayList());
        return entries;
    }

    protected void updateEntries(Set<Map.Entry<Iterable<K>, V>> entries, final List<K> prefix) {
        if (this.children != null) {
            for (Map.Entry<K, TrieMap<K, V>> kTrieMapEntry : this.children.entrySet()) {
                ArrayList<K> p = new ArrayList<K>(prefix.size() + 1);
                p.addAll(prefix);
                p.add(kTrieMapEntry.getKey());
                kTrieMapEntry.getValue().updateEntries(entries, p);
            }
        }
        if (this.value != null) {
            entries.add(new Map.Entry<Iterable<K>, V>(){

                @Override
                public Iterable<K> getKey() {
                    return prefix;
                }

                @Override
                public V getValue() {
                    return TrieMap.this.value;
                }

                @Override
                public V setValue(V value) {
                    throw new UnsupportedOperationException();
                }
            });
        }
    }
}

