/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling.tokensregex.matcher;

import edu.stanford.nlp.ling.tokensregex.matcher.MatchCostFunction;

public final class ExactMatchCost<K, V>
extends MatchCostFunction.AbstractMatchCostFunction<K, V> {
    final double mismatchCost;
    final double insCost;
    final double delCost;

    public ExactMatchCost() {
        this(1.0);
    }

    public ExactMatchCost(double mismatchCost) {
        this(mismatchCost, 1.0, 1.0);
    }

    public ExactMatchCost(double mismatchCost, double insCost, double delCost) {
        this.mismatchCost = mismatchCost;
        this.insCost = insCost;
        this.delCost = delCost;
    }

    @Override
    public double cost(K k1, K k2, int n) {
        if (k1 != null) {
            if (k2 == null) {
                return this.delCost;
            }
            return k1.equals(k2) ? 0.0 : this.mismatchCost;
        }
        return k2 == null ? 0.0 : this.insCost;
    }
}

