/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.international.spanish.pipeline;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreeNormalizer;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.trees.tregex.tsurgeon.Tsurgeon;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;
import edu.stanford.nlp.util.Pair;
import java.util.Arrays;
import java.util.List;

public class MultiWordTreeExpander {
    private static final String CANDIDATE_GROUPS = "(^grup\\.(adv|c[cs]|[iwz]|nom|prep|pron|verb)|\\.inter)";
    private static final String PREPOSITIONS = "(por|para|pro|al?|del?|con(?:tra)?|sobre|en(?:tre)?|hacia|sin|seg\u00fan|hasta|bajo)";
    private final TregexPattern parentheticalExpression = TregexPattern.compile("fpa=left > /^grup\\.nom$/ $++ fpt=right");
    private final TsurgeonPattern groupParentheticalExpression = Tsurgeon.parseOperation("createSubtree grup.nom.inter4 left right");
    private final TregexPattern multipleClauses = TregexPattern.compile("/^grup\\.nom/ > /^grup\\.nom/ < (fp !$-- fp $- /^[^g]/=right1 $+ __=left2) <, __=left1 <` __=right2");
    private final TsurgeonPattern expandMultipleClauses = Tsurgeon.parseOperation("[createSubtree grup.nom left1 right1][createSubtree grup.nom left2 right2]");
    private final TregexPattern prepositionalPhrase = TregexPattern.compile("sp000=tag < /(?i)^(por|para|pro|al?|del?|con(?:tra)?|sobre|en(?:tre)?|hacia|sin|seg\u00fan|hasta|bajo)$/ > (/(^grup\\.(adv|c[cs]|[iwz]|nom|prep|pron|verb)|\\.inter)/ <- __=right) $+ /^([adnswz]|p[ipr])/=left !$-- sp000");
    private final TregexPattern leadingPrepositionalPhrase = TregexPattern.compile("sp000=tag < /(?i)^(por|para|pro|al?|del?|con(?:tra)?|sobre|en(?:tre)?|hacia|sin|seg\u00fan|hasta|bajo)$/ >, (/(^grup\\.(adv|c[cs]|[iwz]|nom|prep|pron|verb)|\\.inter)/ <- __=right) $+ /^([adnswz]|p[ipr])/=left !$-- sp000");
    private final TsurgeonPattern expandPrepositionalPhrase1 = Tsurgeon.parseOperation("[createSubtree grup.nom.inter left right]");
    private final TregexPattern intermediatePrepositionalPhrase = TregexPattern.compile("sp000=preptag $+ /^grup\\.nom\\.inter$/=gn");
    private final TsurgeonPattern expandPrepositionalPhrase2 = Tsurgeon.parseOperation("[adjoinF (sp (prep T=preptarget) (sn foot@)) gn][relabel gn /.inter$//][replace preptarget preptag][delete preptag]");
    private final TregexPattern prepositionalVP = TregexPattern.compile("sp000=tag < /(?i)^(para|al?|del?)$/ > (/(^grup\\.(adv|c[cs]|[iwz]|nom|prep|pron|verb)|\\.inter)/ <- __=right) $+ vmn0000=left !$-- sp000");
    private final TsurgeonPattern expandPrepositionalVP1 = Tsurgeon.parseOperation("[createSubtree S.inter left right][adjoinF (infinitiu foot@) left]");
    private final TregexPattern intermediatePrepositionalVP = TregexPattern.compile("sp000=preptag $+ /^S\\.inter$/=si");
    private final TsurgeonPattern expandPrepositionalVP2 = Tsurgeon.parseOperation("[adjoin (sp prep=target S@) si] [move preptag >0 target]");
    private final TregexPattern conjunctPhrase = TregexPattern.compile("cc=cc > (/^grup\\.nom/ <, __=left1 <` __=right2) $- /^[^g]/=right1 $+ /^[^g]/=left2");
    private final TsurgeonPattern expandConjunctPhrase = Tsurgeon.parseOperation("[adjoinF (conj foot@) cc][createSubtree grup.nom.inter2 left1 right1][createSubtree grup.nom.inter2 left2 right2]");
    private final TregexPattern intermediateSubstantiveConjunct = TregexPattern.compile("/grup\\.nom\\.inter2/=target <: /^[dnpw]/");
    private final TsurgeonPattern expandIntermediateSubstantiveConjunct = Tsurgeon.parseOperation("[relabel target /grup.nom/]");
    private final TregexPattern intermediateAdjectiveConjunct = TregexPattern.compile("/^grup\\.nom\\.inter2$/=target <: /^a/");
    private final TsurgeonPattern expandIntermediateAdjectiveConjunct = Tsurgeon.parseOperation("[relabel target /grup.a/]");
    private final TregexPattern intermediateNounPhraseConjunct = TregexPattern.compile("/^grup\\.nom\\.inter2$/=target < /^s[pn]$/");
    private final TsurgeonPattern expandIntermediateNounPhraseConjunct = Tsurgeon.parseOperation("[relabel target sn]");
    private final TregexPattern intermediateVerbConjunct = TregexPattern.compile("/^grup\\.nom\\.inter2$/=gn <: /^vmi/");
    private final TsurgeonPattern expandIntermediateVerbConjunct = Tsurgeon.parseOperation("[adjoin (S (grup.verb@)) gn]");
    private final TregexPattern intermediateNominalGroupConjunct = TregexPattern.compile("/^grup\\.nom\\.inter2$/=target !< /^[^n]/");
    private final TsurgeonPattern expandIntermediateNominalGroupConjunct = Tsurgeon.parseOperation("[relabel target /grup.nom/]");
    private final TregexPattern articleLeadingNominalGroup = TregexPattern.compile("/^d[aip]/=art >, (/^grup\\.nom$/=ng > sn)");
    private final TsurgeonPattern expandArticleLeadingNominalGroup = Tsurgeon.parseOperation("[insert (spec=target) $+ ng] [move art >0 target]");
    private final TregexPattern articleInsideOrphanedNominalGroup = TregexPattern.compile("/^d[aip]/=d >, (/^grup\\.nom/=ng !> sn)");
    private final TsurgeonPattern expandArticleInsideOrphanedNominalGroup = Tsurgeon.parseOperation("[adjoinF (sn=sn spec=spec foot@) ng] [move d >0 spec]");
    private final TregexPattern determinerInsideNominalGroup = TregexPattern.compile("/^d[^n]/=det >, (/^grup\\.nom/=ng > sn) $ __");
    private final TsurgeonPattern expandDeterminerInsideNominalGroup = Tsurgeon.parseOperation("[insert (spec=target) $+ ng] [move det >0 target]");
    private final TregexPattern contractionTrailingIdiomBeforeNominalGroup = TregexPattern.compile("sp000 >` (/^grup\\.prep$/ > (__ $+ /^grup\\.nom/=ng)) < /^(de|a)l$/=contraction");
    private final TsurgeonPattern joinArticleWithNominalGroup = Tsurgeon.parseOperation("[relabel contraction /l//] [adjoinF (sn (spec (da0000 el)) foot@) ng]");
    private final TregexPattern contractionInSpecifier = TregexPattern.compile("sp000=parent < /(?i)^(a|de)l$/=contraction > spec");
    private final TregexPattern delTodo = TregexPattern.compile("del=contraction . todo > sp000=parent");
    private final TregexPattern contractionInRangePhrase = TregexPattern.compile("sp000 < /(?i)^(a|de)l$/=contraction >: (conj $+ (/^grup\\.(w|nom)/=group))");
    private final TsurgeonPattern expandContractionInRangePhrase = Tsurgeon.parseOperation("[relabel contraction /(?i)l//] [adjoinF (sn (spec (da0000 el)) foot@) group]");
    private final TsurgeonPattern extendContraction = Tsurgeon.parseOperation("[relabel contraction /l//] [insert (da0000 el) $- parent]");
    private final TregexPattern terminalPrepositions = TregexPattern.compile("sp000=sp < /(por|para|pro|al?|del?|con(?:tra)?|sobre|en(?:tre)?|hacia|sin|seg\u00fan|hasta|bajo)/ >- (/^grup\\.nom/ >+(/^grup\\.nom/) sn=sn >>- =sn)");
    private final TsurgeonPattern extractTerminalPrepositions = Tsurgeon.parseOperation("[insert (prep=prep) $- sn] [move sp >0 prep]");
    private final TregexPattern terminalPrepositions2 = TregexPattern.compile("prep=prep >` (/^grup\\.nom$/ >: (sn=sn > /^(grup\\.prep|sp)$/))");
    private final TsurgeonPattern extractTerminalPrepositions2 = Tsurgeon.parseOperation("move prep $- sn");
    private final TregexPattern terminalPrepositions3 = TregexPattern.compile("sp000=sp $- infinitiu >` (S=S >` /^(grup\\.prep|sp)$/)");
    private final TsurgeonPattern extractTerminalPrepositions3 = Tsurgeon.parseOperation("[insert (prep=prep) $- S] [move sp >0 prep]");
    private final TregexPattern adverbNominalGroups = TregexPattern.compile("/^grup\\.nom./=ng <: /^r[gn]/=r");
    private final TsurgeonPattern replaceAdverbNominalGroup = Tsurgeon.parseOperation("replace ng r");
    private final TregexPattern adjectiveSpanInNominalGroup = TregexPattern.compile("/^grup\\.nom/=ng <, aq0000=left <` aq0000=right !< /^[^a]/");
    private final TregexPattern clauseInNominalGroup = TregexPattern.compile("lo . (que > (pr000000=pr >, /^grup\\.nom/=ng $+ (/^v/=vb >` =ng)))");
    private final TsurgeonPattern labelClause = Tsurgeon.parseOperation("[relabel ng S] [adjoinF (relatiu foot@) pr] [adjoinF (grup.verb foot@) vb]");
    private final TregexPattern clauseInNominalGroup2 = TregexPattern.compile("/^grup\\.nom/=gn $- spec <: /^vmn/");
    private final TsurgeonPattern labelClause2 = Tsurgeon.parseOperation("[adjoin (S (infinitiu@)) gn]");
    private final TregexPattern clauseInNominalGroup3 = TregexPattern.compile("sn=sn <, (/^vmn/=inf $+ (sp >` =sn))");
    private final TsurgeonPattern labelClause3 = Tsurgeon.parseOperation("[relabel sn S] [adjoinF (infinitiu foot@) inf]");
    private final TregexPattern loneAdjectiveInNominalGroup = TregexPattern.compile("/^a/=a > /^grup\\.nom/ $ /^([snwz]|p[ipr])/ !$ /^a/");
    private final TsurgeonPattern labelAdjective = Tsurgeon.parseOperation("[adjoinF (s.a (grup.a foot@)) a]");
    private final TsurgeonPattern groupAdjectives = Tsurgeon.parseOperation("createSubtree (s.a grup.a@) left right");
    private final TregexPattern alMenos = TregexPattern.compile("/(?i)^al$/ . /(?i)^menos$/ > (sp000 $+ rg > /^grup\\.adv$/=ga)");
    private final TsurgeonPattern fixAlMenos = Tsurgeon.parseOperation("replace ga (grup.adv (sp (prep (sp000 a)) (sn (spec (da0000 lo)) (grup.nom (s.a (grup.a (aq0000 menos)))))))");
    private final TregexPattern todoLoContrario = TregexPattern.compile("(__=ttodo < /(?i)^todo$/) $+ (__=tlo < /(?i)^lo$/ $+ (__=tcon < /(?i)^contrario$/))");
    private final TsurgeonPattern fixTodoLoContrario = Tsurgeon.parseOperation("[adjoin (sn (grup.nom (pp000000@))) tlo] [adjoin (grup.a (aq0000@)) tcon]");
    private final TregexPattern infinitiveInVerbGroup = TregexPattern.compile("/^grup\\.verb$/=grup < (/^v/ !$-- /^v/ $++ (/^vmn/=target !$++ /^vmn/))");
    private final TsurgeonPattern markInfinitive = Tsurgeon.parseOperation("[adjoinF (infinitiu foot@) target]");
    private final TregexPattern floppedGerund = TregexPattern.compile("/^grup\\.verb$/=grup >: gerundi=ger < (/^vmg/=vb !$ /^vmg/)");
    private final TsurgeonPattern unflopFloppedGerund = Tsurgeon.parseOperation("[adjoinF (gerundi foot@) vb] [replace ger grup]");
    private final TregexPattern floppedInfinitive = TregexPattern.compile("/^grup\\.verb$/=grup >: infinitiu=inf < (/^vmn/=vb !$ /^vmn/)");
    private final TsurgeonPattern unflopFloppedInfinitive = Tsurgeon.parseOperation("[adjoinF (infinitiu foot@) vb] [replace inf grup]");
    private final TregexPattern nominalGroupSubstantives = TregexPattern.compile("sn=target < /^[adnwz]/ !< /^([^adnswz]|neg)/");
    private final TregexPattern leftoverIntermediates = TregexPattern.compile("/^grup\\.nom\\.inter/=target");
    private final TsurgeonPattern makeNominalGroup = Tsurgeon.parseOperation("[relabel target /grup.nom/]");
    private final TregexPattern redundantNominalRewrite = TregexPattern.compile("/^grup\\.nom$/ <: sn=child >: sn=parent");
    private final TsurgeonPattern fixRedundantNominalRewrite = Tsurgeon.parseOperation("[replace parent child]");
    private final TregexPattern redundantPrepositionGroupRewrite = TregexPattern.compile("/^grup\\.prep$/=parent <: sp=child >: prep");
    private final TsurgeonPattern fixRedundantPrepositionGroupRewrite = Tsurgeon.parseOperation("[relabel child /grup.prep/] [replace parent child]");
    private final TregexPattern redundantPrepositionGroupRewrite2 = TregexPattern.compile("/^grup\\.prep$/=gp <: sp=sp");
    private final TsurgeonPattern fixRedundantPrepositionGroupRewrite2 = Tsurgeon.parseOperation("replace gp sp");
    private final List<Pair<TregexPattern, TsurgeonPattern>> firstStepExpansions = Arrays.asList(new Pair<TregexPattern, TsurgeonPattern>(this.parentheticalExpression, this.groupParentheticalExpression), new Pair<TregexPattern, TsurgeonPattern>(this.multipleClauses, this.expandMultipleClauses), new Pair<TregexPattern, TsurgeonPattern>(this.leadingPrepositionalPhrase, this.expandPrepositionalPhrase1), new Pair<TregexPattern, TsurgeonPattern>(this.conjunctPhrase, this.expandConjunctPhrase), new Pair<TregexPattern, TsurgeonPattern>(this.prepositionalPhrase, this.expandPrepositionalPhrase1), new Pair<TregexPattern, TsurgeonPattern>(this.prepositionalVP, this.expandPrepositionalVP1), new Pair<TregexPattern, TsurgeonPattern>(this.contractionTrailingIdiomBeforeNominalGroup, this.joinArticleWithNominalGroup), new Pair<TregexPattern, TsurgeonPattern>(this.contractionInSpecifier, this.extendContraction), new Pair<TregexPattern, TsurgeonPattern>(this.delTodo, this.extendContraction), new Pair<TregexPattern, TsurgeonPattern>(this.contractionInRangePhrase, this.expandContractionInRangePhrase), new Pair<TregexPattern, TsurgeonPattern>(this.articleLeadingNominalGroup, this.expandArticleLeadingNominalGroup), new Pair<TregexPattern, TsurgeonPattern>(this.articleInsideOrphanedNominalGroup, this.expandArticleInsideOrphanedNominalGroup), new Pair<TregexPattern, TsurgeonPattern>(this.determinerInsideNominalGroup, this.expandDeterminerInsideNominalGroup));
    private final List<Pair<TregexPattern, TsurgeonPattern>> intermediateExpansions = Arrays.asList(new Pair<TregexPattern, TsurgeonPattern>(this.intermediatePrepositionalPhrase, this.expandPrepositionalPhrase2), new Pair<TregexPattern, TsurgeonPattern>(this.intermediatePrepositionalVP, this.expandPrepositionalVP2), new Pair<TregexPattern, TsurgeonPattern>(this.intermediateSubstantiveConjunct, this.expandIntermediateSubstantiveConjunct), new Pair<TregexPattern, TsurgeonPattern>(this.intermediateAdjectiveConjunct, this.expandIntermediateAdjectiveConjunct), new Pair<TregexPattern, TsurgeonPattern>(this.intermediateNounPhraseConjunct, this.expandIntermediateNounPhraseConjunct), new Pair<TregexPattern, TsurgeonPattern>(this.intermediateVerbConjunct, this.expandIntermediateVerbConjunct), new Pair<TregexPattern, TsurgeonPattern>(this.intermediateNominalGroupConjunct, this.expandIntermediateNominalGroupConjunct));
    private final List<Pair<TregexPattern, TsurgeonPattern>> finalCleanup = Arrays.asList(new Pair<TregexPattern, TsurgeonPattern>(this.terminalPrepositions, this.extractTerminalPrepositions), new Pair<TregexPattern, TsurgeonPattern>(this.terminalPrepositions2, this.extractTerminalPrepositions2), new Pair<TregexPattern, TsurgeonPattern>(this.terminalPrepositions3, this.extractTerminalPrepositions3), new Pair<TregexPattern, TsurgeonPattern>(this.nominalGroupSubstantives, this.makeNominalGroup), new Pair<TregexPattern, TsurgeonPattern>(this.adverbNominalGroups, this.replaceAdverbNominalGroup), new Pair<TregexPattern, TsurgeonPattern>(this.adjectiveSpanInNominalGroup, this.groupAdjectives), new Pair<TregexPattern, TsurgeonPattern>(this.clauseInNominalGroup, this.labelClause), new Pair<TregexPattern, TsurgeonPattern>(this.clauseInNominalGroup2, this.labelClause2), new Pair<TregexPattern, TsurgeonPattern>(this.clauseInNominalGroup3, this.labelClause3), new Pair<TregexPattern, TsurgeonPattern>(this.loneAdjectiveInNominalGroup, this.labelAdjective), new Pair<TregexPattern, TsurgeonPattern>(this.infinitiveInVerbGroup, this.markInfinitive), new Pair<TregexPattern, TsurgeonPattern>(this.floppedGerund, this.unflopFloppedGerund), new Pair<TregexPattern, TsurgeonPattern>(this.floppedInfinitive, this.unflopFloppedInfinitive), new Pair<TregexPattern, TsurgeonPattern>(this.alMenos, this.fixAlMenos), new Pair<TregexPattern, TsurgeonPattern>(this.todoLoContrario, this.fixTodoLoContrario), new Pair<TregexPattern, TsurgeonPattern>(this.redundantNominalRewrite, this.fixRedundantNominalRewrite), new Pair<TregexPattern, TsurgeonPattern>(this.redundantPrepositionGroupRewrite, this.fixRedundantPrepositionGroupRewrite), new Pair<TregexPattern, TsurgeonPattern>(this.redundantPrepositionGroupRewrite2, this.fixRedundantPrepositionGroupRewrite2), new Pair<TregexPattern, TsurgeonPattern>(this.leftoverIntermediates, this.makeNominalGroup));

    public Tree expandPhrases(Tree t, TreeNormalizer tn, TreeFactory tf) {
        Tree oldTree;
        do {
            oldTree = t.deepCopy();
        } while (!(t = Tsurgeon.processPatternsOnTree(this.firstStepExpansions, t)).equals(oldTree));
        t = Tsurgeon.processPatternsOnTree(this.intermediateExpansions, t);
        t = tn.normalizeWholeTree(t, tf);
        t = Tsurgeon.processPatternsOnTree(this.finalCleanup, t);
        return t;
    }
}

