/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.crf;

import edu.stanford.nlp.ie.crf.CRFClassifier;
import edu.stanford.nlp.ie.crf.CRFLabel;
import edu.stanford.nlp.ie.crf.CRFLogConditionalObjectiveFloatFunction;
import edu.stanford.nlp.math.ArrayMath;
import edu.stanford.nlp.optimization.Evaluator;
import edu.stanford.nlp.optimization.QNMinimizer;
import edu.stanford.nlp.optimization.ResultStoringFloatMonitor;
import edu.stanford.nlp.sequences.SeqClassifierFlags;
import edu.stanford.nlp.util.ConvertByteArray;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.zip.GZIPInputStream;

public class CRFClassifierFloat<IN extends CoreMap>
extends CRFClassifier<IN> {
    private static Redwood.RedwoodChannels log = Redwood.channels(CRFClassifierFloat.class);

    protected CRFClassifierFloat() {
        super(new SeqClassifierFlags());
    }

    public CRFClassifierFloat(Properties props) {
        super(props);
    }

    public CRFClassifierFloat(SeqClassifierFlags flags) {
        super(flags);
    }

    @Override
    protected double[] trainWeights(int[][][][] data, int[][] labels, Evaluator[] evaluators, int pruneFeatureItr, double[][][][] featureVals) {
        float[] initialWeights;
        QNMinimizer minimizer;
        CRFLogConditionalObjectiveFloatFunction func = new CRFLogConditionalObjectiveFloatFunction(data, labels, this.featureIndex, this.windowSize, this.classIndex, (List<Index<CRFLabel>>)this.labelIndices, this.map, this.flags.backgroundSymbol, this.flags.sigma);
        this.cliquePotentialFunctionHelper = func;
        if (this.flags.interimOutputFreq != 0) {
            ResultStoringFloatMonitor monitor = new ResultStoringFloatMonitor(this.flags.interimOutputFreq, this.flags.serializeTo);
            minimizer = new QNMinimizer(monitor);
        } else {
            minimizer = new QNMinimizer();
        }
        if (pruneFeatureItr == 0) {
            minimizer.setM(this.flags.QNsize);
        } else {
            minimizer.setM(this.flags.QNsize2);
        }
        if (this.flags.initialWeights == null) {
            initialWeights = func.initial();
        } else {
            try {
                log.info("Reading initial weights from file " + this.flags.initialWeights);
                DataInputStream dis = new DataInputStream(new BufferedInputStream(new GZIPInputStream(new FileInputStream(this.flags.initialWeights))));
                initialWeights = ConvertByteArray.readFloatArr(dis);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read from float initial weight file " + this.flags.initialWeights);
            }
        }
        log.info("numWeights: " + initialWeights.length);
        float[] weights = minimizer.minimize(func, (float)this.flags.tolerance, initialWeights);
        return ArrayMath.floatArrayToDoubleArray(weights);
    }
}

