/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie;

import edu.stanford.nlp.classify.Classifier;
import edu.stanford.nlp.classify.LinearClassifier;
import edu.stanford.nlp.ie.KBPRelationExtractor;
import edu.stanford.nlp.ie.KBPSemgrexExtractor;
import edu.stanford.nlp.ie.KBPStatisticalExtractor;
import edu.stanford.nlp.ie.KBPTokensregexExtractor;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.util.ArgumentParser;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.logging.Redwood;
import edu.stanford.nlp.util.logging.RedwoodConfiguration;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.Optional;

public class KBPEnsembleExtractor
implements KBPRelationExtractor {
    protected static final Redwood.RedwoodChannels logger = Redwood.channels(KBPRelationExtractor.class);
    @ArgumentParser.Option(name="model", gloss="The path to the model")
    private static String STATISTICAL_MODEL = "edu/stanford/nlp/models/kbp/tac-re-lr.ser.gz";
    @ArgumentParser.Option(name="semgrex", gloss="Semgrex patterns directory")
    private static String SEMGREX_DIR = "edu/stanford/nlp/models/kbp/semgrex";
    @ArgumentParser.Option(name="tokensregex", gloss="Tokensregex patterns directory")
    private static String TOKENSREGEX_DIR = "edu/stanford/nlp/models/kbp/tokensregex";
    @ArgumentParser.Option(name="predictions", gloss="Dump model predictions to this file")
    public static Optional<String> PREDICTIONS = Optional.empty();
    @ArgumentParser.Option(name="test", gloss="The dataset to test on")
    public static File TEST_FILE = new File("test.conll");
    public final KBPRelationExtractor[] extractors;

    public KBPEnsembleExtractor(KBPRelationExtractor ... extractors) {
        this.extractors = extractors;
    }

    @Override
    public Pair<String, Double> classify(KBPRelationExtractor.KBPInput input) {
        Pair<String, Double> prediction = Pair.makePair("no_relation", 1.0);
        for (KBPRelationExtractor extractor : this.extractors) {
            Pair<String, Double> classifierPrediction = extractor.classify(input);
            if (!((String)prediction.first).equals("no_relation") && (((String)classifierPrediction.first).equals("no_relation") || !((Double)classifierPrediction.second > (Double)prediction.second))) continue;
            prediction = classifierPrediction;
        }
        return prediction;
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        KBPStatisticalExtractor statisticalExtractor;
        RedwoodConfiguration.standard().apply();
        ArgumentParser.fillOptions(KBPEnsembleExtractor.class, args);
        Object object = IOUtils.readObjectFromURLOrClasspathOrFileSystem(STATISTICAL_MODEL);
        if (object instanceof LinearClassifier) {
            statisticalExtractor = new KBPStatisticalExtractor((Classifier)object);
        } else if (object instanceof KBPStatisticalExtractor) {
            statisticalExtractor = (KBPStatisticalExtractor)object;
        } else {
            throw new ClassCastException(object.getClass() + " cannot be cast into a " + KBPStatisticalExtractor.class);
        }
        logger.info("Read statistical model from " + STATISTICAL_MODEL);
        KBPEnsembleExtractor extractor = new KBPEnsembleExtractor(new KBPTokensregexExtractor(TOKENSREGEX_DIR), new KBPSemgrexExtractor(SEMGREX_DIR), statisticalExtractor);
        List<Pair<KBPRelationExtractor.KBPInput, String>> testExamples = KBPRelationExtractor.readDataset(TEST_FILE);
        extractor.computeAccuracy(testExamples.stream(), PREDICTIONS.map(x -> {
            try {
                return "stdout".equalsIgnoreCase((String)x) ? System.out : new PrintStream(new FileOutputStream((String)x));
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }));
    }
}

