/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.dcoref;

import edu.stanford.nlp.dcoref.CorefScorer;
import edu.stanford.nlp.dcoref.Document;
import edu.stanford.nlp.dcoref.Mention;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public class ScorerBCubed
extends CorefScorer {
    private final BCubedType type;

    public ScorerBCubed(BCubedType _type) {
        super(CorefScorer.ScoreType.BCubed);
        this.type = _type;
    }

    @Override
    protected void calculatePrecision(Document doc) {
        switch (this.type) {
            case Bcai: {
                this.calculatePrecisionBcai(doc);
                break;
            }
            case Ball: {
                this.calculatePrecisionBall(doc);
                break;
            }
            case Bconll: {
                this.calculatePrecisionBconll(doc);
            }
        }
    }

    @Override
    protected void calculateRecall(Document doc) {
        switch (this.type) {
            case Bcai: {
                this.calculateRecallBcai(doc);
                break;
            }
            case Ball: {
                this.calculateRecallBall(doc);
                break;
            }
            case Bconll: {
                this.calculateRecallBconll(doc);
            }
        }
    }

    private void calculatePrecisionBall(Document doc) {
        int pDen = 0;
        double pNum = 0.0;
        Map<Integer, Mention> goldMentions = doc.allGoldMentions;
        Map<Integer, Mention> predictedMentions = doc.allPredictedMentions;
        for (Mention m : predictedMentions.values()) {
            double correct = 0.0;
            double total = 0.0;
            for (Mention m2 : doc.corefClusters.get(m.corefClusterID).getCorefMentions()) {
                if (m == m2 || goldMentions.containsKey(m.mentionID) && goldMentions.containsKey(m2.mentionID) && goldMentions.get((Object)Integer.valueOf((int)m.mentionID)).goldCorefClusterID == goldMentions.get((Object)Integer.valueOf((int)m2.mentionID)).goldCorefClusterID) {
                    correct += 1.0;
                }
                total += 1.0;
            }
            pNum += correct / total;
            ++pDen;
        }
        this.precisionDenSum += (double)pDen;
        this.precisionNumSum += pNum;
    }

    private void calculateRecallBall(Document doc) {
        int rDen = 0;
        double rNum = 0.0;
        Map<Integer, Mention> goldMentions = doc.allGoldMentions;
        Map<Integer, Mention> predictedMentions = doc.allPredictedMentions;
        for (Mention m : goldMentions.values()) {
            double correct = 0.0;
            double total = 0.0;
            for (Mention m2 : doc.goldCorefClusters.get(m.goldCorefClusterID).getCorefMentions()) {
                if (m == m2 || predictedMentions.containsKey(m.mentionID) && predictedMentions.containsKey(m2.mentionID) && predictedMentions.get((Object)Integer.valueOf((int)m.mentionID)).corefClusterID == predictedMentions.get((Object)Integer.valueOf((int)m2.mentionID)).corefClusterID) {
                    correct += 1.0;
                }
                total += 1.0;
            }
            rNum += correct / total;
            ++rDen;
        }
        this.recallDenSum += (double)rDen;
        this.recallNumSum += rNum;
    }

    private void calculatePrecisionBcai(Document doc) {
        int pDen = 0;
        double pNum = 0.0;
        Map<Integer, Mention> goldMentions = doc.allGoldMentions;
        Map<Integer, Mention> predictedMentions = doc.allPredictedMentions;
        for (Mention m : predictedMentions.values()) {
            if (!goldMentions.containsKey(m.mentionID) && doc.corefClusters.get(m.corefClusterID).getCorefMentions().size() == 1) continue;
            double correct = 0.0;
            double total = 0.0;
            for (Mention m2 : doc.corefClusters.get(m.corefClusterID).getCorefMentions()) {
                if (m == m2 || goldMentions.containsKey(m.mentionID) && goldMentions.containsKey(m2.mentionID) && goldMentions.get((Object)Integer.valueOf((int)m.mentionID)).goldCorefClusterID == goldMentions.get((Object)Integer.valueOf((int)m2.mentionID)).goldCorefClusterID) {
                    correct += 1.0;
                }
                total += 1.0;
            }
            pNum += correct / total;
            ++pDen;
        }
        Iterator<Serializable> iterator = goldMentions.keySet().iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            if (predictedMentions.containsKey(id)) continue;
            pNum += 1.0;
            ++pDen;
        }
        this.precisionDenSum += (double)pDen;
        this.precisionNumSum += pNum;
    }

    private void calculateRecallBcai(Document doc) {
        int rDen = 0;
        double rNum = 0.0;
        Map<Integer, Mention> goldMentions = doc.allGoldMentions;
        Map<Integer, Mention> predictedMentions = doc.allPredictedMentions;
        for (Mention m : goldMentions.values()) {
            double correct = 0.0;
            double total = 0.0;
            for (Mention m2 : doc.goldCorefClusters.get(m.goldCorefClusterID).getCorefMentions()) {
                if (m == m2 || predictedMentions.containsKey(m.mentionID) && predictedMentions.containsKey(m2.mentionID) && predictedMentions.get((Object)Integer.valueOf((int)m.mentionID)).corefClusterID == predictedMentions.get((Object)Integer.valueOf((int)m2.mentionID)).corefClusterID) {
                    correct += 1.0;
                }
                total += 1.0;
            }
            rNum += correct / total;
            ++rDen;
        }
        this.recallDenSum += (double)rDen;
        this.recallNumSum += rNum;
    }

    private void calculatePrecisionBconll(Document doc) {
        this.calculatePrecisionBcai(doc);
    }

    private void calculateRecallBconll(Document doc) {
        int rDen = 0;
        double rNum = 0.0;
        Map<Integer, Mention> goldMentions = doc.allGoldMentions;
        Map<Integer, Mention> predictedMentions = doc.allPredictedMentions;
        for (Mention m : goldMentions.values()) {
            double correct = 0.0;
            double total = 0.0;
            for (Mention m2 : doc.goldCorefClusters.get(m.goldCorefClusterID).getCorefMentions()) {
                if (m == m2 || predictedMentions.containsKey(m.mentionID) && predictedMentions.containsKey(m2.mentionID) && predictedMentions.get((Object)Integer.valueOf((int)m.mentionID)).corefClusterID == predictedMentions.get((Object)Integer.valueOf((int)m2.mentionID)).corefClusterID) {
                    correct += 1.0;
                }
                total += 1.0;
            }
            rNum += correct / total;
            ++rDen;
        }
        for (Mention m : predictedMentions.values()) {
            if (goldMentions.containsKey(m.mentionID) || doc.corefClusters.get(m.corefClusterID).getCorefMentions().size() == 1) continue;
            rNum += 1.0;
            ++rDen;
        }
        this.recallDenSum += (double)rDen;
        this.recallNumSum += rNum;
    }

    protected static enum BCubedType {
        B0,
        Ball,
        Brahman,
        Bcai,
        Bconll;

    }
}

