/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.dcoref;

import edu.stanford.nlp.classify.LogisticClassifier;
import edu.stanford.nlp.dcoref.Dictionaries;
import edu.stanford.nlp.dcoref.MentionExtractor;
import edu.stanford.nlp.dcoref.Semantics;
import edu.stanford.nlp.dcoref.SieveCoreferenceSystem;
import edu.stanford.nlp.dcoref.SpeakerInfo;
import edu.stanford.nlp.ling.AbstractCoreLabel;
import edu.stanford.nlp.ling.BasicDatum;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.semgrex.SemgrexMatcher;
import edu.stanford.nlp.semgraph.semgrex.SemgrexPattern;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.UniversalEnglishGrammaticalRelations;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.util.CollectionUtils;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class Mention
implements CoreAnnotation<Mention>,
Serializable {
    private static final long serialVersionUID = -7524485803945717057L;
    public Dictionaries.MentionType mentionType;
    public Dictionaries.Number number;
    public Dictionaries.Gender gender;
    public Dictionaries.Animacy animacy;
    public Dictionaries.Person person;
    public String headString;
    public String nerString;
    public int startIndex;
    public int endIndex;
    public int headIndex;
    public int mentionID = -1;
    public int originalRef = -1;
    public IndexedWord headIndexedWord;
    public int goldCorefClusterID = -1;
    public int corefClusterID = -1;
    public int sentNum = -1;
    public int utter = -1;
    public int paragraph = -1;
    public boolean isSubject;
    public boolean isDirectObject;
    public boolean isIndirectObject;
    public boolean isPrepositionObject;
    public IndexedWord dependingVerb;
    public boolean twinless = true;
    public boolean generic = false;
    public boolean isSingleton;
    public List<CoreLabel> sentenceWords;
    public List<CoreLabel> originalSpan;
    public Tree mentionSubTree;
    public Tree contextParseTree;
    public CoreLabel headWord;
    public SemanticGraph dependency;
    public Set<String> dependents = Generics.newHashSet();
    public List<String> preprocessedTerms;
    public Object synsets;
    public Set<Mention> appositions = null;
    public Set<Mention> predicateNominatives = null;
    public Set<Mention> relativePronouns = null;
    public Set<Mention> listMembers = null;
    public Set<Mention> belongToLists = null;
    public SpeakerInfo speakerInfo;
    private transient String spanString = null;
    private transient String lowercaseNormalizedSpanString = null;
    private static final String[] commonNESuffixes = new String[]{"Corp", "Co", "Inc", "Ltd"};

    public Mention() {
    }

    public Mention(int mentionID, int startIndex, int endIndex, SemanticGraph dependency) {
        this.mentionID = mentionID;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.dependency = dependency;
    }

    public Mention(int mentionID, int startIndex, int endIndex, SemanticGraph dependency, List<CoreLabel> mentionSpan) {
        this.mentionID = mentionID;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.dependency = dependency;
        this.originalSpan = mentionSpan;
    }

    public Mention(int mentionID, int startIndex, int endIndex, SemanticGraph dependency, List<CoreLabel> mentionSpan, Tree mentionTree) {
        this.mentionID = mentionID;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.dependency = dependency;
        this.originalSpan = mentionSpan;
        this.mentionSubTree = mentionTree;
    }

    @Override
    public Class<Mention> getType() {
        return Mention.class;
    }

    public boolean isPronominal() {
        return this.mentionType == Dictionaries.MentionType.PRONOMINAL;
    }

    public String toString() {
        return this.spanToString();
    }

    public String spanToString() {
        if (this.spanString == null) {
            StringBuilder os = new StringBuilder();
            for (int i = 0; i < this.originalSpan.size(); ++i) {
                if (i > 0) {
                    os.append(" ");
                }
                os.append((String)this.originalSpan.get(i).get(CoreAnnotations.TextAnnotation.class));
            }
            this.spanString = os.toString();
        }
        return this.spanString;
    }

    public String lowercaseNormalizedSpanString() {
        if (this.lowercaseNormalizedSpanString == null) {
            this.lowercaseNormalizedSpanString = this.spanString.toLowerCase();
        }
        return this.lowercaseNormalizedSpanString;
    }

    public List<CoreLabel> nerTokens() {
        CoreLabel next;
        CoreLabel prev;
        int start;
        if (this.nerString == null || "O".equals(this.nerString)) {
            return null;
        }
        int end = this.headIndex - this.startIndex + 1;
        for (start = this.headIndex - this.startIndex; start > 0 && this.nerString.equals((prev = this.originalSpan.get(start - 1)).ner()); --start) {
        }
        while (end < this.originalSpan.size() && this.nerString.equals((next = this.originalSpan.get(end)).ner())) {
            ++end;
        }
        return this.originalSpan.subList(start, end);
    }

    public String nerName() {
        List<CoreLabel> t = this.nerTokens();
        return t != null ? StringUtils.joinWords(t, " ") : null;
    }

    public void process(Dictionaries dict, Semantics semantics, MentionExtractor mentionExtractor) throws Exception {
        this.setHeadString();
        this.setType(dict);
        this.setNERString();
        List<String> mStr = this.getMentionString();
        this.setNumber(dict);
        this.setGender(dict, this.getGender(dict, mStr));
        this.setAnimacy(dict);
        this.setPerson(dict);
        this.setDiscourse();
        this.headIndexedWord = this.dependency.getNodeByIndexSafe(this.headWord.index());
        if (semantics != null) {
            this.setSemantics(dict, semantics, mentionExtractor);
        }
    }

    public void process(Dictionaries dict, Semantics semantics, MentionExtractor mentionExtractor, LogisticClassifier<String, String> singletonPredictor) throws Exception {
        this.process(dict, semantics, mentionExtractor);
        if (singletonPredictor != null) {
            this.setSingleton(singletonPredictor, dict);
        }
    }

    private void setSingleton(LogisticClassifier<String, String> predictor, Dictionaries dict) {
        double coreference_score = predictor.probabilityOf(new BasicDatum<String, String>(this.getSingletonFeatures(dict), "1"));
        if (coreference_score < 0.2) {
            this.isSingleton = true;
        }
    }

    protected ArrayList<String> getSingletonFeatures(Dictionaries dict) {
        ArrayList<String> features = new ArrayList<String>();
        features.add(this.mentionType.toString());
        features.add(this.nerString);
        features.add(this.animacy.toString());
        int personNum = 3;
        if (this.person.equals((Object)Dictionaries.Person.I) || this.person.equals((Object)Dictionaries.Person.WE)) {
            personNum = 1;
        }
        if (this.person.equals((Object)Dictionaries.Person.YOU)) {
            personNum = 2;
        }
        if (this.person.equals((Object)Dictionaries.Person.UNKNOWN)) {
            personNum = 0;
        }
        features.add(String.valueOf(personNum));
        features.add(this.number.toString());
        features.add(this.getPosition());
        features.add(this.getRelation());
        features.add(this.getQuantification(dict));
        features.add(String.valueOf(this.getModifiers(dict)));
        features.add(String.valueOf(this.getNegation(dict)));
        features.add(String.valueOf(this.getModal(dict)));
        features.add(String.valueOf(this.getReportEmbedding(dict)));
        features.add(String.valueOf(this.getCoordination()));
        return features;
    }

    private List<String> getMentionString() {
        ArrayList<String> mStr = new ArrayList<String>();
        for (CoreLabel l : this.originalSpan) {
            mStr.add(((String)l.get(CoreAnnotations.TextAnnotation.class)).toLowerCase());
            if (l != this.headWord) continue;
            break;
        }
        return mStr;
    }

    private Dictionaries.Gender getGender(Dictionaries dict, List<String> mStr) {
        int len = mStr.size();
        char firstLetter = ((String)this.headWord.get(CoreAnnotations.TextAnnotation.class)).charAt(0);
        if (len > 1 && Character.isUpperCase(firstLetter) && this.nerString.startsWith("PER")) {
            int firstNameIdx = len - 2;
            String secondToLast = mStr.get(firstNameIdx);
            if (firstNameIdx > 1 && (secondToLast.length() == 1 || secondToLast.length() == 2 && secondToLast.endsWith("."))) {
                --firstNameIdx;
            }
            for (int i = 0; i <= firstNameIdx; ++i) {
                if (!dict.genderNumber.containsKey(mStr.subList(i, len))) continue;
                return dict.genderNumber.get(mStr.subList(i, len));
            }
            ArrayList<String> convertedStr = new ArrayList<String>(2);
            convertedStr.add(mStr.get(firstNameIdx));
            convertedStr.add("!");
            if (dict.genderNumber.containsKey(convertedStr)) {
                return dict.genderNumber.get(convertedStr);
            }
            if (dict.genderNumber.containsKey(mStr.subList(firstNameIdx, firstNameIdx + 1))) {
                return dict.genderNumber.get(mStr.subList(firstNameIdx, firstNameIdx + 1));
            }
        }
        if (mStr.size() > 0 && dict.genderNumber.containsKey(mStr.subList(len - 1, len))) {
            return dict.genderNumber.get(mStr.subList(len - 1, len));
        }
        return null;
    }

    private void setDiscourse() {
        this.utter = (Integer)this.headWord.get(CoreAnnotations.UtteranceAnnotation.class);
        Pair<IndexedWord, String> verbDependency = Mention.findDependentVerb(this);
        String dep = verbDependency.second();
        this.dependingVerb = verbDependency.first();
        this.isSubject = false;
        this.isDirectObject = false;
        this.isIndirectObject = false;
        this.isPrepositionObject = false;
        if (dep == null) {
            return;
        }
        if (dep.equals("nsubj") || dep.equals("csubj")) {
            this.isSubject = true;
        } else if (dep.equals("dobj")) {
            this.isDirectObject = true;
        } else if (dep.equals("iobj")) {
            this.isIndirectObject = true;
        } else if (!(!dep.startsWith("nmod") || dep.equals("nmod:npmod") || dep.equals("nmod:tmod") || dep.equals("nmod:poss") || dep.equals("nmod:agent"))) {
            this.isPrepositionObject = true;
        }
    }

    private void setPerson(Dictionaries dict) {
        String spanToString;
        if (!this.isPronominal()) {
            this.person = Dictionaries.Person.UNKNOWN;
        }
        this.person = dict.firstPersonPronouns.contains(spanToString = this.spanToString().toLowerCase()) ? (this.number == Dictionaries.Number.SINGULAR ? Dictionaries.Person.I : (this.number == Dictionaries.Number.PLURAL ? Dictionaries.Person.WE : Dictionaries.Person.UNKNOWN)) : (dict.secondPersonPronouns.contains(spanToString) ? Dictionaries.Person.YOU : (dict.thirdPersonPronouns.contains(spanToString) ? (this.gender == Dictionaries.Gender.MALE && this.number == Dictionaries.Number.SINGULAR ? Dictionaries.Person.HE : (this.gender == Dictionaries.Gender.FEMALE && this.number == Dictionaries.Number.SINGULAR ? Dictionaries.Person.SHE : ((this.gender == Dictionaries.Gender.NEUTRAL || this.animacy == Dictionaries.Animacy.INANIMATE) && this.number == Dictionaries.Number.SINGULAR ? Dictionaries.Person.IT : (this.number == Dictionaries.Number.PLURAL ? Dictionaries.Person.THEY : Dictionaries.Person.UNKNOWN)))) : Dictionaries.Person.UNKNOWN));
    }

    private void setSemantics(Dictionaries dict, Semantics semantics, MentionExtractor mentionExtractor) throws Exception {
        this.preprocessedTerms = this.preprocessSearchTerm();
        if (dict.statesAbbreviation.containsKey(this.spanToString())) {
            this.preprocessedTerms = new ArrayList<String>();
            this.preprocessedTerms.add(dict.statesAbbreviation.get(this.spanToString()));
        }
        Method meth = semantics.wordnet.getClass().getDeclaredMethod("findSynset", List.class);
        this.synsets = meth.invoke(semantics.wordnet, this.preprocessedTerms);
        if (this.isPronominal()) {
            return;
        }
    }

    public boolean isListMemberOf(Mention m) {
        if (this.equals(m)) {
            return false;
        }
        if (m.mentionType == Dictionaries.MentionType.LIST && this.mentionType == Dictionaries.MentionType.LIST) {
            return false;
        }
        if (m.mentionType == Dictionaries.MentionType.LIST) {
            return this.includedIn(m);
        }
        return false;
    }

    public void addListMember(Mention m) {
        if (this.listMembers == null) {
            this.listMembers = Generics.newHashSet();
        }
        this.listMembers.add(m);
    }

    public void addBelongsToList(Mention m) {
        if (this.belongToLists == null) {
            this.belongToLists = Generics.newHashSet();
        }
        this.belongToLists.add(m);
    }

    public boolean isMemberOfSameList(Mention m) {
        Set<Mention> l1 = this.belongToLists;
        Set<Mention> l2 = m.belongToLists;
        return l1 != null && l2 != null && CollectionUtils.containsAny(l1, l2);
    }

    private boolean isListLike() {
        String ner;
        int commas = 0;
        String mentionSpanString = this.spanToString();
        String subTreeSpanString = StringUtils.joinWords(this.mentionSubTree.yieldWords(), " ");
        if (subTreeSpanString.equals(mentionSpanString)) {
            List<Tree> children = this.mentionSubTree.getChildrenAsList();
            for (Tree tree : children) {
                String label = tree.value();
                ner = null;
                if (tree.isLeaf()) {
                    ner = ((CoreLabel)((Tree)tree.getLeaves().get(0)).label()).ner();
                }
                if ("CC".equals(label)) {
                    if (ner != null && !"O".equals(ner)) continue;
                    return true;
                }
                if (!label.equals(",") || ner != null && !"O".equals(ner)) continue;
                ++commas;
            }
        }
        if (commas <= 2) {
            boolean first = true;
            for (CoreLabel coreLabel : this.originalSpan) {
                String tag = coreLabel.tag();
                ner = coreLabel.ner();
                String w = coreLabel.word();
                if (tag.equals("TO") || tag.equals("IN") || tag.startsWith("VB")) {
                    return false;
                }
                if (!first && (w.equalsIgnoreCase("and") || w.equalsIgnoreCase("or")) && (ner == null || "O".equals(ner))) {
                    return true;
                }
                first = false;
            }
        }
        return commas > 2;
    }

    private void setType(Dictionaries dict) {
        if (this.isListLike()) {
            this.mentionType = Dictionaries.MentionType.LIST;
            SieveCoreferenceSystem.logger.finer("IS LIST: " + this);
        } else if (this.headWord.containsKey(CoreAnnotations.EntityTypeAnnotation.class)) {
            this.mentionType = ((String)this.headWord.get(CoreAnnotations.EntityTypeAnnotation.class)).equals("PRO") ? Dictionaries.MentionType.PRONOMINAL : (((String)this.headWord.get(CoreAnnotations.EntityTypeAnnotation.class)).equals("NAM") ? Dictionaries.MentionType.PROPER : Dictionaries.MentionType.NOMINAL);
        } else if (!this.headWord.containsKey(CoreAnnotations.NamedEntityTagAnnotation.class)) {
            this.mentionType = Dictionaries.MentionType.NOMINAL;
            SieveCoreferenceSystem.logger.finest("no NamedEntityTagAnnotation: " + this.headWord);
        } else {
            this.mentionType = ((String)this.headWord.get(CoreAnnotations.PartOfSpeechAnnotation.class)).startsWith("PRP") || this.originalSpan.size() == 1 && ((String)this.headWord.get(CoreAnnotations.NamedEntityTagAnnotation.class)).equals("O") && (dict.allPronouns.contains(this.headString) || dict.relativePronouns.contains(this.headString)) ? Dictionaries.MentionType.PRONOMINAL : (!((String)this.headWord.get(CoreAnnotations.NamedEntityTagAnnotation.class)).equals("O") || ((String)this.headWord.get(CoreAnnotations.PartOfSpeechAnnotation.class)).startsWith("NNP") ? Dictionaries.MentionType.PROPER : Dictionaries.MentionType.NOMINAL);
        }
    }

    private void setGender(Dictionaries dict, Dictionaries.Gender genderNumberResult) {
        this.gender = Dictionaries.Gender.UNKNOWN;
        if (genderNumberResult != null && this.number != Dictionaries.Number.PLURAL) {
            this.gender = genderNumberResult;
            SieveCoreferenceSystem.logger.finer("[Gender number count] New gender assigned:\t" + (Object)((Object)this.gender) + ":\t" + this.headString + "\tspan:" + this.spanToString());
        }
        if (this.mentionType == Dictionaries.MentionType.PRONOMINAL) {
            if (dict.malePronouns.contains(this.headString)) {
                this.gender = Dictionaries.Gender.MALE;
            } else if (dict.femalePronouns.contains(this.headString)) {
                this.gender = Dictionaries.Gender.FEMALE;
            }
        } else if (this.gender == Dictionaries.Gender.UNKNOWN) {
            if ("PERSON".equals(this.nerString) || "PER".equals(this.nerString)) {
                List<CoreLabel> nerToks = this.nerTokens();
                for (CoreLabel t : nerToks) {
                    String name = t.word().toLowerCase();
                    if (dict.maleWords.contains(name)) {
                        this.gender = Dictionaries.Gender.MALE;
                        SieveCoreferenceSystem.logger.finer("[Bergsma List] New gender assigned:\tMale:\t" + name + "\tspan:" + this.spanToString());
                    } else {
                        if (!dict.femaleWords.contains(name)) continue;
                        this.gender = Dictionaries.Gender.FEMALE;
                        SieveCoreferenceSystem.logger.finer("[Bergsma List] New gender assigned:\tFemale:\t" + name + "\tspan:" + this.spanToString());
                    }
                    break;
                }
            } else if (dict.maleWords.contains(this.headString)) {
                this.gender = Dictionaries.Gender.MALE;
                SieveCoreferenceSystem.logger.finer("[Bergsma List] New gender assigned:\tMale:\t" + this.headString + "\tspan:" + this.spanToString());
            } else if (dict.femaleWords.contains(this.headString)) {
                this.gender = Dictionaries.Gender.FEMALE;
                SieveCoreferenceSystem.logger.finer("[Bergsma List] New gender assigned:\tFemale:\t" + this.headString + "\tspan:" + this.spanToString());
            } else if (dict.neutralWords.contains(this.headString)) {
                this.gender = Dictionaries.Gender.NEUTRAL;
                SieveCoreferenceSystem.logger.finer("[Bergsma List] New gender assigned:\tNeutral:\t" + this.headString + "\tspan:" + this.spanToString());
            }
        }
    }

    protected void setNumber(Dictionaries dict) {
        String tag;
        this.number = this.mentionType == Dictionaries.MentionType.PRONOMINAL ? (dict.pluralPronouns.contains(this.headString) ? Dictionaries.Number.PLURAL : (dict.singularPronouns.contains(this.headString) ? Dictionaries.Number.SINGULAR : Dictionaries.Number.UNKNOWN)) : (this.mentionType == Dictionaries.MentionType.LIST ? Dictionaries.Number.PLURAL : (!this.nerString.equals("O") && this.mentionType != Dictionaries.MentionType.NOMINAL ? (!this.nerString.equals("ORGANIZATION") && !this.nerString.startsWith("ORG") ? Dictionaries.Number.SINGULAR : Dictionaries.Number.UNKNOWN) : ((tag = (String)this.headWord.get(CoreAnnotations.PartOfSpeechAnnotation.class)).startsWith("N") && tag.endsWith("S") ? Dictionaries.Number.PLURAL : (tag.startsWith("N") ? Dictionaries.Number.SINGULAR : Dictionaries.Number.UNKNOWN))));
        if (this.mentionType != Dictionaries.MentionType.PRONOMINAL) {
            if (this.number == Dictionaries.Number.UNKNOWN) {
                if (dict.singularWords.contains(this.headString)) {
                    this.number = Dictionaries.Number.SINGULAR;
                    SieveCoreferenceSystem.logger.finest("[Bergsma] Number set to:\tSINGULAR:\t" + this.headString);
                } else if (dict.pluralWords.contains(this.headString)) {
                    this.number = Dictionaries.Number.PLURAL;
                    SieveCoreferenceSystem.logger.finest("[Bergsma] Number set to:\tPLURAL:\t" + this.headString);
                }
            }
            String enumerationPattern = "NP < (NP=tmp $.. (/,|CC/ $.. NP))";
            TregexPattern tgrepPattern = TregexPattern.compile("NP < (NP=tmp $.. (/,|CC/ $.. NP))");
            TregexMatcher m = tgrepPattern.matcher(this.mentionSubTree);
            while (m.find()) {
                if (this.mentionSubTree != m.getNode("tmp") || !this.spanToString().toLowerCase().contains(" and ")) continue;
                this.number = Dictionaries.Number.PLURAL;
            }
        }
    }

    private void setAnimacy(Dictionaries dict) {
        this.animacy = this.mentionType == Dictionaries.MentionType.PRONOMINAL ? (dict.animatePronouns.contains(this.headString) ? Dictionaries.Animacy.ANIMATE : (dict.inanimatePronouns.contains(this.headString) ? Dictionaries.Animacy.INANIMATE : Dictionaries.Animacy.UNKNOWN)) : (this.nerString.equals("PERSON") || this.nerString.startsWith("PER") ? Dictionaries.Animacy.ANIMATE : (this.nerString.equals("LOCATION") || this.nerString.startsWith("LOC") ? Dictionaries.Animacy.INANIMATE : (this.nerString.equals("MONEY") ? Dictionaries.Animacy.INANIMATE : (this.nerString.equals("NUMBER") ? Dictionaries.Animacy.INANIMATE : (this.nerString.equals("PERCENT") ? Dictionaries.Animacy.INANIMATE : (this.nerString.equals("DATE") ? Dictionaries.Animacy.INANIMATE : (this.nerString.equals("TIME") ? Dictionaries.Animacy.INANIMATE : (this.nerString.equals("MISC") ? Dictionaries.Animacy.UNKNOWN : (this.nerString.startsWith("VEH") ? Dictionaries.Animacy.UNKNOWN : (this.nerString.startsWith("FAC") ? Dictionaries.Animacy.INANIMATE : (this.nerString.startsWith("GPE") ? Dictionaries.Animacy.INANIMATE : (this.nerString.startsWith("WEA") ? Dictionaries.Animacy.INANIMATE : (this.nerString.startsWith("ORG") ? Dictionaries.Animacy.INANIMATE : Dictionaries.Animacy.UNKNOWN)))))))))))));
        if (this.mentionType != Dictionaries.MentionType.PRONOMINAL && this.animacy == Dictionaries.Animacy.UNKNOWN) {
            if (dict.animateWords.contains(this.headString)) {
                this.animacy = Dictionaries.Animacy.ANIMATE;
                SieveCoreferenceSystem.logger.finest("Assigned Dekang Lin animacy:\tANIMATE:\t" + this.headString);
            } else if (dict.inanimateWords.contains(this.headString)) {
                this.animacy = Dictionaries.Animacy.INANIMATE;
                SieveCoreferenceSystem.logger.finest("Assigned Dekang Lin animacy:\tINANIMATE:\t" + this.headString);
            }
        }
    }

    private static boolean knownSuffix(String s) {
        if (s.endsWith(".")) {
            s = s.substring(0, s.length() - 1);
        }
        for (String suff : commonNESuffixes) {
            if (!suff.equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    private void setHeadString() {
        this.headString = ((String)this.headWord.get(CoreAnnotations.TextAnnotation.class)).toLowerCase();
        String ner = (String)this.headWord.get(CoreAnnotations.NamedEntityTagAnnotation.class);
        if (ner != null && !ner.equals("O")) {
            int start;
            if (this.originalSpan.size() > 0 && start >= this.originalSpan.size()) {
                throw new RuntimeException("Invalid start index " + start + "=" + this.headIndex + "-" + this.startIndex + ": originalSpan=[" + StringUtils.joinWords(this.originalSpan, " ") + "], head=" + this.headWord);
            }
            for (start = this.headIndex - this.startIndex; start >= 0; --start) {
                String head;
                String string = head = this.originalSpan.size() > 0 ? ((String)this.originalSpan.get(start).get(CoreAnnotations.TextAnnotation.class)).toLowerCase() : "";
                if (Mention.knownSuffix(head)) {
                    continue;
                }
                this.headString = head;
                this.headWord = this.originalSpan.get(start);
                this.headIndex = this.startIndex + start;
                break;
            }
        }
    }

    private void setNERString() {
        this.nerString = this.headWord.containsKey(CoreAnnotations.EntityTypeAnnotation.class) ? (this.headWord.containsKey(CoreAnnotations.NamedEntityTagAnnotation.class) && ((String)this.headWord.get(CoreAnnotations.EntityTypeAnnotation.class)).equals("NAM") ? (String)this.headWord.get(CoreAnnotations.NamedEntityTagAnnotation.class) : "O") : (this.headWord.containsKey(CoreAnnotations.NamedEntityTagAnnotation.class) ? (String)this.headWord.get(CoreAnnotations.NamedEntityTagAnnotation.class) : "O");
    }

    public boolean sameSentence(Mention m) {
        return m.sentenceWords == this.sentenceWords;
    }

    private static boolean included(CoreLabel small, List<CoreLabel> big) {
        if (small.tag().equals("NNP")) {
            for (CoreLabel w : big) {
                if (!small.word().equals(w.word()) && (small.word().length() <= 2 || !w.word().startsWith(small.word()))) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean headsAgree(Mention m) {
        if (!this.nerString.equals("O") && !m.nerString.equals("O") && this.nerString.equals(m.nerString) && (Mention.included(this.headWord, m.originalSpan) || Mention.included(m.headWord, this.originalSpan))) {
            return true;
        }
        return this.headString.equals(m.headString);
    }

    public boolean numbersAgree(Mention m) {
        return this.numbersAgree(m, false);
    }

    private boolean numbersAgree(Mention m, boolean strict) {
        if (strict) {
            return this.number == m.number;
        }
        return this.number == Dictionaries.Number.UNKNOWN || m.number == Dictionaries.Number.UNKNOWN || this.number == m.number;
    }

    public boolean gendersAgree(Mention m) {
        return this.gendersAgree(m, false);
    }

    public boolean gendersAgree(Mention m, boolean strict) {
        if (strict) {
            return this.gender == m.gender;
        }
        return this.gender == Dictionaries.Gender.UNKNOWN || m.gender == Dictionaries.Gender.UNKNOWN || this.gender == m.gender;
    }

    public boolean animaciesAgree(Mention m) {
        return this.animaciesAgree(m, false);
    }

    public boolean animaciesAgree(Mention m, boolean strict) {
        if (strict) {
            return this.animacy == m.animacy;
        }
        return this.animacy == Dictionaries.Animacy.UNKNOWN || m.animacy == Dictionaries.Animacy.UNKNOWN || this.animacy == m.animacy;
    }

    public boolean entityTypesAgree(Mention m, Dictionaries dict) {
        return this.entityTypesAgree(m, dict, false);
    }

    public boolean entityTypesAgree(Mention m, Dictionaries dict, boolean strict) {
        if (strict) {
            return this.nerString.equals(m.nerString);
        }
        if (this.isPronominal()) {
            if (this.nerString.contains("-") || m.nerString.contains("-")) {
                if (m.nerString.equals("O")) {
                    return true;
                }
                if (m.nerString.startsWith("ORG")) {
                    return dict.organizationPronouns.contains(this.headString);
                }
                if (m.nerString.startsWith("PER")) {
                    return dict.personPronouns.contains(this.headString);
                }
                if (m.nerString.startsWith("LOC")) {
                    return dict.locationPronouns.contains(this.headString);
                }
                if (m.nerString.startsWith("GPE")) {
                    return dict.GPEPronouns.contains(this.headString);
                }
                if (m.nerString.startsWith("VEH") || m.nerString.startsWith("FAC") || m.nerString.startsWith("WEA")) {
                    return dict.facilityVehicleWeaponPronouns.contains(this.headString);
                }
                return false;
            }
            switch (m.nerString) {
                case "O": {
                    return true;
                }
                case "MISC": {
                    return true;
                }
                case "ORGANIZATION": {
                    return dict.organizationPronouns.contains(this.headString);
                }
                case "PERSON": {
                    return dict.personPronouns.contains(this.headString);
                }
                case "LOCATION": {
                    return dict.locationPronouns.contains(this.headString);
                }
                case "DATE": 
                case "TIME": {
                    return dict.dateTimePronouns.contains(this.headString);
                }
                case "MONEY": 
                case "PERCENT": 
                case "NUMBER": {
                    return dict.moneyPercentNumberPronouns.contains(this.headString);
                }
            }
            return false;
        }
        return this.nerString.equals("O") || m.nerString.equals("O") || this.nerString.equals(m.nerString);
    }

    public boolean includedIn(Mention m) {
        if (!m.sameSentence(this)) {
            return false;
        }
        if (this.startIndex < m.startIndex || this.endIndex > m.endIndex) {
            return false;
        }
        for (Tree t : m.mentionSubTree.subTrees()) {
            if (t != this.mentionSubTree) continue;
            return true;
        }
        return false;
    }

    public boolean attributesAgree(Mention potentialAntecedent, Dictionaries dict) {
        return this.animaciesAgree(potentialAntecedent) && this.entityTypesAgree(potentialAntecedent, dict) && this.gendersAgree(potentialAntecedent) && this.numbersAgree(potentialAntecedent);
    }

    public void addApposition(Mention m) {
        if (this.appositions == null) {
            this.appositions = Generics.newHashSet();
        }
        this.appositions.add(m);
    }

    public boolean isApposition(Mention m) {
        return this.appositions != null && this.appositions.contains(m);
    }

    public void addPredicateNominatives(Mention m) {
        if (this.predicateNominatives == null) {
            this.predicateNominatives = Generics.newHashSet();
        }
        this.predicateNominatives.add(m);
    }

    public boolean isPredicateNominatives(Mention m) {
        return this.predicateNominatives != null && this.predicateNominatives.contains(m);
    }

    public void addRelativePronoun(Mention m) {
        if (this.relativePronouns == null) {
            this.relativePronouns = Generics.newHashSet();
        }
        this.relativePronouns.add(m);
    }

    public boolean appearEarlierThan(Mention m) {
        if (this.sentNum < m.sentNum) {
            return true;
        }
        if (this.sentNum > m.sentNum) {
            return false;
        }
        if (this.startIndex < m.startIndex) {
            return true;
        }
        if (this.startIndex > m.startIndex) {
            return false;
        }
        if (this.endIndex > m.endIndex) {
            return true;
        }
        if (this.endIndex < m.endIndex) {
            return false;
        }
        if (this.headIndex != m.headIndex) {
            return this.headIndex < m.headIndex;
        }
        if (this.mentionType != m.mentionType) {
            return this.mentionType.representativeness > m.mentionType.representativeness;
        }
        return this.hashCode() < m.hashCode();
    }

    public String longestNNPEndsWithHead() {
        String pos;
        String ret = "";
        for (int i = this.headIndex; i >= this.startIndex && (pos = (String)this.sentenceWords.get(i).get(CoreAnnotations.PartOfSpeechAnnotation.class)).startsWith("NNP"); --i) {
            if (!ret.equals("")) {
                ret = " " + ret;
            }
            ret = (String)this.sentenceWords.get(i).get(CoreAnnotations.TextAnnotation.class) + ret;
        }
        return ret;
    }

    public String lowestNPIncludesHead() {
        String s;
        Tree head;
        String ret = "";
        Tree lowestNP = head = (Tree)this.contextParseTree.getLeaves().get(this.headIndex);
        while (true) {
            if (lowestNP == null) {
                return ret;
            }
            s = (String)((CoreLabel)lowestNP.label()).get(CoreAnnotations.ValueAnnotation.class);
            if (s.equals("NP") || s.equals("ROOT")) break;
            lowestNP = lowestNP.ancestor(1, this.contextParseTree);
        }
        if (s.equals("ROOT")) {
            lowestNP = head;
        }
        for (Tree t : lowestNP.getLeaves()) {
            if (!ret.equals("")) {
                ret = ret + " ";
            }
            ret = ret + (String)((CoreLabel)t.label()).get(CoreAnnotations.TextAnnotation.class);
        }
        if (!this.spanToString().contains(ret)) {
            return (String)this.sentenceWords.get(this.headIndex).get(CoreAnnotations.TextAnnotation.class);
        }
        return ret;
    }

    public String stringWithoutArticle(String str) {
        String ret;
        String string = ret = str == null ? this.spanToString() : str;
        if (ret.startsWith("a ") || ret.startsWith("A ")) {
            return ret.substring(2);
        }
        if (ret.startsWith("an ") || ret.startsWith("An ")) {
            return ret.substring(3);
        }
        if (ret.startsWith("the ") || ret.startsWith("The ")) {
            return ret.substring(4);
        }
        return ret;
    }

    public List<String> preprocessSearchTerm() {
        ArrayList<String> searchTerms = new ArrayList<String>();
        String[] terms = new String[]{this.stringWithoutArticle(this.removePhraseAfterHead()), this.stringWithoutArticle(this.lowestNPIncludesHead()), this.stringWithoutArticle(this.longestNNPEndsWithHead()), this.headString};
        for (String term : terms) {
            if (term.contains("\"")) {
                term = term.replace("\"", "\\\"");
            }
            if (term.contains("(")) {
                term = term.replace("(", "\\(");
            }
            if (term.contains(")")) {
                term = term.replace(")", "\\)");
            }
            if (term.contains("!")) {
                term = term.replace("!", "\\!");
            }
            if (term.contains(":")) {
                term = term.replace(":", "\\:");
            }
            if (term.contains("+")) {
                term = term.replace("+", "\\+");
            }
            if (term.contains("-")) {
                term = term.replace("-", "\\-");
            }
            if (term.contains("~")) {
                term = term.replace("~", "\\~");
            }
            if (term.contains("*")) {
                term = term.replace("*", "\\*");
            }
            if (term.contains("[")) {
                term = term.replace("[", "\\[");
            }
            if (term.contains("]")) {
                term = term.replace("]", "\\]");
            }
            if (term.contains("^")) {
                term = term.replace("^", "\\^");
            }
            if (term.equals("") || term.equals("") || searchTerms.contains(term) || term.equals(terms[3]) && !terms[2].equals("")) continue;
            searchTerms.add(term);
        }
        return searchTerms;
    }

    public static String buildQueryText(List<String> terms) {
        String query = "";
        for (String t : terms) {
            query = query + t + " ";
        }
        return query.trim();
    }

    public String removePhraseAfterHead() {
        String removed = "";
        int posComma = -1;
        int posWH = -1;
        for (int i = 0; i < this.originalSpan.size(); ++i) {
            CoreLabel w = this.originalSpan.get(i);
            if (posComma == -1 && ((String)w.get(CoreAnnotations.PartOfSpeechAnnotation.class)).equals(",")) {
                posComma = this.startIndex + i;
            }
            if (posWH != -1 || !((String)w.get(CoreAnnotations.PartOfSpeechAnnotation.class)).startsWith("W")) continue;
            posWH = this.startIndex + i;
        }
        if (posComma != -1 && this.headIndex < posComma) {
            StringBuilder os = new StringBuilder();
            for (int i = 0; i < posComma - this.startIndex; ++i) {
                if (i > 0) {
                    os.append(" ");
                }
                os.append((String)this.originalSpan.get(i).get(CoreAnnotations.TextAnnotation.class));
            }
            removed = os.toString();
        }
        if (posComma == -1 && posWH != -1 && this.headIndex < posWH) {
            StringBuilder os = new StringBuilder();
            for (int i = 0; i < posWH - this.startIndex; ++i) {
                if (i > 0) {
                    os.append(" ");
                }
                os.append((String)this.originalSpan.get(i).get(CoreAnnotations.TextAnnotation.class));
            }
            removed = os.toString();
        }
        if (posComma == -1 && posWH == -1) {
            removed = this.spanToString();
        }
        return removed;
    }

    public static String removeParenthesis(String text) {
        if (text.split("\\(").length > 0) {
            return text.split("\\(")[0].trim();
        }
        return "";
    }

    protected boolean isTheCommonNoun() {
        return this.mentionType == Dictionaries.MentionType.NOMINAL && this.spanToString().toLowerCase().startsWith("the ") && this.spanToString().split(" ").length == 2;
    }

    private static Pair<IndexedWord, String> findDependentVerb(Mention m) {
        if (m.dependency.getRoots().size() == 0) {
            return new Pair<IndexedWord, String>();
        }
        SemgrexPattern pattern = SemgrexPattern.compile("{idx:" + (m.headIndex + 1) + "} [ <=reln {tag:/^V.*/}=verb | <=reln ({} << {tag:/^V.*/}=verb) ]");
        SemgrexMatcher matcher = pattern.matcher(m.dependency);
        if (matcher.find()) {
            return Pair.makePair(matcher.getNode("verb"), matcher.getRelnString("reln"));
        }
        return new Pair<IndexedWord, String>();
    }

    public boolean insideIn(Mention m) {
        return this.sentNum == m.sentNum && m.startIndex <= this.startIndex && this.endIndex <= m.endIndex;
    }

    public boolean moreRepresentativeThan(Mention m) {
        if (m == null) {
            return true;
        }
        if (this.mentionType.representativeness > m.mentionType.representativeness) {
            return true;
        }
        if (m.mentionType.representativeness > this.mentionType.representativeness) {
            return false;
        }
        if (this.nerString != null && m.nerString == null) {
            return true;
        }
        if (this.nerString == null && m.nerString != null) {
            return false;
        }
        if (this.nerString != null && !this.nerString.equals(m.nerString)) {
            if ("O".equals(m.nerString)) {
                return true;
            }
            if ("O".equals(this.nerString)) {
                return false;
            }
            if ("MISC".equals(m.nerString)) {
                return true;
            }
            if ("MISC".equals(this.nerString)) {
                return false;
            }
        }
        assert (this.nerString == null || this.nerString.equals(m.nerString) || !this.nerString.equals("O") && !this.nerString.equals("MISC") && !m.nerString.equals("O") && !m.nerString.equals("MISC"));
        if (this.headIndex - this.startIndex > m.headIndex - m.startIndex) {
            return true;
        }
        if (this.headIndex - this.startIndex < m.headIndex - m.startIndex) {
            return false;
        }
        if (this.sentNum < m.sentNum) {
            return true;
        }
        if (this.sentNum > m.sentNum) {
            return false;
        }
        if (this.headIndex < m.headIndex) {
            return true;
        }
        if (this.headIndex > m.headIndex) {
            return false;
        }
        if (this.originalSpan.size() <= 5 && this.originalSpan.size() > m.originalSpan.size()) {
            return true;
        }
        if (this.originalSpan.size() <= 5 && this.originalSpan.size() < m.originalSpan.size()) {
            return false;
        }
        if (this.originalSpan.size() < m.originalSpan.size()) {
            return true;
        }
        if (this.originalSpan.size() > m.originalSpan.size()) {
            return false;
        }
        throw new IllegalStateException("Comparing a mention with itself for representativeness");
    }

    public ArrayList<ArrayList<IndexedWord>> getPremodifiers() {
        ArrayList<ArrayList<IndexedWord>> premod = new ArrayList<ArrayList<IndexedWord>>();
        if (this.headIndexedWord == null) {
            return premod;
        }
        for (Pair<GrammaticalRelation, IndexedWord> child : this.dependency.childPairs(this.headIndexedWord)) {
            String function = child.first().getShortName();
            if (child.second().index() >= this.headWord.index() || ((IndexedWord)child.second).tag().equals("DT") || ((IndexedWord)child.second).tag().equals("WRB") || function.endsWith("det") || function.equals("nummod") || function.startsWith("acl") || function.startsWith("advcl") || function.equals("punct")) continue;
            ArrayList<IndexedWord> phrase = new ArrayList<IndexedWord>(this.dependency.descendants(child.second()));
            Collections.sort(phrase);
            premod.add(phrase);
        }
        return premod;
    }

    public ArrayList<ArrayList<IndexedWord>> getPostmodifiers() {
        ArrayList<ArrayList<IndexedWord>> postmod = new ArrayList<ArrayList<IndexedWord>>();
        if (this.headIndexedWord == null) {
            return postmod;
        }
        for (Pair<GrammaticalRelation, IndexedWord> child : this.dependency.childPairs(this.headIndexedWord)) {
            String function = child.first().getShortName();
            if (child.second().index() <= this.headWord.index() || function.endsWith("det") || function.equals("nummod") || function.startsWith("acl") || function.startsWith("advcl") || function.equals("punct") || function.equals("case") && this.dependency.descendants(child.second()).size() == 1 && ((IndexedWord)child.second).tag().equals("POS")) continue;
            ArrayList<IndexedWord> phrase = new ArrayList<IndexedWord>(this.dependency.descendants(child.second()));
            Collections.sort(phrase);
            postmod.add(phrase);
        }
        return postmod;
    }

    public String[] getSplitPattern() {
        ArrayList<ArrayList<IndexedWord>> premodifiers = this.getPremodifiers();
        String[] components = new String[4];
        components[0] = this.headWord.lemma();
        if (premodifiers.size() == 0) {
            components[1] = this.headWord.lemma();
            components[2] = this.headWord.lemma();
        } else if (premodifiers.size() == 1) {
            ArrayList<AbstractCoreLabel> premod = Generics.newArrayList();
            premod.addAll((Collection)premodifiers.get(premodifiers.size() - 1));
            premod.add(this.headWord);
            components[1] = this.getPattern(premod);
            components[2] = this.getPattern(premod);
        } else {
            ArrayList<AbstractCoreLabel> premod1 = Generics.newArrayList();
            premod1.addAll((Collection)premodifiers.get(premodifiers.size() - 1));
            premod1.add(this.headWord);
            components[1] = this.getPattern(premod1);
            ArrayList<AbstractCoreLabel> premod2 = Generics.newArrayList();
            for (ArrayList<IndexedWord> premodifier : premodifiers) {
                premod2.addAll(premodifier);
            }
            premod2.add(this.headWord);
            components[2] = this.getPattern(premod2);
        }
        components[3] = this.getPattern();
        return components;
    }

    public String getPattern() {
        ArrayList<AbstractCoreLabel> pattern = Generics.newArrayList();
        for (ArrayList<IndexedWord> premodifier : this.getPremodifiers()) {
            pattern.addAll(premodifier);
        }
        pattern.add(this.headWord);
        for (ArrayList<IndexedWord> postmodifier : this.getPostmodifiers()) {
            pattern.addAll(postmodifier);
        }
        return this.getPattern(pattern);
    }

    public String getPattern(List<AbstractCoreLabel> pTokens) {
        ArrayList<String> phrase_string = new ArrayList<String>();
        String ne = "";
        for (AbstractCoreLabel token : pTokens) {
            if (token.index() == this.headWord.index()) {
                phrase_string.add(token.lemma());
                ne = "";
                continue;
            }
            if ((token.lemma().equals("and") || StringUtils.isPunct(token.lemma())) && pTokens.size() > pTokens.indexOf(token) + 1 && pTokens.indexOf(token) > 0 && pTokens.get(pTokens.indexOf(token) + 1).ner().equals(pTokens.get(pTokens.indexOf(token) - 1).ner())) continue;
            if (token.index() == this.headWord.index() - 1 && token.ner().equals(this.nerString)) {
                phrase_string.add(token.lemma());
                ne = "";
                continue;
            }
            if (!token.ner().equals("O")) {
                if (token.ner().equals(ne)) continue;
                ne = token.ner();
                phrase_string.add("<" + ne + ">");
                continue;
            }
            phrase_string.add(token.lemma());
            ne = "";
        }
        return StringUtils.join(phrase_string);
    }

    public boolean isCoordinated() {
        if (this.headIndexedWord == null) {
            return false;
        }
        for (Pair<GrammaticalRelation, IndexedWord> child : this.dependency.childPairs(this.headIndexedWord)) {
            if (!child.first().getShortName().equals("cc")) continue;
            return true;
        }
        return false;
    }

    private static List<String> getContextHelper(List<? extends AbstractCoreLabel> words) {
        ArrayList namedEntities = Generics.newArrayList();
        ArrayList<AbstractCoreLabel> ne = Generics.newArrayList();
        String previousNEType = "";
        int previousNEIndex = -1;
        for (int i = 0; i < words.size(); ++i) {
            AbstractCoreLabel word = words.get(i);
            if (word.ner().equals("O")) continue;
            if (!word.ner().equals(previousNEType) || previousNEIndex != i - 1) {
                ne = Generics.newArrayList();
                namedEntities.add(ne);
            }
            ne.add(word);
            previousNEType = word.ner();
            previousNEIndex = i;
        }
        ArrayList<String> neStrings = new ArrayList<String>();
        Set<String> hs = Generics.newHashSet();
        for (List list : namedEntities) {
            String ne_str = StringUtils.joinWords(list, " ");
            hs.add(ne_str);
        }
        neStrings.addAll(hs);
        return neStrings;
    }

    public List<String> getContext() {
        return Mention.getContextHelper(this.sentenceWords);
    }

    public List<String> getPremodifierContext() {
        ArrayList<String> neStrings = new ArrayList<String>();
        for (List list : this.getPremodifiers()) {
            neStrings.addAll(Mention.getContextHelper(list));
        }
        return neStrings;
    }

    public boolean isRelativePronoun(Mention m) {
        return this.relativePronouns != null && this.relativePronouns.contains(m);
    }

    public boolean isRoleAppositive(Mention m, Dictionaries dict) {
        String thisString = this.spanToString();
        String thisStringLower = this.lowercaseNormalizedSpanString();
        if (this.isPronominal() || dict.allPronouns.contains(thisStringLower)) {
            return false;
        }
        if (!m.nerString.startsWith("PER") && !m.nerString.equals("O")) {
            return false;
        }
        if (!this.nerString.startsWith("PER") && !this.nerString.equals("O")) {
            return false;
        }
        if (!this.sameSentence(m) || !m.spanToString().startsWith(thisString)) {
            return false;
        }
        if (m.spanToString().contains("'") || m.spanToString().contains(" and ")) {
            return false;
        }
        if (!this.animaciesAgree(m) || this.animacy == Dictionaries.Animacy.INANIMATE || this.gender == Dictionaries.Gender.NEUTRAL || m.gender == Dictionaries.Gender.NEUTRAL || !this.numbersAgree(m)) {
            return false;
        }
        return !dict.demonymSet.contains(thisStringLower) && !dict.demonymSet.contains(m.lowercaseNormalizedSpanString());
    }

    public boolean isDemonym(Mention m, Dictionaries dict) {
        String thisCasedString = this.spanToString();
        String antCasedString = m.spanToString();
        String thisNormed = dict.lookupCanonicalAmericanStateName(thisCasedString);
        String antNormed = dict.lookupCanonicalAmericanStateName(antCasedString);
        if (thisNormed != null && thisNormed.equals(antNormed)) {
            return true;
        }
        String thisString = thisCasedString.toLowerCase(Locale.ENGLISH);
        String antString = antCasedString.toLowerCase(Locale.ENGLISH);
        if (thisString.startsWith("the ")) {
            thisString = thisString.substring(4);
        }
        if (antString.startsWith("the ")) {
            antString = antString.substring(4);
        }
        Set<String> thisDemonyms = dict.getDemonyms(thisString);
        Set<String> antDemonyms = dict.getDemonyms(antString);
        return thisDemonyms.contains(antString) || antDemonyms.contains(thisString);
    }

    public String getPosition() {
        int size = this.sentenceWords.size();
        if (this.headIndex == 0) {
            return "first";
        }
        if (this.headIndex == size - 1) {
            return "last";
        }
        if (this.headIndex > 0 && this.headIndex < size / 3) {
            return "begin";
        }
        if (this.headIndex >= size / 3 && this.headIndex < 2 * size / 3) {
            return "middle";
        }
        if (this.headIndex >= 2 * size / 3 && this.headIndex < size - 1) {
            return "end";
        }
        return null;
    }

    public String getRelation() {
        if (this.headIndexedWord == null) {
            return null;
        }
        if (this.dependency.getRoots().isEmpty()) {
            return null;
        }
        if (this.dependency.getFirstRoot().equals(this.headIndexedWord)) {
            return "root";
        }
        if (!this.dependency.containsVertex(this.dependency.getParent(this.headIndexedWord))) {
            return null;
        }
        GrammaticalRelation relation = this.dependency.reln(this.dependency.getParent(this.headIndexedWord), this.headIndexedWord);
        if (relation != UniversalEnglishGrammaticalRelations.RELATIVE_CLAUSE_MODIFIER && relation != UniversalEnglishGrammaticalRelations.POSSESSION_MODIFIER && relation != UniversalEnglishGrammaticalRelations.NP_ADVERBIAL_MODIFIER && relation != UniversalEnglishGrammaticalRelations.AGENT && (relation.toString().startsWith("nmod") || relation.toString().startsWith("acl") || relation.toString().startsWith("advcl") || relation == UniversalEnglishGrammaticalRelations.ADVERBIAL_MODIFIER)) {
            return "adjunct";
        }
        if (relation == UniversalEnglishGrammaticalRelations.NOMINAL_SUBJECT || relation == UniversalEnglishGrammaticalRelations.CLAUSAL_SUBJECT) {
            return "subject";
        }
        if (relation == UniversalEnglishGrammaticalRelations.NOMINAL_PASSIVE_SUBJECT || relation == UniversalEnglishGrammaticalRelations.CLAUSAL_PASSIVE_SUBJECT) {
            return "subject";
        }
        if (relation == UniversalEnglishGrammaticalRelations.CLAUSAL_COMPLEMENT || relation == UniversalEnglishGrammaticalRelations.XCLAUSAL_COMPLEMENT || relation == UniversalEnglishGrammaticalRelations.AGENT || relation == UniversalEnglishGrammaticalRelations.DIRECT_OBJECT || relation == UniversalEnglishGrammaticalRelations.INDIRECT_OBJECT) {
            return "verbArg";
        }
        if (relation == UniversalEnglishGrammaticalRelations.RELATIVE_CLAUSE_MODIFIER || relation == UniversalEnglishGrammaticalRelations.COMPOUND_MODIFIER || relation == UniversalEnglishGrammaticalRelations.ADJECTIVAL_MODIFIER || relation == UniversalEnglishGrammaticalRelations.APPOSITIONAL_MODIFIER || relation == UniversalEnglishGrammaticalRelations.POSSESSION_MODIFIER) {
            return "nounArg";
        }
        return null;
    }

    public int getModifiers(Dictionaries dict) {
        if (this.headIndexedWord == null) {
            return 0;
        }
        int count = 0;
        List<Pair<GrammaticalRelation, IndexedWord>> childPairs = this.dependency.childPairs(this.headIndexedWord);
        for (Pair<GrammaticalRelation, IndexedWord> childPair : childPairs) {
            GrammaticalRelation gr = (GrammaticalRelation)childPair.first;
            IndexedWord word = (IndexedWord)childPair.second;
            if ((gr == UniversalEnglishGrammaticalRelations.ADJECTIVAL_MODIFIER || gr == UniversalEnglishGrammaticalRelations.RELATIVE_CLAUSE_MODIFIER || gr.toString().startsWith("nmod") || gr.toString().startsWith("acl") || gr.toString().startsWith("advcl")) && !dict.determiners.contains(word.lemma())) {
                ++count;
            }
            if (!this.nerString.equals("O") || gr != UniversalEnglishGrammaticalRelations.COMPOUND_MODIFIER) continue;
            ++count;
        }
        return count;
    }

    public String getQuantification(Dictionaries dict) {
        if (this.headIndexedWord == null) {
            return null;
        }
        if (!this.nerString.equals("O")) {
            return "definite";
        }
        Set<IndexedWord> quant = this.dependency.getChildrenWithReln(this.headIndexedWord, UniversalEnglishGrammaticalRelations.DETERMINER);
        Set<IndexedWord> poss = this.dependency.getChildrenWithReln(this.headIndexedWord, UniversalEnglishGrammaticalRelations.POSSESSION_MODIFIER);
        if (!quant.isEmpty()) {
            for (IndexedWord word : quant) {
                String det = word.lemma();
                if (dict.determiners.contains(det)) {
                    return "definite";
                }
                if (!dict.quantifiers2.contains(det)) continue;
                return "quantified";
            }
        } else {
            if (!poss.isEmpty()) {
                return "definite";
            }
            quant = this.dependency.getChildrenWithReln(this.headIndexedWord, UniversalEnglishGrammaticalRelations.NUMERIC_MODIFIER);
            if (!quant.isEmpty()) {
                return "quantified";
            }
        }
        return "indefinite";
    }

    public int getNegation(Dictionaries dict) {
        if (this.headIndexedWord == null) {
            return 0;
        }
        Set<IndexedWord> children = this.dependency.getChildren(this.headIndexedWord);
        for (IndexedWord child : children) {
            if (!dict.negations.contains(child.lemma())) continue;
            return 1;
        }
        for (IndexedWord sibling : this.dependency.getSiblings(this.headIndexedWord)) {
            if (!dict.negations.contains(sibling.lemma()) || this.dependency.hasParentWithReln(this.headIndexedWord, UniversalEnglishGrammaticalRelations.NOMINAL_SUBJECT)) continue;
            return 1;
        }
        List<Pair<GrammaticalRelation, IndexedWord>> parentPairs = this.dependency.parentPairs(this.headIndexedWord);
        if (!parentPairs.isEmpty()) {
            Pair<GrammaticalRelation, IndexedWord> parentPair = parentPairs.get(0);
            GrammaticalRelation gr = (GrammaticalRelation)parentPair.first;
            if (dict.neg_relations.contains(gr.toString())) {
                return 1;
            }
        }
        return 0;
    }

    public int getModal(Dictionaries dict) {
        List<IndexedWord> path;
        if (this.headIndexedWord == null) {
            return 0;
        }
        Set<IndexedWord> children = this.dependency.getChildren(this.headIndexedWord);
        for (IndexedWord child : children) {
            if (!dict.modals.contains(child.lemma())) continue;
            return 1;
        }
        IndexedWord parent = this.dependency.getParent(this.headIndexedWord);
        if (parent != null) {
            IndexedWord child;
            if (dict.modals.contains(parent.lemma())) {
                return 1;
            }
            child = this.dependency.getChildWithReln(parent, UniversalEnglishGrammaticalRelations.AUX_MODIFIER);
            if (!this.dependency.hasParentWithReln(this.headIndexedWord, UniversalEnglishGrammaticalRelations.NOMINAL_SUBJECT) && child != null && dict.modals.contains(child.lemma())) {
                return 1;
            }
        }
        if ((path = this.dependency.getPathToRoot(this.headIndexedWord)) == null) {
            return 0;
        }
        for (IndexedWord word : path) {
            if (!dict.modals.contains(word.lemma())) continue;
            return 1;
        }
        return 0;
    }

    public int getReportEmbedding(Dictionaries dict) {
        if (this.headIndexedWord == null) {
            return 0;
        }
        for (IndexedWord sibling : this.dependency.getSiblings(this.headIndexedWord)) {
            IndexedWord marker;
            if (!dict.reportVerb.contains(sibling.lemma()) || !this.dependency.hasParentWithReln(sibling, UniversalEnglishGrammaticalRelations.ADV_CLAUSE_MODIFIER) || (marker = this.dependency.getChildWithReln(sibling, UniversalEnglishGrammaticalRelations.MARKER)) == null || !marker.lemma().equals("as")) continue;
            return 1;
        }
        List<IndexedWord> path = this.dependency.getPathToRoot(this.headIndexedWord);
        if (path == null) {
            return 0;
        }
        boolean isSubject = false;
        if (this.dependency.hasParentWithReln(this.headIndexedWord, UniversalEnglishGrammaticalRelations.NOMINAL_SUBJECT)) {
            isSubject = true;
        }
        for (IndexedWord word : path) {
            if (!isSubject && (dict.reportVerb.contains(word.lemma()) || dict.reportNoun.contains(word.lemma()))) {
                return 1;
            }
            isSubject = this.dependency.hasParentWithReln(word, UniversalEnglishGrammaticalRelations.NOMINAL_SUBJECT);
        }
        return 0;
    }

    public int getCoordination() {
        if (this.headIndexedWord == null) {
            return 0;
        }
        Set<GrammaticalRelation> relations = this.dependency.childRelns(this.headIndexedWord);
        for (GrammaticalRelation rel : relations) {
            if (!rel.toString().startsWith("conj:")) continue;
            return 1;
        }
        Set<GrammaticalRelation> parent_relations = this.dependency.relns(this.headIndexedWord);
        for (GrammaticalRelation rel : parent_relations) {
            if (!rel.toString().startsWith("conj:")) continue;
            return 1;
        }
        return 0;
    }
}

