/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.coref.statistical;

import edu.stanford.nlp.coref.statistical.StatisticalCorefTrainer;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ClustererDataLoader {
    public static List<ClustererDoc> loadDocuments(int maxDocs) throws Exception {
        Map labeledPairs = (Map)IOUtils.readObjectFromFile(StatisticalCorefTrainer.datasetFile);
        Map mentionTypes = (Map)IOUtils.readObjectFromFile(StatisticalCorefTrainer.mentionTypesFile);
        Map goldClusters = (Map)IOUtils.readObjectFromFile(StatisticalCorefTrainer.goldClustersFile);
        Map classificationScores = (Map)IOUtils.readObjectFromFile(StatisticalCorefTrainer.pairwiseModelsPath + "classification" + "/" + StatisticalCorefTrainer.predictionsName + ".ser");
        Map rankingScores = (Map)IOUtils.readObjectFromFile(StatisticalCorefTrainer.pairwiseModelsPath + "ranking" + "/" + StatisticalCorefTrainer.predictionsName + ".ser");
        Map anaphoricityScoresLoaded = (Map)IOUtils.readObjectFromFile(StatisticalCorefTrainer.pairwiseModelsPath + "anaphoricity" + "/" + StatisticalCorefTrainer.predictionsName + ".ser");
        HashMap anaphoricityScores = new HashMap();
        for (Map.Entry e : anaphoricityScoresLoaded.entrySet()) {
            ClassicCounter scores = new ClassicCounter();
            ((Counter)e.getValue()).entrySet().forEach(e2 -> scores.incrementCount(((Pair)e2.getKey()).second, (Double)e2.getValue()));
            anaphoricityScores.put(e.getKey(), scores);
        }
        return labeledPairs.keySet().stream().sorted().limit(maxDocs).map(i -> new ClustererDoc((int)i, (Counter)classificationScores.get(i), (Counter)rankingScores.get(i), (Counter)anaphoricityScores.get(i), (Map)labeledPairs.get(i), (List)goldClusters.get(i), (Map)mentionTypes.get(i))).collect(Collectors.toList());
    }

    public static class ClustererDoc {
        public final int id;
        public final Counter<Pair<Integer, Integer>> classificationScores;
        public final Counter<Pair<Integer, Integer>> rankingScores;
        public final Counter<Integer> anaphoricityScores;
        public final List<List<Integer>> goldClusters;
        public final Map<Integer, List<Integer>> mentionToGold;
        public final List<Integer> mentions;
        public final Map<Integer, String> mentionTypes;
        public final Set<Pair<Integer, Integer>> positivePairs;
        public final Map<Integer, Integer> mentionIndices;

        public ClustererDoc(int id, Counter<Pair<Integer, Integer>> classificationScores, Counter<Pair<Integer, Integer>> rankingScores, Counter<Integer> anaphoricityScores, Map<Pair<Integer, Integer>, Boolean> labeledPairs, List<List<Integer>> goldClusters, Map<Integer, String> mentionTypes) {
            this.id = id;
            this.classificationScores = classificationScores;
            this.rankingScores = rankingScores;
            this.goldClusters = goldClusters;
            this.mentionTypes = mentionTypes;
            this.anaphoricityScores = anaphoricityScores;
            this.positivePairs = labeledPairs.keySet().stream().filter(p -> (Boolean)labeledPairs.get(p)).collect(Collectors.toSet());
            HashSet<Object> mentionsSet = new HashSet<Object>();
            for (Pair<Integer, Integer> pair : labeledPairs.keySet()) {
                mentionsSet.add(pair.first);
                mentionsSet.add(pair.second);
            }
            this.mentions = new ArrayList<Integer>(mentionsSet);
            Collections.sort(this.mentions, (m1, m2) -> {
                Pair<Integer, Integer> p = new Pair<Integer, Integer>((Integer)m1, (Integer)m2);
                return m1 == m2 ? 0 : (classificationScores.containsKey(p) ? -1 : 1);
            });
            this.mentionIndices = new HashMap<Integer, Integer>();
            for (int i = 0; i < this.mentions.size(); ++i) {
                this.mentionIndices.put(this.mentions.get(i), i);
            }
            this.mentionToGold = new HashMap<Integer, List<Integer>>();
            if (goldClusters != null) {
                for (List<Integer> gold : goldClusters) {
                    for (int m : gold) {
                        this.mentionToGold.put(m, gold);
                    }
                }
            }
        }
    }
}

