/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.coref.data;

import edu.stanford.nlp.coref.data.WordLists;
import edu.stanford.nlp.coref.hybrid.HybridCorefProperties;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.neural.VectorMap;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class Dictionaries {
    private static Redwood.RedwoodChannels log = Redwood.channels(Dictionaries.class);
    public Set<String> reportVerb;
    public Set<String> reportNoun;
    public Set<String> nonWords;
    public Set<String> copulas;
    public Set<String> quantifiers;
    public Set<String> parts;
    public Set<String> temporals;
    public Set<String> femalePronouns;
    public Set<String> malePronouns;
    public Set<String> neutralPronouns;
    public Set<String> possessivePronouns;
    public Set<String> otherPronouns;
    public Set<String> thirdPersonPronouns;
    public Set<String> secondPersonPronouns;
    public Set<String> firstPersonPronouns;
    public Set<String> moneyPercentNumberPronouns;
    public Set<String> dateTimePronouns;
    public Set<String> organizationPronouns;
    public Set<String> locationPronouns;
    public Set<String> inanimatePronouns;
    public Set<String> animatePronouns;
    public Set<String> indefinitePronouns;
    public Set<String> relativePronouns;
    public Set<String> interrogativePronouns;
    public Set<String> GPEPronouns;
    public Set<String> pluralPronouns;
    public Set<String> singularPronouns;
    public Set<String> facilityVehicleWeaponPronouns;
    public Set<String> miscPronouns;
    public Set<String> reflexivePronouns;
    public Set<String> transparentNouns;
    public Set<String> stopWords;
    public Set<String> notOrganizationPRP;
    public Set<String> quantifiers2;
    public Set<String> determiners;
    public Set<String> negations;
    public Set<String> neg_relations;
    public Set<String> modals;
    public Set<String> titleWords;
    public Set<String> removeWords;
    public Set<String> removeChars;
    public final Set<String> personPronouns = Generics.newHashSet();
    public final Set<String> allPronouns = Generics.newHashSet();
    public final Map<String, String> statesAbbreviation = Generics.newHashMap();
    private final Map<String, Set<String>> demonyms = Generics.newHashMap();
    public final Set<String> demonymSet = Generics.newHashSet();
    private final Set<String> adjectiveNation = Generics.newHashSet();
    public final Set<String> countries = Generics.newHashSet();
    public final Set<String> statesAndProvinces = Generics.newHashSet();
    public final Set<String> neutralWords = Generics.newHashSet();
    public final Set<String> femaleWords = Generics.newHashSet();
    public final Set<String> maleWords = Generics.newHashSet();
    public final Set<String> pluralWords = Generics.newHashSet();
    public final Set<String> singularWords = Generics.newHashSet();
    public final Set<String> inanimateWords = Generics.newHashSet();
    public final Set<String> animateWords = Generics.newHashSet();
    public final Map<List<String>, Gender> genderNumber = Generics.newHashMap();
    public final ArrayList<Counter<Pair<String, String>>> corefDict = new ArrayList(4);
    public final Counter<Pair<String, String>> corefDictPMI = new ClassicCounter<Pair<String, String>>();
    public final Map<String, Counter<String>> NE_signatures = Generics.newHashMap();
    public int dimVector;
    public VectorMap vectors = new VectorMap();
    public Map<String, String> strToEntity = Generics.newHashMap();
    public Counter<String> dictScore = new ClassicCounter<String>();

    private void readWordLists(Locale lang) {
        switch (lang.getLanguage()) {
            default: {
                this.reportVerb = WordLists.reportVerbEn;
                this.reportNoun = WordLists.reportNounEn;
                this.nonWords = WordLists.nonWordsEn;
                this.copulas = WordLists.copulasEn;
                this.quantifiers = WordLists.quantifiersEn;
                this.parts = WordLists.partsEn;
                this.temporals = WordLists.temporalsEn;
                this.femalePronouns = WordLists.femalePronounsEn;
                this.malePronouns = WordLists.malePronounsEn;
                this.neutralPronouns = WordLists.neutralPronounsEn;
                this.possessivePronouns = WordLists.possessivePronounsEn;
                this.otherPronouns = WordLists.otherPronounsEn;
                this.thirdPersonPronouns = WordLists.thirdPersonPronounsEn;
                this.secondPersonPronouns = WordLists.secondPersonPronounsEn;
                this.firstPersonPronouns = WordLists.firstPersonPronounsEn;
                this.moneyPercentNumberPronouns = WordLists.moneyPercentNumberPronounsEn;
                this.dateTimePronouns = WordLists.dateTimePronounsEn;
                this.organizationPronouns = WordLists.organizationPronounsEn;
                this.locationPronouns = WordLists.locationPronounsEn;
                this.inanimatePronouns = WordLists.inanimatePronounsEn;
                this.animatePronouns = WordLists.animatePronounsEn;
                this.indefinitePronouns = WordLists.indefinitePronounsEn;
                this.relativePronouns = WordLists.relativePronounsEn;
                this.GPEPronouns = WordLists.GPEPronounsEn;
                this.pluralPronouns = WordLists.pluralPronounsEn;
                this.singularPronouns = WordLists.singularPronounsEn;
                this.facilityVehicleWeaponPronouns = WordLists.facilityVehicleWeaponPronounsEn;
                this.miscPronouns = WordLists.miscPronounsEn;
                this.reflexivePronouns = WordLists.reflexivePronounsEn;
                this.transparentNouns = WordLists.transparentNounsEn;
                this.stopWords = WordLists.stopWordsEn;
                this.notOrganizationPRP = WordLists.notOrganizationPRPEn;
                this.quantifiers2 = WordLists.quantifiers2En;
                this.determiners = WordLists.determinersEn;
                this.negations = WordLists.negationsEn;
                this.neg_relations = WordLists.neg_relationsEn;
                this.modals = WordLists.modalsEn;
                break;
            }
            case "zh": {
                this.reportVerb = WordLists.reportVerbZh;
                this.reportNoun = WordLists.reportNounZh;
                this.nonWords = WordLists.nonWordsZh;
                this.copulas = WordLists.copulasZh;
                this.quantifiers = WordLists.quantifiersZh;
                this.parts = WordLists.partsZh;
                this.temporals = WordLists.temporalsZh;
                this.femalePronouns = WordLists.femalePronounsZh;
                this.malePronouns = WordLists.malePronounsZh;
                this.neutralPronouns = WordLists.neutralPronounsZh;
                this.possessivePronouns = WordLists.possessivePronounsZh;
                this.otherPronouns = WordLists.otherPronounsZh;
                this.thirdPersonPronouns = WordLists.thirdPersonPronounsZh;
                this.secondPersonPronouns = WordLists.secondPersonPronounsZh;
                this.firstPersonPronouns = WordLists.firstPersonPronounsZh;
                this.moneyPercentNumberPronouns = WordLists.moneyPercentNumberPronounsZh;
                this.dateTimePronouns = WordLists.dateTimePronounsZh;
                this.organizationPronouns = WordLists.organizationPronounsZh;
                this.locationPronouns = WordLists.locationPronounsZh;
                this.inanimatePronouns = WordLists.inanimatePronounsZh;
                this.animatePronouns = WordLists.animatePronounsZh;
                this.indefinitePronouns = WordLists.indefinitePronounsZh;
                this.relativePronouns = WordLists.relativePronounsZh;
                this.interrogativePronouns = WordLists.interrogativePronounsZh;
                this.GPEPronouns = WordLists.GPEPronounsZh;
                this.pluralPronouns = WordLists.pluralPronounsZh;
                this.singularPronouns = WordLists.singularPronounsZh;
                this.facilityVehicleWeaponPronouns = WordLists.facilityVehicleWeaponPronounsZh;
                this.miscPronouns = WordLists.miscPronounsZh;
                this.reflexivePronouns = WordLists.reflexivePronounsZh;
                this.transparentNouns = WordLists.transparentNounsZh;
                this.stopWords = WordLists.stopWordsZh;
                this.notOrganizationPRP = WordLists.notOrganizationPRPZh;
                this.quantifiers2 = WordLists.quantifiers2Zh;
                this.determiners = WordLists.determinersZh;
                this.negations = WordLists.negationsZh;
                this.neg_relations = WordLists.neg_relationsZh;
                this.modals = WordLists.modalsZh;
                this.titleWords = WordLists.titleWordsZh;
                this.removeWords = WordLists.removeWordsZh;
                this.removeChars = WordLists.removeCharsZh;
            }
        }
    }

    private void setPronouns() {
        for (String s : this.animatePronouns) {
            this.personPronouns.add(s);
        }
        this.allPronouns.addAll(this.firstPersonPronouns);
        this.allPronouns.addAll(this.secondPersonPronouns);
        this.allPronouns.addAll(this.thirdPersonPronouns);
        this.allPronouns.addAll(this.otherPronouns);
        this.stopWords.addAll(this.allPronouns);
    }

    public void loadStateAbbreviation(String statesFile) {
        BufferedReader reader = null;
        try {
            String line;
            reader = IOUtils.readerFromString(statesFile);
            while ((line = reader.readLine()) != null) {
                String[] tokens;
                for (String token : tokens = line.split("\t")) {
                    this.statesAbbreviation.put(token, tokens[0]);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        finally {
            IOUtils.closeIgnoringExceptions(reader);
        }
    }

    public String lookupCanonicalAmericanStateName(String name) {
        return this.statesAbbreviation.get(name);
    }

    private void loadDemonymLists(String demonymFile) {
        BufferedReader reader = null;
        try {
            String line;
            reader = IOUtils.readerFromString(demonymFile);
            while ((line = reader.readLine()) != null) {
                String[] tokens = (line = line.toLowerCase(Locale.ENGLISH)).split("\t");
                if (tokens[0].startsWith("#")) continue;
                Set<String> set = Generics.newHashSet();
                for (String s : tokens) {
                    set.add(s);
                    this.demonymSet.add(s);
                }
                this.demonyms.put(tokens[0], set);
            }
            this.adjectiveNation.addAll(this.demonymSet);
            this.adjectiveNation.removeAll(this.demonyms.keySet());
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        finally {
            IOUtils.closeIgnoringExceptions(reader);
        }
    }

    public Set<String> getDemonyms(String name) {
        Set<String> result = this.demonyms.get(name);
        if (result == null) {
            result = Collections.emptySet();
        }
        return result;
    }

    public boolean isAdjectivalDemonym(String token) {
        return this.adjectiveNation.contains(token.toLowerCase(Locale.ENGLISH));
    }

    private static void getWordsFromFile(String filename, Set<String> resultSet, boolean lowercase) throws IOException {
        if (filename == null) {
            return;
        }
        BufferedReader reader = IOUtils.readerFromString(filename);
        while (reader.ready()) {
            if (lowercase) {
                resultSet.add(reader.readLine().toLowerCase());
                continue;
            }
            resultSet.add(reader.readLine());
        }
        IOUtils.closeIgnoringExceptions(reader);
    }

    private void loadAnimacyLists(String animateWordsFile, String inanimateWordsFile) {
        try {
            Dictionaries.getWordsFromFile(animateWordsFile, this.animateWords, false);
            Dictionaries.getWordsFromFile(inanimateWordsFile, this.inanimateWords, false);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private void loadGenderLists(String maleWordsFile, String neutralWordsFile, String femaleWordsFile) {
        try {
            Dictionaries.getWordsFromFile(maleWordsFile, this.maleWords, false);
            Dictionaries.getWordsFromFile(neutralWordsFile, this.neutralWords, false);
            Dictionaries.getWordsFromFile(femaleWordsFile, this.femaleWords, false);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private void loadNumberLists(String pluralWordsFile, String singularWordsFile) {
        try {
            Dictionaries.getWordsFromFile(pluralWordsFile, this.pluralWords, false);
            Dictionaries.getWordsFromFile(singularWordsFile, this.singularWords, false);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private void loadStatesLists(String file) {
        try {
            Dictionaries.getWordsFromFile(file, this.statesAndProvinces, true);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private void loadCountriesLists(String file) {
        try {
            String line;
            BufferedReader reader = IOUtils.readerFromString(file);
            while ((line = reader.readLine()) != null) {
                this.countries.add(line.split("\t")[1].toLowerCase());
            }
            reader.close();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private void loadGenderNumber(String file, String neutralWordsFile) {
        try {
            String line;
            Dictionaries.getWordsFromFile(neutralWordsFile, this.neutralWords, false);
            BufferedReader reader = IOUtils.readerFromString(file);
            String[] split = new String[2];
            String[] countStr = new String[3];
            while ((line = reader.readLine()) != null) {
                StringUtils.splitOnChar(split, line, '\t');
                StringUtils.splitOnChar(countStr, split[1], ' ');
                int male = Integer.parseInt(countStr[0]);
                int female = Integer.parseInt(countStr[1]);
                int neutral = Integer.parseInt(countStr[2]);
                Gender gender = Gender.UNKNOWN;
                if ((double)male * 0.5 > (double)(female + neutral) && male > 2) {
                    gender = Gender.MALE;
                } else if ((double)female * 0.5 > (double)(male + neutral) && female > 2) {
                    gender = Gender.FEMALE;
                } else if ((double)neutral * 0.5 > (double)(male + female) && neutral > 2) {
                    gender = Gender.NEUTRAL;
                }
                if (gender == Gender.UNKNOWN) continue;
                String[] words = split[0].split(" ");
                List<String> tokens = Arrays.asList(words);
                this.genderNumber.put(tokens, gender);
            }
            reader.close();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public void loadChineseGenderNumberAnimacy(String file) {
        String[] split = new String[8];
        for (String line : IOUtils.readLines(file)) {
            if (line.startsWith("#WORD")) continue;
            StringUtils.splitOnChar(split, line, '\t');
            String word = split[0];
            int animate = Integer.parseInt(split[1]);
            int inanimate = Integer.parseInt(split[2]);
            int male = Integer.parseInt(split[3]);
            int female = Integer.parseInt(split[4]);
            int neutral = Integer.parseInt(split[5]);
            int singular = Integer.parseInt(split[6]);
            int plural = Integer.parseInt(split[7]);
            if ((double)male * 0.5 > (double)(female + neutral) && male > 2) {
                this.maleWords.add(word);
            } else if ((double)female * 0.5 > (double)(male + neutral) && female > 2) {
                this.femaleWords.add(word);
            } else if ((double)neutral * 0.5 > (double)(male + female) && neutral > 2) {
                this.neutralWords.add(word);
            }
            if ((double)animate * 0.5 > (double)inanimate && animate > 2) {
                this.animateWords.add(word);
            } else if ((double)inanimate * 0.5 > (double)animate && inanimate > 2) {
                this.inanimateWords.add(word);
            }
            if ((double)singular * 0.5 > (double)plural && singular > 2) {
                this.singularWords.add(word);
                continue;
            }
            if (!((double)plural * 0.5 > (double)singular) || plural <= 2) continue;
            this.pluralWords.add(word);
        }
    }

    private static void loadCorefDict(String[] file, ArrayList<Counter<Pair<String, String>>> dict) {
        for (int i = 0; i < 4; ++i) {
            dict.add(new ClassicCounter());
            BufferedReader reader = null;
            try {
                reader = IOUtils.readerFromString(file[i]);
                reader.readLine();
                while (reader.ready()) {
                    String[] split = reader.readLine().split("\t");
                    dict.get(i).setCount(new Pair<String, String>(split[0], split[1]), Double.parseDouble(split[2]));
                }
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeIgnoringExceptions(reader);
                    throw throwable;
                }
            }
            IOUtils.closeIgnoringExceptions(reader);
        }
    }

    private static void loadCorefDictPMI(String file, Counter<Pair<String, String>> dict) {
        BufferedReader reader = null;
        try {
            reader = IOUtils.readerFromString(file);
            reader.readLine();
            while (reader.ready()) {
                String[] split = reader.readLine().split("\t");
                dict.setCount(new Pair<String, String>(split[0], split[1]), Double.parseDouble(split[3]));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeIgnoringExceptions(reader);
        }
    }

    private static void loadSignatures(String file, Map<String, Counter<String>> sigs) {
        BufferedReader reader = null;
        try {
            reader = IOUtils.readerFromString(file);
            while (reader.ready()) {
                String[] split = reader.readLine().split("\t");
                ClassicCounter<String> cntr = new ClassicCounter<String>();
                sigs.put(split[0], cntr);
                for (int i = 1; i < split.length; i += 2) {
                    cntr.setCount(split[i], Double.parseDouble(split[i + 1]));
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeIgnoringExceptions(reader);
        }
    }

    public void loadSemantics(Properties props) throws ClassNotFoundException, IOException {
        log.info("LOADING SEMANTICS");
        if (HybridCorefProperties.loadWordEmbedding(props)) {
            log.info("LOAD: WordVectors");
            String wordvectorFile = HybridCorefProperties.getPathSerializedWordVectors(props);
            String word2vecFile = HybridCorefProperties.getPathWord2Vec(props);
            try {
                this.vectors = VectorMap.deserialize(wordvectorFile);
            }
            catch (IOException e) {
                if (new File(word2vecFile).exists()) {
                    this.vectors = VectorMap.readWord2Vec(word2vecFile);
                    if (wordvectorFile != null && !wordvectorFile.startsWith("edu")) {
                        this.vectors.serialize(wordvectorFile);
                    }
                }
                throw new RuntimeIOException(e);
            }
            this.dimVector = ((float[])this.vectors.entrySet().iterator().next().getValue()).length;
        }
    }

    public Dictionaries(Properties props) throws ClassNotFoundException, IOException {
        this(props.getProperty("coref.language", HybridCorefProperties.LANGUAGE_DEFAULT.toLanguageTag()), props.getProperty("coref.demonym", "edu/stanford/nlp/models/dcoref/demonyms.txt"), props.getProperty("coref.animate", "edu/stanford/nlp/models/dcoref/animate.unigrams.txt"), props.getProperty("coref.inanimate", "edu/stanford/nlp/models/dcoref/inanimate.unigrams.txt"), props.getProperty("coref.male"), props.getProperty("coref.neutral"), props.getProperty("coref.female"), props.getProperty("coref.plural"), props.getProperty("coref.singular"), props.getProperty("coref.states", "edu/stanford/nlp/models/dcoref/state-abbreviations.txt"), props.getProperty("coref.big.gender.number", HybridCorefProperties.getGenderNumber(props)), props.getProperty("coref.countries", "edu/stanford/nlp/models/dcoref/countries"), props.getProperty("coref.states.provinces", "edu/stanford/nlp/models/dcoref/statesandprovinces"), HybridCorefProperties.getSieves(props).contains("CorefDictionaryMatch"), PropertiesUtils.getStringArray(props, "coref.dictlist", new String[]{"edu/stanford/nlp/models/dcoref/coref.dict1.tsv", "edu/stanford/nlp/models/dcoref/coref.dict2.tsv", "edu/stanford/nlp/models/dcoref/coref.dict3.tsv", "edu/stanford/nlp/models/dcoref/coref.dict4.tsv"}), props.getProperty("coref.dictpmi", "edu/stanford/nlp/models/dcoref/coref.dict1.tsv"), props.getProperty("coref.signatures", "edu/stanford/nlp/models/dcoref/ne.signatures.txt"));
        if (props.containsKey("coref.zh.dict")) {
            this.loadChineseGenderNumberAnimacy(props.getProperty("coref.zh.dict"));
        }
    }

    public static String signature(Properties props) {
        StringBuilder os = new StringBuilder();
        os.append("coref.demonym:" + props.getProperty("coref.demonym", "edu/stanford/nlp/models/dcoref/demonyms.txt"));
        os.append("coref.animate:" + props.getProperty("coref.animate", "edu/stanford/nlp/models/dcoref/animate.unigrams.txt"));
        os.append("coref.inanimate:" + props.getProperty("coref.inanimate", "edu/stanford/nlp/models/dcoref/inanimate.unigrams.txt"));
        if (props.containsKey("coref.male")) {
            os.append("coref.male:" + props.getProperty("coref.male"));
        }
        if (props.containsKey("coref.neutral")) {
            os.append("coref.neutral:" + props.getProperty("coref.neutral"));
        }
        if (props.containsKey("coref.female")) {
            os.append("coref.female:" + props.getProperty("coref.female"));
        }
        if (props.containsKey("coref.plural")) {
            os.append("coref.plural:" + props.getProperty("coref.plural"));
        }
        if (props.containsKey("coref.singular")) {
            os.append("coref.singular:" + props.getProperty("coref.singular"));
        }
        os.append("coref.states:" + props.getProperty("coref.states", "edu/stanford/nlp/models/dcoref/state-abbreviations.txt"));
        os.append("coref.big.gender.number:" + props.getProperty("coref.big.gender.number", "edu/stanford/nlp/models/dcoref/gender.map.ser.gz"));
        os.append("coref.countries:" + props.getProperty("coref.countries", "edu/stanford/nlp/models/dcoref/countries"));
        os.append("coref.states.provinces:" + props.getProperty("coref.states.provinces", "edu/stanford/nlp/models/dcoref/statesandprovinces"));
        return os.toString();
    }

    public Dictionaries(String language, String demonymWords, String animateWords, String inanimateWords, String maleWords, String neutralWords, String femaleWords, String pluralWords, String singularWords, String statesWords, String genderNumber, String countries, String states, boolean loadCorefDict, String[] corefDictFiles, String corefDictPMIFile, String signaturesFile) {
        Locale lang = Locale.forLanguageTag(language);
        this.readWordLists(lang);
        this.loadDemonymLists(demonymWords);
        this.loadStateAbbreviation(statesWords);
        this.loadAnimacyLists(animateWords, inanimateWords);
        this.loadGenderLists(maleWords, neutralWords, femaleWords);
        this.loadNumberLists(pluralWords, singularWords);
        this.loadGenderNumber(genderNumber, neutralWords);
        this.loadCountriesLists(countries);
        this.loadStatesLists(states);
        this.setPronouns();
        if (loadCorefDict) {
            Dictionaries.loadCorefDict(corefDictFiles, this.corefDict);
            Dictionaries.loadCorefDictPMI(corefDictPMIFile, this.corefDictPMI);
            Dictionaries.loadSignatures(signaturesFile, this.NE_signatures);
        }
    }

    public Dictionaries() throws ClassNotFoundException, IOException {
        this(new Properties());
    }

    public static enum Person {
        I,
        YOU,
        HE,
        SHE,
        WE,
        THEY,
        IT,
        UNKNOWN;

    }

    public static enum Animacy {
        ANIMATE,
        INANIMATE,
        UNKNOWN;

    }

    public static enum Number {
        SINGULAR,
        PLURAL,
        UNKNOWN;

    }

    public static enum Gender {
        MALE,
        FEMALE,
        NEUTRAL,
        UNKNOWN;

    }

    public static enum MentionType {
        PRONOMINAL(1),
        NOMINAL(3),
        PROPER(4),
        LIST(2);

        public final int representativeness;

        private MentionType(int representativeness) {
            this.representativeness = representativeness;
        }
    }
}

