/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.coref;

import edu.stanford.nlp.coref.data.Dictionaries;
import edu.stanford.nlp.coref.data.Document;
import edu.stanford.nlp.coref.data.DocumentMaker;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.Properties;

public interface CorefDocumentProcessor {
    public void process(int var1, Document var2);

    public void finish() throws Exception;

    default public String getName() {
        return this.getClass().getName();
    }

    default public void run(Properties props, Dictionaries dictionaries) throws Exception {
        this.run(new DocumentMaker(props, dictionaries));
    }

    default public void runFromScratch(Properties props, Dictionaries dictionaries) throws Exception {
        StanfordCoreNLP.clearAnnotatorPool();
        this.run(new DocumentMaker(props, dictionaries));
    }

    default public void run(DocumentMaker docMaker) throws Exception {
        Redwood.hideChannelsEverywhere("debug-mention", "debug-preprocessor", "debug-docreader", "debug-md");
        int docId = 0;
        Document document = docMaker.nextDoc();
        long time = System.currentTimeMillis();
        while (document != null) {
            this.process(docId, document);
            Redwood.log(this.getName(), "Processed document " + docId + " in " + (double)(System.currentTimeMillis() - time) / 1000.0 + "s");
            time = System.currentTimeMillis();
            ++docId;
            document = docMaker.nextDoc();
        }
        this.finish();
    }
}

