/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.classify;

import edu.stanford.nlp.classify.LogPrior;
import edu.stanford.nlp.optimization.AbstractCachingDiffFunction;
import java.util.Arrays;

public class BiasedLogisticObjectiveFunction
extends AbstractCachingDiffFunction {
    private final int numFeatures;
    private final int[][] data;
    private final double[][] dataValues;
    private final int[] labels;
    protected float[] dataweights = null;
    private final LogPrior prior;
    double probCorrect = 0.7;

    @Override
    public int domainDimension() {
        return this.numFeatures;
    }

    @Override
    protected void calculate(double[] x) {
        if (this.dataValues != null) {
            throw new RuntimeException();
        }
        this.value = 0.0;
        Arrays.fill(this.derivative, 0.0);
        for (int d = 0; d < this.data.length; ++d) {
            double derivativeIncrement;
            double g;
            double expSum;
            int[] features = this.data[d];
            double sum = 0.0;
            for (int feature1 : features) {
                sum += x[feature1];
            }
            if (this.dataweights != null) {
                throw new RuntimeException();
            }
            if (this.labels[d] == 1) {
                expSum = Math.exp(-sum);
                g = 1.0 / (1.0 + expSum);
                this.value -= Math.log(g);
                derivativeIncrement = g - 1.0;
            } else {
                expSum = Math.exp(-sum);
                g = 1.0 / (1.0 + expSum);
                double e = (1.0 - this.probCorrect) * g + this.probCorrect * (1.0 - g);
                this.value -= Math.log(e);
                derivativeIncrement = -(g * (1.0 - g) * (1.0 - 2.0 * this.probCorrect)) / e;
            }
            int[] nArray = features;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int feature;
                int n2 = feature = nArray[i];
                this.derivative[n2] = this.derivative[n2] + derivativeIncrement;
            }
        }
        this.value += this.prior.compute(x, this.derivative);
    }

    protected void calculateRVF(double[] x) {
        this.value = 0.0;
        Arrays.fill(this.derivative, 0.0);
        for (int d = 0; d < this.data.length; ++d) {
            double derivativeIncrement;
            double expSum;
            int[] features = this.data[d];
            double[] values = this.dataValues[d];
            double sum = 0.0;
            for (int feature1 : features) {
                sum += x[feature1] * values[feature1];
            }
            if (this.labels[d] == 0) {
                expSum = Math.exp(sum);
                derivativeIncrement = 1.0 / (1.0 + 1.0 / expSum);
            } else {
                expSum = Math.exp(-sum);
                derivativeIncrement = -1.0 / (1.0 + 1.0 / expSum);
            }
            if (this.dataweights == null) {
                this.value += Math.log(1.0 + expSum);
            } else {
                this.value += Math.log(1.0 + expSum) * (double)this.dataweights[d];
                derivativeIncrement *= (double)this.dataweights[d];
            }
            int[] nArray = features;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int feature;
                int n2 = feature = nArray[i];
                this.derivative[n2] = this.derivative[n2] + values[feature] * derivativeIncrement;
            }
        }
        this.value += this.prior.compute(x, this.derivative);
    }

    public BiasedLogisticObjectiveFunction(int numFeatures, int[][] data, int[] labels) {
        this(numFeatures, data, labels, new LogPrior(LogPrior.LogPriorType.QUADRATIC));
    }

    public BiasedLogisticObjectiveFunction(int numFeatures, int[][] data, int[] labels, LogPrior prior) {
        this(numFeatures, data, labels, prior, null);
    }

    public BiasedLogisticObjectiveFunction(int numFeatures, int[][] data, int[] labels, float[] dataweights) {
        this(numFeatures, data, labels, new LogPrior(LogPrior.LogPriorType.QUADRATIC), dataweights);
    }

    public BiasedLogisticObjectiveFunction(int numFeatures, int[][] data, int[] labels, LogPrior prior, float[] dataweights) {
        this(numFeatures, data, null, labels, prior, dataweights);
    }

    public BiasedLogisticObjectiveFunction(int numFeatures, int[][] data, double[][] values, int[] labels) {
        this(numFeatures, data, values, labels, new LogPrior(LogPrior.LogPriorType.QUADRATIC));
    }

    public BiasedLogisticObjectiveFunction(int numFeatures, int[][] data, double[][] values, int[] labels, LogPrior prior) {
        this(numFeatures, data, values, labels, prior, null);
    }

    public BiasedLogisticObjectiveFunction(int numFeatures, int[][] data, double[][] values, int[] labels, LogPrior prior, float[] dataweights) {
        this.numFeatures = numFeatures;
        this.data = data;
        this.labels = labels;
        this.prior = prior;
        this.dataweights = dataweights;
        this.dataValues = values;
    }
}

