"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogQueryWidget = exports.LogQueryVisualizationType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const widget_1 = require("./widget");
/**
 * Types of view.
 *
 * @stability stable
 */
var LogQueryVisualizationType;
(function (LogQueryVisualizationType) {
    LogQueryVisualizationType["TABLE"] = "table";
    LogQueryVisualizationType["LINE"] = "line";
    LogQueryVisualizationType["STACKEDAREA"] = "stackedarea";
    LogQueryVisualizationType["BAR"] = "bar";
    LogQueryVisualizationType["PIE"] = "pie";
})(LogQueryVisualizationType = exports.LogQueryVisualizationType || (exports.LogQueryVisualizationType = {}));
/**
 * Display query results from Logs Insights.
 *
 * @stability stable
 */
class LogQueryWidget extends widget_1.ConcreteWidget {
    /**
     * @stability stable
     */
    constructor(props) {
        super(props.width || 6, props.height || 6);
        this.props = props;
        if (props.logGroupNames.length === 0) {
            throw new Error('Specify at least one log group name.');
        }
        if (!!props.queryString === !!props.queryLines) {
            throw new Error('Specify exactly one of \'queryString\' and \'queryLines\'');
        }
    }
    /**
     * Return the widget JSON for use in the dashboard.
     *
     * @stability stable
     */
    toJson() {
        const sources = this.props.logGroupNames.map(l => `SOURCE '${l}'`).join(' | ');
        const query = this.props.queryLines
            ? this.props.queryLines.join('\n| ')
            : this.props.queryString;
        const properties = {
            view: this.props.view ? this.props.view : LogQueryVisualizationType.TABLE,
            title: this.props.title,
            region: this.props.region || cdk.Aws.REGION,
            query: `${sources} | ${query}`,
        };
        // adding stacked property in case of LINE or STACKEDAREA
        if (this.props.view === LogQueryVisualizationType.LINE || this.props.view === LogQueryVisualizationType.STACKEDAREA) {
            // assign the right native view value. both types share the same value
            properties.view = 'timeSeries',
                properties.stacked = this.props.view === LogQueryVisualizationType.STACKEDAREA ? true : false;
        }
        return [{
                type: 'log',
                width: this.width,
                height: this.height,
                x: this.x,
                y: this.y,
                properties: properties,
            }];
    }
}
exports.LogQueryWidget = LogQueryWidget;
_a = JSII_RTTI_SYMBOL_1;
LogQueryWidget[_a] = { fqn: "@aws-cdk/aws-cloudwatch.LogQueryWidget", version: "1.130.0" };
//# sourceMappingURL=data:application/json;base64,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