# Copyright (c) 2024, qBraid Development Team
# All rights reserved.

"""
Module serving qBraid system information.

.. currentmodule:: qbraid_core.system

Classes
--------

.. autosummary::
   :toctree: ../stubs/

   FileManager

Functions
----------

.. autosummary::
   :toctree: ../stubs/

   echo_log
   extract_version
   is_exe
   is_valid_python
   is_valid_semantic_version
   get_python_version_from_cfg
   get_python_version_from_exe
   get_venv_site_packages_path
   get_active_site_packages_path
   get_active_python_path
   get_local_package_path
   get_local_package_version
   get_latest_package_version
   python_paths_equivalent
   replace_str


Exceptions
------------

.. autosummary::
   :toctree: ../stubs/

   InvalidVersionError
   QbraidSystemError
   UnknownFileSystemObjectError
   VersionNotFoundError

"""
from .exceptions import (
    InvalidVersionError,
    QbraidSystemError,
    UnknownFileSystemObjectError,
    VersionNotFoundError,
)
from .executables import (
    get_active_python_path,
    get_python_version_from_cfg,
    get_python_version_from_exe,
    is_exe,
    is_valid_python,
    python_paths_equivalent,
)
from .generic import echo_log, replace_str
from .packages import (
    get_active_site_packages_path,
    get_latest_package_version,
    get_local_package_path,
    get_local_package_version,
    get_venv_site_packages_path,
)
from .threader import FileManager
from .versions import extract_version, is_valid_semantic_version
