def load(h):
    return ({'abbr': 'strf', 'code': 1, 'title': 'Stream function', 'units': 'm**2 s**-1'},
            {'abbr': 'vp',
             'code': 2,
             'title': 'Velocity potential',
             'units': 'm**2 s**-1'},
            {'abbr': 'pt', 'code': 3, 'title': 'Potential temperature', 'units': 'K'},
            {'abbr': 'eqpt',
             'code': 4,
             'title': 'Equivalent potential temperature',
             'units': 'K'},
            {'abbr': 'sept',
             'code': 5,
             'title': 'Saturated equivalent potential temperature',
             'units': 'K'},
            {'abbr': 'ssfr', 'code': 6, 'title': 'Soil sand fraction', 'units': '(0 - 1)'},
            {'abbr': 'scfr', 'code': 7, 'title': 'Soil clay fraction', 'units': '(0 - 1)'},
            {'abbr': 'sro', 'code': 8, 'title': 'Surface runoff', 'units': 'm'},
            {'abbr': 'ssro', 'code': 9, 'title': 'Sub-surface runoff', 'units': 'm'},
            {'abbr': 'ws', 'code': 10, 'title': 'Wind speed', 'units': 'm s**-1'},
            {'abbr': 'udvw',
             'code': 11,
             'title': 'U component of divergent wind',
             'units': 'm s**-1'},
            {'abbr': 'vdvw',
             'code': 12,
             'title': 'V component of divergent wind',
             'units': 'm s**-1'},
            {'abbr': 'urtw',
             'code': 13,
             'title': 'U component of rotational wind',
             'units': 'm s**-1'},
            {'abbr': 'vrtw',
             'code': 14,
             'title': 'V component of rotational wind',
             'units': 'm s**-1'},
            {'abbr': 'aluvp',
             'code': 15,
             'title': 'UV visible albedo for direct radiation',
             'units': '(0 - 1)'},
            {'abbr': 'aluvd',
             'code': 16,
             'title': 'UV visible albedo for diffuse radiation',
             'units': '(0 - 1)'},
            {'abbr': 'alnip',
             'code': 17,
             'title': 'Near IR albedo for direct radiation',
             'units': '(0 - 1)'},
            {'abbr': 'alnid',
             'code': 18,
             'title': 'Near IR albedo for diffuse radiation',
             'units': '(0 - 1)'},
            {'abbr': 'uvcs',
             'code': 19,
             'title': 'Clear sky surface UV',
             'units': 'W m**-2 s'},
            {'abbr': 'parcs',
             'code': 20,
             'title': 'Clear sky surface photosynthetically active radiation',
             'units': 'W m**-2 s'},
            {'abbr': 'uctp',
             'code': 21,
             'title': 'Unbalanced component of temperature',
             'units': 'K'},
            {'abbr': 'ucln',
             'code': 22,
             'title': 'Unbalanced component of logarithm of surface pressure',
             'units': ''},
            {'abbr': 'ucdv',
             'code': 23,
             'title': 'Unbalanced component of divergence',
             'units': 's**-1'},
            {'abbr': '-',
             'code': 24,
             'title': 'Reserved for future unbalanced components',
             'units': ''},
            {'abbr': '-',
             'code': 25,
             'title': 'Reserved for future unbalanced components',
             'units': ''},
            {'abbr': 'cl', 'code': 26, 'title': 'Lake cover', 'units': '(0 - 1)'},
            {'abbr': 'cvl',
             'code': 27,
             'title': 'Low vegetation cover',
             'units': '(0 - 1)'},
            {'abbr': 'cvh',
             'code': 28,
             'title': 'High vegetation cover',
             'units': '(0 - 1)'},
            {'abbr': 'tvl', 'code': 29, 'title': 'Type of low vegetation', 'units': ''},
            {'abbr': 'tvh', 'code': 30, 'title': 'Type of high vegetation', 'units': ''},
            {'abbr': 'ci', 'code': 31, 'title': 'Sea-ice cover', 'units': '(0 - 1)'},
            {'abbr': 'asn', 'code': 32, 'title': 'Snow albedo', 'units': '(0 - 1)'},
            {'abbr': 'rsn', 'code': 33, 'title': 'Snow density', 'units': 'kg m**-3'},
            {'abbr': 'sst', 'code': 34, 'title': 'Sea surface temperature', 'units': 'K'},
            {'abbr': 'istl1',
             'code': 35,
             'title': 'Ice surface temperature layer 1',
             'units': 'K'},
            {'abbr': 'istl2',
             'code': 36,
             'title': 'Ice surface temperature layer 2',
             'units': 'K'},
            {'abbr': 'istl3',
             'code': 37,
             'title': 'Ice surface temperature layer 3',
             'units': 'K'},
            {'abbr': 'istl4',
             'code': 38,
             'title': 'Ice surface temperature layer 4',
             'units': 'K'},
            {'abbr': 'swvl1',
             'code': 39,
             'title': 'Volumetric soil water layer 1',
             'units': 'm**3 m**-3'},
            {'abbr': 'swvl2',
             'code': 40,
             'title': 'Volumetric soil water layer 2',
             'units': 'm**3 m**-3'},
            {'abbr': 'swvl3',
             'code': 41,
             'title': 'Volumetric soil water layer 3',
             'units': 'm**3 m**-3'},
            {'abbr': 'swvl4',
             'code': 42,
             'title': 'Volumetric soil water layer 4',
             'units': 'm**3 m**-3'},
            {'abbr': 'slt', 'code': 43, 'title': 'Soil type', 'units': ''},
            {'abbr': 'es', 'code': 44, 'title': 'Snow evaporation', 'units': 'm of water'},
            {'abbr': 'smlt', 'code': 45, 'title': 'Snowmelt', 'units': 'm of water'},
            {'abbr': 'sdur', 'code': 46, 'title': 'Solar duration', 'units': 's'},
            {'abbr': 'dsrp',
             'code': 47,
             'title': 'Direct solar radiation',
             'units': 'w m**-2'},
            {'abbr': 'magss',
             'code': 48,
             'title': 'Magnitude of surface stress',
             'units': 'N m**-2 s'},
            {'abbr': '10fg',
             'code': 49,
             'title': '10 metre wind gust',
             'units': 'm s**-1'},
            {'abbr': 'lspf',
             'code': 50,
             'title': 'Large-scale precipitation fraction',
             'units': 's'},
            {'abbr': 'mx2t24',
             'code': 51,
             'title': 'Maximum temperature at 2 metres since last 24 hours',
             'units': 'K'},
            {'abbr': 'mn2t24',
             'code': 52,
             'title': 'Minimum temperature at 2 metres since last 24 hours',
             'units': 'K'},
            {'abbr': 'mont',
             'code': 53,
             'title': 'Montgomery potential',
             'units': 'm**2 s**-2'},
            {'abbr': 'pres', 'code': 54, 'title': 'Pressure', 'units': 'Pa'},
            {'abbr': 'mean2t24',
             'code': 55,
             'title': 'Mean temperature at 2 metres since last 24 hours',
             'units': 'K'},
            {'abbr': 'mn2d24',
             'code': 56,
             'title': 'Mean 2 metre dewpoint temperature in past 24 hours',
             'units': 'K'},
            {'abbr': 'uvb',
             'code': 57,
             'title': 'Downward UV radiation at the surface',
             'units': 'w m**-2 s'},
            {'abbr': 'par',
             'code': 58,
             'title': 'Photosynthetically active radiation at the surface',
             'units': 'w m**-2 s'},
            {'abbr': 'cape',
             'code': 59,
             'title': 'Convective available potential energy',
             'units': 'J kg**-1'},
            {'abbr': 'pv',
             'code': 60,
             'title': 'Potential vorticity',
             'units': 'K m**2 kg**-1 s**-1'},
            {'abbr': 'obct', 'code': 62, 'title': 'Observation count', 'units': ''},
            {'abbr': 'stsktd',
             'code': 63,
             'title': 'Start time for skin temperature difference',
             'units': 's'},
            {'abbr': 'ftsktd',
             'code': 64,
             'title': 'Finish time for skin temperature difference',
             'units': 's'},
            {'abbr': 'sktd',
             'code': 65,
             'title': 'Skin temperature difference',
             'units': 'K'},
            {'abbr': 'lai_lv',
             'code': 66,
             'title': 'Leaf area index, low vegetation',
             'units': 'm**2 / m**2'},
            {'abbr': 'lai_hv',
             'code': 67,
             'title': 'Leaf area index, high vegetation',
             'units': 'm**2 / m**2'},
            {'abbr': 'msr_lv',
             'code': 68,
             'title': 'Minimum stomatal resistance, low vegetation',
             'units': 's m**-1'},
            {'abbr': 'msr_hv',
             'code': 69,
             'title': 'Minimum stomatal resistance, high vegetation',
             'units': 's m**-1'},
            {'abbr': 'bc_lv',
             'code': 70,
             'title': 'Biome cover, low vegetation',
             'units': '(0 - 1)'},
            {'abbr': 'bc_hv',
             'code': 71,
             'title': 'Biome cover, high vegetation',
             'units': '(0 - 1)'},
            {'abbr': 'issrd',
             'code': 72,
             'title': 'Instantaneous surface solar radiation downwards',
             'units': 'w m**-2'},
            {'abbr': 'istrd',
             'code': 73,
             'title': 'Instantaneous surface thermal radiation downwards',
             'units': 'w m**-2'},
            {'abbr': 'sdfor',
             'code': 74,
             'title': 'Standard deviation of filtered subgrid orography',
             'units': 'm'},
            {'abbr': 'crwc',
             'code': 75,
             'title': 'Cloud rain water content',
             'units': 'kg kg**-1'},
            {'abbr': 'cswc',
             'code': 76,
             'title': 'Cloud snow water content',
             'units': 'kg kg**-1'},
            {'abbr': 'etadot',
             'code': 77,
             'title': 'Eta-coordinate vertical velocity',
             'units': 's**-1'},
            {'abbr': 'tclw',
             'code': 78,
             'title': 'Total column liquid water',
             'units': 'kg m**-2'},
            {'abbr': 'tciw',
             'code': 79,
             'title': 'Total column ice water',
             'units': 'kg m**-2'},
            {'abbr': '-', 'code': 80, 'title': 'Experimental product', 'units': ''},
            {'abbr': '-', 'code': 81, 'title': 'Experimental product', 'units': ''},
            {'abbr': '-', 'code': 82, 'title': 'Experimental product', 'units': ''},
            {'abbr': '-', 'code': 83, 'title': 'Experimental product', 'units': ''},
            {'abbr': '-', 'code': 84, 'title': 'Experimental product', 'units': ''},
            {'abbr': '-', 'code': 85, 'title': 'Experimental product', 'units': ''},
            {'abbr': '-', 'code': 86, 'title': 'Experimental product', 'units': ''},
            {'abbr': '-', 'code': 87, 'title': 'Experimental product', 'units': ''},
            {'abbr': '-', 'code': 88, 'title': 'Experimental product', 'units': ''},
            {'abbr': '-', 'code': 89, 'title': 'Experimental product', 'units': ''},
            {'abbr': '-', 'code': 90, 'title': 'Experimental product', 'units': ''},
            {'abbr': '-', 'code': 91, 'title': 'Experimental product', 'units': ''},
            {'abbr': '-', 'code': 92, 'title': 'Experimental product', 'units': ''},
            {'abbr': '-', 'code': 93, 'title': 'Experimental product', 'units': ''},
            {'abbr': '-', 'code': 94, 'title': 'Experimental product', 'units': ''},
            {'abbr': '-', 'code': 95, 'title': 'Experimental product', 'units': ''},
            {'abbr': '-', 'code': 96, 'title': 'Experimental product', 'units': ''},
            {'abbr': '-', 'code': 97, 'title': 'Experimental product', 'units': ''},
            {'abbr': '-', 'code': 98, 'title': 'Experimental product', 'units': ''},
            {'abbr': '-', 'code': 99, 'title': 'Experimental product', 'units': ''},
            {'abbr': '-', 'code': 100, 'title': 'Experimental product', 'units': ''},
            {'abbr': '-', 'code': 101, 'title': 'Experimental product', 'units': ''},
            {'abbr': '-', 'code': 102, 'title': 'Experimental product', 'units': ''},
            {'abbr': '-', 'code': 103, 'title': 'Experimental product', 'units': ''},
            {'abbr': '-', 'code': 104, 'title': 'Experimental product', 'units': ''},
            {'abbr': '-', 'code': 105, 'title': 'Experimental product', 'units': ''},
            {'abbr': '-', 'code': 106, 'title': 'Experimental product', 'units': ''},
            {'abbr': '-', 'code': 107, 'title': 'Experimental product', 'units': ''},
            {'abbr': '-', 'code': 108, 'title': 'Experimental product', 'units': ''},
            {'abbr': '-', 'code': 109, 'title': 'Experimental product', 'units': ''},
            {'abbr': '-', 'code': 110, 'title': 'Experimental product', 'units': ''},
            {'abbr': '-', 'code': 111, 'title': 'Experimental product', 'units': ''},
            {'abbr': '-', 'code': 112, 'title': 'Experimental product', 'units': ''},
            {'abbr': '-', 'code': 113, 'title': 'Experimental product', 'units': ''},
            {'abbr': '-', 'code': 114, 'title': 'Experimental product', 'units': ''},
            {'abbr': '-', 'code': 115, 'title': 'Experimental product', 'units': ''},
            {'abbr': '-', 'code': 116, 'title': 'Experimental product', 'units': ''},
            {'abbr': '-', 'code': 117, 'title': 'Experimental product', 'units': ''},
            {'abbr': '-', 'code': 118, 'title': 'Experimental product', 'units': ''},
            {'abbr': '-', 'code': 119, 'title': 'Experimental product', 'units': ''},
            {'abbr': '-', 'code': 120, 'title': 'Experimental product', 'units': ''},
            {'abbr': 'mx2t6',
             'code': 121,
             'title': 'Maximum temperature at 2 metres since last 6 hours',
             'units': 'K'},
            {'abbr': 'mn2t6',
             'code': 122,
             'title': 'Minimum temperature at 2 metres since last 6 hours',
             'units': 'K'},
            {'abbr': '10fg6',
             'code': 123,
             'title': '10 metre wind gust in the past 6 hours',
             'units': 'm s**-1'},
            {'abbr': 'emis',
             'code': 124,
             'title': 'Surface emissivity',
             'units': 'dimensionless'},
            {'abbr': 'vite',
             'code': 125,
             'title': 'Vertically integrated total energy',
             'units': 'J m**-2'},
            {'abbr': '-',
             'code': 126,
             'title': 'Generic parameter for sensitive area prediction',
             'units': 'Various'},
            {'abbr': 'at', 'code': 127, 'title': 'Atmospheric tide', 'units': ''},
            {'abbr': 'bv', 'code': 128, 'title': 'Budget values', 'units': ''},
            {'abbr': 'z', 'code': 129, 'title': 'Geopotential', 'units': 'm**2 s**-2'},
            {'abbr': 't', 'code': 130, 'title': 'Temperature', 'units': 'K'},
            {'abbr': 'u', 'code': 131, 'title': 'U velocity', 'units': 'm s**-1'},
            {'abbr': 'v', 'code': 132, 'title': 'V velocity', 'units': 'm s**-1'},
            {'abbr': 'q', 'code': 133, 'title': 'Specific humidity', 'units': 'kg kg**-1'},
            {'abbr': 'sp', 'code': 134, 'title': 'Surface pressure', 'units': 'Pa'},
            {'abbr': 'w', 'code': 135, 'title': 'Vertical velocity', 'units': 'Pa s**-1'},
            {'abbr': 'tcw',
             'code': 136,
             'title': 'Total column water',
             'units': 'kg m**-2'},
            {'abbr': 'tcwv',
             'code': 137,
             'title': 'Total column water vapour',
             'units': 'kg m**-2'},
            {'abbr': 'vo', 'code': 138, 'title': 'Vorticity (relative)', 'units': 's**-1'},
            {'abbr': 'stl1',
             'code': 139,
             'title': 'Soil temperature level 1',
             'units': 'K'},
            {'abbr': 'swl1',
             'code': 140,
             'title': 'Soil wetness level 1',
             'units': 'm of water'},
            {'abbr': 'sd',
             'code': 141,
             'title': 'Snow depth',
             'units': 'm of water equivalent'},
            {'abbr': 'lsp',
             'code': 142,
             'title': 'Stratiform precipitation (Large-scale precipitation)',
             'units': 'm'},
            {'abbr': 'cp', 'code': 143, 'title': 'Convective precipitation', 'units': 'm'},
            {'abbr': 'sf',
             'code': 144,
             'title': 'Snowfall',
             'units': 'm of water equivalent'},
            {'abbr': 'bld',
             'code': 145,
             'title': 'Boundary layer dissipation',
             'units': 'W m**-2 s'},
            {'abbr': 'sshf',
             'code': 146,
             'title': 'Surface sensible heat flux',
             'units': 'W m**-2 s'},
            {'abbr': 'slhf',
             'code': 147,
             'title': 'Surface latent heat flux',
             'units': 'W m**-2 s'},
            {'abbr': 'chnk', 'code': 148, 'title': 'Charnock', 'units': ''},
            {'abbr': 'snr',
             'code': 149,
             'title': 'Surface net radiation',
             'units': 'W m**-2 s'},
            {'abbr': 'tnr', 'code': 150, 'title': 'Top net radiation', 'units': ''},
            {'abbr': 'msl',
             'code': 151,
             'title': 'Mean sea level pressure',
             'units': 'Pa'},
            {'abbr': 'lnsp',
             'code': 152,
             'title': 'Logarithm of surface pressure',
             'units': ''},
            {'abbr': 'swhr',
             'code': 153,
             'title': 'Short-wave heating rate',
             'units': 'K'},
            {'abbr': 'lwhr', 'code': 154, 'title': 'Long-wave heating rate', 'units': 'K'},
            {'abbr': 'd', 'code': 155, 'title': 'Divergence', 'units': 's**-1'},
            {'abbr': 'gh', 'code': 156, 'title': 'Gepotential Height', 'units': 'gpm'},
            {'abbr': 'r', 'code': 157, 'title': 'Relative humidity', 'units': '%'},
            {'abbr': 'tsp',
             'code': 158,
             'title': 'Tendency of surface pressure',
             'units': 'Pa s**-1'},
            {'abbr': 'blh', 'code': 159, 'title': 'Boundary layer height', 'units': 'm'},
            {'abbr': 'sdor',
             'code': 160,
             'title': 'Standard deviation of orography',
             'units': ''},
            {'abbr': 'isor',
             'code': 161,
             'title': 'Anisotropy of sub-gridscale orography',
             'units': ''},
            {'abbr': 'anor',
             'code': 162,
             'title': 'Angle of sub-gridscale orography',
             'units': 'rad'},
            {'abbr': 'slor',
             'code': 163,
             'title': 'Slope of sub-gridscale orography',
             'units': ''},
            {'abbr': 'tcc', 'code': 164, 'title': 'Total cloud cover', 'units': '(0 - 1)'},
            {'abbr': '10u',
             'code': 165,
             'title': '10 metre U wind component',
             'units': 'm s**-1'},
            {'abbr': '10v',
             'code': 166,
             'title': '10 metre V wind component',
             'units': 'm s**-1'},
            {'abbr': '2t', 'code': 167, 'title': '2 metre temperature', 'units': 'K'},
            {'abbr': '2d',
             'code': 168,
             'title': '2 metre dewpoint temperature',
             'units': 'K'},
            {'abbr': 'ssrd',
             'code': 169,
             'title': 'Surface solar radiation downwards',
             'units': 'W m**-2 s'},
            {'abbr': 'stl2',
             'code': 170,
             'title': 'Soil temperature level 2',
             'units': 'K'},
            {'abbr': 'swl2',
             'code': 171,
             'title': 'Soil wetness level 2',
             'units': 'm of water'},
            {'abbr': 'lsm', 'code': 172, 'title': 'Land-sea mask', 'units': '(0 - 1)'},
            {'abbr': 'sr', 'code': 173, 'title': 'Surface roughness', 'units': 'm'},
            {'abbr': 'al', 'code': 174, 'title': 'Albedo', 'units': '(0 - 1)'},
            {'abbr': 'strd',
             'code': 175,
             'title': 'Surface thermal radiation downwards',
             'units': 'W m**-2 s'},
            {'abbr': 'ssr',
             'code': 176,
             'title': 'Surface solar radiation',
             'units': 'W m**-2 s'},
            {'abbr': 'str',
             'code': 177,
             'title': 'Surface thermal radiation',
             'units': 'W m**-2 s'},
            {'abbr': 'tsr',
             'code': 178,
             'title': 'Top solar radiation',
             'units': 'W m**-2 s'},
            {'abbr': 'ttr',
             'code': 179,
             'title': 'Top thermal radiation',
             'units': 'W m**-2 s'},
            {'abbr': 'ewss',
             'code': 180,
             'title': 'East-West surface stress',
             'units': 'N m**-2 s'},
            {'abbr': 'nsss',
             'code': 181,
             'title': 'North-South surface stress',
             'units': 'N m**-2 s'},
            {'abbr': 'e', 'code': 182, 'title': 'Evaporation', 'units': 'm of water'},
            {'abbr': 'stl3',
             'code': 183,
             'title': 'Soil temperature level 3',
             'units': 'K'},
            {'abbr': 'swl3',
             'code': 184,
             'title': 'Soil wetness level 3',
             'units': 'm of water'},
            {'abbr': 'ccc',
             'code': 185,
             'title': 'Convective cloud cover',
             'units': '(0 - 1)'},
            {'abbr': 'lcc', 'code': 186, 'title': 'Low cloud cover', 'units': '(0 - 1)'},
            {'abbr': 'mcc',
             'code': 187,
             'title': 'Medium cloud cover',
             'units': '(0 - 1)'},
            {'abbr': 'hcc', 'code': 188, 'title': 'High cloud cover', 'units': '(0 - 1)'},
            {'abbr': 'sund', 'code': 189, 'title': 'Sunshine duration', 'units': 's'},
            {'abbr': 'ewov',
             'code': 190,
             'title': 'East-West component of sub-gridscale orographic variance',
             'units': 'm**2'},
            {'abbr': 'nsov',
             'code': 191,
             'title': 'North-South component of sub-gridscale orographic variance',
             'units': 'm**2'},
            {'abbr': 'nwov',
             'code': 192,
             'title': 'North-West/South-East component of sub-gridscale orographic '
                      'variance',
             'units': 'm**2'},
            {'abbr': 'neov',
             'code': 193,
             'title': 'North-East/South-West component of sub-gridscale orographic '
                      'variance',
             'units': 'm**2'},
            {'abbr': 'btmp', 'code': 194, 'title': 'Brightness temperature', 'units': 'K'},
            {'abbr': 'lgws',
             'code': 195,
             'title': 'Latitudinal component of gravity wave stress',
             'units': 'N m**-2 s'},
            {'abbr': 'mgws',
             'code': 196,
             'title': 'Meridional component of gravity wave stress',
             'units': 'N m**-2 s'},
            {'abbr': 'gwd',
             'code': 197,
             'title': 'Gravity wave dissipation',
             'units': 'W m**-2 s'},
            {'abbr': 'src',
             'code': 198,
             'title': 'Skin reservoir content',
             'units': 'm of water'},
            {'abbr': 'veg',
             'code': 199,
             'title': 'Vegetation fraction',
             'units': '(0 - 1)'},
            {'abbr': 'vso',
             'code': 200,
             'title': 'Variance of sub-gridscale orography',
             'units': 'm**2'},
            {'abbr': 'mx2t',
             'code': 201,
             'title': 'Maximum temperature at 2 metres since previous post-processing',
             'units': 'K'},
            {'abbr': 'mn2t',
             'code': 202,
             'title': 'Minimum temperature at 2 metres since previous post-processing',
             'units': 'K'},
            {'abbr': 'o3',
             'code': 203,
             'title': 'Ozone mass mixing ratio',
             'units': 'kg kg**-1'},
            {'abbr': 'paw',
             'code': 204,
             'title': 'Precipitation analysis weights',
             'units': ''},
            {'abbr': 'ro', 'code': 205, 'title': 'Runoff', 'units': 'm'},
            {'abbr': 'tco3',
             'code': 206,
             'title': 'Total column ozone',
             'units': 'kg m**-2'},
            {'abbr': '10si',
             'code': 207,
             'title': '10 metre wind speed',
             'units': 'm s**-1'},
            {'abbr': 'tsrc',
             'code': 208,
             'title': 'Top net solar radiation, clear sky',
             'units': 'W m**-2 s'},
            {'abbr': 'ttrc',
             'code': 209,
             'title': 'Top net thermal radiation, clear sky',
             'units': 'W m**-2 s'},
            {'abbr': 'ssrc',
             'code': 210,
             'title': 'Surface net solar radiation, clear sky',
             'units': 'W m**-2 s'},
            {'abbr': 'strc',
             'code': 211,
             'title': 'Surface net thermal radiation, clear sky',
             'units': 'W m**-2 s'},
            {'abbr': 'tisr',
             'code': 212,
             'title': 'TOA incident solar radiation',
             'units': 'W m**-2 s'},
            {'abbr': 'vimd',
             'code': 213,
             'title': 'Vertically integrated moisture divergence',
             'units': 'kg m**-2'},
            {'abbr': 'dhr',
             'code': 214,
             'title': 'Diabatic heating by radiation',
             'units': 'K'},
            {'abbr': 'dhvd',
             'code': 215,
             'title': 'Diabatic heating by vertical diffusion',
             'units': 'K'},
            {'abbr': 'dhcc',
             'code': 216,
             'title': 'Diabatic heating by cumulus convection',
             'units': 'K'},
            {'abbr': 'dhlc',
             'code': 217,
             'title': 'Diabatic heating large-scale condensation',
             'units': 'K'},
            {'abbr': 'vdzw',
             'code': 218,
             'title': 'Vertical diffusion of zonal wind',
             'units': 'm s**-1'},
            {'abbr': 'vdmw',
             'code': 219,
             'title': 'Vertical diffusion of meridional wind',
             'units': 'm s**-1'},
            {'abbr': 'ewgd',
             'code': 220,
             'title': 'East-West gravity wave drag tendency',
             'units': 'm s**-1'},
            {'abbr': 'nsgd',
             'code': 221,
             'title': 'North-South gravity wave drag tendency',
             'units': 'm s**-1'},
            {'abbr': 'ctzw',
             'code': 222,
             'title': 'Convective tendency of zonal wind',
             'units': 'm s**-1'},
            {'abbr': 'ctmw',
             'code': 223,
             'title': 'Convective tendency of meridional wind',
             'units': 'm s**-1'},
            {'abbr': 'vdh',
             'code': 224,
             'title': 'Vertical diffusion of humidity',
             'units': 'kg kg**-1'},
            {'abbr': 'htcc',
             'code': 225,
             'title': 'Humidity tendency by cumulus convection',
             'units': 'kg kg**-1'},
            {'abbr': 'htlc',
             'code': 226,
             'title': 'Humidity tendency by large-scale condensation',
             'units': 'kg kg**-1'},
            {'abbr': 'crnh',
             'code': 227,
             'title': 'Change from removal of negative humidity',
             'units': 'kg kg**-1'},
            {'abbr': 'tp', 'code': 228, 'title': 'Total precipitation', 'units': 'm'},
            {'abbr': 'iews',
             'code': 229,
             'title': 'Instantaneous X surface stress',
             'units': 'N m**-2'},
            {'abbr': 'inss',
             'code': 230,
             'title': 'Instantaneous Y surface stress',
             'units': 'N m**-2'},
            {'abbr': 'ishf',
             'code': 231,
             'title': 'Instantaneous surface heat flux',
             'units': 'W m**-2'},
            {'abbr': 'ie',
             'code': 232,
             'title': 'Instantaneous moisture flux',
             'units': 'kg m**-2 s**-1'},
            {'abbr': 'asq',
             'code': 233,
             'title': 'Apparent surface humidity',
             'units': 'kg kg**-1'},
            {'abbr': 'lsrh',
             'code': 234,
             'title': 'Logarithm of surface roughness length for heat',
             'units': ''},
            {'abbr': 'skt', 'code': 235, 'title': 'Skin temperature', 'units': 'K'},
            {'abbr': 'stl4',
             'code': 236,
             'title': 'Soil temperature level 4',
             'units': 'K'},
            {'abbr': 'swl4', 'code': 237, 'title': 'Soil wetness level 4', 'units': 'm'},
            {'abbr': 'tsn',
             'code': 238,
             'title': 'Temperature of snow layer',
             'units': 'K'},
            {'abbr': 'csf',
             'code': 239,
             'title': 'Convective snowfall',
             'units': 'm of water equivalent'},
            {'abbr': 'lsf',
             'code': 240,
             'title': 'Large-scale snowfall',
             'units': 'm of water equivalent'},
            {'abbr': 'acf',
             'code': 241,
             'title': 'Accumulated cloud fraction tendency',
             'units': '(-1 to 1)'},
            {'abbr': 'alw',
             'code': 242,
             'title': 'Accumulated liquid water tendency',
             'units': '(-1 to 1)'},
            {'abbr': 'fal', 'code': 243, 'title': 'Forecast albedo', 'units': '(0 - 1)'},
            {'abbr': 'fsr',
             'code': 244,
             'title': 'Forecast surface roughness',
             'units': 'm'},
            {'abbr': 'flsr',
             'code': 245,
             'title': 'Forecast logarithm of surface roughness for heat',
             'units': ''},
            {'abbr': 'clwc',
             'code': 246,
             'title': 'Cloud liquid water content',
             'units': 'kg kg**-1'},
            {'abbr': 'ciwc',
             'code': 247,
             'title': 'Cloud ice water content',
             'units': 'kg kg**-1'},
            {'abbr': 'cc',
             'code': 248,
             'title': 'Fraction of cloud cover',
             'units': '(0 - 1)'},
            {'abbr': 'aiw',
             'code': 249,
             'title': 'Accumulated ice water tendency',
             'units': '(-1 to 1)'},
            {'abbr': 'ice', 'code': 250, 'title': 'Ice age', 'units': '(0 - 1)'},
            {'abbr': 'atte',
             'code': 251,
             'title': 'Adiabatic tendency of temperature',
             'units': 'K'},
            {'abbr': 'athe',
             'code': 252,
             'title': 'Adiabatic tendency of humidity',
             'units': 'kg kg**-1'},
            {'abbr': 'atze',
             'code': 253,
             'title': 'Adiabatic tendency of zonal wind',
             'units': 'm s**-1'},
            {'abbr': 'atmw',
             'code': 254,
             'title': 'Adiabatic tendency of meridional wind',
             'units': 'm s**-1'},
            {'abbr': '-', 'code': 255, 'title': 'Indicates a missing value', 'units': ''})
