"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketLambdaAuthorizer = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_alpha_1 = require("@aws-cdk/aws-apigatewayv2-alpha");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * (experimental) Authorize WebSocket Api routes via a lambda function.
 *
 * @experimental
 */
class WebSocketLambdaAuthorizer {
    /**
     * @experimental
     */
    constructor(id, handler, props = {}) {
        this.id = id;
        this.handler = handler;
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_authorizers_alpha_WebSocketLambdaAuthorizerProps(props);
    }
    /**
     * (experimental) (experimental) Bind this authorizer to a specified WebSocket route.
     *
     * @experimental
     */
    bind(options) {
        var _b, _c;
        if (this.webSocketApi && (this.webSocketApi.apiId !== options.route.webSocketApi.apiId)) {
            throw new Error('Cannot attach the same authorizer to multiple Apis');
        }
        if (!this.authorizer) {
            this.webSocketApi = options.route.webSocketApi;
            this.authorizer = new aws_apigatewayv2_alpha_1.WebSocketAuthorizer(options.scope, this.id, {
                webSocketApi: options.route.webSocketApi,
                identitySource: (_b = this.props.identitySource) !== null && _b !== void 0 ? _b : [
                    'route.request.header.Authorization',
                ],
                type: aws_apigatewayv2_alpha_1.WebSocketAuthorizerType.LAMBDA,
                authorizerName: (_c = this.props.authorizerName) !== null && _c !== void 0 ? _c : this.id,
                authorizerUri: lambdaAuthorizerArn(this.handler),
            });
            this.handler.addPermission(`${aws_cdk_lib_1.Names.nodeUniqueId(this.authorizer.node)}-Permission`, {
                scope: options.scope,
                principal: new aws_iam_1.ServicePrincipal('apigateway.amazonaws.com'),
                sourceArn: aws_cdk_lib_1.Stack.of(options.route).formatArn({
                    service: 'execute-api',
                    resource: options.route.webSocketApi.apiId,
                    resourceName: `authorizers/${this.authorizer.authorizerId}`,
                }),
            });
        }
        return {
            authorizerId: this.authorizer.authorizerId,
            authorizationType: 'CUSTOM',
        };
    }
}
exports.WebSocketLambdaAuthorizer = WebSocketLambdaAuthorizer;
_a = JSII_RTTI_SYMBOL_1;
WebSocketLambdaAuthorizer[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-authorizers-alpha.WebSocketLambdaAuthorizer", version: "2.9.0-alpha.0" };
/**
 * constructs the authorizerURIArn.
 */
function lambdaAuthorizerArn(handler) {
    return `arn:${aws_cdk_lib_1.Stack.of(handler).partition}:apigateway:${aws_cdk_lib_1.Stack.of(handler).region}:lambda:path/2015-03-31/functions/${handler.functionArn}/invocations`;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGFtYmRhLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsibGFtYmRhLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUFBLDRFQU95QztBQUN6QyxpREFBdUQ7QUFFdkQsNkNBQTJDOzs7Ozs7QUFjM0MsTUFBYSx5QkFBeUI7Ozs7SUFJcEMsWUFDbUIsRUFBVSxFQUNWLE9BQWtCLEVBQ2xCLFFBQXdDLEVBQUU7UUFGMUMsT0FBRSxHQUFGLEVBQUUsQ0FBUTtRQUNWLFlBQU8sR0FBUCxPQUFPLENBQVc7UUFDbEIsVUFBSyxHQUFMLEtBQUssQ0FBcUM7O0tBQzVEOzs7Ozs7SUFFTSxJQUFJLENBQUMsT0FBNEM7O1FBQ3RELElBQUksSUFBSSxDQUFDLFlBQVksSUFBSSxDQUFDLElBQUksQ0FBQyxZQUFZLENBQUMsS0FBSyxLQUFLLE9BQU8sQ0FBQyxLQUFLLENBQUMsWUFBWSxDQUFDLEtBQUssQ0FBQyxFQUFFO1lBQ3ZGLE1BQU0sSUFBSSxLQUFLLENBQUMsb0RBQW9ELENBQUMsQ0FBQztTQUN2RTtRQUVELElBQUksQ0FBQyxJQUFJLENBQUMsVUFBVSxFQUFFO1lBQ3BCLElBQUksQ0FBQyxZQUFZLEdBQUcsT0FBTyxDQUFDLEtBQUssQ0FBQyxZQUFZLENBQUM7WUFDL0MsSUFBSSxDQUFDLFVBQVUsR0FBRyxJQUFJLDRDQUFtQixDQUFDLE9BQU8sQ0FBQyxLQUFLLEVBQUUsSUFBSSxDQUFDLEVBQUUsRUFBRTtnQkFDaEUsWUFBWSxFQUFFLE9BQU8sQ0FBQyxLQUFLLENBQUMsWUFBWTtnQkFDeEMsY0FBYyxRQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsY0FBYyxtQ0FBSTtvQkFDM0Msb0NBQW9DO2lCQUNyQztnQkFDRCxJQUFJLEVBQUUsZ0RBQXVCLENBQUMsTUFBTTtnQkFDcEMsY0FBYyxRQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsY0FBYyxtQ0FBSSxJQUFJLENBQUMsRUFBRTtnQkFDcEQsYUFBYSxFQUFFLG1CQUFtQixDQUFDLElBQUksQ0FBQyxPQUFPLENBQUM7YUFDakQsQ0FBQyxDQUFDO1lBRUgsSUFBSSxDQUFDLE9BQU8sQ0FBQyxhQUFhLENBQUMsR0FBRyxtQkFBSyxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxhQUFhLEVBQUU7Z0JBQ25GLEtBQUssRUFBRSxPQUFPLENBQUMsS0FBa0I7Z0JBQ2pDLFNBQVMsRUFBRSxJQUFJLDBCQUFnQixDQUFDLDBCQUEwQixDQUFDO2dCQUMzRCxTQUFTLEVBQUUsbUJBQUssQ0FBQyxFQUFFLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxDQUFDLFNBQVMsQ0FBQztvQkFDM0MsT0FBTyxFQUFFLGFBQWE7b0JBQ3RCLFFBQVEsRUFBRSxPQUFPLENBQUMsS0FBSyxDQUFDLFlBQVksQ0FBQyxLQUFLO29CQUMxQyxZQUFZLEVBQUUsZUFBZSxJQUFJLENBQUMsVUFBVSxDQUFDLFlBQVksRUFBRTtpQkFDNUQsQ0FBQzthQUNILENBQUMsQ0FBQztTQUNKO1FBRUQsT0FBTztZQUNMLFlBQVksRUFBRSxJQUFJLENBQUMsVUFBVSxDQUFDLFlBQVk7WUFDMUMsaUJBQWlCLEVBQUUsUUFBUTtTQUM1QixDQUFDO0tBQ0g7O0FBMUNILDhEQTJDQzs7O0FBRUQ7O0dBRUc7QUFDSCxTQUFTLG1CQUFtQixDQUFDLE9BQWtCO0lBQzdDLE9BQU8sT0FBTyxtQkFBSyxDQUFDLEVBQUUsQ0FBQyxPQUFPLENBQUMsQ0FBQyxTQUFTLGVBQWUsbUJBQUssQ0FBQyxFQUFFLENBQUMsT0FBTyxDQUFDLENBQUMsTUFBTSxxQ0FBcUMsT0FBTyxDQUFDLFdBQVcsY0FBYyxDQUFDO0FBQ3pKLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQge1xuICBXZWJTb2NrZXRBdXRob3JpemVyLFxuICBXZWJTb2NrZXRBdXRob3JpemVyVHlwZSxcbiAgV2ViU29ja2V0Um91dGVBdXRob3JpemVyQmluZE9wdGlvbnMsXG4gIFdlYlNvY2tldFJvdXRlQXV0aG9yaXplckNvbmZpZyxcbiAgSVdlYlNvY2tldFJvdXRlQXV0aG9yaXplcixcbiAgSVdlYlNvY2tldEFwaSxcbn0gZnJvbSAnQGF3cy1jZGsvYXdzLWFwaWdhdGV3YXl2Mi1hbHBoYSc7XG5pbXBvcnQgeyBTZXJ2aWNlUHJpbmNpcGFsIH0gZnJvbSAnYXdzLWNkay1saWIvYXdzLWlhbSc7XG5pbXBvcnQgeyBJRnVuY3Rpb24gfSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtbGFtYmRhJztcbmltcG9ydCB7IFN0YWNrLCBOYW1lcyB9IGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIFdlYlNvY2tldExhbWJkYUF1dGhvcml6ZXJQcm9wcyB7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBhdXRob3JpemVyTmFtZT86IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgaWRlbnRpdHlTb3VyY2U/OiBzdHJpbmdbXTtcbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgV2ViU29ja2V0TGFtYmRhQXV0aG9yaXplciBpbXBsZW1lbnRzIElXZWJTb2NrZXRSb3V0ZUF1dGhvcml6ZXIge1xuICBwcml2YXRlIGF1dGhvcml6ZXI/OiBXZWJTb2NrZXRBdXRob3JpemVyO1xuICBwcml2YXRlIHdlYlNvY2tldEFwaT86IElXZWJTb2NrZXRBcGk7XG5cbiAgY29uc3RydWN0b3IoXG4gICAgcHJpdmF0ZSByZWFkb25seSBpZDogc3RyaW5nLFxuICAgIHByaXZhdGUgcmVhZG9ubHkgaGFuZGxlcjogSUZ1bmN0aW9uLFxuICAgIHByaXZhdGUgcmVhZG9ubHkgcHJvcHM6IFdlYlNvY2tldExhbWJkYUF1dGhvcml6ZXJQcm9wcyA9IHt9KSB7XG4gIH1cblxuICBwdWJsaWMgYmluZChvcHRpb25zOiBXZWJTb2NrZXRSb3V0ZUF1dGhvcml6ZXJCaW5kT3B0aW9ucyk6IFdlYlNvY2tldFJvdXRlQXV0aG9yaXplckNvbmZpZyB7XG4gICAgaWYgKHRoaXMud2ViU29ja2V0QXBpICYmICh0aGlzLndlYlNvY2tldEFwaS5hcGlJZCAhPT0gb3B0aW9ucy5yb3V0ZS53ZWJTb2NrZXRBcGkuYXBpSWQpKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ0Nhbm5vdCBhdHRhY2ggdGhlIHNhbWUgYXV0aG9yaXplciB0byBtdWx0aXBsZSBBcGlzJyk7XG4gICAgfVxuXG4gICAgaWYgKCF0aGlzLmF1dGhvcml6ZXIpIHtcbiAgICAgIHRoaXMud2ViU29ja2V0QXBpID0gb3B0aW9ucy5yb3V0ZS53ZWJTb2NrZXRBcGk7XG4gICAgICB0aGlzLmF1dGhvcml6ZXIgPSBuZXcgV2ViU29ja2V0QXV0aG9yaXplcihvcHRpb25zLnNjb3BlLCB0aGlzLmlkLCB7XG4gICAgICAgIHdlYlNvY2tldEFwaTogb3B0aW9ucy5yb3V0ZS53ZWJTb2NrZXRBcGksXG4gICAgICAgIGlkZW50aXR5U291cmNlOiB0aGlzLnByb3BzLmlkZW50aXR5U291cmNlID8/IFtcbiAgICAgICAgICAncm91dGUucmVxdWVzdC5oZWFkZXIuQXV0aG9yaXphdGlvbicsXG4gICAgICAgIF0sXG4gICAgICAgIHR5cGU6IFdlYlNvY2tldEF1dGhvcml6ZXJUeXBlLkxBTUJEQSxcbiAgICAgICAgYXV0aG9yaXplck5hbWU6IHRoaXMucHJvcHMuYXV0aG9yaXplck5hbWUgPz8gdGhpcy5pZCxcbiAgICAgICAgYXV0aG9yaXplclVyaTogbGFtYmRhQXV0aG9yaXplckFybih0aGlzLmhhbmRsZXIpLFxuICAgICAgfSk7XG5cbiAgICAgIHRoaXMuaGFuZGxlci5hZGRQZXJtaXNzaW9uKGAke05hbWVzLm5vZGVVbmlxdWVJZCh0aGlzLmF1dGhvcml6ZXIubm9kZSl9LVBlcm1pc3Npb25gLCB7XG4gICAgICAgIHNjb3BlOiBvcHRpb25zLnNjb3BlIGFzIENvbnN0cnVjdCxcbiAgICAgICAgcHJpbmNpcGFsOiBuZXcgU2VydmljZVByaW5jaXBhbCgnYXBpZ2F0ZXdheS5hbWF6b25hd3MuY29tJyksXG4gICAgICAgIHNvdXJjZUFybjogU3RhY2sub2Yob3B0aW9ucy5yb3V0ZSkuZm9ybWF0QXJuKHtcbiAgICAgICAgICBzZXJ2aWNlOiAnZXhlY3V0ZS1hcGknLFxuICAgICAgICAgIHJlc291cmNlOiBvcHRpb25zLnJvdXRlLndlYlNvY2tldEFwaS5hcGlJZCxcbiAgICAgICAgICByZXNvdXJjZU5hbWU6IGBhdXRob3JpemVycy8ke3RoaXMuYXV0aG9yaXplci5hdXRob3JpemVySWR9YCxcbiAgICAgICAgfSksXG4gICAgICB9KTtcbiAgICB9XG5cbiAgICByZXR1cm4ge1xuICAgICAgYXV0aG9yaXplcklkOiB0aGlzLmF1dGhvcml6ZXIuYXV0aG9yaXplcklkLFxuICAgICAgYXV0aG9yaXphdGlvblR5cGU6ICdDVVNUT00nLFxuICAgIH07XG4gIH1cbn1cblxuLyoqXG4gKiBjb25zdHJ1Y3RzIHRoZSBhdXRob3JpemVyVVJJQXJuLlxuICovXG5mdW5jdGlvbiBsYW1iZGFBdXRob3JpemVyQXJuKGhhbmRsZXI6IElGdW5jdGlvbikge1xuICByZXR1cm4gYGFybjoke1N0YWNrLm9mKGhhbmRsZXIpLnBhcnRpdGlvbn06YXBpZ2F0ZXdheToke1N0YWNrLm9mKGhhbmRsZXIpLnJlZ2lvbn06bGFtYmRhOnBhdGgvMjAxNS0wMy0zMS9mdW5jdGlvbnMvJHtoYW5kbGVyLmZ1bmN0aW9uQXJufS9pbnZvY2F0aW9uc2A7XG59XG4iXX0=