#!/usr/bin/env python

"""Tests for `math_base` package."""

import pytest

from click.testing import CliRunner

from math_base import math_base
from math_base import cli


@pytest.fixture
def response():
    """Sample pytest fixture.

    See more at: http://doc.pytest.org/en/latest/fixture.html
    """
    # import requests
    # return requests.get('https://github.com/audreyr/cookiecutter-pypackage')


def test_content(response):
    """Sample pytest test function with the pytest fixture as an argument."""
    # from bs4 import BeautifulSoup
    # assert 'GitHub' in BeautifulSoup(response.content).title.string


def test_command_line_interface():
    """Test the CLI."""
    runner = CliRunner()
    result = runner.invoke(cli.main)
    assert result.exit_code == 0
    assert "math_base.cli.main" in result.output
    help_result = runner.invoke(cli.main, ["--help"])
    assert help_result.exit_code == 0
    assert "--help  Show this message and exit." in help_result.output


def test_add():
    assert math_base.add(3, 4) == 7


def test_factorial_1():
    assert math_base.factorial(5) == 120


def test_factorial_2():
    assert math_base.factorial(2) == 2


def test_combination():
    assert math_base.combination(5, 2) == 60
