from enum import Enum


class Release(Enum):
    PRIVATE = 'PRIVATE'
    SHARED = 'SHARED'
    EXCERPTS = 'EXCERPTS'
    PUBLIC = 'PUBLIC'

    @classmethod
    def has_value(cls, value):
        return value in cls._value2member_map_

    @classmethod
    def get_name(cls, value):
        if value is None:
            value = 'PRIVATE'
        return cls._value2member_map_[value]

