"""
    NCBI Datasets API

    ### NCBI Datasets is a resource that lets you easily gather data from NCBI. The Datasets API is still in alpha, and we're updating it often to add new functionality, iron out bugs and enhance usability. For some larger downloads, you may want to download a [dehydrated bag](https://www.ncbi.nlm.nih.gov/datasets/docs/rehydrate/), and retrieve the individual data files at a later time.   # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from ncbi.datasets.openapi.api_client import ApiClient, Endpoint as _Endpoint
from ncbi.datasets.openapi.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from ncbi.datasets.openapi.model.rpc_status import RpcStatus
from ncbi.datasets.openapi.model.v1_annotation_for_virus_type import V1AnnotationForVirusType
from ncbi.datasets.openapi.model.v1_download_summary import V1DownloadSummary
from ncbi.datasets.openapi.model.v1_table_format import V1TableFormat
from ncbi.datasets.openapi.model.v1_tabular_output import V1TabularOutput
from ncbi.datasets.openapi.model.v1_virus_table_field import V1VirusTableField


class VirusApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.sars2_protein_download_endpoint = _Endpoint(
            settings={
                'response_type': (file_type,),
                'auth': [
                    'ApiKeyAuthHeader'
                ],
                'endpoint_path': '/virus/taxon/sars2/protein/{proteins}/download',
                'operation_id': 'sars2_protein_download',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'proteins',
                    'refseq_only',
                    'annotated_only',
                    'released_since',
                    'host',
                    'geo_location',
                    'complete_only',
                    'include_annotation_type',
                    'filename',
                ],
                'required': [
                    'proteins',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'proteins':
                        ([str],),
                    'refseq_only':
                        (bool,),
                    'annotated_only':
                        (bool,),
                    'released_since':
                        (datetime,),
                    'host':
                        (str,),
                    'geo_location':
                        (str,),
                    'complete_only':
                        (bool,),
                    'include_annotation_type':
                        ([V1AnnotationForVirusType],),
                    'filename':
                        (str,),
                },
                'attribute_map': {
                    'proteins': 'proteins',
                    'refseq_only': 'refseq_only',
                    'annotated_only': 'annotated_only',
                    'released_since': 'released_since',
                    'host': 'host',
                    'geo_location': 'geo_location',
                    'complete_only': 'complete_only',
                    'include_annotation_type': 'include_annotation_type',
                    'filename': 'filename',
                },
                'location_map': {
                    'proteins': 'path',
                    'refseq_only': 'query',
                    'annotated_only': 'query',
                    'released_since': 'query',
                    'host': 'query',
                    'geo_location': 'query',
                    'complete_only': 'query',
                    'include_annotation_type': 'query',
                    'filename': 'query',
                },
                'collection_format_map': {
                    'proteins': 'csv',
                    'include_annotation_type': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/zip',
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.sars2_protein_summary_endpoint = _Endpoint(
            settings={
                'response_type': (V1DownloadSummary,),
                'auth': [
                    'ApiKeyAuthHeader'
                ],
                'endpoint_path': '/virus/taxon/sars2/protein/{proteins}',
                'operation_id': 'sars2_protein_summary',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'proteins',
                    'refseq_only',
                    'annotated_only',
                    'released_since',
                    'host',
                    'geo_location',
                    'complete_only',
                    'include_annotation_type',
                ],
                'required': [
                    'proteins',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'proteins':
                        ([str],),
                    'refseq_only':
                        (bool,),
                    'annotated_only':
                        (bool,),
                    'released_since':
                        (datetime,),
                    'host':
                        (str,),
                    'geo_location':
                        (str,),
                    'complete_only':
                        (bool,),
                    'include_annotation_type':
                        ([V1AnnotationForVirusType],),
                },
                'attribute_map': {
                    'proteins': 'proteins',
                    'refseq_only': 'refseq_only',
                    'annotated_only': 'annotated_only',
                    'released_since': 'released_since',
                    'host': 'host',
                    'geo_location': 'geo_location',
                    'complete_only': 'complete_only',
                    'include_annotation_type': 'include_annotation_type',
                },
                'location_map': {
                    'proteins': 'path',
                    'refseq_only': 'query',
                    'annotated_only': 'query',
                    'released_since': 'query',
                    'host': 'query',
                    'geo_location': 'query',
                    'complete_only': 'query',
                    'include_annotation_type': 'query',
                },
                'collection_format_map': {
                    'proteins': 'csv',
                    'include_annotation_type': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.sars2_protein_table_endpoint = _Endpoint(
            settings={
                'response_type': (V1TabularOutput,),
                'auth': [
                    'ApiKeyAuthHeader'
                ],
                'endpoint_path': '/virus/taxon/sars2/protein/{proteins}/table',
                'operation_id': 'sars2_protein_table',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'proteins',
                    'refseq_only',
                    'annotated_only',
                    'released_since',
                    'host',
                    'geo_location',
                    'complete_only',
                    'table_fields',
                    'format',
                ],
                'required': [
                    'proteins',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'proteins':
                        ([str],),
                    'refseq_only':
                        (bool,),
                    'annotated_only':
                        (bool,),
                    'released_since':
                        (datetime,),
                    'host':
                        (str,),
                    'geo_location':
                        (str,),
                    'complete_only':
                        (bool,),
                    'table_fields':
                        ([V1VirusTableField],),
                    'format':
                        (V1TableFormat,),
                },
                'attribute_map': {
                    'proteins': 'proteins',
                    'refseq_only': 'refseq_only',
                    'annotated_only': 'annotated_only',
                    'released_since': 'released_since',
                    'host': 'host',
                    'geo_location': 'geo_location',
                    'complete_only': 'complete_only',
                    'table_fields': 'table_fields',
                    'format': 'format',
                },
                'location_map': {
                    'proteins': 'path',
                    'refseq_only': 'query',
                    'annotated_only': 'query',
                    'released_since': 'query',
                    'host': 'query',
                    'geo_location': 'query',
                    'complete_only': 'query',
                    'table_fields': 'query',
                    'format': 'query',
                },
                'collection_format_map': {
                    'proteins': 'csv',
                    'table_fields': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.virus_genome_download_endpoint = _Endpoint(
            settings={
                'response_type': (file_type,),
                'auth': [
                    'ApiKeyAuthHeader'
                ],
                'endpoint_path': '/virus/taxon/{taxon}/genome/download',
                'operation_id': 'virus_genome_download',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'taxon',
                    'refseq_only',
                    'annotated_only',
                    'released_since',
                    'host',
                    'pangolin_classification',
                    'geo_location',
                    'complete_only',
                    'exclude_sequence',
                    'include_annotation_type',
                    'filename',
                ],
                'required': [
                    'taxon',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'taxon':
                        (str,),
                    'refseq_only':
                        (bool,),
                    'annotated_only':
                        (bool,),
                    'released_since':
                        (datetime,),
                    'host':
                        (str,),
                    'pangolin_classification':
                        (str,),
                    'geo_location':
                        (str,),
                    'complete_only':
                        (bool,),
                    'exclude_sequence':
                        (bool,),
                    'include_annotation_type':
                        ([V1AnnotationForVirusType],),
                    'filename':
                        (str,),
                },
                'attribute_map': {
                    'taxon': 'taxon',
                    'refseq_only': 'refseq_only',
                    'annotated_only': 'annotated_only',
                    'released_since': 'released_since',
                    'host': 'host',
                    'pangolin_classification': 'pangolin_classification',
                    'geo_location': 'geo_location',
                    'complete_only': 'complete_only',
                    'exclude_sequence': 'exclude_sequence',
                    'include_annotation_type': 'include_annotation_type',
                    'filename': 'filename',
                },
                'location_map': {
                    'taxon': 'path',
                    'refseq_only': 'query',
                    'annotated_only': 'query',
                    'released_since': 'query',
                    'host': 'query',
                    'pangolin_classification': 'query',
                    'geo_location': 'query',
                    'complete_only': 'query',
                    'exclude_sequence': 'query',
                    'include_annotation_type': 'query',
                    'filename': 'query',
                },
                'collection_format_map': {
                    'include_annotation_type': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/zip',
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.virus_genome_summary_endpoint = _Endpoint(
            settings={
                'response_type': (V1DownloadSummary,),
                'auth': [
                    'ApiKeyAuthHeader'
                ],
                'endpoint_path': '/virus/taxon/{taxon}/genome',
                'operation_id': 'virus_genome_summary',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'taxon',
                    'refseq_only',
                    'annotated_only',
                    'released_since',
                    'host',
                    'pangolin_classification',
                    'geo_location',
                    'complete_only',
                    'exclude_sequence',
                    'include_annotation_type',
                ],
                'required': [
                    'taxon',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'taxon':
                        (str,),
                    'refseq_only':
                        (bool,),
                    'annotated_only':
                        (bool,),
                    'released_since':
                        (datetime,),
                    'host':
                        (str,),
                    'pangolin_classification':
                        (str,),
                    'geo_location':
                        (str,),
                    'complete_only':
                        (bool,),
                    'exclude_sequence':
                        (bool,),
                    'include_annotation_type':
                        ([V1AnnotationForVirusType],),
                },
                'attribute_map': {
                    'taxon': 'taxon',
                    'refseq_only': 'refseq_only',
                    'annotated_only': 'annotated_only',
                    'released_since': 'released_since',
                    'host': 'host',
                    'pangolin_classification': 'pangolin_classification',
                    'geo_location': 'geo_location',
                    'complete_only': 'complete_only',
                    'exclude_sequence': 'exclude_sequence',
                    'include_annotation_type': 'include_annotation_type',
                },
                'location_map': {
                    'taxon': 'path',
                    'refseq_only': 'query',
                    'annotated_only': 'query',
                    'released_since': 'query',
                    'host': 'query',
                    'pangolin_classification': 'query',
                    'geo_location': 'query',
                    'complete_only': 'query',
                    'exclude_sequence': 'query',
                    'include_annotation_type': 'query',
                },
                'collection_format_map': {
                    'include_annotation_type': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.virus_genome_table_endpoint = _Endpoint(
            settings={
                'response_type': (V1TabularOutput,),
                'auth': [
                    'ApiKeyAuthHeader'
                ],
                'endpoint_path': '/virus/taxon/{taxon}/genome/table',
                'operation_id': 'virus_genome_table',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'taxon',
                    'refseq_only',
                    'annotated_only',
                    'released_since',
                    'host',
                    'pangolin_classification',
                    'geo_location',
                    'complete_only',
                    'table_fields',
                    'format',
                ],
                'required': [
                    'taxon',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'taxon':
                        (str,),
                    'refseq_only':
                        (bool,),
                    'annotated_only':
                        (bool,),
                    'released_since':
                        (datetime,),
                    'host':
                        (str,),
                    'pangolin_classification':
                        (str,),
                    'geo_location':
                        (str,),
                    'complete_only':
                        (bool,),
                    'table_fields':
                        ([V1VirusTableField],),
                    'format':
                        (V1TableFormat,),
                },
                'attribute_map': {
                    'taxon': 'taxon',
                    'refseq_only': 'refseq_only',
                    'annotated_only': 'annotated_only',
                    'released_since': 'released_since',
                    'host': 'host',
                    'pangolin_classification': 'pangolin_classification',
                    'geo_location': 'geo_location',
                    'complete_only': 'complete_only',
                    'table_fields': 'table_fields',
                    'format': 'format',
                },
                'location_map': {
                    'taxon': 'path',
                    'refseq_only': 'query',
                    'annotated_only': 'query',
                    'released_since': 'query',
                    'host': 'query',
                    'pangolin_classification': 'query',
                    'geo_location': 'query',
                    'complete_only': 'query',
                    'table_fields': 'query',
                    'format': 'query',
                },
                'collection_format_map': {
                    'table_fields': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def sars2_protein_download(
        self,
        proteins,
        accept=None,
        **kwargs
    ):
        """Download SARS-CoV-2 protein and CDS datasets by protein name  # noqa: E501

        Download a SARS-CoV-2 protein datasets  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.sars2_protein_download(proteins, async_req=True)
        >>> result = thread.get()

        Args:
            proteins ([str]): Which proteins to retrieve in the data package

        Keyword Args:
            refseq_only (bool): If true, limit results to RefSeq genomes.. [optional] if omitted the server will use the default value of False
            annotated_only (bool): If true, limit results to annotated genomes.. [optional] if omitted the server will use the default value of False
            released_since (datetime): If set, limit results to viral genomes that have been released after a specified date (and optionally, time). April 1, 2020 midnight UTC should be formatted as '2020-04-01T00:00:00.000Z'. [optional]
            host (str): If set, limit results to genomes extracted from this host (Taxonomy ID or name) All hosts by default. [optional]
            geo_location (str): Assemblies from this location (country and state, or continent). [optional]
            complete_only (bool): only include complete genomes.. [optional] if omitted the server will use the default value of False
            include_annotation_type ([V1AnnotationForVirusType]): Select additional types of annotation to include in the data package.  If unset, no annotation is provided.. [optional]
            filename (str): Output file name.. [optional] if omitted the server will use the default value of "ncbi_dataset.zip"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            file_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['proteins'] = \
            proteins
        if accept and self.sars2_protein_download_endpoint.headers_map:
            updated_header_maps = self.sars2_protein_download_endpoint.headers_map.copy()
            if accept in updated_header_maps:
                updated_header_maps['accept'] = [accept]
                self.sars2_protein_download_endpoint.headers_map = updated_header_maps

        return self.sars2_protein_download_endpoint.call_with_http_info(**kwargs)

    def sars2_protein_summary(
        self,
        proteins,
        accept=None,
        **kwargs
    ):
        """Summary of SARS-CoV-2 protein and CDS datasets by protein name  # noqa: E501

        Download a summary of available SARS-CoV-2 protein datasets  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.sars2_protein_summary(proteins, async_req=True)
        >>> result = thread.get()

        Args:
            proteins ([str]): Which proteins to retrieve in the data package

        Keyword Args:
            refseq_only (bool): If true, limit results to RefSeq genomes.. [optional] if omitted the server will use the default value of False
            annotated_only (bool): If true, limit results to annotated genomes.. [optional] if omitted the server will use the default value of False
            released_since (datetime): If set, limit results to viral genomes that have been released after a specified date (and optionally, time). April 1, 2020 midnight UTC should be formatted as '2020-04-01T00:00:00.000Z'. [optional]
            host (str): If set, limit results to genomes extracted from this host (Taxonomy ID or name) All hosts by default. [optional]
            geo_location (str): Assemblies from this location (country and state, or continent). [optional]
            complete_only (bool): only include complete genomes.. [optional] if omitted the server will use the default value of False
            include_annotation_type ([V1AnnotationForVirusType]): Select additional types of annotation to include in the data package.  If unset, no annotation is provided.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1DownloadSummary
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['proteins'] = \
            proteins
        if accept and self.sars2_protein_summary_endpoint.headers_map:
            updated_header_maps = self.sars2_protein_summary_endpoint.headers_map.copy()
            if accept in updated_header_maps:
                updated_header_maps['accept'] = [accept]
                self.sars2_protein_summary_endpoint.headers_map = updated_header_maps

        return self.sars2_protein_summary_endpoint.call_with_http_info(**kwargs)

    def sars2_protein_table(
        self,
        proteins,
        accept=None,
        **kwargs
    ):
        """Get SARS-CoV-2 protein metadata in a tabular format.  # noqa: E501

        Get protein metadata in tabular format for SARS-CoV-2 genomes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.sars2_protein_table(proteins, async_req=True)
        >>> result = thread.get()

        Args:
            proteins ([str]): Which proteins to retrieve in the data package

        Keyword Args:
            refseq_only (bool): If true, limit results to RefSeq genomes.. [optional] if omitted the server will use the default value of False
            annotated_only (bool): If true, limit results to annotated genomes.. [optional] if omitted the server will use the default value of False
            released_since (datetime): If set, limit results to viral genomes that have been released after a specified date (and optionally, time). April 1, 2020 midnight UTC should be formatted as '2020-04-01T00:00:00.000Z'. [optional]
            host (str): If set, limit results to genomes extracted from this host (Taxonomy ID or name) All hosts by default. [optional]
            geo_location (str): Assemblies from this location (country and state, or continent). [optional]
            complete_only (bool): only include complete genomes.. [optional] if omitted the server will use the default value of False
            table_fields ([V1VirusTableField]): Specify which fields to include in the tabular report. [optional]
            format (V1TableFormat): Choose download format (tsv, csv or jsonl). [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1TabularOutput
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['proteins'] = \
            proteins
        if accept and self.sars2_protein_table_endpoint.headers_map:
            updated_header_maps = self.sars2_protein_table_endpoint.headers_map.copy()
            if accept in updated_header_maps:
                updated_header_maps['accept'] = [accept]
                self.sars2_protein_table_endpoint.headers_map = updated_header_maps

        return self.sars2_protein_table_endpoint.call_with_http_info(**kwargs)

    def virus_genome_download(
        self,
        taxon,
        accept=None,
        **kwargs
    ):
        """Download Coronavirus genome datasets by taxon  # noqa: E501

        Download a Coronavirus genome datasets by taxon  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.virus_genome_download(taxon, async_req=True)
        >>> result = thread.get()

        Args:
            taxon (str): NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank

        Keyword Args:
            refseq_only (bool): If true, limit results to RefSeq genomes.. [optional] if omitted the server will use the default value of False
            annotated_only (bool): If true, limit results to annotated genomes.. [optional] if omitted the server will use the default value of False
            released_since (datetime): If set, limit results to viral genomes that have been released after a specified date (and optionally, time). April 1, 2020 midnight UTC should be formatted as '2020-04-01T00:00:00.000Z'. [optional]
            host (str): If set, limit results to genomes extracted from this host (Taxonomy ID or name) All hosts by default. [optional]
            pangolin_classification (str): If set, limit results to genomes classified to this lineage by the PangoLearn tool.. [optional]
            geo_location (str): Assemblies from this location (country and state, or continent). [optional]
            complete_only (bool): only include complete genomes.. [optional] if omitted the server will use the default value of False
            exclude_sequence (bool): Set to true to omit the genomic sequence.. [optional] if omitted the server will use the default value of False
            include_annotation_type ([V1AnnotationForVirusType]): Select additional types of annotation to include in the data package.  If unset, no annotation is provided.. [optional]
            filename (str): Output file name.. [optional] if omitted the server will use the default value of "ncbi_dataset.zip"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            file_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['taxon'] = \
            taxon
        if accept and self.virus_genome_download_endpoint.headers_map:
            updated_header_maps = self.virus_genome_download_endpoint.headers_map.copy()
            if accept in updated_header_maps:
                updated_header_maps['accept'] = [accept]
                self.virus_genome_download_endpoint.headers_map = updated_header_maps

        return self.virus_genome_download_endpoint.call_with_http_info(**kwargs)

    def virus_genome_summary(
        self,
        taxon,
        accept=None,
        **kwargs
    ):
        """Get summary data for Coronaviridae genomes by taxon  # noqa: E501

        Get summary data and download by command line instructions for Coronaviridae genomes by taxon.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.virus_genome_summary(taxon, async_req=True)
        >>> result = thread.get()

        Args:
            taxon (str): NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank

        Keyword Args:
            refseq_only (bool): If true, limit results to RefSeq genomes.. [optional] if omitted the server will use the default value of False
            annotated_only (bool): If true, limit results to annotated genomes.. [optional] if omitted the server will use the default value of False
            released_since (datetime): If set, limit results to viral genomes that have been released after a specified date (and optionally, time). April 1, 2020 midnight UTC should be formatted as '2020-04-01T00:00:00.000Z'. [optional]
            host (str): If set, limit results to genomes extracted from this host (Taxonomy ID or name) All hosts by default. [optional]
            pangolin_classification (str): If set, limit results to genomes classified to this lineage by the PangoLearn tool.. [optional]
            geo_location (str): Assemblies from this location (country and state, or continent). [optional]
            complete_only (bool): only include complete genomes.. [optional] if omitted the server will use the default value of False
            exclude_sequence (bool): Set to true to omit the genomic sequence.. [optional] if omitted the server will use the default value of False
            include_annotation_type ([V1AnnotationForVirusType]): Select additional types of annotation to include in the data package.  If unset, no annotation is provided.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1DownloadSummary
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['taxon'] = \
            taxon
        if accept and self.virus_genome_summary_endpoint.headers_map:
            updated_header_maps = self.virus_genome_summary_endpoint.headers_map.copy()
            if accept in updated_header_maps:
                updated_header_maps['accept'] = [accept]
                self.virus_genome_summary_endpoint.headers_map = updated_header_maps

        return self.virus_genome_summary_endpoint.call_with_http_info(**kwargs)

    def virus_genome_table(
        self,
        taxon,
        accept=None,
        **kwargs
    ):
        """Get viral genomic metadata in a tabular format.  # noqa: E501

        Get viral genomic metadata in tabular format for Coronaviridae genomes by taxon.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.virus_genome_table(taxon, async_req=True)
        >>> result = thread.get()

        Args:
            taxon (str): NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank

        Keyword Args:
            refseq_only (bool): If true, limit results to RefSeq genomes.. [optional] if omitted the server will use the default value of False
            annotated_only (bool): If true, limit results to annotated genomes.. [optional] if omitted the server will use the default value of False
            released_since (datetime): If set, limit results to viral genomes that have been released after a specified date (and optionally, time). April 1, 2020 midnight UTC should be formatted as '2020-04-01T00:00:00.000Z'. [optional]
            host (str): If set, limit results to genomes extracted from this host (Taxonomy ID or name) All hosts by default. [optional]
            pangolin_classification (str): If set, limit results to genomes classified to this lineage by the PangoLearn tool.. [optional]
            geo_location (str): Assemblies from this location (country and state, or continent). [optional]
            complete_only (bool): only include complete genomes.. [optional] if omitted the server will use the default value of False
            table_fields ([V1VirusTableField]): Specify which fields to include in the tabular report. [optional]
            format (V1TableFormat): Choose download format (tsv, csv or jsonl). [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1TabularOutput
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['taxon'] = \
            taxon
        if accept and self.virus_genome_table_endpoint.headers_map:
            updated_header_maps = self.virus_genome_table_endpoint.headers_map.copy()
            if accept in updated_header_maps:
                updated_header_maps['accept'] = [accept]
                self.virus_genome_table_endpoint.headers_map = updated_header_maps

        return self.virus_genome_table_endpoint.call_with_http_info(**kwargs)

