import setuptools

with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

setuptools.setup(
    name="django-snowflake-backend",
    version="1.0.1",
    author="Ben Ryan",
    author_email="bkr@bu.edu",
    description="Snowflake backend for django",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/benryan2010/django-snowflake-backend",
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
    python_requires='>=3.6',
    install_requires=[
        'snowflake-connector-python==2.3.8',
        'asn1crypto==1.4.0',
        'azure-common==1.1.25',
        'azure-core==1.8.2',
        'azure-storage-blob==12.5.0',
        'boto3==1.15.18',
        'botocore==1.18.18',
        'certifi==2020.6.20',
        'cffi==1.14.3',
        'chardet==3.0.4',
        'cryptography==2.9.2',
        'idna==2.10',
        'isodate==0.6.0',
        'jmespath==0.10.0',
        'msrest==0.6.19',
        'oauthlib==3.1.0',
        'oscrypto==1.2.1',
        'pycparser==2.20',
        'pycryptodomex==3.9.8',
        'PyJWT==1.7.1',
        'pyOpenSSL==19.1.0',
        'python-dateutil==2.8.1',
        'pytz==2020.1',
        'requests==2.23.0',
        'requests-oauthlib==1.3.0',
        's3transfer==0.3.3',
        'six==1.15.0',
        'urllib3==1.25.11',
        'django>=2.2'
    ]
)
