# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetConnectorResult',
    'AwaitableGetConnectorResult',
    'get_connector',
    'get_connector_output',
]

@pulumi.output_type
class GetConnectorResult:
    def __init__(__self__, access_role=None, arn=None, as2_config=None, connector_id=None, logging_role=None, tags=None, url=None):
        if access_role and not isinstance(access_role, str):
            raise TypeError("Expected argument 'access_role' to be a str")
        pulumi.set(__self__, "access_role", access_role)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if as2_config and not isinstance(as2_config, dict):
            raise TypeError("Expected argument 'as2_config' to be a dict")
        pulumi.set(__self__, "as2_config", as2_config)
        if connector_id and not isinstance(connector_id, str):
            raise TypeError("Expected argument 'connector_id' to be a str")
        pulumi.set(__self__, "connector_id", connector_id)
        if logging_role and not isinstance(logging_role, str):
            raise TypeError("Expected argument 'logging_role' to be a str")
        pulumi.set(__self__, "logging_role", logging_role)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if url and not isinstance(url, str):
            raise TypeError("Expected argument 'url' to be a str")
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="accessRole")
    def access_role(self) -> Optional[str]:
        """
        Specifies the access role for the connector.
        """
        return pulumi.get(self, "access_role")

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        Specifies the unique Amazon Resource Name (ARN) for the workflow.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="as2Config")
    def as2_config(self) -> Optional['outputs.As2ConfigProperties']:
        """
        Configuration for an AS2 connector.
        """
        return pulumi.get(self, "as2_config")

    @property
    @pulumi.getter(name="connectorId")
    def connector_id(self) -> Optional[str]:
        """
        A unique identifier for the connector.
        """
        return pulumi.get(self, "connector_id")

    @property
    @pulumi.getter(name="loggingRole")
    def logging_role(self) -> Optional[str]:
        """
        Specifies the logging role for the connector.
        """
        return pulumi.get(self, "logging_role")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.ConnectorTag']]:
        """
        Key-value pairs that can be used to group and search for workflows. Tags are metadata attached to workflows for any purpose.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        URL for Connector
        """
        return pulumi.get(self, "url")


class AwaitableGetConnectorResult(GetConnectorResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConnectorResult(
            access_role=self.access_role,
            arn=self.arn,
            as2_config=self.as2_config,
            connector_id=self.connector_id,
            logging_role=self.logging_role,
            tags=self.tags,
            url=self.url)


def get_connector(connector_id: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConnectorResult:
    """
    Resource Type definition for AWS::Transfer::Connector


    :param str connector_id: A unique identifier for the connector.
    """
    __args__ = dict()
    __args__['connectorId'] = connector_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:transfer:getConnector', __args__, opts=opts, typ=GetConnectorResult).value

    return AwaitableGetConnectorResult(
        access_role=__ret__.access_role,
        arn=__ret__.arn,
        as2_config=__ret__.as2_config,
        connector_id=__ret__.connector_id,
        logging_role=__ret__.logging_role,
        tags=__ret__.tags,
        url=__ret__.url)


@_utilities.lift_output_func(get_connector)
def get_connector_output(connector_id: Optional[pulumi.Input[str]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetConnectorResult]:
    """
    Resource Type definition for AWS::Transfer::Connector


    :param str connector_id: A unique identifier for the connector.
    """
    ...
