# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetTopicResult',
    'AwaitableGetTopicResult',
    'get_topic',
    'get_topic_output',
]

@pulumi.output_type
class GetTopicResult:
    def __init__(__self__, content_based_deduplication=None, data_protection_policy=None, display_name=None, kms_master_key_id=None, subscription=None, tags=None, topic_arn=None):
        if content_based_deduplication and not isinstance(content_based_deduplication, bool):
            raise TypeError("Expected argument 'content_based_deduplication' to be a bool")
        pulumi.set(__self__, "content_based_deduplication", content_based_deduplication)
        if data_protection_policy and not isinstance(data_protection_policy, dict):
            raise TypeError("Expected argument 'data_protection_policy' to be a dict")
        pulumi.set(__self__, "data_protection_policy", data_protection_policy)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if kms_master_key_id and not isinstance(kms_master_key_id, str):
            raise TypeError("Expected argument 'kms_master_key_id' to be a str")
        pulumi.set(__self__, "kms_master_key_id", kms_master_key_id)
        if subscription and not isinstance(subscription, list):
            raise TypeError("Expected argument 'subscription' to be a list")
        pulumi.set(__self__, "subscription", subscription)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if topic_arn and not isinstance(topic_arn, str):
            raise TypeError("Expected argument 'topic_arn' to be a str")
        pulumi.set(__self__, "topic_arn", topic_arn)

    @property
    @pulumi.getter(name="contentBasedDeduplication")
    def content_based_deduplication(self) -> Optional[bool]:
        """
        Enables content-based deduplication for FIFO topics. By default, ContentBasedDeduplication is set to false. If you create a FIFO topic and this attribute is false, you must specify a value for the MessageDeduplicationId parameter for the Publish action.

        When you set ContentBasedDeduplication to true, Amazon SNS uses a SHA-256 hash to generate the MessageDeduplicationId using the body of the message (but not the attributes of the message).

        (Optional) To override the generated value, you can specify a value for the the MessageDeduplicationId parameter for the Publish action.
        """
        return pulumi.get(self, "content_based_deduplication")

    @property
    @pulumi.getter(name="dataProtectionPolicy")
    def data_protection_policy(self) -> Optional[Any]:
        """
        The body of the policy document you want to use for this topic.

        You can only add one policy per topic.

        The policy must be in JSON string format.

        Length Constraints: Maximum length of 30720
        """
        return pulumi.get(self, "data_protection_policy")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The display name to use for an Amazon SNS topic with SMS subscriptions.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="kmsMasterKeyId")
    def kms_master_key_id(self) -> Optional[str]:
        """
        The ID of an AWS-managed customer master key (CMK) for Amazon SNS or a custom CMK. For more information, see Key Terms. For more examples, see KeyId in the AWS Key Management Service API Reference.

        This property applies only to [server-side-encryption](https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html).
        """
        return pulumi.get(self, "kms_master_key_id")

    @property
    @pulumi.getter
    def subscription(self) -> Optional[Sequence['outputs.TopicSubscription']]:
        """
        The SNS subscriptions (endpoints) for this topic.
        """
        return pulumi.get(self, "subscription")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.TopicTag']]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="topicArn")
    def topic_arn(self) -> Optional[str]:
        return pulumi.get(self, "topic_arn")


class AwaitableGetTopicResult(GetTopicResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTopicResult(
            content_based_deduplication=self.content_based_deduplication,
            data_protection_policy=self.data_protection_policy,
            display_name=self.display_name,
            kms_master_key_id=self.kms_master_key_id,
            subscription=self.subscription,
            tags=self.tags,
            topic_arn=self.topic_arn)


def get_topic(topic_arn: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTopicResult:
    """
    Resource Type definition for AWS::SNS::Topic
    """
    __args__ = dict()
    __args__['topicArn'] = topic_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:sns:getTopic', __args__, opts=opts, typ=GetTopicResult).value

    return AwaitableGetTopicResult(
        content_based_deduplication=__ret__.content_based_deduplication,
        data_protection_policy=__ret__.data_protection_policy,
        display_name=__ret__.display_name,
        kms_master_key_id=__ret__.kms_master_key_id,
        subscription=__ret__.subscription,
        tags=__ret__.tags,
        topic_arn=__ret__.topic_arn)


@_utilities.lift_output_func(get_topic)
def get_topic_output(topic_arn: Optional[pulumi.Input[str]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTopicResult]:
    """
    Resource Type definition for AWS::SNS::Topic
    """
    ...
