# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AccessPointPublicAccessBlockConfiguration',
    'AccessPointVpcConfiguration',
    'BucketAbortIncompleteMultipartUpload',
    'BucketAccelerateConfiguration',
    'BucketAccessControlTranslation',
    'BucketAnalyticsConfiguration',
    'BucketCorsConfiguration',
    'BucketCorsRule',
    'BucketDataExport',
    'BucketDefaultRetention',
    'BucketDeleteMarkerReplication',
    'BucketDestination',
    'BucketEncryption',
    'BucketEncryptionConfiguration',
    'BucketEventBridgeConfiguration',
    'BucketFilterRule',
    'BucketIntelligentTieringConfiguration',
    'BucketInventoryConfiguration',
    'BucketLambdaConfiguration',
    'BucketLifecycleConfiguration',
    'BucketLoggingConfiguration',
    'BucketMetrics',
    'BucketMetricsConfiguration',
    'BucketNoncurrentVersionExpiration',
    'BucketNoncurrentVersionTransition',
    'BucketNotificationConfiguration',
    'BucketNotificationFilter',
    'BucketObjectLockConfiguration',
    'BucketObjectLockRule',
    'BucketOwnershipControls',
    'BucketOwnershipControlsRule',
    'BucketPublicAccessBlockConfiguration',
    'BucketQueueConfiguration',
    'BucketRedirectAllRequestsTo',
    'BucketRedirectRule',
    'BucketReplicaModifications',
    'BucketReplicationConfiguration',
    'BucketReplicationDestination',
    'BucketReplicationRule',
    'BucketReplicationRuleAndOperator',
    'BucketReplicationRuleFilter',
    'BucketReplicationTime',
    'BucketReplicationTimeValue',
    'BucketRoutingRule',
    'BucketRoutingRuleCondition',
    'BucketRule',
    'BucketS3KeyFilter',
    'BucketServerSideEncryptionByDefault',
    'BucketServerSideEncryptionRule',
    'BucketSourceSelectionCriteria',
    'BucketSseKmsEncryptedObjects',
    'BucketStorageClassAnalysis',
    'BucketTag',
    'BucketTagFilter',
    'BucketTiering',
    'BucketTopicConfiguration',
    'BucketTransition',
    'BucketVersioningConfiguration',
    'BucketWebsiteConfiguration',
    'MultiRegionAccessPointPublicAccessBlockConfiguration',
    'MultiRegionAccessPointRegion',
    'PolicyStatusProperties',
    'StorageLensAccountLevel',
    'StorageLensActivityMetrics',
    'StorageLensAwsOrg',
    'StorageLensBucketLevel',
    'StorageLensBucketsAndRegions',
    'StorageLensCloudWatchMetrics',
    'StorageLensConfiguration',
    'StorageLensDataExport',
    'StorageLensEncryption',
    'StorageLensPrefixLevel',
    'StorageLensPrefixLevelStorageMetrics',
    'StorageLensS3BucketDestination',
    'StorageLensSelectionCriteria',
    'StorageLensTag',
]

@pulumi.output_type
class AccessPointPublicAccessBlockConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blockPublicAcls":
            suggest = "block_public_acls"
        elif key == "blockPublicPolicy":
            suggest = "block_public_policy"
        elif key == "ignorePublicAcls":
            suggest = "ignore_public_acls"
        elif key == "restrictPublicBuckets":
            suggest = "restrict_public_buckets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessPointPublicAccessBlockConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessPointPublicAccessBlockConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessPointPublicAccessBlockConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 block_public_acls: Optional[bool] = None,
                 block_public_policy: Optional[bool] = None,
                 ignore_public_acls: Optional[bool] = None,
                 restrict_public_buckets: Optional[bool] = None):
        """
        :param bool block_public_acls: Specifies whether Amazon S3 should block public access control lists (ACLs) for buckets in this account. Setting this element to TRUE causes the following behavior:
               - PUT Bucket acl and PUT Object acl calls fail if the specified ACL is public.
                - PUT Object calls fail if the request includes a public ACL.
               . - PUT Bucket calls fail if the request includes a public ACL.
               Enabling this setting doesn't affect existing policies or ACLs.
        :param bool block_public_policy: Specifies whether Amazon S3 should block public bucket policies for buckets in this account. Setting this element to TRUE causes Amazon S3 to reject calls to PUT Bucket policy if the specified bucket policy allows public access. Enabling this setting doesn't affect existing bucket policies.
        :param bool ignore_public_acls: Specifies whether Amazon S3 should ignore public ACLs for buckets in this account. Setting this element to TRUE causes Amazon S3 to ignore all public ACLs on buckets in this account and any objects that they contain. Enabling this setting doesn't affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set.
        :param bool restrict_public_buckets: Specifies whether Amazon S3 should restrict public bucket policies for this bucket. Setting this element to TRUE restricts access to this bucket to only AWS services and authorized users within this account if the bucket has a public policy.
               Enabling this setting doesn't affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked.
        """
        if block_public_acls is not None:
            pulumi.set(__self__, "block_public_acls", block_public_acls)
        if block_public_policy is not None:
            pulumi.set(__self__, "block_public_policy", block_public_policy)
        if ignore_public_acls is not None:
            pulumi.set(__self__, "ignore_public_acls", ignore_public_acls)
        if restrict_public_buckets is not None:
            pulumi.set(__self__, "restrict_public_buckets", restrict_public_buckets)

    @property
    @pulumi.getter(name="blockPublicAcls")
    def block_public_acls(self) -> Optional[bool]:
        """
        Specifies whether Amazon S3 should block public access control lists (ACLs) for buckets in this account. Setting this element to TRUE causes the following behavior:
        - PUT Bucket acl and PUT Object acl calls fail if the specified ACL is public.
         - PUT Object calls fail if the request includes a public ACL.
        . - PUT Bucket calls fail if the request includes a public ACL.
        Enabling this setting doesn't affect existing policies or ACLs.
        """
        return pulumi.get(self, "block_public_acls")

    @property
    @pulumi.getter(name="blockPublicPolicy")
    def block_public_policy(self) -> Optional[bool]:
        """
        Specifies whether Amazon S3 should block public bucket policies for buckets in this account. Setting this element to TRUE causes Amazon S3 to reject calls to PUT Bucket policy if the specified bucket policy allows public access. Enabling this setting doesn't affect existing bucket policies.
        """
        return pulumi.get(self, "block_public_policy")

    @property
    @pulumi.getter(name="ignorePublicAcls")
    def ignore_public_acls(self) -> Optional[bool]:
        """
        Specifies whether Amazon S3 should ignore public ACLs for buckets in this account. Setting this element to TRUE causes Amazon S3 to ignore all public ACLs on buckets in this account and any objects that they contain. Enabling this setting doesn't affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set.
        """
        return pulumi.get(self, "ignore_public_acls")

    @property
    @pulumi.getter(name="restrictPublicBuckets")
    def restrict_public_buckets(self) -> Optional[bool]:
        """
        Specifies whether Amazon S3 should restrict public bucket policies for this bucket. Setting this element to TRUE restricts access to this bucket to only AWS services and authorized users within this account if the bucket has a public policy.
        Enabling this setting doesn't affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked.
        """
        return pulumi.get(self, "restrict_public_buckets")


@pulumi.output_type
class AccessPointVpcConfiguration(dict):
    """
    The Virtual Private Cloud (VPC) configuration for a bucket access point.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vpcId":
            suggest = "vpc_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessPointVpcConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessPointVpcConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessPointVpcConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vpc_id: Optional[str] = None):
        """
        The Virtual Private Cloud (VPC) configuration for a bucket access point.
        :param str vpc_id: If this field is specified, this access point will only allow connections from the specified VPC ID.
        """
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[str]:
        """
        If this field is specified, this access point will only allow connections from the specified VPC ID.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class BucketAbortIncompleteMultipartUpload(dict):
    """
    Specifies the days since the initiation of an incomplete multipart upload that Amazon S3 will wait before permanently removing all parts of the upload.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "daysAfterInitiation":
            suggest = "days_after_initiation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketAbortIncompleteMultipartUpload. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketAbortIncompleteMultipartUpload.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketAbortIncompleteMultipartUpload.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 days_after_initiation: int):
        """
        Specifies the days since the initiation of an incomplete multipart upload that Amazon S3 will wait before permanently removing all parts of the upload.
        :param int days_after_initiation: Specifies the number of days after which Amazon S3 aborts an incomplete multipart upload.
        """
        pulumi.set(__self__, "days_after_initiation", days_after_initiation)

    @property
    @pulumi.getter(name="daysAfterInitiation")
    def days_after_initiation(self) -> int:
        """
        Specifies the number of days after which Amazon S3 aborts an incomplete multipart upload.
        """
        return pulumi.get(self, "days_after_initiation")


@pulumi.output_type
class BucketAccelerateConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accelerationStatus":
            suggest = "acceleration_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketAccelerateConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketAccelerateConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketAccelerateConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 acceleration_status: 'BucketAccelerateConfigurationAccelerationStatus'):
        """
        :param 'BucketAccelerateConfigurationAccelerationStatus' acceleration_status: Configures the transfer acceleration state for an Amazon S3 bucket.
        """
        pulumi.set(__self__, "acceleration_status", acceleration_status)

    @property
    @pulumi.getter(name="accelerationStatus")
    def acceleration_status(self) -> 'BucketAccelerateConfigurationAccelerationStatus':
        """
        Configures the transfer acceleration state for an Amazon S3 bucket.
        """
        return pulumi.get(self, "acceleration_status")


@pulumi.output_type
class BucketAccessControlTranslation(dict):
    """
    Specify this only in a cross-account scenario (where source and destination bucket owners are not the same), and you want to change replica ownership to the AWS account that owns the destination bucket. If this is not specified in the replication configuration, the replicas are owned by same AWS account that owns the source object.
    """
    def __init__(__self__, *,
                 owner: str):
        """
        Specify this only in a cross-account scenario (where source and destination bucket owners are not the same), and you want to change replica ownership to the AWS account that owns the destination bucket. If this is not specified in the replication configuration, the replicas are owned by same AWS account that owns the source object.
        """
        pulumi.set(__self__, "owner", owner)

    @property
    @pulumi.getter
    def owner(self) -> str:
        return pulumi.get(self, "owner")


@pulumi.output_type
class BucketAnalyticsConfiguration(dict):
    """
    Specifies the configuration and any analyses for the analytics filter of an Amazon S3 bucket.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageClassAnalysis":
            suggest = "storage_class_analysis"
        elif key == "tagFilters":
            suggest = "tag_filters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketAnalyticsConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketAnalyticsConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketAnalyticsConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 storage_class_analysis: 'outputs.BucketStorageClassAnalysis',
                 prefix: Optional[str] = None,
                 tag_filters: Optional[Sequence['outputs.BucketTagFilter']] = None):
        """
        Specifies the configuration and any analyses for the analytics filter of an Amazon S3 bucket.
        :param str id: The ID that identifies the analytics configuration.
        :param str prefix: The prefix that an object must have to be included in the analytics results.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "storage_class_analysis", storage_class_analysis)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if tag_filters is not None:
            pulumi.set(__self__, "tag_filters", tag_filters)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID that identifies the analytics configuration.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="storageClassAnalysis")
    def storage_class_analysis(self) -> 'outputs.BucketStorageClassAnalysis':
        return pulumi.get(self, "storage_class_analysis")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        The prefix that an object must have to be included in the analytics results.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter(name="tagFilters")
    def tag_filters(self) -> Optional[Sequence['outputs.BucketTagFilter']]:
        return pulumi.get(self, "tag_filters")


@pulumi.output_type
class BucketCorsConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "corsRules":
            suggest = "cors_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketCorsConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketCorsConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketCorsConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cors_rules: Sequence['outputs.BucketCorsRule']):
        pulumi.set(__self__, "cors_rules", cors_rules)

    @property
    @pulumi.getter(name="corsRules")
    def cors_rules(self) -> Sequence['outputs.BucketCorsRule']:
        return pulumi.get(self, "cors_rules")


@pulumi.output_type
class BucketCorsRule(dict):
    """
    A set of origins and methods (cross-origin access that you want to allow). You can add up to 100 rules to the configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedMethods":
            suggest = "allowed_methods"
        elif key == "allowedOrigins":
            suggest = "allowed_origins"
        elif key == "allowedHeaders":
            suggest = "allowed_headers"
        elif key == "exposedHeaders":
            suggest = "exposed_headers"
        elif key == "maxAge":
            suggest = "max_age"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketCorsRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketCorsRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketCorsRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_methods: Sequence['BucketCorsRuleAllowedMethodsItem'],
                 allowed_origins: Sequence[str],
                 allowed_headers: Optional[Sequence[str]] = None,
                 exposed_headers: Optional[Sequence[str]] = None,
                 id: Optional[str] = None,
                 max_age: Optional[int] = None):
        """
        A set of origins and methods (cross-origin access that you want to allow). You can add up to 100 rules to the configuration.
        :param Sequence['BucketCorsRuleAllowedMethodsItem'] allowed_methods: An HTTP method that you allow the origin to execute.
        :param Sequence[str] allowed_origins: One or more origins you want customers to be able to access the bucket from.
        :param Sequence[str] allowed_headers: Headers that are specified in the Access-Control-Request-Headers header.
        :param Sequence[str] exposed_headers: One or more headers in the response that you want customers to be able to access from their applications (for example, from a JavaScript XMLHttpRequest object).
        :param str id: A unique identifier for this rule.
        :param int max_age: The time in seconds that your browser is to cache the preflight response for the specified resource.
        """
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        if allowed_headers is not None:
            pulumi.set(__self__, "allowed_headers", allowed_headers)
        if exposed_headers is not None:
            pulumi.set(__self__, "exposed_headers", exposed_headers)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if max_age is not None:
            pulumi.set(__self__, "max_age", max_age)

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Sequence['BucketCorsRuleAllowedMethodsItem']:
        """
        An HTTP method that you allow the origin to execute.
        """
        return pulumi.get(self, "allowed_methods")

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Sequence[str]:
        """
        One or more origins you want customers to be able to access the bucket from.
        """
        return pulumi.get(self, "allowed_origins")

    @property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Optional[Sequence[str]]:
        """
        Headers that are specified in the Access-Control-Request-Headers header.
        """
        return pulumi.get(self, "allowed_headers")

    @property
    @pulumi.getter(name="exposedHeaders")
    def exposed_headers(self) -> Optional[Sequence[str]]:
        """
        One or more headers in the response that you want customers to be able to access from their applications (for example, from a JavaScript XMLHttpRequest object).
        """
        return pulumi.get(self, "exposed_headers")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        A unique identifier for this rule.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="maxAge")
    def max_age(self) -> Optional[int]:
        """
        The time in seconds that your browser is to cache the preflight response for the specified resource.
        """
        return pulumi.get(self, "max_age")


@pulumi.output_type
class BucketDataExport(dict):
    """
    Specifies how data related to the storage class analysis for an Amazon S3 bucket should be exported.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "outputSchemaVersion":
            suggest = "output_schema_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketDataExport. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketDataExport.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketDataExport.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination: 'outputs.BucketDestination',
                 output_schema_version: str):
        """
        Specifies how data related to the storage class analysis for an Amazon S3 bucket should be exported.
        :param str output_schema_version: The version of the output schema to use when exporting data.
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "output_schema_version", output_schema_version)

    @property
    @pulumi.getter
    def destination(self) -> 'outputs.BucketDestination':
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter(name="outputSchemaVersion")
    def output_schema_version(self) -> str:
        """
        The version of the output schema to use when exporting data.
        """
        return pulumi.get(self, "output_schema_version")


@pulumi.output_type
class BucketDefaultRetention(dict):
    """
    The default retention period that you want to apply to new objects placed in the specified bucket.
    """
    def __init__(__self__, *,
                 days: Optional[int] = None,
                 mode: Optional['BucketDefaultRetentionMode'] = None,
                 years: Optional[int] = None):
        """
        The default retention period that you want to apply to new objects placed in the specified bucket.
        """
        if days is not None:
            pulumi.set(__self__, "days", days)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if years is not None:
            pulumi.set(__self__, "years", years)

    @property
    @pulumi.getter
    def days(self) -> Optional[int]:
        return pulumi.get(self, "days")

    @property
    @pulumi.getter
    def mode(self) -> Optional['BucketDefaultRetentionMode']:
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def years(self) -> Optional[int]:
        return pulumi.get(self, "years")


@pulumi.output_type
class BucketDeleteMarkerReplication(dict):
    def __init__(__self__, *,
                 status: Optional['BucketDeleteMarkerReplicationStatus'] = None):
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def status(self) -> Optional['BucketDeleteMarkerReplicationStatus']:
        return pulumi.get(self, "status")


@pulumi.output_type
class BucketDestination(dict):
    """
    Specifies information about where to publish analysis or configuration results for an Amazon S3 bucket and S3 Replication Time Control (S3 RTC).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketArn":
            suggest = "bucket_arn"
        elif key == "bucketAccountId":
            suggest = "bucket_account_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_arn: str,
                 format: 'BucketDestinationFormat',
                 bucket_account_id: Optional[str] = None,
                 prefix: Optional[str] = None):
        """
        Specifies information about where to publish analysis or configuration results for an Amazon S3 bucket and S3 Replication Time Control (S3 RTC).
        :param str bucket_arn: The Amazon Resource Name (ARN) of the bucket to which data is exported.
        :param 'BucketDestinationFormat' format: Specifies the file format used when exporting data to Amazon S3.
        :param str bucket_account_id: The account ID that owns the destination S3 bucket. 
        :param str prefix: The prefix to use when exporting data. The prefix is prepended to all results.
        """
        pulumi.set(__self__, "bucket_arn", bucket_arn)
        pulumi.set(__self__, "format", format)
        if bucket_account_id is not None:
            pulumi.set(__self__, "bucket_account_id", bucket_account_id)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter(name="bucketArn")
    def bucket_arn(self) -> str:
        """
        The Amazon Resource Name (ARN) of the bucket to which data is exported.
        """
        return pulumi.get(self, "bucket_arn")

    @property
    @pulumi.getter
    def format(self) -> 'BucketDestinationFormat':
        """
        Specifies the file format used when exporting data to Amazon S3.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="bucketAccountId")
    def bucket_account_id(self) -> Optional[str]:
        """
        The account ID that owns the destination S3 bucket. 
        """
        return pulumi.get(self, "bucket_account_id")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        The prefix to use when exporting data. The prefix is prepended to all results.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class BucketEncryption(dict):
    """
    Specifies default encryption for a bucket using server-side encryption with either Amazon S3-managed keys (SSE-S3) or AWS KMS-managed keys (SSE-KMS).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serverSideEncryptionConfiguration":
            suggest = "server_side_encryption_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 server_side_encryption_configuration: Sequence['outputs.BucketServerSideEncryptionRule']):
        """
        Specifies default encryption for a bucket using server-side encryption with either Amazon S3-managed keys (SSE-S3) or AWS KMS-managed keys (SSE-KMS).
        :param Sequence['BucketServerSideEncryptionRule'] server_side_encryption_configuration: Specifies the default server-side-encryption configuration.
        """
        pulumi.set(__self__, "server_side_encryption_configuration", server_side_encryption_configuration)

    @property
    @pulumi.getter(name="serverSideEncryptionConfiguration")
    def server_side_encryption_configuration(self) -> Sequence['outputs.BucketServerSideEncryptionRule']:
        """
        Specifies the default server-side-encryption configuration.
        """
        return pulumi.get(self, "server_side_encryption_configuration")


@pulumi.output_type
class BucketEncryptionConfiguration(dict):
    """
    Specifies encryption-related information for an Amazon S3 bucket that is a destination for replicated objects.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "replicaKmsKeyID":
            suggest = "replica_kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketEncryptionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketEncryptionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketEncryptionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 replica_kms_key_id: str):
        """
        Specifies encryption-related information for an Amazon S3 bucket that is a destination for replicated objects.
        :param str replica_kms_key_id: Specifies the ID (Key ARN or Alias ARN) of the customer managed customer master key (CMK) stored in AWS Key Management Service (KMS) for the destination bucket.
        """
        pulumi.set(__self__, "replica_kms_key_id", replica_kms_key_id)

    @property
    @pulumi.getter(name="replicaKmsKeyID")
    def replica_kms_key_id(self) -> str:
        """
        Specifies the ID (Key ARN or Alias ARN) of the customer managed customer master key (CMK) stored in AWS Key Management Service (KMS) for the destination bucket.
        """
        return pulumi.get(self, "replica_kms_key_id")


@pulumi.output_type
class BucketEventBridgeConfiguration(dict):
    """
    Describes the Amazon EventBridge notification configuration for an Amazon S3 bucket.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventBridgeEnabled":
            suggest = "event_bridge_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketEventBridgeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketEventBridgeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketEventBridgeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_bridge_enabled: bool):
        """
        Describes the Amazon EventBridge notification configuration for an Amazon S3 bucket.
        :param bool event_bridge_enabled: Specifies whether to send notifications to Amazon EventBridge when events occur in an Amazon S3 bucket.
        """
        pulumi.set(__self__, "event_bridge_enabled", event_bridge_enabled)

    @property
    @pulumi.getter(name="eventBridgeEnabled")
    def event_bridge_enabled(self) -> bool:
        """
        Specifies whether to send notifications to Amazon EventBridge when events occur in an Amazon S3 bucket.
        """
        return pulumi.get(self, "event_bridge_enabled")


@pulumi.output_type
class BucketFilterRule(dict):
    """
    Specifies the Amazon S3 object key name to filter on and whether to filter on the suffix or prefix of the key name.
    """
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        Specifies the Amazon S3 object key name to filter on and whether to filter on the suffix or prefix of the key name.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class BucketIntelligentTieringConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tagFilters":
            suggest = "tag_filters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketIntelligentTieringConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketIntelligentTieringConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketIntelligentTieringConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 status: 'BucketIntelligentTieringConfigurationStatus',
                 tierings: Sequence['outputs.BucketTiering'],
                 prefix: Optional[str] = None,
                 tag_filters: Optional[Sequence['outputs.BucketTagFilter']] = None):
        """
        :param str id: The ID used to identify the S3 Intelligent-Tiering configuration.
        :param 'BucketIntelligentTieringConfigurationStatus' status: Specifies the status of the configuration.
        :param Sequence['BucketTiering'] tierings: Specifies a list of S3 Intelligent-Tiering storage class tiers in the configuration. At least one tier must be defined in the list. At most, you can specify two tiers in the list, one for each available AccessTier: ARCHIVE_ACCESS and DEEP_ARCHIVE_ACCESS.
        :param str prefix: An object key name prefix that identifies the subset of objects to which the rule applies.
        :param Sequence['BucketTagFilter'] tag_filters: A container for a key-value pair.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tierings", tierings)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if tag_filters is not None:
            pulumi.set(__self__, "tag_filters", tag_filters)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID used to identify the S3 Intelligent-Tiering configuration.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def status(self) -> 'BucketIntelligentTieringConfigurationStatus':
        """
        Specifies the status of the configuration.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tierings(self) -> Sequence['outputs.BucketTiering']:
        """
        Specifies a list of S3 Intelligent-Tiering storage class tiers in the configuration. At least one tier must be defined in the list. At most, you can specify two tiers in the list, one for each available AccessTier: ARCHIVE_ACCESS and DEEP_ARCHIVE_ACCESS.
        """
        return pulumi.get(self, "tierings")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        An object key name prefix that identifies the subset of objects to which the rule applies.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter(name="tagFilters")
    def tag_filters(self) -> Optional[Sequence['outputs.BucketTagFilter']]:
        """
        A container for a key-value pair.
        """
        return pulumi.get(self, "tag_filters")


@pulumi.output_type
class BucketInventoryConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "includedObjectVersions":
            suggest = "included_object_versions"
        elif key == "scheduleFrequency":
            suggest = "schedule_frequency"
        elif key == "optionalFields":
            suggest = "optional_fields"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketInventoryConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketInventoryConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketInventoryConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination: 'outputs.BucketDestination',
                 enabled: bool,
                 id: str,
                 included_object_versions: 'BucketInventoryConfigurationIncludedObjectVersions',
                 schedule_frequency: 'BucketInventoryConfigurationScheduleFrequency',
                 optional_fields: Optional[Sequence['BucketInventoryConfigurationOptionalFieldsItem']] = None,
                 prefix: Optional[str] = None):
        """
        :param bool enabled: Specifies whether the inventory is enabled or disabled.
        :param str id: The ID used to identify the inventory configuration.
        :param 'BucketInventoryConfigurationIncludedObjectVersions' included_object_versions: Object versions to include in the inventory list.
        :param 'BucketInventoryConfigurationScheduleFrequency' schedule_frequency: Specifies the schedule for generating inventory results.
        :param Sequence['BucketInventoryConfigurationOptionalFieldsItem'] optional_fields: Contains the optional fields that are included in the inventory results.
        :param str prefix: The prefix that is prepended to all inventory results.
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "included_object_versions", included_object_versions)
        pulumi.set(__self__, "schedule_frequency", schedule_frequency)
        if optional_fields is not None:
            pulumi.set(__self__, "optional_fields", optional_fields)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def destination(self) -> 'outputs.BucketDestination':
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Specifies whether the inventory is enabled or disabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID used to identify the inventory configuration.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="includedObjectVersions")
    def included_object_versions(self) -> 'BucketInventoryConfigurationIncludedObjectVersions':
        """
        Object versions to include in the inventory list.
        """
        return pulumi.get(self, "included_object_versions")

    @property
    @pulumi.getter(name="scheduleFrequency")
    def schedule_frequency(self) -> 'BucketInventoryConfigurationScheduleFrequency':
        """
        Specifies the schedule for generating inventory results.
        """
        return pulumi.get(self, "schedule_frequency")

    @property
    @pulumi.getter(name="optionalFields")
    def optional_fields(self) -> Optional[Sequence['BucketInventoryConfigurationOptionalFieldsItem']]:
        """
        Contains the optional fields that are included in the inventory results.
        """
        return pulumi.get(self, "optional_fields")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        The prefix that is prepended to all inventory results.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class BucketLambdaConfiguration(dict):
    """
    Describes the AWS Lambda functions to invoke and the events for which to invoke them.
    """
    def __init__(__self__, *,
                 event: str,
                 function: str,
                 filter: Optional['outputs.BucketNotificationFilter'] = None):
        """
        Describes the AWS Lambda functions to invoke and the events for which to invoke them.
        :param str event: The Amazon S3 bucket event for which to invoke the AWS Lambda function.
        :param str function: The Amazon Resource Name (ARN) of the AWS Lambda function that Amazon S3 invokes when the specified event type occurs.
        :param 'BucketNotificationFilter' filter: The filtering rules that determine which objects invoke the AWS Lambda function.
        """
        pulumi.set(__self__, "event", event)
        pulumi.set(__self__, "function", function)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)

    @property
    @pulumi.getter
    def event(self) -> str:
        """
        The Amazon S3 bucket event for which to invoke the AWS Lambda function.
        """
        return pulumi.get(self, "event")

    @property
    @pulumi.getter
    def function(self) -> str:
        """
        The Amazon Resource Name (ARN) of the AWS Lambda function that Amazon S3 invokes when the specified event type occurs.
        """
        return pulumi.get(self, "function")

    @property
    @pulumi.getter
    def filter(self) -> Optional['outputs.BucketNotificationFilter']:
        """
        The filtering rules that determine which objects invoke the AWS Lambda function.
        """
        return pulumi.get(self, "filter")


@pulumi.output_type
class BucketLifecycleConfiguration(dict):
    def __init__(__self__, *,
                 rules: Sequence['outputs.BucketRule']):
        """
        :param Sequence['BucketRule'] rules: A lifecycle rule for individual objects in an Amazon S3 bucket.
        """
        pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.BucketRule']:
        """
        A lifecycle rule for individual objects in an Amazon S3 bucket.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class BucketLoggingConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationBucketName":
            suggest = "destination_bucket_name"
        elif key == "logFilePrefix":
            suggest = "log_file_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLoggingConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLoggingConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLoggingConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination_bucket_name: Optional[str] = None,
                 log_file_prefix: Optional[str] = None):
        """
        :param str destination_bucket_name: The name of an Amazon S3 bucket where Amazon S3 store server access log files. You can store log files in any bucket that you own. By default, logs are stored in the bucket where the LoggingConfiguration property is defined.
        """
        if destination_bucket_name is not None:
            pulumi.set(__self__, "destination_bucket_name", destination_bucket_name)
        if log_file_prefix is not None:
            pulumi.set(__self__, "log_file_prefix", log_file_prefix)

    @property
    @pulumi.getter(name="destinationBucketName")
    def destination_bucket_name(self) -> Optional[str]:
        """
        The name of an Amazon S3 bucket where Amazon S3 store server access log files. You can store log files in any bucket that you own. By default, logs are stored in the bucket where the LoggingConfiguration property is defined.
        """
        return pulumi.get(self, "destination_bucket_name")

    @property
    @pulumi.getter(name="logFilePrefix")
    def log_file_prefix(self) -> Optional[str]:
        return pulumi.get(self, "log_file_prefix")


@pulumi.output_type
class BucketMetrics(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventThreshold":
            suggest = "event_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketMetrics. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketMetrics.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketMetrics.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status: 'BucketMetricsStatus',
                 event_threshold: Optional['outputs.BucketReplicationTimeValue'] = None):
        pulumi.set(__self__, "status", status)
        if event_threshold is not None:
            pulumi.set(__self__, "event_threshold", event_threshold)

    @property
    @pulumi.getter
    def status(self) -> 'BucketMetricsStatus':
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="eventThreshold")
    def event_threshold(self) -> Optional['outputs.BucketReplicationTimeValue']:
        return pulumi.get(self, "event_threshold")


@pulumi.output_type
class BucketMetricsConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessPointArn":
            suggest = "access_point_arn"
        elif key == "tagFilters":
            suggest = "tag_filters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketMetricsConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketMetricsConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketMetricsConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 access_point_arn: Optional[str] = None,
                 prefix: Optional[str] = None,
                 tag_filters: Optional[Sequence['outputs.BucketTagFilter']] = None):
        pulumi.set(__self__, "id", id)
        if access_point_arn is not None:
            pulumi.set(__self__, "access_point_arn", access_point_arn)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if tag_filters is not None:
            pulumi.set(__self__, "tag_filters", tag_filters)

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="accessPointArn")
    def access_point_arn(self) -> Optional[str]:
        return pulumi.get(self, "access_point_arn")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter(name="tagFilters")
    def tag_filters(self) -> Optional[Sequence['outputs.BucketTagFilter']]:
        return pulumi.get(self, "tag_filters")


@pulumi.output_type
class BucketNoncurrentVersionExpiration(dict):
    """
    Container for the expiration rule that describes when noncurrent objects are expired. If your bucket is versioning-enabled (or versioning is suspended), you can set this action to request that Amazon S3 expire noncurrent object versions at a specific period in the object's lifetime
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "noncurrentDays":
            suggest = "noncurrent_days"
        elif key == "newerNoncurrentVersions":
            suggest = "newer_noncurrent_versions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketNoncurrentVersionExpiration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketNoncurrentVersionExpiration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketNoncurrentVersionExpiration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 noncurrent_days: int,
                 newer_noncurrent_versions: Optional[int] = None):
        """
        Container for the expiration rule that describes when noncurrent objects are expired. If your bucket is versioning-enabled (or versioning is suspended), you can set this action to request that Amazon S3 expire noncurrent object versions at a specific period in the object's lifetime
        :param int noncurrent_days: Specified the number of days an object is noncurrent before Amazon S3 can perform the associated action
        :param int newer_noncurrent_versions: Specified the number of newer noncurrent and current versions that must exists before performing the associated action
        """
        pulumi.set(__self__, "noncurrent_days", noncurrent_days)
        if newer_noncurrent_versions is not None:
            pulumi.set(__self__, "newer_noncurrent_versions", newer_noncurrent_versions)

    @property
    @pulumi.getter(name="noncurrentDays")
    def noncurrent_days(self) -> int:
        """
        Specified the number of days an object is noncurrent before Amazon S3 can perform the associated action
        """
        return pulumi.get(self, "noncurrent_days")

    @property
    @pulumi.getter(name="newerNoncurrentVersions")
    def newer_noncurrent_versions(self) -> Optional[int]:
        """
        Specified the number of newer noncurrent and current versions that must exists before performing the associated action
        """
        return pulumi.get(self, "newer_noncurrent_versions")


@pulumi.output_type
class BucketNoncurrentVersionTransition(dict):
    """
    Container for the transition rule that describes when noncurrent objects transition to the STANDARD_IA, ONEZONE_IA, INTELLIGENT_TIERING, GLACIER_IR, GLACIER, or DEEP_ARCHIVE storage class. If your bucket is versioning-enabled (or versioning is suspended), you can set this action to request that Amazon S3 transition noncurrent object versions to the STANDARD_IA, ONEZONE_IA, INTELLIGENT_TIERING, GLACIER_IR, GLACIER, or DEEP_ARCHIVE storage class at a specific period in the object's lifetime.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageClass":
            suggest = "storage_class"
        elif key == "transitionInDays":
            suggest = "transition_in_days"
        elif key == "newerNoncurrentVersions":
            suggest = "newer_noncurrent_versions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketNoncurrentVersionTransition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketNoncurrentVersionTransition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketNoncurrentVersionTransition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_class: 'BucketNoncurrentVersionTransitionStorageClass',
                 transition_in_days: int,
                 newer_noncurrent_versions: Optional[int] = None):
        """
        Container for the transition rule that describes when noncurrent objects transition to the STANDARD_IA, ONEZONE_IA, INTELLIGENT_TIERING, GLACIER_IR, GLACIER, or DEEP_ARCHIVE storage class. If your bucket is versioning-enabled (or versioning is suspended), you can set this action to request that Amazon S3 transition noncurrent object versions to the STANDARD_IA, ONEZONE_IA, INTELLIGENT_TIERING, GLACIER_IR, GLACIER, or DEEP_ARCHIVE storage class at a specific period in the object's lifetime.
        :param 'BucketNoncurrentVersionTransitionStorageClass' storage_class: The class of storage used to store the object.
        :param int transition_in_days: Specifies the number of days an object is noncurrent before Amazon S3 can perform the associated action.
        :param int newer_noncurrent_versions: Specified the number of newer noncurrent and current versions that must exists before performing the associated action
        """
        pulumi.set(__self__, "storage_class", storage_class)
        pulumi.set(__self__, "transition_in_days", transition_in_days)
        if newer_noncurrent_versions is not None:
            pulumi.set(__self__, "newer_noncurrent_versions", newer_noncurrent_versions)

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> 'BucketNoncurrentVersionTransitionStorageClass':
        """
        The class of storage used to store the object.
        """
        return pulumi.get(self, "storage_class")

    @property
    @pulumi.getter(name="transitionInDays")
    def transition_in_days(self) -> int:
        """
        Specifies the number of days an object is noncurrent before Amazon S3 can perform the associated action.
        """
        return pulumi.get(self, "transition_in_days")

    @property
    @pulumi.getter(name="newerNoncurrentVersions")
    def newer_noncurrent_versions(self) -> Optional[int]:
        """
        Specified the number of newer noncurrent and current versions that must exists before performing the associated action
        """
        return pulumi.get(self, "newer_noncurrent_versions")


@pulumi.output_type
class BucketNotificationConfiguration(dict):
    """
    Describes the notification configuration for an Amazon S3 bucket.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventBridgeConfiguration":
            suggest = "event_bridge_configuration"
        elif key == "lambdaConfigurations":
            suggest = "lambda_configurations"
        elif key == "queueConfigurations":
            suggest = "queue_configurations"
        elif key == "topicConfigurations":
            suggest = "topic_configurations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketNotificationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketNotificationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketNotificationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_bridge_configuration: Optional['outputs.BucketEventBridgeConfiguration'] = None,
                 lambda_configurations: Optional[Sequence['outputs.BucketLambdaConfiguration']] = None,
                 queue_configurations: Optional[Sequence['outputs.BucketQueueConfiguration']] = None,
                 topic_configurations: Optional[Sequence['outputs.BucketTopicConfiguration']] = None):
        """
        Describes the notification configuration for an Amazon S3 bucket.
        """
        if event_bridge_configuration is not None:
            pulumi.set(__self__, "event_bridge_configuration", event_bridge_configuration)
        if lambda_configurations is not None:
            pulumi.set(__self__, "lambda_configurations", lambda_configurations)
        if queue_configurations is not None:
            pulumi.set(__self__, "queue_configurations", queue_configurations)
        if topic_configurations is not None:
            pulumi.set(__self__, "topic_configurations", topic_configurations)

    @property
    @pulumi.getter(name="eventBridgeConfiguration")
    def event_bridge_configuration(self) -> Optional['outputs.BucketEventBridgeConfiguration']:
        return pulumi.get(self, "event_bridge_configuration")

    @property
    @pulumi.getter(name="lambdaConfigurations")
    def lambda_configurations(self) -> Optional[Sequence['outputs.BucketLambdaConfiguration']]:
        return pulumi.get(self, "lambda_configurations")

    @property
    @pulumi.getter(name="queueConfigurations")
    def queue_configurations(self) -> Optional[Sequence['outputs.BucketQueueConfiguration']]:
        return pulumi.get(self, "queue_configurations")

    @property
    @pulumi.getter(name="topicConfigurations")
    def topic_configurations(self) -> Optional[Sequence['outputs.BucketTopicConfiguration']]:
        return pulumi.get(self, "topic_configurations")


@pulumi.output_type
class BucketNotificationFilter(dict):
    """
    Specifies object key name filtering rules.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Key":
            suggest = "s3_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketNotificationFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketNotificationFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketNotificationFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_key: 'outputs.BucketS3KeyFilter'):
        """
        Specifies object key name filtering rules.
        """
        pulumi.set(__self__, "s3_key", s3_key)

    @property
    @pulumi.getter(name="s3Key")
    def s3_key(self) -> 'outputs.BucketS3KeyFilter':
        return pulumi.get(self, "s3_key")


@pulumi.output_type
class BucketObjectLockConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectLockEnabled":
            suggest = "object_lock_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketObjectLockConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketObjectLockConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketObjectLockConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_lock_enabled: Optional[str] = None,
                 rule: Optional['outputs.BucketObjectLockRule'] = None):
        if object_lock_enabled is not None:
            pulumi.set(__self__, "object_lock_enabled", object_lock_enabled)
        if rule is not None:
            pulumi.set(__self__, "rule", rule)

    @property
    @pulumi.getter(name="objectLockEnabled")
    def object_lock_enabled(self) -> Optional[str]:
        return pulumi.get(self, "object_lock_enabled")

    @property
    @pulumi.getter
    def rule(self) -> Optional['outputs.BucketObjectLockRule']:
        return pulumi.get(self, "rule")


@pulumi.output_type
class BucketObjectLockRule(dict):
    """
    The Object Lock rule in place for the specified object.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultRetention":
            suggest = "default_retention"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketObjectLockRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketObjectLockRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketObjectLockRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_retention: Optional['outputs.BucketDefaultRetention'] = None):
        """
        The Object Lock rule in place for the specified object.
        """
        if default_retention is not None:
            pulumi.set(__self__, "default_retention", default_retention)

    @property
    @pulumi.getter(name="defaultRetention")
    def default_retention(self) -> Optional['outputs.BucketDefaultRetention']:
        return pulumi.get(self, "default_retention")


@pulumi.output_type
class BucketOwnershipControls(dict):
    def __init__(__self__, *,
                 rules: Sequence['outputs.BucketOwnershipControlsRule']):
        pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.BucketOwnershipControlsRule']:
        return pulumi.get(self, "rules")


@pulumi.output_type
class BucketOwnershipControlsRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectOwnership":
            suggest = "object_ownership"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketOwnershipControlsRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketOwnershipControlsRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketOwnershipControlsRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_ownership: Optional['BucketOwnershipControlsRuleObjectOwnership'] = None):
        """
        :param 'BucketOwnershipControlsRuleObjectOwnership' object_ownership: Specifies an object ownership rule.
        """
        if object_ownership is not None:
            pulumi.set(__self__, "object_ownership", object_ownership)

    @property
    @pulumi.getter(name="objectOwnership")
    def object_ownership(self) -> Optional['BucketOwnershipControlsRuleObjectOwnership']:
        """
        Specifies an object ownership rule.
        """
        return pulumi.get(self, "object_ownership")


@pulumi.output_type
class BucketPublicAccessBlockConfiguration(dict):
    """
    Configuration that defines how Amazon S3 handles public access.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blockPublicAcls":
            suggest = "block_public_acls"
        elif key == "blockPublicPolicy":
            suggest = "block_public_policy"
        elif key == "ignorePublicAcls":
            suggest = "ignore_public_acls"
        elif key == "restrictPublicBuckets":
            suggest = "restrict_public_buckets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketPublicAccessBlockConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketPublicAccessBlockConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketPublicAccessBlockConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 block_public_acls: Optional[bool] = None,
                 block_public_policy: Optional[bool] = None,
                 ignore_public_acls: Optional[bool] = None,
                 restrict_public_buckets: Optional[bool] = None):
        """
        Configuration that defines how Amazon S3 handles public access.
        :param bool block_public_acls: Specifies whether Amazon S3 should block public access control lists (ACLs) for this bucket and objects in this bucket. Setting this element to TRUE causes the following behavior:
               - PUT Bucket acl and PUT Object acl calls fail if the specified ACL is public.
                - PUT Object calls fail if the request includes a public ACL.
               Enabling this setting doesn't affect existing policies or ACLs.
        :param bool block_public_policy: Specifies whether Amazon S3 should block public bucket policies for this bucket. Setting this element to TRUE causes Amazon S3 to reject calls to PUT Bucket policy if the specified bucket policy allows public access.
               Enabling this setting doesn't affect existing bucket policies.
        :param bool ignore_public_acls: Specifies whether Amazon S3 should ignore public ACLs for this bucket and objects in this bucket. Setting this element to TRUE causes Amazon S3 to ignore all public ACLs on this bucket and objects in this bucket.
               Enabling this setting doesn't affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set.
        :param bool restrict_public_buckets: Specifies whether Amazon S3 should restrict public bucket policies for this bucket. Setting this element to TRUE restricts access to this bucket to only AWS services and authorized users within this account if the bucket has a public policy.
               Enabling this setting doesn't affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked.
        """
        if block_public_acls is not None:
            pulumi.set(__self__, "block_public_acls", block_public_acls)
        if block_public_policy is not None:
            pulumi.set(__self__, "block_public_policy", block_public_policy)
        if ignore_public_acls is not None:
            pulumi.set(__self__, "ignore_public_acls", ignore_public_acls)
        if restrict_public_buckets is not None:
            pulumi.set(__self__, "restrict_public_buckets", restrict_public_buckets)

    @property
    @pulumi.getter(name="blockPublicAcls")
    def block_public_acls(self) -> Optional[bool]:
        """
        Specifies whether Amazon S3 should block public access control lists (ACLs) for this bucket and objects in this bucket. Setting this element to TRUE causes the following behavior:
        - PUT Bucket acl and PUT Object acl calls fail if the specified ACL is public.
         - PUT Object calls fail if the request includes a public ACL.
        Enabling this setting doesn't affect existing policies or ACLs.
        """
        return pulumi.get(self, "block_public_acls")

    @property
    @pulumi.getter(name="blockPublicPolicy")
    def block_public_policy(self) -> Optional[bool]:
        """
        Specifies whether Amazon S3 should block public bucket policies for this bucket. Setting this element to TRUE causes Amazon S3 to reject calls to PUT Bucket policy if the specified bucket policy allows public access.
        Enabling this setting doesn't affect existing bucket policies.
        """
        return pulumi.get(self, "block_public_policy")

    @property
    @pulumi.getter(name="ignorePublicAcls")
    def ignore_public_acls(self) -> Optional[bool]:
        """
        Specifies whether Amazon S3 should ignore public ACLs for this bucket and objects in this bucket. Setting this element to TRUE causes Amazon S3 to ignore all public ACLs on this bucket and objects in this bucket.
        Enabling this setting doesn't affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set.
        """
        return pulumi.get(self, "ignore_public_acls")

    @property
    @pulumi.getter(name="restrictPublicBuckets")
    def restrict_public_buckets(self) -> Optional[bool]:
        """
        Specifies whether Amazon S3 should restrict public bucket policies for this bucket. Setting this element to TRUE restricts access to this bucket to only AWS services and authorized users within this account if the bucket has a public policy.
        Enabling this setting doesn't affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked.
        """
        return pulumi.get(self, "restrict_public_buckets")


@pulumi.output_type
class BucketQueueConfiguration(dict):
    """
    The Amazon Simple Queue Service queues to publish messages to and the events for which to publish messages.
    """
    def __init__(__self__, *,
                 event: str,
                 queue: str,
                 filter: Optional['outputs.BucketNotificationFilter'] = None):
        """
        The Amazon Simple Queue Service queues to publish messages to and the events for which to publish messages.
        :param str event: The Amazon S3 bucket event about which you want to publish messages to Amazon SQS.
        :param str queue: The Amazon Resource Name (ARN) of the Amazon SQS queue to which Amazon S3 publishes a message when it detects events of the specified type.
        :param 'BucketNotificationFilter' filter: The filtering rules that determine which objects trigger notifications.
        """
        pulumi.set(__self__, "event", event)
        pulumi.set(__self__, "queue", queue)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)

    @property
    @pulumi.getter
    def event(self) -> str:
        """
        The Amazon S3 bucket event about which you want to publish messages to Amazon SQS.
        """
        return pulumi.get(self, "event")

    @property
    @pulumi.getter
    def queue(self) -> str:
        """
        The Amazon Resource Name (ARN) of the Amazon SQS queue to which Amazon S3 publishes a message when it detects events of the specified type.
        """
        return pulumi.get(self, "queue")

    @property
    @pulumi.getter
    def filter(self) -> Optional['outputs.BucketNotificationFilter']:
        """
        The filtering rules that determine which objects trigger notifications.
        """
        return pulumi.get(self, "filter")


@pulumi.output_type
class BucketRedirectAllRequestsTo(dict):
    """
    Specifies the redirect behavior of all requests to a website endpoint of an Amazon S3 bucket.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostName":
            suggest = "host_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketRedirectAllRequestsTo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketRedirectAllRequestsTo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketRedirectAllRequestsTo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_name: str,
                 protocol: Optional['BucketRedirectAllRequestsToProtocol'] = None):
        """
        Specifies the redirect behavior of all requests to a website endpoint of an Amazon S3 bucket.
        :param str host_name: Name of the host where requests are redirected.
        :param 'BucketRedirectAllRequestsToProtocol' protocol: Protocol to use when redirecting requests. The default is the protocol that is used in the original request.
        """
        pulumi.set(__self__, "host_name", host_name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> str:
        """
        Name of the host where requests are redirected.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter
    def protocol(self) -> Optional['BucketRedirectAllRequestsToProtocol']:
        """
        Protocol to use when redirecting requests. The default is the protocol that is used in the original request.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class BucketRedirectRule(dict):
    """
    Specifies how requests are redirected. In the event of an error, you can specify a different error code to return.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostName":
            suggest = "host_name"
        elif key == "httpRedirectCode":
            suggest = "http_redirect_code"
        elif key == "replaceKeyPrefixWith":
            suggest = "replace_key_prefix_with"
        elif key == "replaceKeyWith":
            suggest = "replace_key_with"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketRedirectRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketRedirectRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketRedirectRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_name: Optional[str] = None,
                 http_redirect_code: Optional[str] = None,
                 protocol: Optional['BucketRedirectRuleProtocol'] = None,
                 replace_key_prefix_with: Optional[str] = None,
                 replace_key_with: Optional[str] = None):
        """
        Specifies how requests are redirected. In the event of an error, you can specify a different error code to return.
        :param str host_name: The host name to use in the redirect request.
        :param str http_redirect_code: The HTTP redirect code to use on the response. Not required if one of the siblings is present.
        :param 'BucketRedirectRuleProtocol' protocol: Protocol to use when redirecting requests. The default is the protocol that is used in the original request.
        :param str replace_key_prefix_with: The object key prefix to use in the redirect request.
        :param str replace_key_with: The specific object key to use in the redirect request.d
        """
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if http_redirect_code is not None:
            pulumi.set(__self__, "http_redirect_code", http_redirect_code)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if replace_key_prefix_with is not None:
            pulumi.set(__self__, "replace_key_prefix_with", replace_key_prefix_with)
        if replace_key_with is not None:
            pulumi.set(__self__, "replace_key_with", replace_key_with)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[str]:
        """
        The host name to use in the redirect request.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter(name="httpRedirectCode")
    def http_redirect_code(self) -> Optional[str]:
        """
        The HTTP redirect code to use on the response. Not required if one of the siblings is present.
        """
        return pulumi.get(self, "http_redirect_code")

    @property
    @pulumi.getter
    def protocol(self) -> Optional['BucketRedirectRuleProtocol']:
        """
        Protocol to use when redirecting requests. The default is the protocol that is used in the original request.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="replaceKeyPrefixWith")
    def replace_key_prefix_with(self) -> Optional[str]:
        """
        The object key prefix to use in the redirect request.
        """
        return pulumi.get(self, "replace_key_prefix_with")

    @property
    @pulumi.getter(name="replaceKeyWith")
    def replace_key_with(self) -> Optional[str]:
        """
        The specific object key to use in the redirect request.d
        """
        return pulumi.get(self, "replace_key_with")


@pulumi.output_type
class BucketReplicaModifications(dict):
    def __init__(__self__, *,
                 status: 'BucketReplicaModificationsStatus'):
        """
        :param 'BucketReplicaModificationsStatus' status: Specifies whether Amazon S3 replicates modifications on replicas.
        """
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def status(self) -> 'BucketReplicaModificationsStatus':
        """
        Specifies whether Amazon S3 replicates modifications on replicas.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class BucketReplicationConfiguration(dict):
    """
    A container for replication rules. You can add up to 1,000 rules. The maximum size of a replication configuration is 2 MB.
    """
    def __init__(__self__, *,
                 role: str,
                 rules: Sequence['outputs.BucketReplicationRule']):
        """
        A container for replication rules. You can add up to 1,000 rules. The maximum size of a replication configuration is 2 MB.
        :param str role: The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that Amazon S3 assumes when replicating objects.
        :param Sequence['BucketReplicationRule'] rules: A container for one or more replication rules.
        """
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that Amazon S3 assumes when replicating objects.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.BucketReplicationRule']:
        """
        A container for one or more replication rules.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class BucketReplicationDestination(dict):
    """
    Specifies which Amazon S3 bucket to store replicated objects in and their storage class.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessControlTranslation":
            suggest = "access_control_translation"
        elif key == "encryptionConfiguration":
            suggest = "encryption_configuration"
        elif key == "replicationTime":
            suggest = "replication_time"
        elif key == "storageClass":
            suggest = "storage_class"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketReplicationDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketReplicationDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketReplicationDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: str,
                 access_control_translation: Optional['outputs.BucketAccessControlTranslation'] = None,
                 account: Optional[str] = None,
                 encryption_configuration: Optional['outputs.BucketEncryptionConfiguration'] = None,
                 metrics: Optional['outputs.BucketMetrics'] = None,
                 replication_time: Optional['outputs.BucketReplicationTime'] = None,
                 storage_class: Optional['BucketReplicationDestinationStorageClass'] = None):
        """
        Specifies which Amazon S3 bucket to store replicated objects in and their storage class.
        :param 'BucketReplicationDestinationStorageClass' storage_class: The storage class to use when replicating objects, such as S3 Standard or reduced redundancy.
        """
        pulumi.set(__self__, "bucket", bucket)
        if access_control_translation is not None:
            pulumi.set(__self__, "access_control_translation", access_control_translation)
        if account is not None:
            pulumi.set(__self__, "account", account)
        if encryption_configuration is not None:
            pulumi.set(__self__, "encryption_configuration", encryption_configuration)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if replication_time is not None:
            pulumi.set(__self__, "replication_time", replication_time)
        if storage_class is not None:
            pulumi.set(__self__, "storage_class", storage_class)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="accessControlTranslation")
    def access_control_translation(self) -> Optional['outputs.BucketAccessControlTranslation']:
        return pulumi.get(self, "access_control_translation")

    @property
    @pulumi.getter
    def account(self) -> Optional[str]:
        return pulumi.get(self, "account")

    @property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> Optional['outputs.BucketEncryptionConfiguration']:
        return pulumi.get(self, "encryption_configuration")

    @property
    @pulumi.getter
    def metrics(self) -> Optional['outputs.BucketMetrics']:
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter(name="replicationTime")
    def replication_time(self) -> Optional['outputs.BucketReplicationTime']:
        return pulumi.get(self, "replication_time")

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> Optional['BucketReplicationDestinationStorageClass']:
        """
        The storage class to use when replicating objects, such as S3 Standard or reduced redundancy.
        """
        return pulumi.get(self, "storage_class")


@pulumi.output_type
class BucketReplicationRule(dict):
    """
    Specifies which Amazon S3 objects to replicate and where to store the replicas.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deleteMarkerReplication":
            suggest = "delete_marker_replication"
        elif key == "sourceSelectionCriteria":
            suggest = "source_selection_criteria"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketReplicationRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketReplicationRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketReplicationRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination: 'outputs.BucketReplicationDestination',
                 status: 'BucketReplicationRuleStatus',
                 delete_marker_replication: Optional['outputs.BucketDeleteMarkerReplication'] = None,
                 filter: Optional['outputs.BucketReplicationRuleFilter'] = None,
                 id: Optional[str] = None,
                 prefix: Optional[str] = None,
                 priority: Optional[int] = None,
                 source_selection_criteria: Optional['outputs.BucketSourceSelectionCriteria'] = None):
        """
        Specifies which Amazon S3 objects to replicate and where to store the replicas.
        :param 'BucketReplicationRuleStatus' status: Specifies whether the rule is enabled.
        :param str id: A unique identifier for the rule.
        :param str prefix: An object key name prefix that identifies the object or objects to which the rule applies.
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "status", status)
        if delete_marker_replication is not None:
            pulumi.set(__self__, "delete_marker_replication", delete_marker_replication)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if source_selection_criteria is not None:
            pulumi.set(__self__, "source_selection_criteria", source_selection_criteria)

    @property
    @pulumi.getter
    def destination(self) -> 'outputs.BucketReplicationDestination':
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def status(self) -> 'BucketReplicationRuleStatus':
        """
        Specifies whether the rule is enabled.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="deleteMarkerReplication")
    def delete_marker_replication(self) -> Optional['outputs.BucketDeleteMarkerReplication']:
        return pulumi.get(self, "delete_marker_replication")

    @property
    @pulumi.getter
    def filter(self) -> Optional['outputs.BucketReplicationRuleFilter']:
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        A unique identifier for the rule.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        An object key name prefix that identifies the object or objects to which the rule applies.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="sourceSelectionCriteria")
    def source_selection_criteria(self) -> Optional['outputs.BucketSourceSelectionCriteria']:
        return pulumi.get(self, "source_selection_criteria")


@pulumi.output_type
class BucketReplicationRuleAndOperator(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tagFilters":
            suggest = "tag_filters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketReplicationRuleAndOperator. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketReplicationRuleAndOperator.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketReplicationRuleAndOperator.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 prefix: Optional[str] = None,
                 tag_filters: Optional[Sequence['outputs.BucketTagFilter']] = None):
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if tag_filters is not None:
            pulumi.set(__self__, "tag_filters", tag_filters)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter(name="tagFilters")
    def tag_filters(self) -> Optional[Sequence['outputs.BucketTagFilter']]:
        return pulumi.get(self, "tag_filters")


@pulumi.output_type
class BucketReplicationRuleFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "and":
            suggest = "and_"
        elif key == "tagFilter":
            suggest = "tag_filter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketReplicationRuleFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketReplicationRuleFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketReplicationRuleFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 and_: Optional['outputs.BucketReplicationRuleAndOperator'] = None,
                 prefix: Optional[str] = None,
                 tag_filter: Optional['outputs.BucketTagFilter'] = None):
        if and_ is not None:
            pulumi.set(__self__, "and_", and_)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if tag_filter is not None:
            pulumi.set(__self__, "tag_filter", tag_filter)

    @property
    @pulumi.getter(name="and")
    def and_(self) -> Optional['outputs.BucketReplicationRuleAndOperator']:
        return pulumi.get(self, "and_")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter(name="tagFilter")
    def tag_filter(self) -> Optional['outputs.BucketTagFilter']:
        return pulumi.get(self, "tag_filter")


@pulumi.output_type
class BucketReplicationTime(dict):
    def __init__(__self__, *,
                 status: 'BucketReplicationTimeStatus',
                 time: 'outputs.BucketReplicationTimeValue'):
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter
    def status(self) -> 'BucketReplicationTimeStatus':
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def time(self) -> 'outputs.BucketReplicationTimeValue':
        return pulumi.get(self, "time")


@pulumi.output_type
class BucketReplicationTimeValue(dict):
    def __init__(__self__, *,
                 minutes: int):
        pulumi.set(__self__, "minutes", minutes)

    @property
    @pulumi.getter
    def minutes(self) -> int:
        return pulumi.get(self, "minutes")


@pulumi.output_type
class BucketRoutingRule(dict):
    """
    Specifies the redirect behavior and when a redirect is applied.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "redirectRule":
            suggest = "redirect_rule"
        elif key == "routingRuleCondition":
            suggest = "routing_rule_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketRoutingRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketRoutingRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketRoutingRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 redirect_rule: 'outputs.BucketRedirectRule',
                 routing_rule_condition: Optional['outputs.BucketRoutingRuleCondition'] = None):
        """
        Specifies the redirect behavior and when a redirect is applied.
        :param 'BucketRedirectRule' redirect_rule: Container for redirect information. You can redirect requests to another host, to another page, or with another protocol. In the event of an error, you can specify a different error code to return.
        """
        pulumi.set(__self__, "redirect_rule", redirect_rule)
        if routing_rule_condition is not None:
            pulumi.set(__self__, "routing_rule_condition", routing_rule_condition)

    @property
    @pulumi.getter(name="redirectRule")
    def redirect_rule(self) -> 'outputs.BucketRedirectRule':
        """
        Container for redirect information. You can redirect requests to another host, to another page, or with another protocol. In the event of an error, you can specify a different error code to return.
        """
        return pulumi.get(self, "redirect_rule")

    @property
    @pulumi.getter(name="routingRuleCondition")
    def routing_rule_condition(self) -> Optional['outputs.BucketRoutingRuleCondition']:
        return pulumi.get(self, "routing_rule_condition")


@pulumi.output_type
class BucketRoutingRuleCondition(dict):
    """
    A container for describing a condition that must be met for the specified redirect to apply.You must specify at least one of HttpErrorCodeReturnedEquals and KeyPrefixEquals
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpErrorCodeReturnedEquals":
            suggest = "http_error_code_returned_equals"
        elif key == "keyPrefixEquals":
            suggest = "key_prefix_equals"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketRoutingRuleCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketRoutingRuleCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketRoutingRuleCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_error_code_returned_equals: Optional[str] = None,
                 key_prefix_equals: Optional[str] = None):
        """
        A container for describing a condition that must be met for the specified redirect to apply.You must specify at least one of HttpErrorCodeReturnedEquals and KeyPrefixEquals
        :param str http_error_code_returned_equals: The HTTP error code when the redirect is applied. 
        :param str key_prefix_equals: The object key name prefix when the redirect is applied.
        """
        if http_error_code_returned_equals is not None:
            pulumi.set(__self__, "http_error_code_returned_equals", http_error_code_returned_equals)
        if key_prefix_equals is not None:
            pulumi.set(__self__, "key_prefix_equals", key_prefix_equals)

    @property
    @pulumi.getter(name="httpErrorCodeReturnedEquals")
    def http_error_code_returned_equals(self) -> Optional[str]:
        """
        The HTTP error code when the redirect is applied. 
        """
        return pulumi.get(self, "http_error_code_returned_equals")

    @property
    @pulumi.getter(name="keyPrefixEquals")
    def key_prefix_equals(self) -> Optional[str]:
        """
        The object key name prefix when the redirect is applied.
        """
        return pulumi.get(self, "key_prefix_equals")


@pulumi.output_type
class BucketRule(dict):
    """
    You must specify at least one of the following properties: AbortIncompleteMultipartUpload, ExpirationDate, ExpirationInDays, NoncurrentVersionExpirationInDays, NoncurrentVersionTransition, NoncurrentVersionTransitions, Transition, or Transitions.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "abortIncompleteMultipartUpload":
            suggest = "abort_incomplete_multipart_upload"
        elif key == "expirationDate":
            suggest = "expiration_date"
        elif key == "expirationInDays":
            suggest = "expiration_in_days"
        elif key == "expiredObjectDeleteMarker":
            suggest = "expired_object_delete_marker"
        elif key == "noncurrentVersionExpiration":
            suggest = "noncurrent_version_expiration"
        elif key == "noncurrentVersionExpirationInDays":
            suggest = "noncurrent_version_expiration_in_days"
        elif key == "noncurrentVersionTransition":
            suggest = "noncurrent_version_transition"
        elif key == "noncurrentVersionTransitions":
            suggest = "noncurrent_version_transitions"
        elif key == "objectSizeGreaterThan":
            suggest = "object_size_greater_than"
        elif key == "objectSizeLessThan":
            suggest = "object_size_less_than"
        elif key == "tagFilters":
            suggest = "tag_filters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status: 'BucketRuleStatus',
                 abort_incomplete_multipart_upload: Optional['outputs.BucketAbortIncompleteMultipartUpload'] = None,
                 expiration_date: Optional[str] = None,
                 expiration_in_days: Optional[int] = None,
                 expired_object_delete_marker: Optional[bool] = None,
                 id: Optional[str] = None,
                 noncurrent_version_expiration: Optional['outputs.BucketNoncurrentVersionExpiration'] = None,
                 noncurrent_version_expiration_in_days: Optional[int] = None,
                 noncurrent_version_transition: Optional['outputs.BucketNoncurrentVersionTransition'] = None,
                 noncurrent_version_transitions: Optional[Sequence['outputs.BucketNoncurrentVersionTransition']] = None,
                 object_size_greater_than: Optional[str] = None,
                 object_size_less_than: Optional[str] = None,
                 prefix: Optional[str] = None,
                 tag_filters: Optional[Sequence['outputs.BucketTagFilter']] = None,
                 transition: Optional['outputs.BucketTransition'] = None,
                 transitions: Optional[Sequence['outputs.BucketTransition']] = None):
        """
        You must specify at least one of the following properties: AbortIncompleteMultipartUpload, ExpirationDate, ExpirationInDays, NoncurrentVersionExpirationInDays, NoncurrentVersionTransition, NoncurrentVersionTransitions, Transition, or Transitions.
        """
        pulumi.set(__self__, "status", status)
        if abort_incomplete_multipart_upload is not None:
            pulumi.set(__self__, "abort_incomplete_multipart_upload", abort_incomplete_multipart_upload)
        if expiration_date is not None:
            pulumi.set(__self__, "expiration_date", expiration_date)
        if expiration_in_days is not None:
            pulumi.set(__self__, "expiration_in_days", expiration_in_days)
        if expired_object_delete_marker is not None:
            pulumi.set(__self__, "expired_object_delete_marker", expired_object_delete_marker)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if noncurrent_version_expiration is not None:
            pulumi.set(__self__, "noncurrent_version_expiration", noncurrent_version_expiration)
        if noncurrent_version_expiration_in_days is not None:
            pulumi.set(__self__, "noncurrent_version_expiration_in_days", noncurrent_version_expiration_in_days)
        if noncurrent_version_transition is not None:
            pulumi.set(__self__, "noncurrent_version_transition", noncurrent_version_transition)
        if noncurrent_version_transitions is not None:
            pulumi.set(__self__, "noncurrent_version_transitions", noncurrent_version_transitions)
        if object_size_greater_than is not None:
            pulumi.set(__self__, "object_size_greater_than", object_size_greater_than)
        if object_size_less_than is not None:
            pulumi.set(__self__, "object_size_less_than", object_size_less_than)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if tag_filters is not None:
            pulumi.set(__self__, "tag_filters", tag_filters)
        if transition is not None:
            pulumi.set(__self__, "transition", transition)
        if transitions is not None:
            pulumi.set(__self__, "transitions", transitions)

    @property
    @pulumi.getter
    def status(self) -> 'BucketRuleStatus':
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="abortIncompleteMultipartUpload")
    def abort_incomplete_multipart_upload(self) -> Optional['outputs.BucketAbortIncompleteMultipartUpload']:
        return pulumi.get(self, "abort_incomplete_multipart_upload")

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[str]:
        return pulumi.get(self, "expiration_date")

    @property
    @pulumi.getter(name="expirationInDays")
    def expiration_in_days(self) -> Optional[int]:
        return pulumi.get(self, "expiration_in_days")

    @property
    @pulumi.getter(name="expiredObjectDeleteMarker")
    def expired_object_delete_marker(self) -> Optional[bool]:
        return pulumi.get(self, "expired_object_delete_marker")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="noncurrentVersionExpiration")
    def noncurrent_version_expiration(self) -> Optional['outputs.BucketNoncurrentVersionExpiration']:
        return pulumi.get(self, "noncurrent_version_expiration")

    @property
    @pulumi.getter(name="noncurrentVersionExpirationInDays")
    def noncurrent_version_expiration_in_days(self) -> Optional[int]:
        return pulumi.get(self, "noncurrent_version_expiration_in_days")

    @property
    @pulumi.getter(name="noncurrentVersionTransition")
    def noncurrent_version_transition(self) -> Optional['outputs.BucketNoncurrentVersionTransition']:
        return pulumi.get(self, "noncurrent_version_transition")

    @property
    @pulumi.getter(name="noncurrentVersionTransitions")
    def noncurrent_version_transitions(self) -> Optional[Sequence['outputs.BucketNoncurrentVersionTransition']]:
        return pulumi.get(self, "noncurrent_version_transitions")

    @property
    @pulumi.getter(name="objectSizeGreaterThan")
    def object_size_greater_than(self) -> Optional[str]:
        return pulumi.get(self, "object_size_greater_than")

    @property
    @pulumi.getter(name="objectSizeLessThan")
    def object_size_less_than(self) -> Optional[str]:
        return pulumi.get(self, "object_size_less_than")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter(name="tagFilters")
    def tag_filters(self) -> Optional[Sequence['outputs.BucketTagFilter']]:
        return pulumi.get(self, "tag_filters")

    @property
    @pulumi.getter
    def transition(self) -> Optional['outputs.BucketTransition']:
        return pulumi.get(self, "transition")

    @property
    @pulumi.getter
    def transitions(self) -> Optional[Sequence['outputs.BucketTransition']]:
        return pulumi.get(self, "transitions")


@pulumi.output_type
class BucketS3KeyFilter(dict):
    """
    A container for object key name prefix and suffix filtering rules.
    """
    def __init__(__self__, *,
                 rules: Sequence['outputs.BucketFilterRule']):
        """
        A container for object key name prefix and suffix filtering rules.
        """
        pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.BucketFilterRule']:
        return pulumi.get(self, "rules")


@pulumi.output_type
class BucketServerSideEncryptionByDefault(dict):
    """
    Specifies the default server-side encryption to apply to new objects in the bucket. If a PUT Object request doesn't specify any server-side encryption, this default encryption will be applied.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sSEAlgorithm":
            suggest = "s_se_algorithm"
        elif key == "kMSMasterKeyID":
            suggest = "k_ms_master_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketServerSideEncryptionByDefault. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketServerSideEncryptionByDefault.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketServerSideEncryptionByDefault.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s_se_algorithm: 'BucketServerSideEncryptionByDefaultSSEAlgorithm',
                 k_ms_master_key_id: Optional[str] = None):
        """
        Specifies the default server-side encryption to apply to new objects in the bucket. If a PUT Object request doesn't specify any server-side encryption, this default encryption will be applied.
        :param str k_ms_master_key_id: "KMSMasterKeyID" can only be used when you set the value of SSEAlgorithm as aws:kms.
        """
        pulumi.set(__self__, "s_se_algorithm", s_se_algorithm)
        if k_ms_master_key_id is not None:
            pulumi.set(__self__, "k_ms_master_key_id", k_ms_master_key_id)

    @property
    @pulumi.getter(name="sSEAlgorithm")
    def s_se_algorithm(self) -> 'BucketServerSideEncryptionByDefaultSSEAlgorithm':
        return pulumi.get(self, "s_se_algorithm")

    @property
    @pulumi.getter(name="kMSMasterKeyID")
    def k_ms_master_key_id(self) -> Optional[str]:
        """
        "KMSMasterKeyID" can only be used when you set the value of SSEAlgorithm as aws:kms.
        """
        return pulumi.get(self, "k_ms_master_key_id")


@pulumi.output_type
class BucketServerSideEncryptionRule(dict):
    """
    Specifies the default server-side encryption configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketKeyEnabled":
            suggest = "bucket_key_enabled"
        elif key == "serverSideEncryptionByDefault":
            suggest = "server_side_encryption_by_default"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketServerSideEncryptionRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketServerSideEncryptionRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketServerSideEncryptionRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_key_enabled: Optional[bool] = None,
                 server_side_encryption_by_default: Optional['outputs.BucketServerSideEncryptionByDefault'] = None):
        """
        Specifies the default server-side encryption configuration.
        :param bool bucket_key_enabled: Specifies whether Amazon S3 should use an S3 Bucket Key with server-side encryption using KMS (SSE-KMS) for new objects in the bucket. Existing objects are not affected. Setting the BucketKeyEnabled element to true causes Amazon S3 to use an S3 Bucket Key. By default, S3 Bucket Key is not enabled.
        """
        if bucket_key_enabled is not None:
            pulumi.set(__self__, "bucket_key_enabled", bucket_key_enabled)
        if server_side_encryption_by_default is not None:
            pulumi.set(__self__, "server_side_encryption_by_default", server_side_encryption_by_default)

    @property
    @pulumi.getter(name="bucketKeyEnabled")
    def bucket_key_enabled(self) -> Optional[bool]:
        """
        Specifies whether Amazon S3 should use an S3 Bucket Key with server-side encryption using KMS (SSE-KMS) for new objects in the bucket. Existing objects are not affected. Setting the BucketKeyEnabled element to true causes Amazon S3 to use an S3 Bucket Key. By default, S3 Bucket Key is not enabled.
        """
        return pulumi.get(self, "bucket_key_enabled")

    @property
    @pulumi.getter(name="serverSideEncryptionByDefault")
    def server_side_encryption_by_default(self) -> Optional['outputs.BucketServerSideEncryptionByDefault']:
        return pulumi.get(self, "server_side_encryption_by_default")


@pulumi.output_type
class BucketSourceSelectionCriteria(dict):
    """
    A container that describes additional filters for identifying the source objects that you want to replicate.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "replicaModifications":
            suggest = "replica_modifications"
        elif key == "sseKmsEncryptedObjects":
            suggest = "sse_kms_encrypted_objects"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketSourceSelectionCriteria. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketSourceSelectionCriteria.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketSourceSelectionCriteria.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 replica_modifications: Optional['outputs.BucketReplicaModifications'] = None,
                 sse_kms_encrypted_objects: Optional['outputs.BucketSseKmsEncryptedObjects'] = None):
        """
        A container that describes additional filters for identifying the source objects that you want to replicate.
        :param 'BucketReplicaModifications' replica_modifications: A filter that you can specify for selection for modifications on replicas.
        :param 'BucketSseKmsEncryptedObjects' sse_kms_encrypted_objects: A container for filter information for the selection of Amazon S3 objects encrypted with AWS KMS.
        """
        if replica_modifications is not None:
            pulumi.set(__self__, "replica_modifications", replica_modifications)
        if sse_kms_encrypted_objects is not None:
            pulumi.set(__self__, "sse_kms_encrypted_objects", sse_kms_encrypted_objects)

    @property
    @pulumi.getter(name="replicaModifications")
    def replica_modifications(self) -> Optional['outputs.BucketReplicaModifications']:
        """
        A filter that you can specify for selection for modifications on replicas.
        """
        return pulumi.get(self, "replica_modifications")

    @property
    @pulumi.getter(name="sseKmsEncryptedObjects")
    def sse_kms_encrypted_objects(self) -> Optional['outputs.BucketSseKmsEncryptedObjects']:
        """
        A container for filter information for the selection of Amazon S3 objects encrypted with AWS KMS.
        """
        return pulumi.get(self, "sse_kms_encrypted_objects")


@pulumi.output_type
class BucketSseKmsEncryptedObjects(dict):
    """
    A container for filter information for the selection of S3 objects encrypted with AWS KMS.
    """
    def __init__(__self__, *,
                 status: 'BucketSseKmsEncryptedObjectsStatus'):
        """
        A container for filter information for the selection of S3 objects encrypted with AWS KMS.
        :param 'BucketSseKmsEncryptedObjectsStatus' status: Specifies whether Amazon S3 replicates objects created with server-side encryption using a customer master key (CMK) stored in AWS Key Management Service.
        """
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def status(self) -> 'BucketSseKmsEncryptedObjectsStatus':
        """
        Specifies whether Amazon S3 replicates objects created with server-side encryption using a customer master key (CMK) stored in AWS Key Management Service.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class BucketStorageClassAnalysis(dict):
    """
    Specifies data related to access patterns to be collected and made available to analyze the tradeoffs between different storage classes for an Amazon S3 bucket.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataExport":
            suggest = "data_export"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketStorageClassAnalysis. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketStorageClassAnalysis.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketStorageClassAnalysis.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_export: Optional['outputs.BucketDataExport'] = None):
        """
        Specifies data related to access patterns to be collected and made available to analyze the tradeoffs between different storage classes for an Amazon S3 bucket.
        """
        if data_export is not None:
            pulumi.set(__self__, "data_export", data_export)

    @property
    @pulumi.getter(name="dataExport")
    def data_export(self) -> Optional['outputs.BucketDataExport']:
        return pulumi.get(self, "data_export")


@pulumi.output_type
class BucketTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class BucketTagFilter(dict):
    """
    Tags to use to identify a subset of objects for an Amazon S3 bucket.
    """
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        Tags to use to identify a subset of objects for an Amazon S3 bucket.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class BucketTiering(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessTier":
            suggest = "access_tier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketTiering. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketTiering.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketTiering.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_tier: 'BucketTieringAccessTier',
                 days: int):
        """
        :param 'BucketTieringAccessTier' access_tier: S3 Intelligent-Tiering access tier. See Storage class for automatically optimizing frequently and infrequently accessed objects for a list of access tiers in the S3 Intelligent-Tiering storage class.
        :param int days: The number of consecutive days of no access after which an object will be eligible to be transitioned to the corresponding tier. The minimum number of days specified for Archive Access tier must be at least 90 days and Deep Archive Access tier must be at least 180 days. The maximum can be up to 2 years (730 days).
        """
        pulumi.set(__self__, "access_tier", access_tier)
        pulumi.set(__self__, "days", days)

    @property
    @pulumi.getter(name="accessTier")
    def access_tier(self) -> 'BucketTieringAccessTier':
        """
        S3 Intelligent-Tiering access tier. See Storage class for automatically optimizing frequently and infrequently accessed objects for a list of access tiers in the S3 Intelligent-Tiering storage class.
        """
        return pulumi.get(self, "access_tier")

    @property
    @pulumi.getter
    def days(self) -> int:
        """
        The number of consecutive days of no access after which an object will be eligible to be transitioned to the corresponding tier. The minimum number of days specified for Archive Access tier must be at least 90 days and Deep Archive Access tier must be at least 180 days. The maximum can be up to 2 years (730 days).
        """
        return pulumi.get(self, "days")


@pulumi.output_type
class BucketTopicConfiguration(dict):
    """
    The topic to which notifications are sent and the events for which notifications are generated.
    """
    def __init__(__self__, *,
                 event: str,
                 topic: str,
                 filter: Optional['outputs.BucketNotificationFilter'] = None):
        """
        The topic to which notifications are sent and the events for which notifications are generated.
        :param str event: The Amazon S3 bucket event about which to send notifications.
        :param str topic: The Amazon Resource Name (ARN) of the Amazon SNS topic to which Amazon S3 publishes a message when it detects events of the specified type.
        :param 'BucketNotificationFilter' filter: The filtering rules that determine for which objects to send notifications.
        """
        pulumi.set(__self__, "event", event)
        pulumi.set(__self__, "topic", topic)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)

    @property
    @pulumi.getter
    def event(self) -> str:
        """
        The Amazon S3 bucket event about which to send notifications.
        """
        return pulumi.get(self, "event")

    @property
    @pulumi.getter
    def topic(self) -> str:
        """
        The Amazon Resource Name (ARN) of the Amazon SNS topic to which Amazon S3 publishes a message when it detects events of the specified type.
        """
        return pulumi.get(self, "topic")

    @property
    @pulumi.getter
    def filter(self) -> Optional['outputs.BucketNotificationFilter']:
        """
        The filtering rules that determine for which objects to send notifications.
        """
        return pulumi.get(self, "filter")


@pulumi.output_type
class BucketTransition(dict):
    """
    You must specify at least one of "TransitionDate" and "TransitionInDays"
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageClass":
            suggest = "storage_class"
        elif key == "transitionDate":
            suggest = "transition_date"
        elif key == "transitionInDays":
            suggest = "transition_in_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketTransition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketTransition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketTransition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_class: 'BucketTransitionStorageClass',
                 transition_date: Optional[str] = None,
                 transition_in_days: Optional[int] = None):
        """
        You must specify at least one of "TransitionDate" and "TransitionInDays"
        """
        pulumi.set(__self__, "storage_class", storage_class)
        if transition_date is not None:
            pulumi.set(__self__, "transition_date", transition_date)
        if transition_in_days is not None:
            pulumi.set(__self__, "transition_in_days", transition_in_days)

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> 'BucketTransitionStorageClass':
        return pulumi.get(self, "storage_class")

    @property
    @pulumi.getter(name="transitionDate")
    def transition_date(self) -> Optional[str]:
        return pulumi.get(self, "transition_date")

    @property
    @pulumi.getter(name="transitionInDays")
    def transition_in_days(self) -> Optional[int]:
        return pulumi.get(self, "transition_in_days")


@pulumi.output_type
class BucketVersioningConfiguration(dict):
    """
    Describes the versioning state of an Amazon S3 bucket.
    """
    def __init__(__self__, *,
                 status: 'BucketVersioningConfigurationStatus'):
        """
        Describes the versioning state of an Amazon S3 bucket.
        :param 'BucketVersioningConfigurationStatus' status: The versioning state of the bucket.
        """
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def status(self) -> 'BucketVersioningConfigurationStatus':
        """
        The versioning state of the bucket.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class BucketWebsiteConfiguration(dict):
    """
    Specifies website configuration parameters for an Amazon S3 bucket.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorDocument":
            suggest = "error_document"
        elif key == "indexDocument":
            suggest = "index_document"
        elif key == "redirectAllRequestsTo":
            suggest = "redirect_all_requests_to"
        elif key == "routingRules":
            suggest = "routing_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketWebsiteConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketWebsiteConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketWebsiteConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_document: Optional[str] = None,
                 index_document: Optional[str] = None,
                 redirect_all_requests_to: Optional['outputs.BucketRedirectAllRequestsTo'] = None,
                 routing_rules: Optional[Sequence['outputs.BucketRoutingRule']] = None):
        """
        Specifies website configuration parameters for an Amazon S3 bucket.
        :param str error_document: The name of the error document for the website.
        :param str index_document: The name of the index document for the website.
        """
        if error_document is not None:
            pulumi.set(__self__, "error_document", error_document)
        if index_document is not None:
            pulumi.set(__self__, "index_document", index_document)
        if redirect_all_requests_to is not None:
            pulumi.set(__self__, "redirect_all_requests_to", redirect_all_requests_to)
        if routing_rules is not None:
            pulumi.set(__self__, "routing_rules", routing_rules)

    @property
    @pulumi.getter(name="errorDocument")
    def error_document(self) -> Optional[str]:
        """
        The name of the error document for the website.
        """
        return pulumi.get(self, "error_document")

    @property
    @pulumi.getter(name="indexDocument")
    def index_document(self) -> Optional[str]:
        """
        The name of the index document for the website.
        """
        return pulumi.get(self, "index_document")

    @property
    @pulumi.getter(name="redirectAllRequestsTo")
    def redirect_all_requests_to(self) -> Optional['outputs.BucketRedirectAllRequestsTo']:
        return pulumi.get(self, "redirect_all_requests_to")

    @property
    @pulumi.getter(name="routingRules")
    def routing_rules(self) -> Optional[Sequence['outputs.BucketRoutingRule']]:
        return pulumi.get(self, "routing_rules")


@pulumi.output_type
class MultiRegionAccessPointPublicAccessBlockConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blockPublicAcls":
            suggest = "block_public_acls"
        elif key == "blockPublicPolicy":
            suggest = "block_public_policy"
        elif key == "ignorePublicAcls":
            suggest = "ignore_public_acls"
        elif key == "restrictPublicBuckets":
            suggest = "restrict_public_buckets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MultiRegionAccessPointPublicAccessBlockConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MultiRegionAccessPointPublicAccessBlockConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MultiRegionAccessPointPublicAccessBlockConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 block_public_acls: Optional[bool] = None,
                 block_public_policy: Optional[bool] = None,
                 ignore_public_acls: Optional[bool] = None,
                 restrict_public_buckets: Optional[bool] = None):
        """
        :param bool block_public_acls: Specifies whether Amazon S3 should block public access control lists (ACLs) for buckets in this account. Setting this element to TRUE causes the following behavior:
               - PUT Bucket acl and PUT Object acl calls fail if the specified ACL is public.
                - PUT Object calls fail if the request includes a public ACL.
               . - PUT Bucket calls fail if the request includes a public ACL.
               Enabling this setting doesn't affect existing policies or ACLs.
        :param bool block_public_policy: Specifies whether Amazon S3 should block public bucket policies for buckets in this account. Setting this element to TRUE causes Amazon S3 to reject calls to PUT Bucket policy if the specified bucket policy allows public access. Enabling this setting doesn't affect existing bucket policies.
        :param bool ignore_public_acls: Specifies whether Amazon S3 should ignore public ACLs for buckets in this account. Setting this element to TRUE causes Amazon S3 to ignore all public ACLs on buckets in this account and any objects that they contain. Enabling this setting doesn't affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set.
        :param bool restrict_public_buckets: Specifies whether Amazon S3 should restrict public bucket policies for this bucket. Setting this element to TRUE restricts access to this bucket to only AWS services and authorized users within this account if the bucket has a public policy.
               Enabling this setting doesn't affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked.
        """
        if block_public_acls is not None:
            pulumi.set(__self__, "block_public_acls", block_public_acls)
        if block_public_policy is not None:
            pulumi.set(__self__, "block_public_policy", block_public_policy)
        if ignore_public_acls is not None:
            pulumi.set(__self__, "ignore_public_acls", ignore_public_acls)
        if restrict_public_buckets is not None:
            pulumi.set(__self__, "restrict_public_buckets", restrict_public_buckets)

    @property
    @pulumi.getter(name="blockPublicAcls")
    def block_public_acls(self) -> Optional[bool]:
        """
        Specifies whether Amazon S3 should block public access control lists (ACLs) for buckets in this account. Setting this element to TRUE causes the following behavior:
        - PUT Bucket acl and PUT Object acl calls fail if the specified ACL is public.
         - PUT Object calls fail if the request includes a public ACL.
        . - PUT Bucket calls fail if the request includes a public ACL.
        Enabling this setting doesn't affect existing policies or ACLs.
        """
        return pulumi.get(self, "block_public_acls")

    @property
    @pulumi.getter(name="blockPublicPolicy")
    def block_public_policy(self) -> Optional[bool]:
        """
        Specifies whether Amazon S3 should block public bucket policies for buckets in this account. Setting this element to TRUE causes Amazon S3 to reject calls to PUT Bucket policy if the specified bucket policy allows public access. Enabling this setting doesn't affect existing bucket policies.
        """
        return pulumi.get(self, "block_public_policy")

    @property
    @pulumi.getter(name="ignorePublicAcls")
    def ignore_public_acls(self) -> Optional[bool]:
        """
        Specifies whether Amazon S3 should ignore public ACLs for buckets in this account. Setting this element to TRUE causes Amazon S3 to ignore all public ACLs on buckets in this account and any objects that they contain. Enabling this setting doesn't affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set.
        """
        return pulumi.get(self, "ignore_public_acls")

    @property
    @pulumi.getter(name="restrictPublicBuckets")
    def restrict_public_buckets(self) -> Optional[bool]:
        """
        Specifies whether Amazon S3 should restrict public bucket policies for this bucket. Setting this element to TRUE restricts access to this bucket to only AWS services and authorized users within this account if the bucket has a public policy.
        Enabling this setting doesn't affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked.
        """
        return pulumi.get(self, "restrict_public_buckets")


@pulumi.output_type
class MultiRegionAccessPointRegion(dict):
    def __init__(__self__, *,
                 bucket: str):
        pulumi.set(__self__, "bucket", bucket)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        return pulumi.get(self, "bucket")


@pulumi.output_type
class PolicyStatusProperties(dict):
    """
    The Policy Status associated with this Multi Region Access Point
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isPublic":
            suggest = "is_public"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyStatusProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyStatusProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyStatusProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_public: 'MultiRegionAccessPointPolicyPolicyStatusPropertiesIsPublic'):
        """
        The Policy Status associated with this Multi Region Access Point
        :param 'MultiRegionAccessPointPolicyPolicyStatusPropertiesIsPublic' is_public: Specifies whether the policy is public or not.
        """
        pulumi.set(__self__, "is_public", is_public)

    @property
    @pulumi.getter(name="isPublic")
    def is_public(self) -> 'MultiRegionAccessPointPolicyPolicyStatusPropertiesIsPublic':
        """
        Specifies whether the policy is public or not.
        """
        return pulumi.get(self, "is_public")


@pulumi.output_type
class StorageLensAccountLevel(dict):
    """
    Account-level metrics configurations.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketLevel":
            suggest = "bucket_level"
        elif key == "activityMetrics":
            suggest = "activity_metrics"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageLensAccountLevel. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageLensAccountLevel.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageLensAccountLevel.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_level: 'outputs.StorageLensBucketLevel',
                 activity_metrics: Optional['outputs.StorageLensActivityMetrics'] = None):
        """
        Account-level metrics configurations.
        """
        pulumi.set(__self__, "bucket_level", bucket_level)
        if activity_metrics is not None:
            pulumi.set(__self__, "activity_metrics", activity_metrics)

    @property
    @pulumi.getter(name="bucketLevel")
    def bucket_level(self) -> 'outputs.StorageLensBucketLevel':
        return pulumi.get(self, "bucket_level")

    @property
    @pulumi.getter(name="activityMetrics")
    def activity_metrics(self) -> Optional['outputs.StorageLensActivityMetrics']:
        return pulumi.get(self, "activity_metrics")


@pulumi.output_type
class StorageLensActivityMetrics(dict):
    """
    Enables activity metrics.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isEnabled":
            suggest = "is_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageLensActivityMetrics. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageLensActivityMetrics.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageLensActivityMetrics.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_enabled: Optional[bool] = None):
        """
        Enables activity metrics.
        :param bool is_enabled: Specifies whether activity metrics are enabled or disabled.
        """
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[bool]:
        """
        Specifies whether activity metrics are enabled or disabled.
        """
        return pulumi.get(self, "is_enabled")


@pulumi.output_type
class StorageLensAwsOrg(dict):
    """
    The AWS Organizations ARN to use in the Amazon S3 Storage Lens configuration.
    """
    def __init__(__self__, *,
                 arn: str):
        """
        The AWS Organizations ARN to use in the Amazon S3 Storage Lens configuration.
        """
        pulumi.set(__self__, "arn", arn)

    @property
    @pulumi.getter
    def arn(self) -> str:
        return pulumi.get(self, "arn")


@pulumi.output_type
class StorageLensBucketLevel(dict):
    """
    Bucket-level metrics configurations.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activityMetrics":
            suggest = "activity_metrics"
        elif key == "prefixLevel":
            suggest = "prefix_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageLensBucketLevel. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageLensBucketLevel.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageLensBucketLevel.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 activity_metrics: Optional['outputs.StorageLensActivityMetrics'] = None,
                 prefix_level: Optional['outputs.StorageLensPrefixLevel'] = None):
        """
        Bucket-level metrics configurations.
        """
        if activity_metrics is not None:
            pulumi.set(__self__, "activity_metrics", activity_metrics)
        if prefix_level is not None:
            pulumi.set(__self__, "prefix_level", prefix_level)

    @property
    @pulumi.getter(name="activityMetrics")
    def activity_metrics(self) -> Optional['outputs.StorageLensActivityMetrics']:
        return pulumi.get(self, "activity_metrics")

    @property
    @pulumi.getter(name="prefixLevel")
    def prefix_level(self) -> Optional['outputs.StorageLensPrefixLevel']:
        return pulumi.get(self, "prefix_level")


@pulumi.output_type
class StorageLensBucketsAndRegions(dict):
    """
    S3 buckets and Regions to include/exclude in the Amazon S3 Storage Lens configuration.
    """
    def __init__(__self__, *,
                 buckets: Optional[Sequence[str]] = None,
                 regions: Optional[Sequence[str]] = None):
        """
        S3 buckets and Regions to include/exclude in the Amazon S3 Storage Lens configuration.
        """
        if buckets is not None:
            pulumi.set(__self__, "buckets", buckets)
        if regions is not None:
            pulumi.set(__self__, "regions", regions)

    @property
    @pulumi.getter
    def buckets(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "buckets")

    @property
    @pulumi.getter
    def regions(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "regions")


@pulumi.output_type
class StorageLensCloudWatchMetrics(dict):
    """
    CloudWatch metrics settings for the Amazon S3 Storage Lens metrics export.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isEnabled":
            suggest = "is_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageLensCloudWatchMetrics. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageLensCloudWatchMetrics.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageLensCloudWatchMetrics.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_enabled: bool):
        """
        CloudWatch metrics settings for the Amazon S3 Storage Lens metrics export.
        :param bool is_enabled: Specifies whether CloudWatch metrics are enabled or disabled.
        """
        pulumi.set(__self__, "is_enabled", is_enabled)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Specifies whether CloudWatch metrics are enabled or disabled.
        """
        return pulumi.get(self, "is_enabled")


@pulumi.output_type
class StorageLensConfiguration(dict):
    """
    Specifies the details of Amazon S3 Storage Lens configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountLevel":
            suggest = "account_level"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "awsOrg":
            suggest = "aws_org"
        elif key == "dataExport":
            suggest = "data_export"
        elif key == "storageLensArn":
            suggest = "storage_lens_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageLensConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageLensConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageLensConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_level: 'outputs.StorageLensAccountLevel',
                 id: str,
                 is_enabled: bool,
                 aws_org: Optional['outputs.StorageLensAwsOrg'] = None,
                 data_export: Optional['outputs.StorageLensDataExport'] = None,
                 exclude: Optional['outputs.StorageLensBucketsAndRegions'] = None,
                 include: Optional['outputs.StorageLensBucketsAndRegions'] = None,
                 storage_lens_arn: Optional[str] = None):
        """
        Specifies the details of Amazon S3 Storage Lens configuration.
        :param bool is_enabled: Specifies whether the Amazon S3 Storage Lens configuration is enabled or disabled.
        :param str storage_lens_arn: The ARN for the Amazon S3 Storage Lens configuration.
        """
        pulumi.set(__self__, "account_level", account_level)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_enabled", is_enabled)
        if aws_org is not None:
            pulumi.set(__self__, "aws_org", aws_org)
        if data_export is not None:
            pulumi.set(__self__, "data_export", data_export)
        if exclude is not None:
            pulumi.set(__self__, "exclude", exclude)
        if include is not None:
            pulumi.set(__self__, "include", include)
        if storage_lens_arn is not None:
            pulumi.set(__self__, "storage_lens_arn", storage_lens_arn)

    @property
    @pulumi.getter(name="accountLevel")
    def account_level(self) -> 'outputs.StorageLensAccountLevel':
        return pulumi.get(self, "account_level")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Specifies whether the Amazon S3 Storage Lens configuration is enabled or disabled.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="awsOrg")
    def aws_org(self) -> Optional['outputs.StorageLensAwsOrg']:
        return pulumi.get(self, "aws_org")

    @property
    @pulumi.getter(name="dataExport")
    def data_export(self) -> Optional['outputs.StorageLensDataExport']:
        return pulumi.get(self, "data_export")

    @property
    @pulumi.getter
    def exclude(self) -> Optional['outputs.StorageLensBucketsAndRegions']:
        return pulumi.get(self, "exclude")

    @property
    @pulumi.getter
    def include(self) -> Optional['outputs.StorageLensBucketsAndRegions']:
        return pulumi.get(self, "include")

    @property
    @pulumi.getter(name="storageLensArn")
    def storage_lens_arn(self) -> Optional[str]:
        """
        The ARN for the Amazon S3 Storage Lens configuration.
        """
        return pulumi.get(self, "storage_lens_arn")


@pulumi.output_type
class StorageLensDataExport(dict):
    """
    Specifies how Amazon S3 Storage Lens metrics should be exported.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudWatchMetrics":
            suggest = "cloud_watch_metrics"
        elif key == "s3BucketDestination":
            suggest = "s3_bucket_destination"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageLensDataExport. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageLensDataExport.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageLensDataExport.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_watch_metrics: Optional['outputs.StorageLensCloudWatchMetrics'] = None,
                 s3_bucket_destination: Optional['outputs.StorageLensS3BucketDestination'] = None):
        """
        Specifies how Amazon S3 Storage Lens metrics should be exported.
        """
        if cloud_watch_metrics is not None:
            pulumi.set(__self__, "cloud_watch_metrics", cloud_watch_metrics)
        if s3_bucket_destination is not None:
            pulumi.set(__self__, "s3_bucket_destination", s3_bucket_destination)

    @property
    @pulumi.getter(name="cloudWatchMetrics")
    def cloud_watch_metrics(self) -> Optional['outputs.StorageLensCloudWatchMetrics']:
        return pulumi.get(self, "cloud_watch_metrics")

    @property
    @pulumi.getter(name="s3BucketDestination")
    def s3_bucket_destination(self) -> Optional['outputs.StorageLensS3BucketDestination']:
        return pulumi.get(self, "s3_bucket_destination")


@pulumi.output_type
class StorageLensEncryption(dict):
    """
    Configures the server-side encryption for Amazon S3 Storage Lens report files with either S3-managed keys (SSE-S3) or KMS-managed keys (SSE-KMS).
    """
    def __init__(__self__):
        """
        Configures the server-side encryption for Amazon S3 Storage Lens report files with either S3-managed keys (SSE-S3) or KMS-managed keys (SSE-KMS).
        """
        pass


@pulumi.output_type
class StorageLensPrefixLevel(dict):
    """
    Prefix-level metrics configurations.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageMetrics":
            suggest = "storage_metrics"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageLensPrefixLevel. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageLensPrefixLevel.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageLensPrefixLevel.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_metrics: 'outputs.StorageLensPrefixLevelStorageMetrics'):
        """
        Prefix-level metrics configurations.
        """
        pulumi.set(__self__, "storage_metrics", storage_metrics)

    @property
    @pulumi.getter(name="storageMetrics")
    def storage_metrics(self) -> 'outputs.StorageLensPrefixLevelStorageMetrics':
        return pulumi.get(self, "storage_metrics")


@pulumi.output_type
class StorageLensPrefixLevelStorageMetrics(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isEnabled":
            suggest = "is_enabled"
        elif key == "selectionCriteria":
            suggest = "selection_criteria"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageLensPrefixLevelStorageMetrics. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageLensPrefixLevelStorageMetrics.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageLensPrefixLevelStorageMetrics.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_enabled: Optional[bool] = None,
                 selection_criteria: Optional['outputs.StorageLensSelectionCriteria'] = None):
        """
        :param bool is_enabled: Specifies whether prefix-level storage metrics are enabled or disabled.
        """
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if selection_criteria is not None:
            pulumi.set(__self__, "selection_criteria", selection_criteria)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[bool]:
        """
        Specifies whether prefix-level storage metrics are enabled or disabled.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="selectionCriteria")
    def selection_criteria(self) -> Optional['outputs.StorageLensSelectionCriteria']:
        return pulumi.get(self, "selection_criteria")


@pulumi.output_type
class StorageLensS3BucketDestination(dict):
    """
    S3 bucket destination settings for the Amazon S3 Storage Lens metrics export.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountId":
            suggest = "account_id"
        elif key == "outputSchemaVersion":
            suggest = "output_schema_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageLensS3BucketDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageLensS3BucketDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageLensS3BucketDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_id: str,
                 arn: str,
                 format: 'StorageLensS3BucketDestinationFormat',
                 output_schema_version: 'StorageLensS3BucketDestinationOutputSchemaVersion',
                 encryption: Optional['outputs.StorageLensEncryption'] = None,
                 prefix: Optional[str] = None):
        """
        S3 bucket destination settings for the Amazon S3 Storage Lens metrics export.
        :param str account_id: The AWS account ID that owns the destination S3 bucket.
        :param str arn: The ARN of the bucket to which Amazon S3 Storage Lens exports will be placed.
        :param 'StorageLensS3BucketDestinationFormat' format: Specifies the file format to use when exporting Amazon S3 Storage Lens metrics export.
        :param 'StorageLensS3BucketDestinationOutputSchemaVersion' output_schema_version: The version of the output schema to use when exporting Amazon S3 Storage Lens metrics.
        :param str prefix: The prefix to use for Amazon S3 Storage Lens export.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "format", format)
        pulumi.set(__self__, "output_schema_version", output_schema_version)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> str:
        """
        The AWS account ID that owns the destination S3 bucket.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        The ARN of the bucket to which Amazon S3 Storage Lens exports will be placed.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def format(self) -> 'StorageLensS3BucketDestinationFormat':
        """
        Specifies the file format to use when exporting Amazon S3 Storage Lens metrics export.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="outputSchemaVersion")
    def output_schema_version(self) -> 'StorageLensS3BucketDestinationOutputSchemaVersion':
        """
        The version of the output schema to use when exporting Amazon S3 Storage Lens metrics.
        """
        return pulumi.get(self, "output_schema_version")

    @property
    @pulumi.getter
    def encryption(self) -> Optional['outputs.StorageLensEncryption']:
        return pulumi.get(self, "encryption")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        The prefix to use for Amazon S3 Storage Lens export.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class StorageLensSelectionCriteria(dict):
    """
    Selection criteria for prefix-level metrics.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxDepth":
            suggest = "max_depth"
        elif key == "minStorageBytesPercentage":
            suggest = "min_storage_bytes_percentage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageLensSelectionCriteria. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageLensSelectionCriteria.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageLensSelectionCriteria.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delimiter: Optional[str] = None,
                 max_depth: Optional[int] = None,
                 min_storage_bytes_percentage: Optional[float] = None):
        """
        Selection criteria for prefix-level metrics.
        :param str delimiter: Delimiter to divide S3 key into hierarchy of prefixes.
        :param int max_depth: Max depth of prefixes of S3 key that Amazon S3 Storage Lens will analyze.
        :param float min_storage_bytes_percentage: The minimum storage bytes threshold for the prefixes to be included in the analysis.
        """
        if delimiter is not None:
            pulumi.set(__self__, "delimiter", delimiter)
        if max_depth is not None:
            pulumi.set(__self__, "max_depth", max_depth)
        if min_storage_bytes_percentage is not None:
            pulumi.set(__self__, "min_storage_bytes_percentage", min_storage_bytes_percentage)

    @property
    @pulumi.getter
    def delimiter(self) -> Optional[str]:
        """
        Delimiter to divide S3 key into hierarchy of prefixes.
        """
        return pulumi.get(self, "delimiter")

    @property
    @pulumi.getter(name="maxDepth")
    def max_depth(self) -> Optional[int]:
        """
        Max depth of prefixes of S3 key that Amazon S3 Storage Lens will analyze.
        """
        return pulumi.get(self, "max_depth")

    @property
    @pulumi.getter(name="minStorageBytesPercentage")
    def min_storage_bytes_percentage(self) -> Optional[float]:
        """
        The minimum storage bytes threshold for the prefixes to be included in the analysis.
        """
        return pulumi.get(self, "min_storage_bytes_percentage")


@pulumi.output_type
class StorageLensTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


