# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'CellTag',
    'ReadinessCheckTag',
    'RecoveryGroupTag',
    'ResourceSetDNSTargetResource',
    'ResourceSetNLBResource',
    'ResourceSetR53ResourceRecord',
    'ResourceSetResource',
    'ResourceSetTag',
    'ResourceSetTargetResource',
]

@pulumi.output_type
class CellTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class ReadinessCheckTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class RecoveryGroupTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class ResourceSetDNSTargetResource(dict):
    """
    A component for DNS/routing control readiness checks.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"
        elif key == "hostedZoneArn":
            suggest = "hosted_zone_arn"
        elif key == "recordSetId":
            suggest = "record_set_id"
        elif key == "recordType":
            suggest = "record_type"
        elif key == "targetResource":
            suggest = "target_resource"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceSetDNSTargetResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceSetDNSTargetResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceSetDNSTargetResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: Optional[str] = None,
                 hosted_zone_arn: Optional[str] = None,
                 record_set_id: Optional[str] = None,
                 record_type: Optional[str] = None,
                 target_resource: Optional['outputs.ResourceSetTargetResource'] = None):
        """
        A component for DNS/routing control readiness checks.
        :param str domain_name: The domain name that acts as an ingress point to a portion of the customer application.
        :param str hosted_zone_arn: The hosted zone Amazon Resource Name (ARN) that contains the DNS record with the provided name of the target resource.
        :param str record_set_id: The Route 53 record set ID that will uniquely identify a DNS record, given a name and a type.
        :param str record_type: The type of DNS record of the target resource.
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if hosted_zone_arn is not None:
            pulumi.set(__self__, "hosted_zone_arn", hosted_zone_arn)
        if record_set_id is not None:
            pulumi.set(__self__, "record_set_id", record_set_id)
        if record_type is not None:
            pulumi.set(__self__, "record_type", record_type)
        if target_resource is not None:
            pulumi.set(__self__, "target_resource", target_resource)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[str]:
        """
        The domain name that acts as an ingress point to a portion of the customer application.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="hostedZoneArn")
    def hosted_zone_arn(self) -> Optional[str]:
        """
        The hosted zone Amazon Resource Name (ARN) that contains the DNS record with the provided name of the target resource.
        """
        return pulumi.get(self, "hosted_zone_arn")

    @property
    @pulumi.getter(name="recordSetId")
    def record_set_id(self) -> Optional[str]:
        """
        The Route 53 record set ID that will uniquely identify a DNS record, given a name and a type.
        """
        return pulumi.get(self, "record_set_id")

    @property
    @pulumi.getter(name="recordType")
    def record_type(self) -> Optional[str]:
        """
        The type of DNS record of the target resource.
        """
        return pulumi.get(self, "record_type")

    @property
    @pulumi.getter(name="targetResource")
    def target_resource(self) -> Optional['outputs.ResourceSetTargetResource']:
        return pulumi.get(self, "target_resource")


@pulumi.output_type
class ResourceSetNLBResource(dict):
    """
    The Network Load Balancer resource that a DNS target resource points to.
    """
    def __init__(__self__, *,
                 arn: Optional[str] = None):
        """
        The Network Load Balancer resource that a DNS target resource points to.
        :param str arn: A Network Load Balancer resource Amazon Resource Name (ARN).
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        A Network Load Balancer resource Amazon Resource Name (ARN).
        """
        return pulumi.get(self, "arn")


@pulumi.output_type
class ResourceSetR53ResourceRecord(dict):
    """
    The Route 53 resource that a DNS target resource record points to.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"
        elif key == "recordSetId":
            suggest = "record_set_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceSetR53ResourceRecord. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceSetR53ResourceRecord.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceSetR53ResourceRecord.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: Optional[str] = None,
                 record_set_id: Optional[str] = None):
        """
        The Route 53 resource that a DNS target resource record points to.
        :param str domain_name: The DNS target domain name.
        :param str record_set_id: The Resource Record set id.
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if record_set_id is not None:
            pulumi.set(__self__, "record_set_id", record_set_id)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[str]:
        """
        The DNS target domain name.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="recordSetId")
    def record_set_id(self) -> Optional[str]:
        """
        The Resource Record set id.
        """
        return pulumi.get(self, "record_set_id")


@pulumi.output_type
class ResourceSetResource(dict):
    """
    The resource element of a ResourceSet
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "componentId":
            suggest = "component_id"
        elif key == "dnsTargetResource":
            suggest = "dns_target_resource"
        elif key == "readinessScopes":
            suggest = "readiness_scopes"
        elif key == "resourceArn":
            suggest = "resource_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceSetResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceSetResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceSetResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 component_id: Optional[str] = None,
                 dns_target_resource: Optional['outputs.ResourceSetDNSTargetResource'] = None,
                 readiness_scopes: Optional[Sequence[str]] = None,
                 resource_arn: Optional[str] = None):
        """
        The resource element of a ResourceSet
        :param str component_id: The component identifier of the resource, generated when DNS target resource is used.
        :param Sequence[str] readiness_scopes: A list of recovery group Amazon Resource Names (ARNs) and cell ARNs that this resource is contained within.
        :param str resource_arn: The Amazon Resource Name (ARN) of the AWS resource.
        """
        if component_id is not None:
            pulumi.set(__self__, "component_id", component_id)
        if dns_target_resource is not None:
            pulumi.set(__self__, "dns_target_resource", dns_target_resource)
        if readiness_scopes is not None:
            pulumi.set(__self__, "readiness_scopes", readiness_scopes)
        if resource_arn is not None:
            pulumi.set(__self__, "resource_arn", resource_arn)

    @property
    @pulumi.getter(name="componentId")
    def component_id(self) -> Optional[str]:
        """
        The component identifier of the resource, generated when DNS target resource is used.
        """
        return pulumi.get(self, "component_id")

    @property
    @pulumi.getter(name="dnsTargetResource")
    def dns_target_resource(self) -> Optional['outputs.ResourceSetDNSTargetResource']:
        return pulumi.get(self, "dns_target_resource")

    @property
    @pulumi.getter(name="readinessScopes")
    def readiness_scopes(self) -> Optional[Sequence[str]]:
        """
        A list of recovery group Amazon Resource Names (ARNs) and cell ARNs that this resource is contained within.
        """
        return pulumi.get(self, "readiness_scopes")

    @property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the AWS resource.
        """
        return pulumi.get(self, "resource_arn")


@pulumi.output_type
class ResourceSetTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class ResourceSetTargetResource(dict):
    """
    The target resource that the Route 53 record points to.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nLBResource":
            suggest = "n_lb_resource"
        elif key == "r53Resource":
            suggest = "r53_resource"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceSetTargetResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceSetTargetResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceSetTargetResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 n_lb_resource: Optional['outputs.ResourceSetNLBResource'] = None,
                 r53_resource: Optional['outputs.ResourceSetR53ResourceRecord'] = None):
        """
        The target resource that the Route 53 record points to.
        """
        if n_lb_resource is not None:
            pulumi.set(__self__, "n_lb_resource", n_lb_resource)
        if r53_resource is not None:
            pulumi.set(__self__, "r53_resource", r53_resource)

    @property
    @pulumi.getter(name="nLBResource")
    def n_lb_resource(self) -> Optional['outputs.ResourceSetNLBResource']:
        return pulumi.get(self, "n_lb_resource")

    @property
    @pulumi.getter(name="r53Resource")
    def r53_resource(self) -> Optional['outputs.ResourceSetR53ResourceRecord']:
        return pulumi.get(self, "r53_resource")


