# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetEndpointAuthorizationResult',
    'AwaitableGetEndpointAuthorizationResult',
    'get_endpoint_authorization',
    'get_endpoint_authorization_output',
]

@pulumi.output_type
class GetEndpointAuthorizationResult:
    def __init__(__self__, allowed_all_vpcs=None, allowed_vpcs=None, authorize_time=None, cluster_status=None, endpoint_count=None, grantee=None, grantor=None, status=None, vpc_ids=None):
        if allowed_all_vpcs and not isinstance(allowed_all_vpcs, bool):
            raise TypeError("Expected argument 'allowed_all_vpcs' to be a bool")
        pulumi.set(__self__, "allowed_all_vpcs", allowed_all_vpcs)
        if allowed_vpcs and not isinstance(allowed_vpcs, list):
            raise TypeError("Expected argument 'allowed_vpcs' to be a list")
        pulumi.set(__self__, "allowed_vpcs", allowed_vpcs)
        if authorize_time and not isinstance(authorize_time, str):
            raise TypeError("Expected argument 'authorize_time' to be a str")
        pulumi.set(__self__, "authorize_time", authorize_time)
        if cluster_status and not isinstance(cluster_status, str):
            raise TypeError("Expected argument 'cluster_status' to be a str")
        pulumi.set(__self__, "cluster_status", cluster_status)
        if endpoint_count and not isinstance(endpoint_count, int):
            raise TypeError("Expected argument 'endpoint_count' to be a int")
        pulumi.set(__self__, "endpoint_count", endpoint_count)
        if grantee and not isinstance(grantee, str):
            raise TypeError("Expected argument 'grantee' to be a str")
        pulumi.set(__self__, "grantee", grantee)
        if grantor and not isinstance(grantor, str):
            raise TypeError("Expected argument 'grantor' to be a str")
        pulumi.set(__self__, "grantor", grantor)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if vpc_ids and not isinstance(vpc_ids, list):
            raise TypeError("Expected argument 'vpc_ids' to be a list")
        pulumi.set(__self__, "vpc_ids", vpc_ids)

    @property
    @pulumi.getter(name="allowedAllVPCs")
    def allowed_all_vpcs(self) -> Optional[bool]:
        """
        Indicates whether all VPCs in the grantee account are allowed access to the cluster.
        """
        return pulumi.get(self, "allowed_all_vpcs")

    @property
    @pulumi.getter(name="allowedVPCs")
    def allowed_vpcs(self) -> Optional[Sequence[str]]:
        """
        The VPCs allowed access to the cluster.
        """
        return pulumi.get(self, "allowed_vpcs")

    @property
    @pulumi.getter(name="authorizeTime")
    def authorize_time(self) -> Optional[str]:
        """
        The time (UTC) when the authorization was created.
        """
        return pulumi.get(self, "authorize_time")

    @property
    @pulumi.getter(name="clusterStatus")
    def cluster_status(self) -> Optional[str]:
        """
        The status of the cluster.
        """
        return pulumi.get(self, "cluster_status")

    @property
    @pulumi.getter(name="endpointCount")
    def endpoint_count(self) -> Optional[int]:
        """
        The number of Redshift-managed VPC endpoints created for the authorization.
        """
        return pulumi.get(self, "endpoint_count")

    @property
    @pulumi.getter
    def grantee(self) -> Optional[str]:
        """
        The AWS account ID of the grantee of the cluster.
        """
        return pulumi.get(self, "grantee")

    @property
    @pulumi.getter
    def grantor(self) -> Optional[str]:
        """
        The AWS account ID of the cluster owner.
        """
        return pulumi.get(self, "grantor")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of the authorization action.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="vpcIds")
    def vpc_ids(self) -> Optional[Sequence[str]]:
        """
        The virtual private cloud (VPC) identifiers to grant or revoke access to.
        """
        return pulumi.get(self, "vpc_ids")


class AwaitableGetEndpointAuthorizationResult(GetEndpointAuthorizationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEndpointAuthorizationResult(
            allowed_all_vpcs=self.allowed_all_vpcs,
            allowed_vpcs=self.allowed_vpcs,
            authorize_time=self.authorize_time,
            cluster_status=self.cluster_status,
            endpoint_count=self.endpoint_count,
            grantee=self.grantee,
            grantor=self.grantor,
            status=self.status,
            vpc_ids=self.vpc_ids)


def get_endpoint_authorization(account: Optional[str] = None,
                               cluster_identifier: Optional[str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEndpointAuthorizationResult:
    """
    Describes an endpoint authorization for authorizing Redshift-managed VPC endpoint access to a cluster across AWS accounts.


    :param str account: The target AWS account ID to grant or revoke access for.
    :param str cluster_identifier: The cluster identifier.
    """
    __args__ = dict()
    __args__['account'] = account
    __args__['clusterIdentifier'] = cluster_identifier
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:redshift:getEndpointAuthorization', __args__, opts=opts, typ=GetEndpointAuthorizationResult).value

    return AwaitableGetEndpointAuthorizationResult(
        allowed_all_vpcs=__ret__.allowed_all_vpcs,
        allowed_vpcs=__ret__.allowed_vpcs,
        authorize_time=__ret__.authorize_time,
        cluster_status=__ret__.cluster_status,
        endpoint_count=__ret__.endpoint_count,
        grantee=__ret__.grantee,
        grantor=__ret__.grantor,
        status=__ret__.status,
        vpc_ids=__ret__.vpc_ids)


@_utilities.lift_output_func(get_endpoint_authorization)
def get_endpoint_authorization_output(account: Optional[pulumi.Input[str]] = None,
                                      cluster_identifier: Optional[pulumi.Input[str]] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetEndpointAuthorizationResult]:
    """
    Describes an endpoint authorization for authorizing Redshift-managed VPC endpoint access to a cluster across AWS accounts.


    :param str account: The target AWS account ID to grant or revoke access for.
    :param str cluster_identifier: The cluster identifier.
    """
    ...
