# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetCampaignResult',
    'AwaitableGetCampaignResult',
    'get_campaign',
    'get_campaign_output',
]

@pulumi.output_type
class GetCampaignResult:
    def __init__(__self__, arn=None, dialer_config=None, name=None, outbound_call_config=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if dialer_config and not isinstance(dialer_config, dict):
            raise TypeError("Expected argument 'dialer_config' to be a dict")
        pulumi.set(__self__, "dialer_config", dialer_config)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if outbound_call_config and not isinstance(outbound_call_config, dict):
            raise TypeError("Expected argument 'outbound_call_config' to be a dict")
        pulumi.set(__self__, "outbound_call_config", outbound_call_config)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        Amazon Connect Campaign Arn
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="dialerConfig")
    def dialer_config(self) -> Optional['outputs.CampaignDialerConfig']:
        return pulumi.get(self, "dialer_config")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Amazon Connect Campaign Name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outboundCallConfig")
    def outbound_call_config(self) -> Optional['outputs.CampaignOutboundCallConfig']:
        return pulumi.get(self, "outbound_call_config")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.CampaignTag']]:
        """
        One or more tags.
        """
        return pulumi.get(self, "tags")


class AwaitableGetCampaignResult(GetCampaignResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCampaignResult(
            arn=self.arn,
            dialer_config=self.dialer_config,
            name=self.name,
            outbound_call_config=self.outbound_call_config,
            tags=self.tags)


def get_campaign(arn: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCampaignResult:
    """
    Definition of AWS::ConnectCampaigns::Campaign Resource Type


    :param str arn: Amazon Connect Campaign Arn
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:connectcampaigns:getCampaign', __args__, opts=opts, typ=GetCampaignResult).value

    return AwaitableGetCampaignResult(
        arn=__ret__.arn,
        dialer_config=__ret__.dialer_config,
        name=__ret__.name,
        outbound_call_config=__ret__.outbound_call_config,
        tags=__ret__.tags)


@_utilities.lift_output_func(get_campaign)
def get_campaign_output(arn: Optional[pulumi.Input[str]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCampaignResult]:
    """
    Definition of AWS::ConnectCampaigns::Campaign Resource Type


    :param str arn: Amazon Connect Campaign Arn
    """
    ...
