# JLC2KiCadLib

JLC2KiCadLib is a python script that generate a component library (schematic, footprint and 3D model) for KiCad from the JLCPCB/easyEDA library.
This script requires **Python 3.6** or higher.

## Exemple 



easyEDA origin | KiCad result
---- | ----
![JLC1](images/JLC_Schematic_1.png) | ![JLC1](images/KiCad_Schematic_1.png)
![JLC1](images/JLC_Footprint_1.png) | ![JLC1](images/KiCad_Footprint_1.png)
![JLC1](images/JLC_3Dmodel.png) | ![JLC1](images/KiCad_3Dmodel.png)

## Installation

```bash
pip install JLC2KiCadLib
```

## Usage 

```
positional arguments:
  JLCPCB_part_#         list of JLCPCB part # from the components you want to create

options:
  -h, --help            show this help message and exit
  -dir OUTPUT_DIR       base directory for output library files
  --model_path_relative
                        use --model_path_relative if you want the 3D model to be linked to the footprint using relative instead of absolute path, default is absolute
  --no_footprint        use --no_footprint if you do not want to create the footprint
  --no_schematic        use --no_schematic if you do not want to create the schematic
  -schematic_lib SCHEMATIC_LIB
                        set schematic library name, default is "default_lib"
  -footprint_lib FOOTPRINT_LIB
                        set footprint library name, default is "footprint"
  -logging_level {DEBUG,INFO,WARNING,ERROR,CRITICAL}
                        set logging level. If DEBUG is used, the debug logs are only written in the log file if the option --log_file is set
  --log_file            use --log_file if you want logs to be written in a file
```

Example usage : `JLC2KiCadLib.py C1337258 C24112 -dir My_lib -schematic_lib My_Schematic_lib`

This example will create the schematic, footprint and 3D model for the two components specified, and will output the schematic in the `./My_lib/Schematic/My_Schematic_lib.lib` file, the footprint and 3D model will be created in the `./My_lib/Footprint`.

The JLCPCB part # is found in the part info section of every component in the JLCPCB part library. 

By default, the library will be created in the execution folder. You can specify an absolute path with the -dir option. 

## Dependencies 

This script use the [KicadModTree](https://gitlab.com/kicad/libraries/kicad-footprint-generator) framework to write the footprints. 

## Notes

* Even so I tested the script on a lot of components, be careful and always check the output footprint and schematic.

## License 

Copyright © 2021 TousstNicolas 

The code is released under the MIT license