"""
Target values for the one- and two-loop remainders of the Vjj amplitudes as given in arXiv:2110.07541 Table 5,
at associated phase space point given in :code:momenta.py. The format is that of a dictionary: (partial, loops, nf-powers).
Import with

.. code-block:: python

    from amplitudes.Vjj.target_values import target_values

"""

target_values = {

    # (partial, loops, nf-powers): target value - loop is normalized by the tree.

    ("quarkspm", 0, 0): 3.7636813341235895084456343835246 - 2.8565611153597122945411257523423j,
    ("quarkspm", 1, 0): 5.0394236323908900379398369705679 - 7.6720001345108985059452283281780j,
    ("quarkspm", 1, 1): - 1.8435193035565175720412746023928 + 0j,
    ("quarkspm", 2, 0): 146.67405518574346950142243692548 - 158.03592884417241145649922014778j,
    ("quarkspm", 2, 1): - 51.876494035194307150671600812344 + 43.001741025983452745318802355945j,
    ("quarkspm", 2, 2): 3.3985634225855075823432774924603 + 0j,

    ("quarksmp", 0, 0): 6.3174714114588299509370491214766 + 4.1682945838654512497100291825771j,
    ("quarksmp", 1, 0): 3.7787467232606043085629485291787 - 7.1688097645665861863893861573662j,
    ("quarksmp", 1, 1): - 1.8435193035565175720412746023928 + 0j,
    ("quarksmp", 2, 0): 109.48155479309488749024120292009 - 140.50620505261657997069179088349j,
    ("quarksmp", 2, 1): - 45.623112301910951942053194550271 + 41.319123316131740804214953046438j,
    ("quarksmp", 2, 2): 3.3985634225855075823432774924603 + 0j,

    ("gluonspp", 0, 0): 0.023642359058938397894548669272156 + 0.0044544447400485618434401593414443j,
    ("gluonspp", 1, 0): 103.342870987841128170028946458613 - 16.562565973584147961206479563634j,
    ("gluonspp", 1, 1): - 80.2235859563104985917709936938 + 21.1719625473749533034217240368j,
    ("gluonspp", 2, 0): 2630.7896094333798321261128814801 - 1047.6488122520150310638588522254j,
    ("gluonspp", 2, 1): - 2223.2948827670329778297492178883 + 1107.3264626158004457960019585401j,
    ("gluonspp", 2, 2): 179.97159295558907811624201211268 + 40.91323686442971611922802327433j,

    ("gluonspm", 0, 0): 3.7229460034770018469911986830323 + 1.7267077666104762062484815507543j,
    ("gluonspm", 1, 0): 0.0335899410058592457041394847093 - 5.3942292280301052167187389231723j,
    ("gluonspm", 1, 1): - 0.125806791594214200030212500703 - 1.047197551196597746154214461093j,
    ("gluonspm", 2, 0): 76.728329033915255088572146807173 - 103.520996261248419051819756331433j,
    ("gluonspm", 2, 1): - 20.297863470205721513413840949506 + 22.479201706415579198466788614618j,
    ("gluonspm", 2, 2): - 1.03490376197656785454885732723644 + 0.79181046130181572078863480763033j,

    ("gluonsmp", 0, 0): -8.8426136492098667867861594086532 + 3.4838583901260477278467513517097j,
    ("gluonsmp", 1, 0): - 1.5850318227570171660065240966651 - 5.9893250317409578683572234464818j,
    ("gluonsmp", 1, 1): - 0.125806791594214200030212500703 - 1.047197551196597746154214461093j,
    ("gluonsmp", 2, 0): 49.200999459320106985665508027131 - 100.575405544319135425799674254589j,
    ("gluonsmp", 2, 1): - 15.300311411465869857630350059749 + 26.629013080533603816559511658910j,
    ("gluonsmp", 2, 2): - 1.03490376197656785454885732723644 + 0.79181046130181572078863480763033j,

}
