# Rolling-Pin
A library of generic tools for ETL work and visualization of JSON blobs and
python repositories

**[Documentation](https://thenewflesh.github.io/rolling-pin/)**

On the documentation main page, under the *Architecture* section, is a
dynamically generated dependency graph of rolling-pin's current architecture.
It is generated using the RepoETL class.

If you look under the *Metrics* section you will find Radon code metric plots
and data of the rolling-pin source code, generated by the RadonETL class.

**[Jupyter Notebook Demo](https://github.com/theNewFlesh/rolling-pin/blob/master/notebooks/prototype_demo.ipynb)**

# Installation
### Python
`pip install rolling-pin`

### Docker
1. Install
   [docker](https://docs.docker.com/v17.09/engine/installation)
2. Install
   [docker-machine](https://docs.docker.com/machine/install-machine)
   (if running on macOS or Windows)
3. `docker pull theNewFlesh/rolling-pin:[version]`
4. `docker run --rm --name rolling-pin-prod --publish 5180:80 theNewFlesh/rolling-pin:[version]`

### Docker For Developers
1. Install
   [docker](https://docs.docker.com/v17.09/engine/installation)
2. Install
   [docker-machine](https://docs.docker.com/machine/install-machine)
   (if running on macOS or Windows)
3. Ensure docker-machine has at least 4 GB of memory allocated to it.
4. `git clone git@github.com:theNewFlesh/rolling-pin.git`
5. `cd rolling-pin`
6. `chmod +x bin/rolling-pin`
7. `bin/rolling-pin start`

The service should take a few minutes to start up.

Run `bin/rolling-pin --help` for more help on the command line tool.
