# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/03_cli.ipynb (unless otherwise specified).

__all__ = ['init_configs', 'make_gh_release_cli']

# Cell
import argparse
from .utils import (
    check_project_root,
    write_settings_ini,
    write_setup_py,
    write_conda_build_scripts,
    update_gitignore,
    run_tests
)
from .gh import write_gh_template, make_gh_release

# Cell
def init_configs():
    "Write initial configs to project root directory"
    parser = argparse.ArgumentParser(description="Initialize project")
    parser.add_argument(
        "project_type",
        help="Either application or package"
    )
    project_type = parser.parse_args()
    # validate input
    if project_type not in ("application", "package"):
        raise Exception(f"Input project_type {project_type} is not valid")
    write_gh_template()
    write_settings_ini(project_type)
    update_gitignore()
    if project_type == "package":
        write_setup_py()
        write_conda_build_scripts()

# Cell
@run_tests
def make_gh_release_cli():
    "CLI for making GitHub releases"
    parser = argparse.ArgumentParser(description="Make a GitHub release")
    parser.add_argument(
        "-d",
        "--draft",
        action="store_true",
        help="Is this a release draft?"
    )
    parser.add_argument(
        "-p",
        "--prerelease",
        action="store_true",
        help="Is this a prerelease?"
    )
    args = parser.parse_args()
    make_gh_release(draft=args.draft, prerelease=args.prerelease)