# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.15.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class SetVariablesAsyncDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'process_instance_ids': 'list[str]',
        'process_instance_query': 'ProcessInstanceQueryDto',
        'historic_process_instance_query': 'HistoricProcessInstanceQueryDto',
        'variables': 'dict(str, VariableValueDto)'
    }

    attribute_map = {
        'process_instance_ids': 'processInstanceIds',
        'process_instance_query': 'processInstanceQuery',
        'historic_process_instance_query': 'historicProcessInstanceQuery',
        'variables': 'variables'
    }

    def __init__(self, process_instance_ids=None, process_instance_query=None, historic_process_instance_query=None, variables=None, local_vars_configuration=None):  # noqa: E501
        """SetVariablesAsyncDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._process_instance_ids = None
        self._process_instance_query = None
        self._historic_process_instance_query = None
        self._variables = None
        self.discriminator = None

        self.process_instance_ids = process_instance_ids
        if process_instance_query is not None:
            self.process_instance_query = process_instance_query
        if historic_process_instance_query is not None:
            self.historic_process_instance_query = historic_process_instance_query
        self.variables = variables

    @property
    def process_instance_ids(self):
        """Gets the process_instance_ids of this SetVariablesAsyncDto.  # noqa: E501

        A list of process instance ids that define a group of process instances to which the operation will set variables.  Please note that if `processInstanceIds`, `processInstanceQuery` and `historicProcessInstanceQuery` are defined, the resulting operation will be performed on the union of these sets.  # noqa: E501

        :return: The process_instance_ids of this SetVariablesAsyncDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._process_instance_ids

    @process_instance_ids.setter
    def process_instance_ids(self, process_instance_ids):
        """Sets the process_instance_ids of this SetVariablesAsyncDto.

        A list of process instance ids that define a group of process instances to which the operation will set variables.  Please note that if `processInstanceIds`, `processInstanceQuery` and `historicProcessInstanceQuery` are defined, the resulting operation will be performed on the union of these sets.  # noqa: E501

        :param process_instance_ids: The process_instance_ids of this SetVariablesAsyncDto.  # noqa: E501
        :type: list[str]
        """

        self._process_instance_ids = process_instance_ids

    @property
    def process_instance_query(self):
        """Gets the process_instance_query of this SetVariablesAsyncDto.  # noqa: E501


        :return: The process_instance_query of this SetVariablesAsyncDto.  # noqa: E501
        :rtype: ProcessInstanceQueryDto
        """
        return self._process_instance_query

    @process_instance_query.setter
    def process_instance_query(self, process_instance_query):
        """Sets the process_instance_query of this SetVariablesAsyncDto.


        :param process_instance_query: The process_instance_query of this SetVariablesAsyncDto.  # noqa: E501
        :type: ProcessInstanceQueryDto
        """

        self._process_instance_query = process_instance_query

    @property
    def historic_process_instance_query(self):
        """Gets the historic_process_instance_query of this SetVariablesAsyncDto.  # noqa: E501


        :return: The historic_process_instance_query of this SetVariablesAsyncDto.  # noqa: E501
        :rtype: HistoricProcessInstanceQueryDto
        """
        return self._historic_process_instance_query

    @historic_process_instance_query.setter
    def historic_process_instance_query(self, historic_process_instance_query):
        """Sets the historic_process_instance_query of this SetVariablesAsyncDto.


        :param historic_process_instance_query: The historic_process_instance_query of this SetVariablesAsyncDto.  # noqa: E501
        :type: HistoricProcessInstanceQueryDto
        """

        self._historic_process_instance_query = historic_process_instance_query

    @property
    def variables(self):
        """Gets the variables of this SetVariablesAsyncDto.  # noqa: E501

        A variables the operation will set in the root scope of the process instances.  # noqa: E501

        :return: The variables of this SetVariablesAsyncDto.  # noqa: E501
        :rtype: dict(str, VariableValueDto)
        """
        return self._variables

    @variables.setter
    def variables(self, variables):
        """Sets the variables of this SetVariablesAsyncDto.

        A variables the operation will set in the root scope of the process instances.  # noqa: E501

        :param variables: The variables of this SetVariablesAsyncDto.  # noqa: E501
        :type: dict(str, VariableValueDto)
        """

        self._variables = variables

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SetVariablesAsyncDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SetVariablesAsyncDto):
            return True

        return self.to_dict() != other.to_dict()
